/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.utils;

import java.time.Clock;

public class History {
    private int mSize;
    private int mCount;
    private int mStart;
    private int mEnd;
    private long[] mTimes;
    private float[] mValues;
    private Clock mClock;

    public History(int size) {
        this(size, Clock.systemUTC());
    }

    public History(int size, Clock clock) {
        this.mSize = size;
        this.mCount = 0;
        this.mStart = 0;
        this.mEnd = 0;
        this.mTimes = new long[size];
        this.mValues = new float[size];
        this.mClock = clock;
    }

    public void add(float value) {
        this.mTimes[this.mEnd] = this.mClock.millis();
        this.mValues[this.mEnd] = value;
        if (this.mCount < this.mSize) {
            ++this.mCount;
        } else {
            this.mStart = (this.mStart + 1) % this.mSize;
        }
        this.mEnd = (this.mEnd + 1) % this.mSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.mCount; ++i) {
            int index = (this.mStart + i) % this.mSize;
            long time = this.mTimes[index];
            float value = this.mValues[index];
            sb.append(value + " @ " + time);
            if (i + 1 == this.mCount) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

