/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.utils;

public class RollingBuffer {
    private static final int INITIAL_SIZE = 50;
    private int mSize = 50;
    private int mCount;
    private int mStart;
    private int mEnd;
    private long[] mTimes = new long[50];
    private float[] mValues = new float[50];

    public RollingBuffer() {
        this.clear();
    }

    public void add(long time, float value) {
        if (this.mCount >= this.mSize) {
            this.expandBuffer();
        }
        this.mTimes[this.mEnd] = time;
        this.mValues[this.mEnd] = value;
        this.mEnd = (this.mEnd + 1) % this.mSize;
        ++this.mCount;
    }

    public int size() {
        return this.mCount;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public long getTime(int index) {
        return this.mTimes[this.offsetOf(index)];
    }

    public float getValue(int index) {
        return this.mValues[this.offsetOf(index)];
    }

    public void truncate(long minTime) {
        if (this.isEmpty() || this.getTime(0) >= minTime) {
            return;
        }
        int index = this.getLatestIndexBefore(minTime);
        this.mStart = this.offsetOf(index);
        this.mCount -= index;
        this.mTimes[this.mStart] = minTime;
    }

    public void clear() {
        this.mCount = 0;
        this.mStart = 0;
        this.mEnd = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.mCount; ++i) {
            int index = this.offsetOf(i);
            sb.append(this.mValues[index] + " @ " + this.mTimes[index]);
            if (i + 1 == this.mCount) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private int offsetOf(int index) {
        if (index < 0 || index >= this.mCount) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + index + ", mCount= " + this.mCount);
        }
        return (this.mStart + index) % this.mSize;
    }

    private void expandBuffer() {
        int size = this.mSize * 2;
        long[] times = new long[size];
        float[] values = new float[size];
        System.arraycopy(this.mTimes, this.mStart, times, 0, this.mCount - this.mStart);
        System.arraycopy(this.mTimes, 0, times, this.mCount - this.mStart, this.mStart);
        System.arraycopy(this.mValues, this.mStart, values, 0, this.mCount - this.mStart);
        System.arraycopy(this.mValues, 0, values, this.mCount - this.mStart, this.mStart);
        this.mSize = size;
        this.mStart = 0;
        this.mEnd = this.mCount;
        this.mTimes = times;
        this.mValues = values;
    }

    private int getLatestIndexBefore(long time) {
        for (int i = 1; i < this.mCount; ++i) {
            if (this.mTimes[this.offsetOf(i)] <= time) continue;
            return i - 1;
        }
        return this.mCount - 1;
    }
}

