/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.whitebalance;

import android.util.Slog;
import com.android.server.display.utils.RollingBuffer;
import java.io.PrintWriter;

abstract class AmbientFilter {
    protected static final boolean DEBUG = false;
    protected final String mTag;
    protected boolean mLoggingEnabled;
    private final int mHorizon;
    private final RollingBuffer mBuffer;

    AmbientFilter(String tag, int horizon) {
        this.validateArguments(horizon);
        this.mTag = tag;
        this.mLoggingEnabled = false;
        this.mHorizon = horizon;
        this.mBuffer = new RollingBuffer();
    }

    public boolean addValue(long time, float value) {
        if (value < 0.0f) {
            return false;
        }
        this.truncateOldValues(time);
        if (this.mLoggingEnabled) {
            Slog.d(this.mTag, "add value: " + value + " @ " + time);
        }
        this.mBuffer.add(time, value);
        return true;
    }

    public float getEstimate(long time) {
        this.truncateOldValues(time);
        float value = this.filter(time, this.mBuffer);
        if (this.mLoggingEnabled) {
            Slog.d(this.mTag, "get estimate: " + value + " @ " + time);
        }
        return value;
    }

    public void clear() {
        this.mBuffer.clear();
    }

    public boolean setLoggingEnabled(boolean loggingEnabled) {
        if (this.mLoggingEnabled == loggingEnabled) {
            return false;
        }
        this.mLoggingEnabled = loggingEnabled;
        return true;
    }

    public void dump(PrintWriter writer) {
        writer.println("  " + this.mTag);
        writer.println("    mLoggingEnabled=" + this.mLoggingEnabled);
        writer.println("    mHorizon=" + this.mHorizon);
        writer.println("    mBuffer=" + this.mBuffer);
    }

    private void validateArguments(int horizon) {
        if (horizon <= 0) {
            throw new IllegalArgumentException("horizon must be positive");
        }
    }

    private void truncateOldValues(long time) {
        long minTime = time - (long)this.mHorizon;
        this.mBuffer.truncate(minTime);
    }

    protected abstract float filter(long var1, RollingBuffer var3);

    static class WeightedMovingAverageAmbientFilter
    extends AmbientFilter {
        private static final int PREDICTION_TIME = 100;
        private final float mIntercept;

        WeightedMovingAverageAmbientFilter(String tag, int horizon, float intercept) {
            super(tag, horizon);
            this.validateArguments(intercept);
            this.mIntercept = intercept;
        }

        @Override
        public void dump(PrintWriter writer) {
            super.dump(writer);
            writer.println("    mIntercept=" + this.mIntercept);
        }

        @Override
        protected float filter(long time, RollingBuffer buffer) {
            if (buffer.isEmpty()) {
                return -1.0f;
            }
            float total = 0.0f;
            float totalWeight = 0.0f;
            float[] weights = this.getWeights(time, buffer);
            for (int i = 0; i < weights.length; ++i) {
                float value = buffer.getValue(i);
                float weight = weights[i];
                total += weight * value;
                totalWeight += weight;
            }
            if (totalWeight == 0.0f) {
                return buffer.getValue(buffer.size() - 1);
            }
            return total / totalWeight;
        }

        private void validateArguments(float intercept) {
            if (Float.isNaN(intercept) || intercept < 0.0f) {
                throw new IllegalArgumentException("intercept must be a non-negative number");
            }
        }

        private float[] getWeights(long time, RollingBuffer buffer) {
            float lastWeight;
            float[] weights = new float[buffer.size()];
            long startTime = buffer.getTime(0);
            float previousTime = 0.0f;
            for (int i = 1; i < weights.length; ++i) {
                float weight;
                float currentTime = (float)(buffer.getTime(i) - startTime) / 1000.0f;
                weights[i - 1] = weight = this.calculateIntegral(previousTime, currentTime);
                previousTime = currentTime;
            }
            float lastTime = (float)(time + 100L - startTime) / 1000.0f;
            weights[weights.length - 1] = lastWeight = this.calculateIntegral(previousTime, lastTime);
            return weights;
        }

        private float calculateIntegral(float from, float to) {
            return this.antiderivative(to) - this.antiderivative(from);
        }

        private float antiderivative(float x) {
            return 0.5f * x * x + this.mIntercept * x;
        }
    }
}

