/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.whitebalance;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.display.utils.History;
import java.io.PrintWriter;

abstract class AmbientSensor {
    protected String mTag;
    protected boolean mLoggingEnabled;
    private final Handler mHandler;
    protected final SensorManager mSensorManager;
    protected Sensor mSensor;
    private boolean mEnabled;
    private int mRate;
    private int mEventsCount;
    private static final int HISTORY_SIZE = 50;
    private History mEventsHistory;
    private SensorEventListener mListener = new SensorEventListener(){

        @Override
        public void onSensorChanged(SensorEvent event) {
            float value = event.values[0];
            AmbientSensor.this.handleNewEvent(value);
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    AmbientSensor(String tag, Handler handler, SensorManager sensorManager, int rate) {
        AmbientSensor.validateArguments(handler, sensorManager, rate);
        this.mTag = tag;
        this.mLoggingEnabled = false;
        this.mHandler = handler;
        this.mSensorManager = sensorManager;
        this.mEnabled = false;
        this.mRate = rate;
        this.mEventsCount = 0;
        this.mEventsHistory = new History(50);
    }

    public boolean setEnabled(boolean enabled) {
        if (enabled) {
            return this.enable();
        }
        return this.disable();
    }

    public boolean setLoggingEnabled(boolean loggingEnabled) {
        if (this.mLoggingEnabled == loggingEnabled) {
            return false;
        }
        this.mLoggingEnabled = loggingEnabled;
        return true;
    }

    public void dump(PrintWriter writer) {
        writer.println("  " + this.mTag);
        writer.println("    mLoggingEnabled=" + this.mLoggingEnabled);
        writer.println("    mHandler=" + this.mHandler);
        writer.println("    mSensorManager=" + this.mSensorManager);
        writer.println("    mSensor=" + this.mSensor);
        writer.println("    mEnabled=" + this.mEnabled);
        writer.println("    mRate=" + this.mRate);
        writer.println("    mEventsCount=" + this.mEventsCount);
        writer.println("    mEventsHistory=" + this.mEventsHistory);
    }

    private static void validateArguments(Handler handler, SensorManager sensorManager, int rate) {
        Preconditions.checkNotNull(handler, "handler cannot be null");
        Preconditions.checkNotNull(sensorManager, "sensorManager cannot be null");
        if (rate <= 0) {
            throw new IllegalArgumentException("rate must be positive");
        }
    }

    protected abstract void update(float var1);

    private boolean enable() {
        if (this.mEnabled) {
            return false;
        }
        if (this.mLoggingEnabled) {
            Slog.d(this.mTag, "enabling");
        }
        this.mEnabled = true;
        this.startListening();
        return true;
    }

    private boolean disable() {
        if (!this.mEnabled) {
            return false;
        }
        if (this.mLoggingEnabled) {
            Slog.d(this.mTag, "disabling");
        }
        this.mEnabled = false;
        this.mEventsCount = 0;
        this.stopListening();
        return true;
    }

    private void startListening() {
        if (this.mSensorManager == null) {
            return;
        }
        this.mSensorManager.registerListener(this.mListener, this.mSensor, this.mRate * 1000, this.mHandler);
    }

    private void stopListening() {
        if (this.mSensorManager == null) {
            return;
        }
        this.mSensorManager.unregisterListener(this.mListener);
    }

    private void handleNewEvent(float value) {
        if (!this.mEnabled) {
            return;
        }
        if (this.mLoggingEnabled) {
            Slog.d(this.mTag, "handle new event: " + value);
        }
        ++this.mEventsCount;
        this.mEventsHistory.add(value);
        this.update(value);
    }

    static class AmbientColorTemperatureSensor
    extends AmbientSensor {
        private static final String TAG = "AmbientColorTemperatureSensor";
        private Callbacks mCallbacks;

        AmbientColorTemperatureSensor(Handler handler, SensorManager sensorManager, String name, int rate) {
            super(TAG, handler, sensorManager, rate);
            this.mSensor = null;
            for (Sensor sensor : this.mSensorManager.getSensorList(-1)) {
                if (!sensor.getStringType().equals(name)) continue;
                this.mSensor = sensor;
                break;
            }
            if (this.mSensor == null) {
                throw new IllegalStateException("cannot find sensor " + name);
            }
            this.mCallbacks = null;
        }

        public boolean setCallbacks(Callbacks callbacks) {
            if (this.mCallbacks == callbacks) {
                return false;
            }
            this.mCallbacks = callbacks;
            return true;
        }

        @Override
        public void dump(PrintWriter writer) {
            super.dump(writer);
            writer.println("    mCallbacks=" + this.mCallbacks);
        }

        @Override
        protected void update(float value) {
            if (this.mCallbacks != null) {
                this.mCallbacks.onAmbientColorTemperatureChanged(value);
            }
        }

        static interface Callbacks {
            public void onAmbientColorTemperatureChanged(float var1);
        }
    }

    static class AmbientBrightnessSensor
    extends AmbientSensor {
        private static final String TAG = "AmbientBrightnessSensor";
        private Callbacks mCallbacks;

        AmbientBrightnessSensor(Handler handler, SensorManager sensorManager, int rate) {
            super(TAG, handler, sensorManager, rate);
            this.mSensor = this.mSensorManager.getDefaultSensor(5);
            if (this.mSensor == null) {
                throw new IllegalStateException("cannot find light sensor");
            }
            this.mCallbacks = null;
        }

        public boolean setCallbacks(Callbacks callbacks) {
            if (this.mCallbacks == callbacks) {
                return false;
            }
            this.mCallbacks = callbacks;
            return true;
        }

        @Override
        public void dump(PrintWriter writer) {
            super.dump(writer);
            writer.println("    mCallbacks=" + this.mCallbacks);
        }

        @Override
        protected void update(float value) {
            if (this.mCallbacks != null) {
                this.mCallbacks.onAmbientBrightnessChanged(value);
            }
        }

        static interface Callbacks {
            public void onAmbientBrightnessChanged(float var1);
        }
    }
}

