/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.whitebalance;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.hardware.SensorManager;
import android.os.Handler;
import android.util.TypedValue;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.display.whitebalance.AmbientFilter;
import com.android.server.display.whitebalance.AmbientSensor;
import com.android.server.display.whitebalance.DisplayWhiteBalanceController;
import com.android.server.display.whitebalance.DisplayWhiteBalanceThrottler;

public class DisplayWhiteBalanceFactory {
    private static final String BRIGHTNESS_FILTER_TAG = "AmbientBrightnessFilter";
    private static final String COLOR_TEMPERATURE_FILTER_TAG = "AmbientColorTemperatureFilter";

    public static DisplayWhiteBalanceController create(Handler handler, SensorManager sensorManager, Resources resources) {
        AmbientSensor.AmbientBrightnessSensor brightnessSensor = DisplayWhiteBalanceFactory.createBrightnessSensor(handler, sensorManager, resources);
        AmbientFilter brightnessFilter = DisplayWhiteBalanceFactory.createBrightnessFilter(resources);
        AmbientSensor.AmbientColorTemperatureSensor colorTemperatureSensor = DisplayWhiteBalanceFactory.createColorTemperatureSensor(handler, sensorManager, resources);
        AmbientFilter colorTemperatureFilter = DisplayWhiteBalanceFactory.createColorTemperatureFilter(resources);
        DisplayWhiteBalanceThrottler throttler = DisplayWhiteBalanceFactory.createThrottler(resources);
        float lowLightAmbientBrightnessThreshold = DisplayWhiteBalanceFactory.getFloat(resources, 17105056);
        float lowLightAmbientColorTemperature = DisplayWhiteBalanceFactory.getFloat(resources, 17105057);
        float[] ambientColorTemperatures = DisplayWhiteBalanceFactory.getFloatArray(resources, 17236011);
        float[] displayColorTempeartures = DisplayWhiteBalanceFactory.getFloatArray(resources, 17236014);
        DisplayWhiteBalanceController controller = new DisplayWhiteBalanceController(brightnessSensor, brightnessFilter, colorTemperatureSensor, colorTemperatureFilter, throttler, lowLightAmbientBrightnessThreshold, lowLightAmbientColorTemperature, ambientColorTemperatures, displayColorTempeartures);
        brightnessSensor.setCallbacks(controller);
        colorTemperatureSensor.setCallbacks(controller);
        return controller;
    }

    private DisplayWhiteBalanceFactory() {
    }

    @VisibleForTesting
    public static AmbientSensor.AmbientBrightnessSensor createBrightnessSensor(Handler handler, SensorManager sensorManager, Resources resources) {
        int rate = resources.getInteger(17694787);
        return new AmbientSensor.AmbientBrightnessSensor(handler, sensorManager, rate);
    }

    @VisibleForTesting
    static AmbientFilter createBrightnessFilter(Resources resources) {
        int horizon = resources.getInteger(17694786);
        float intercept = DisplayWhiteBalanceFactory.getFloat(resources, 17105054);
        if (!Float.isNaN(intercept)) {
            return new AmbientFilter.WeightedMovingAverageAmbientFilter(BRIGHTNESS_FILTER_TAG, horizon, intercept);
        }
        throw new IllegalArgumentException("missing configurations: expected config_displayWhiteBalanceBrightnessFilterIntercept");
    }

    @VisibleForTesting
    public static AmbientSensor.AmbientColorTemperatureSensor createColorTemperatureSensor(Handler handler, SensorManager sensorManager, Resources resources) {
        String name = resources.getString(17039721);
        int rate = resources.getInteger(17694792);
        return new AmbientSensor.AmbientColorTemperatureSensor(handler, sensorManager, name, rate);
    }

    private static AmbientFilter createColorTemperatureFilter(Resources resources) {
        int horizon = resources.getInteger(17694789);
        float intercept = DisplayWhiteBalanceFactory.getFloat(resources, 17105055);
        if (!Float.isNaN(intercept)) {
            return new AmbientFilter.WeightedMovingAverageAmbientFilter(COLOR_TEMPERATURE_FILTER_TAG, horizon, intercept);
        }
        throw new IllegalArgumentException("missing configurations: expected config_displayWhiteBalanceColorTemperatureFilterIntercept");
    }

    private static DisplayWhiteBalanceThrottler createThrottler(Resources resources) {
        int increaseDebounce = resources.getInteger(17694793);
        int decreaseDebounce = resources.getInteger(17694794);
        float[] baseThresholds = DisplayWhiteBalanceFactory.getFloatArray(resources, 17236012);
        float[] increaseThresholds = DisplayWhiteBalanceFactory.getFloatArray(resources, 17236017);
        float[] decreaseThresholds = DisplayWhiteBalanceFactory.getFloatArray(resources, 17236013);
        return new DisplayWhiteBalanceThrottler(increaseDebounce, decreaseDebounce, baseThresholds, increaseThresholds, decreaseThresholds);
    }

    private static float getFloat(Resources resources, int id2) {
        TypedValue value = new TypedValue();
        resources.getValue(id2, value, true);
        if (value.type != 4) {
            return Float.NaN;
        }
        return value.getFloat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[] getFloatArray(Resources resources, int id2) {
        TypedArray array2 = resources.obtainTypedArray(id2);
        try {
            if (array2.length() == 0) {
                float[] fArray = null;
                return fArray;
            }
            float[] values = new float[array2.length()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = array2.getFloat(i, Float.NaN);
                if (!Float.isNaN(values[i])) continue;
                float[] fArray = null;
                return fArray;
            }
            float[] fArray = values;
            return fArray;
        }
        finally {
            array2.recycle();
        }
    }
}

