/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.whitebalance;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.display.color.ColorDisplayService;
import com.android.server.display.whitebalance.DisplayWhiteBalanceController;
import java.io.PrintWriter;

public class DisplayWhiteBalanceSettings
implements ColorDisplayService.DisplayWhiteBalanceListener {
    protected static final String TAG = "DisplayWhiteBalanceSettings";
    protected boolean mLoggingEnabled;
    private static final int MSG_SET_ACTIVE = 1;
    private final Context mContext;
    private final Handler mHandler;
    private final ColorDisplayService.ColorDisplayServiceInternal mCdsi;
    private DisplayWhiteBalanceController.Callbacks mCallbacks;
    private boolean mEnabled;
    private boolean mActive;

    public DisplayWhiteBalanceSettings(Context context, Handler handler) {
        this.validateArguments(context, handler);
        this.mLoggingEnabled = false;
        this.mContext = context;
        this.mHandler = new DisplayWhiteBalanceSettingsHandler(handler.getLooper());
        this.mCallbacks = null;
        this.mCdsi = LocalServices.getService(ColorDisplayService.ColorDisplayServiceInternal.class);
        this.setEnabled(this.mCdsi.isDisplayWhiteBalanceEnabled());
        boolean isActive = this.mCdsi.setDisplayWhiteBalanceListener(this);
        this.setActive(isActive);
    }

    public boolean setCallbacks(DisplayWhiteBalanceController.Callbacks callbacks) {
        if (this.mCallbacks == callbacks) {
            return false;
        }
        this.mCallbacks = callbacks;
        return true;
    }

    public boolean setLoggingEnabled(boolean loggingEnabled) {
        if (this.mLoggingEnabled == loggingEnabled) {
            return false;
        }
        this.mLoggingEnabled = loggingEnabled;
        return true;
    }

    public boolean isEnabled() {
        return this.mEnabled && this.mActive;
    }

    public void dump(PrintWriter writer) {
        writer.println(TAG);
        writer.println("  mLoggingEnabled=" + this.mLoggingEnabled);
        writer.println("  mContext=" + this.mContext);
        writer.println("  mHandler=" + this.mHandler);
        writer.println("  mEnabled=" + this.mEnabled);
        writer.println("  mActive=" + this.mActive);
        writer.println("  mCallbacks=" + this.mCallbacks);
    }

    @Override
    public void onDisplayWhiteBalanceStatusChanged(boolean activated) {
        Message msg = this.mHandler.obtainMessage(1, activated ? 1 : 0, 0);
        msg.sendToTarget();
    }

    private void validateArguments(Context context, Handler handler) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(handler, "handler must not be null");
    }

    private void setEnabled(boolean enabled) {
        if (this.mEnabled == enabled) {
            return;
        }
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "Setting: " + enabled);
        }
        this.mEnabled = enabled;
        if (this.mCallbacks != null) {
            this.mCallbacks.updateWhiteBalance();
        }
    }

    private void setActive(boolean active) {
        if (this.mActive == active) {
            return;
        }
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "Active: " + active);
        }
        this.mActive = active;
        if (this.mCallbacks != null) {
            this.mCallbacks.updateWhiteBalance();
        }
    }

    private final class DisplayWhiteBalanceSettingsHandler
    extends Handler {
        DisplayWhiteBalanceSettingsHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DisplayWhiteBalanceSettings.this.setActive(msg.arg1 != 0);
                    DisplayWhiteBalanceSettings.this.setEnabled(DisplayWhiteBalanceSettings.this.mCdsi.isDisplayWhiteBalanceEnabled());
                }
            }
        }
    }
}

