/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.whitebalance;

import android.util.Slog;
import java.io.PrintWriter;
import java.util.Arrays;

class DisplayWhiteBalanceThrottler {
    protected static final String TAG = "DisplayWhiteBalanceThrottler";
    protected boolean mLoggingEnabled;
    private int mIncreaseDebounce;
    private int mDecreaseDebounce;
    private long mLastTime;
    private float[] mBaseThresholds;
    private float[] mIncreaseThresholds;
    private float[] mDecreaseThresholds;
    private float mIncreaseThreshold;
    private float mDecreaseThreshold;
    private float mLastValue;

    DisplayWhiteBalanceThrottler(int increaseDebounce, int decreaseDebounce, float[] baseThresholds, float[] increaseThresholds, float[] decreaseThresholds) {
        this.validateArguments(increaseDebounce, decreaseDebounce, baseThresholds, increaseThresholds, decreaseThresholds);
        this.mLoggingEnabled = false;
        this.mIncreaseDebounce = increaseDebounce;
        this.mDecreaseDebounce = decreaseDebounce;
        this.mBaseThresholds = baseThresholds;
        this.mIncreaseThresholds = increaseThresholds;
        this.mDecreaseThresholds = decreaseThresholds;
        this.clear();
    }

    public boolean throttle(float value) {
        if (this.mLastTime != -1L && (this.tooSoon(value) || this.tooClose(value))) {
            return true;
        }
        this.computeThresholds(value);
        this.mLastTime = System.currentTimeMillis();
        this.mLastValue = value;
        return false;
    }

    public void clear() {
        this.mLastTime = -1L;
        this.mIncreaseThreshold = -1.0f;
        this.mDecreaseThreshold = -1.0f;
        this.mLastValue = -1.0f;
    }

    public boolean setLoggingEnabled(boolean loggingEnabled) {
        if (this.mLoggingEnabled == loggingEnabled) {
            return false;
        }
        this.mLoggingEnabled = loggingEnabled;
        return true;
    }

    public void dump(PrintWriter writer) {
        writer.println("  DisplayWhiteBalanceThrottler");
        writer.println("    mLoggingEnabled=" + this.mLoggingEnabled);
        writer.println("    mIncreaseDebounce=" + this.mIncreaseDebounce);
        writer.println("    mDecreaseDebounce=" + this.mDecreaseDebounce);
        writer.println("    mLastTime=" + this.mLastTime);
        writer.println("    mBaseThresholds=" + Arrays.toString(this.mBaseThresholds));
        writer.println("    mIncreaseThresholds=" + Arrays.toString(this.mIncreaseThresholds));
        writer.println("    mDecreaseThresholds=" + Arrays.toString(this.mDecreaseThresholds));
        writer.println("    mIncreaseThreshold=" + this.mIncreaseThreshold);
        writer.println("    mDecreaseThreshold=" + this.mDecreaseThreshold);
        writer.println("    mLastValue=" + this.mLastValue);
    }

    private void validateArguments(float increaseDebounce, float decreaseDebounce, float[] baseThresholds, float[] increaseThresholds, float[] decreaseThresholds) {
        if (Float.isNaN(increaseDebounce) || increaseDebounce < 0.0f) {
            throw new IllegalArgumentException("increaseDebounce must be a non-negative number.");
        }
        if (Float.isNaN(decreaseDebounce) || decreaseDebounce < 0.0f) {
            throw new IllegalArgumentException("decreaseDebounce must be a non-negative number.");
        }
        if (!DisplayWhiteBalanceThrottler.isValidMapping(baseThresholds, increaseThresholds)) {
            throw new IllegalArgumentException("baseThresholds to increaseThresholds is not a valid mapping.");
        }
        if (!DisplayWhiteBalanceThrottler.isValidMapping(baseThresholds, decreaseThresholds)) {
            throw new IllegalArgumentException("baseThresholds to decreaseThresholds is not a valid mapping.");
        }
    }

    private static boolean isValidMapping(float[] x, float[] y) {
        if (x == null || y == null || x.length == 0 || y.length == 0 || x.length != y.length) {
            return false;
        }
        float prevX = -1.0f;
        for (int i = 0; i < x.length; ++i) {
            if (Float.isNaN(x[i]) || Float.isNaN(y[i]) || x[i] < 0.0f || prevX >= x[i]) {
                return false;
            }
            prevX = x[i];
        }
        return true;
    }

    private boolean tooSoon(float value) {
        boolean tooSoon;
        long time = System.currentTimeMillis();
        long earliestTime = value > this.mLastValue ? this.mLastTime + (long)this.mIncreaseDebounce : this.mLastTime + (long)this.mDecreaseDebounce;
        boolean bl = tooSoon = time < earliestTime;
        if (this.mLoggingEnabled) {
            Slog.d(TAG, (tooSoon ? "too soon: " : "late enough: ") + time + (tooSoon ? " < " : " > ") + earliestTime);
        }
        return tooSoon;
    }

    private boolean tooClose(float value) {
        boolean tooClose;
        float threshold;
        if (value > this.mLastValue) {
            threshold = this.mIncreaseThreshold;
            tooClose = value < threshold;
        } else {
            threshold = this.mDecreaseThreshold;
            boolean bl = tooClose = value > threshold;
        }
        if (this.mLoggingEnabled) {
            Slog.d(TAG, (tooClose ? "too close: " : "far enough: ") + value + (value > threshold ? " > " : " < ") + threshold);
        }
        return tooClose;
    }

    private void computeThresholds(float value) {
        int index = this.getHighestIndexBefore(value, this.mBaseThresholds);
        this.mIncreaseThreshold = value * (1.0f + this.mIncreaseThresholds[index]);
        this.mDecreaseThreshold = value * (1.0f - this.mDecreaseThresholds[index]);
    }

    private int getHighestIndexBefore(float value, float[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] >= value)) continue;
            return i;
        }
        return values.length - 1;
    }
}

