/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.gpu;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.gamedriver.GameDriverProto;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.util.Base64;
import com.android.framework.protobuf.InvalidProtocolBufferException;
import com.android.internal.annotations.GuardedBy;
import com.android.server.SystemService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GpuService
extends SystemService {
    public static final String TAG = "GpuService";
    public static final boolean DEBUG = false;
    private static final String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";
    private static final String GAME_DRIVER_WHITELIST_FILENAME = "whitelist.txt";
    private static final int BASE64_FLAGS = 3;
    private final Context mContext;
    private final String mDriverPackageName;
    private final PackageManager mPackageManager;
    private final Object mLock = new Object();
    private final Object mDeviceConfigLock = new Object();
    private ContentResolver mContentResolver;
    private long mGameDriverVersionCode;
    private SettingsObserver mSettingsObserver;
    private DeviceConfigListener mDeviceConfigListener;
    @GuardedBy(value={"mLock"})
    private GameDriverProto.Blacklists mBlacklists;

    public GpuService(Context context) {
        super(context);
        this.mContext = context;
        this.mDriverPackageName = SystemProperties.get(PROPERTY_GFX_DRIVER);
        this.mGameDriverVersionCode = -1L;
        this.mPackageManager = context.getPackageManager();
        if (this.mDriverPackageName != null && !this.mDriverPackageName.isEmpty()) {
            IntentFilter packageFilter = new IntentFilter();
            packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
            packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
            packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
            packageFilter.addDataScheme("package");
            this.getContext().registerReceiverAsUser(new PackageReceiver(), UserHandle.ALL, packageFilter, null, null);
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 1000) {
            this.mContentResolver = this.mContext.getContentResolver();
            if (this.mDriverPackageName == null || this.mDriverPackageName.isEmpty()) {
                return;
            }
            this.mSettingsObserver = new SettingsObserver();
            this.mDeviceConfigListener = new DeviceConfigListener();
            this.fetchGameDriverPackageProperties();
            this.processBlacklists();
            this.setBlacklist();
        }
    }

    private static void assetToSettingsGlobal(Context context, Context driverContext, String fileName, String settingsGlobal, CharSequence delimiter) {
        try {
            String assetString;
            BufferedReader reader = new BufferedReader(new InputStreamReader(driverContext.getAssets().open(fileName)));
            ArrayList<String> assetStrings = new ArrayList<String>();
            while ((assetString = reader.readLine()) != null) {
                assetStrings.add(assetString);
            }
            Settings.Global.putString(context.getContentResolver(), settingsGlobal, String.join(delimiter, assetStrings));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fetchGameDriverPackageProperties() {
        ApplicationInfo driverInfo;
        try {
            driverInfo = this.mPackageManager.getApplicationInfo(this.mDriverPackageName, 0x100000);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (driverInfo.targetSdkVersion < 26) {
            return;
        }
        Settings.Global.putString(this.mContentResolver, "game_driver_whitelist", "");
        this.mGameDriverVersionCode = driverInfo.longVersionCode;
        try {
            Context driverContext = this.mContext.createPackageContext(this.mDriverPackageName, 4);
            GpuService.assetToSettingsGlobal(this.mContext, driverContext, GAME_DRIVER_WHITELIST_FILENAME, "game_driver_whitelist", ",");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private void processBlacklists() {
        String base64String = DeviceConfig.getProperty("game_driver", "game_driver_blacklists");
        if (base64String == null) {
            base64String = Settings.Global.getString(this.mContentResolver, "game_driver_blacklists");
        }
        this.parseBlacklists(base64String != null ? base64String : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBlacklists(String base64String) {
        Object object = this.mLock;
        synchronized (object) {
            this.mBlacklists = null;
            try {
                this.mBlacklists = GameDriverProto.Blacklists.parseFrom(Base64.decode(base64String, 3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setBlacklist() {
        Settings.Global.putString(this.mContentResolver, "game_driver_blacklist", "");
        Object object = this.mLock;
        synchronized (object) {
            GameDriverProto.Blacklist blacklist;
            if (this.mBlacklists == null) {
                return;
            }
            List<GameDriverProto.Blacklist> blacklists = this.mBlacklists.getBlacklistsList();
            Iterator<GameDriverProto.Blacklist> iterator = blacklists.iterator();
            do {
                if (!iterator.hasNext()) return;
            } while ((blacklist = iterator.next()).getVersionCode() != this.mGameDriverVersionCode);
            Settings.Global.putString(this.mContentResolver, "game_driver_blacklist", String.join((CharSequence)",", blacklist.getPackageNamesList()));
            return;
        }
    }

    private final class PackageReceiver
    extends BroadcastReceiver {
        private PackageReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String packageName;
            Uri data = intent.getData();
            if (data == null) {
                // empty if block
            }
            if (!(packageName = data.getSchemeSpecificPart()).equals(GpuService.this.mDriverPackageName)) {
                return;
            }
            boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
            switch (intent.getAction()) {
                case "android.intent.action.PACKAGE_ADDED": 
                case "android.intent.action.PACKAGE_CHANGED": 
                case "android.intent.action.PACKAGE_REMOVED": {
                    GpuService.this.fetchGameDriverPackageProperties();
                    GpuService.this.setBlacklist();
                    break;
                }
            }
        }
    }

    private final class DeviceConfigListener
    implements DeviceConfig.OnPropertiesChangedListener {
        DeviceConfigListener() {
            DeviceConfig.addOnPropertiesChangedListener("game_driver", GpuService.this.mContext.getMainExecutor(), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPropertiesChanged(DeviceConfig.Properties properties) {
            Object object = GpuService.this.mDeviceConfigLock;
            synchronized (object) {
                if (properties.getKeyset().contains("game_driver_blacklists")) {
                    GpuService.this.parseBlacklists(properties.getString("game_driver_blacklists", ""));
                    GpuService.this.setBlacklist();
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri mGameDriverBlackUri;

        SettingsObserver() {
            super(new Handler());
            this.mGameDriverBlackUri = Settings.Global.getUriFor("game_driver_blacklists");
            GpuService.this.mContentResolver.registerContentObserver(this.mGameDriverBlackUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (uri == null) {
                return;
            }
            if (this.mGameDriverBlackUri.equals(uri)) {
                GpuService.this.processBlacklists();
                GpuService.this.setBlacklist();
            }
        }
    }
}

