/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;

final class ActiveSourceHandler {
    private static final String TAG = "ActiveSourceHandler";
    private final HdmiCecLocalDeviceTv mSource;
    private final HdmiControlService mService;
    private final IHdmiControlCallback mCallback;

    static ActiveSourceHandler create(HdmiCecLocalDeviceTv source, IHdmiControlCallback callback) {
        if (source == null) {
            Slog.e(TAG, "Wrong arguments");
            return null;
        }
        return new ActiveSourceHandler(source, callback);
    }

    private ActiveSourceHandler(HdmiCecLocalDeviceTv source, IHdmiControlCallback callback) {
        this.mSource = source;
        this.mService = this.mSource.getService();
        this.mCallback = callback;
    }

    void process(HdmiCecLocalDevice.ActiveSource newActive, int deviceType) {
        HdmiCecLocalDeviceTv tv = this.mSource;
        HdmiDeviceInfo device = this.mService.getDeviceInfo(newActive.logicalAddress);
        if (device == null) {
            tv.startNewDeviceAction(newActive, deviceType);
        }
        if (!tv.isProhibitMode()) {
            boolean notifyInputChange;
            HdmiCecLocalDevice.ActiveSource old = HdmiCecLocalDevice.ActiveSource.of(tv.getActiveSource());
            tv.updateActiveSource(newActive);
            boolean bl = notifyInputChange = this.mCallback == null;
            if (!old.equals(newActive)) {
                tv.setPrevPortId(tv.getActivePortId());
            }
            tv.updateActiveInput(newActive.physicalAddress, notifyInputChange);
            this.invokeCallback(0);
        } else {
            HdmiCecLocalDevice.ActiveSource current = tv.getActiveSource();
            if (current.logicalAddress == this.getSourceAddress()) {
                HdmiCecMessage activeSourceCommand = HdmiCecMessageBuilder.buildActiveSource(current.logicalAddress, current.physicalAddress);
                this.mService.sendCecCommand(activeSourceCommand);
                tv.updateActiveSource(current);
                this.invokeCallback(0);
            } else {
                tv.startRoutingControl(newActive.physicalAddress, current.physicalAddress, true, this.mCallback);
            }
        }
    }

    private final int getSourceAddress() {
        return this.mSource.getDeviceInfo().getLogicalAddress();
    }

    private void invokeCallback(int result) {
        if (this.mCallback == null) {
            return;
        }
        try {
            this.mCallback.onComplete(result);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Callback failed:" + e);
        }
    }
}

