/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiLogger;

public class ArcInitiationActionFromAvr
extends HdmiCecFeatureAction {
    private static final int STATE_WAITING_FOR_INITIATE_ARC_RESPONSE = 1;
    private static final int STATE_ARC_INITIATED = 2;
    private static final int TIMEOUT_MS = 1000;
    private static final int MAX_RETRY_COUNT = 5;
    private int mSendRequestActiveSourceRetryCount = 0;

    ArcInitiationActionFromAvr(HdmiCecLocalDevice source) {
        super(source);
    }

    @Override
    boolean start() {
        this.audioSystem().setArcStatus(true);
        this.mState = 1;
        this.addTimer(this.mState, 1000);
        this.sendInitiateArc();
        return true;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1) {
            return false;
        }
        switch (cmd.getOpcode()) {
            case 0: {
                if ((cmd.getParams()[0] & 0xFF) == 192) {
                    this.audioSystem().setArcStatus(false);
                    this.finish();
                    return true;
                }
                return false;
            }
            case 194: {
                this.audioSystem().setArcStatus(false);
                this.finish();
                return true;
            }
            case 193: {
                this.mState = 2;
                if (this.audioSystem().getActiveSource().physicalAddress != this.getSourcePath() && this.audioSystem().isSystemAudioActivated()) {
                    this.sendRequestActiveSource();
                } else {
                    this.finish();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.handleInitiateArcTimeout();
            }
        }
    }

    protected void sendInitiateArc() {
        this.sendCommand(HdmiCecMessageBuilder.buildInitiateArc(this.getSourceAddress(), 0), result -> {
            if (result != 0) {
                this.audioSystem().setArcStatus(false);
                this.finish();
            }
        });
    }

    private void handleInitiateArcTimeout() {
        HdmiLogger.debug("handleInitiateArcTimeout", new Object[0]);
        this.audioSystem().setArcStatus(false);
        this.finish();
    }

    protected void sendRequestActiveSource() {
        this.sendCommand(HdmiCecMessageBuilder.buildRequestActiveSource(this.getSourceAddress()), result -> {
            if (result != 0) {
                if (this.mSendRequestActiveSourceRetryCount < 5) {
                    ++this.mSendRequestActiveSourceRetryCount;
                    this.sendRequestActiveSource();
                } else {
                    this.finish();
                }
            } else {
                this.finish();
            }
        });
    }
}

