/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiLogger;

public class ArcTerminationActionFromAvr
extends HdmiCecFeatureAction {
    private static final int STATE_WAITING_FOR_INITIATE_ARC_RESPONSE = 1;
    private static final int STATE_ARC_TERMINATED = 2;
    private static final int TIMEOUT_MS = 1000;

    ArcTerminationActionFromAvr(HdmiCecLocalDevice source) {
        super(source);
    }

    @Override
    boolean start() {
        this.mState = 1;
        this.addTimer(this.mState, 1000);
        this.sendTerminateArc();
        return true;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1) {
            return false;
        }
        switch (cmd.getOpcode()) {
            case 194: {
                this.mState = 2;
                this.audioSystem().setArcStatus(false);
                if (this.audioSystem().getLocalActivePort() == 17) {
                    this.audioSystem().routeToInputFromPortId(this.audioSystem().getRoutingPort());
                }
                this.finish();
                return true;
            }
        }
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.handleTerminateArcTimeout();
            }
        }
    }

    protected void sendTerminateArc() {
        this.sendCommand(HdmiCecMessageBuilder.buildTerminateArc(this.getSourceAddress(), 0), result -> {
            if (result != 0) {
                HdmiLogger.debug("Terminate ARC was not successfully sent.", new Object[0]);
                this.finish();
            }
        });
    }

    private void handleTerminateArcTimeout() {
        HdmiLogger.debug("handleTerminateArcTimeout", new Object[0]);
        this.finish();
    }
}

