/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDeviceAudioSystem;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;

public class DetectTvSystemAudioModeSupportAction
extends HdmiCecFeatureAction {
    private static final int STATE_WAITING_FOR_FEATURE_ABORT = 1;
    private HdmiCecLocalDeviceAudioSystem.TvSystemAudioModeSupportedCallback mCallback;
    private int mState;

    DetectTvSystemAudioModeSupportAction(HdmiCecLocalDevice source, HdmiCecLocalDeviceAudioSystem.TvSystemAudioModeSupportedCallback callback) {
        super(source);
        this.mCallback = callback;
    }

    @Override
    boolean start() {
        this.mState = 1;
        this.addTimer(this.mState, 2000);
        this.sendSetSystemAudioMode();
        return true;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (cmd.getOpcode() == 0) {
            if (this.mState != 1) {
                return false;
            }
            if ((cmd.getParams()[0] & 0xFF) == 114) {
                this.finishAction(false);
                return true;
            }
        }
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.finishAction(true);
            }
        }
    }

    protected void sendSetSystemAudioMode() {
        this.sendCommand(HdmiCecMessageBuilder.buildSetSystemAudioMode(this.getSourceAddress(), 0, true), result -> {
            if (result != 0) {
                this.finishAction(false);
            }
        });
    }

    private void finishAction(boolean supported) {
        this.mCallback.onResult(supported);
        this.audioSystem().setTvSystemAudioModeSupport(supported);
        this.finish();
    }
}

