/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;

final class DeviceSelectAction
extends HdmiCecFeatureAction {
    private static final String TAG = "DeviceSelect";
    private static final int TIMEOUT_TRANSIT_TO_STANDBY_MS = 5000;
    private static final int TIMEOUT_POWER_ON_MS = 5000;
    private static final int LOOP_COUNTER_MAX = 20;
    private static final int STATE_WAIT_FOR_REPORT_POWER_STATUS = 1;
    private static final int STATE_WAIT_FOR_DEVICE_TO_TRANSIT_TO_STANDBY = 2;
    private static final int STATE_WAIT_FOR_DEVICE_POWER_ON = 3;
    private final HdmiDeviceInfo mTarget;
    private final IHdmiControlCallback mCallback;
    private final HdmiCecMessage mGivePowerStatus;
    private int mPowerStatusCounter = 0;

    public DeviceSelectAction(HdmiCecLocalDeviceTv source, HdmiDeviceInfo target, IHdmiControlCallback callback) {
        super(source);
        this.mCallback = callback;
        this.mTarget = target;
        this.mGivePowerStatus = HdmiCecMessageBuilder.buildGiveDevicePowerStatus(this.getSourceAddress(), this.getTargetAddress());
    }

    int getTargetAddress() {
        return this.mTarget.getLogicalAddress();
    }

    @Override
    public boolean start() {
        this.queryDevicePowerStatus();
        return true;
    }

    private void queryDevicePowerStatus() {
        this.sendCommand(this.mGivePowerStatus, new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    DeviceSelectAction.this.invokeCallback(7);
                    DeviceSelectAction.this.finish();
                    return;
                }
            }
        });
        this.mState = 1;
        this.addTimer(this.mState, 2000);
    }

    @Override
    public boolean processCommand(HdmiCecMessage cmd) {
        if (cmd.getSource() != this.getTargetAddress()) {
            return false;
        }
        int opcode = cmd.getOpcode();
        byte[] params = cmd.getParams();
        switch (this.mState) {
            case 1: {
                if (opcode == 144) {
                    return this.handleReportPowerStatus(params[0]);
                }
                return false;
            }
        }
        return false;
    }

    private boolean handleReportPowerStatus(int powerStatus) {
        switch (powerStatus) {
            case 0: {
                this.sendSetStreamPath();
                return true;
            }
            case 3: {
                if (this.mPowerStatusCounter < 4) {
                    this.mState = 2;
                    this.addTimer(this.mState, 5000);
                } else {
                    this.sendSetStreamPath();
                }
                return true;
            }
            case 1: {
                if (this.mPowerStatusCounter == 0) {
                    this.turnOnDevice();
                } else {
                    this.sendSetStreamPath();
                }
                return true;
            }
            case 2: {
                if (this.mPowerStatusCounter < 20) {
                    this.mState = 3;
                    this.addTimer(this.mState, 5000);
                } else {
                    this.sendSetStreamPath();
                }
                return true;
            }
        }
        return false;
    }

    private void turnOnDevice() {
        this.sendUserControlPressedAndReleased(this.mTarget.getLogicalAddress(), 64);
        this.sendUserControlPressedAndReleased(this.mTarget.getLogicalAddress(), 109);
        this.mState = 3;
        this.addTimer(this.mState, 5000);
    }

    private void sendSetStreamPath() {
        this.tv().getActiveSource().invalidate();
        this.tv().setActivePath(this.mTarget.getPhysicalAddress());
        this.sendCommand(HdmiCecMessageBuilder.buildSetStreamPath(this.getSourceAddress(), this.mTarget.getPhysicalAddress()));
        this.invokeCallback(0);
        this.finish();
    }

    @Override
    public void handleTimerEvent(int timeoutState) {
        if (this.mState != timeoutState) {
            Slog.w(TAG, "Timer in a wrong state. Ignored.");
            return;
        }
        switch (this.mState) {
            case 1: {
                if (this.tv().isPowerStandbyOrTransient()) {
                    this.invokeCallback(6);
                    this.finish();
                    return;
                }
                this.sendSetStreamPath();
                break;
            }
            case 2: 
            case 3: {
                ++this.mPowerStatusCounter;
                this.queryDevicePowerStatus();
            }
        }
    }

    private void invokeCallback(int result) {
        if (this.mCallback == null) {
            return;
        }
        try {
            this.mCallback.onComplete(result);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Callback failed:" + e);
        }
    }
}

