/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.tv.TvContract;
import android.media.tv.TvInputInfo;
import android.media.tv.TvInputManager;
import android.os.SystemProperties;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.hdmi.ArcInitiationActionFromAvr;
import com.android.server.hdmi.ArcTerminationActionFromAvr;
import com.android.server.hdmi.DetectTvSystemAudioModeSupportAction;
import com.android.server.hdmi.DeviceDiscoveryAction;
import com.android.server.hdmi.HdmiAnnotations;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDeviceSource;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.SystemAudioInitiationActionFromAvr;
import com.android.server.hdmi.VolumeControlAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.xmlpull.v1.XmlPullParserException;

public class HdmiCecLocalDeviceAudioSystem
extends HdmiCecLocalDeviceSource {
    private static final String TAG = "HdmiCecLocalDeviceAudioSystem";
    @GuardedBy(value={"mLock"})
    private boolean mSystemAudioControlFeatureEnabled;
    private Boolean mTvSystemAudioModeSupport = null;
    @HdmiAnnotations.ServiceThreadOnly
    private boolean mArcEstablished = false;
    private boolean mArcIntentUsed = SystemProperties.get("ro.hdmi.property_sytem_audio_device_arc_port", "0").contains("tvinput");
    @GuardedBy(value={"mLock"})
    private final HashMap<Integer, String> mPortIdToTvInputs = new HashMap();
    @GuardedBy(value={"mLock"})
    private final HashMap<String, HdmiDeviceInfo> mTvInputsToDeviceInfo = new HashMap();
    @GuardedBy(value={"mLock"})
    private List<HdmiDeviceInfo> mSafeAllDeviceInfos = Collections.emptyList();
    private final SparseArray<HdmiDeviceInfo> mDeviceInfos = new SparseArray();
    private static final String SHORT_AUDIO_DESCRIPTOR_CONFIG_PATH = "/vendor/etc/sadConfig.xml";
    private final TvInputManager.TvInputCallback mTvInputCallback = new TvInputManager.TvInputCallback(){

        @Override
        public void onInputAdded(String inputId) {
            HdmiCecLocalDeviceAudioSystem.this.addOrUpdateTvInput(inputId);
        }

        @Override
        public void onInputRemoved(String inputId) {
            HdmiCecLocalDeviceAudioSystem.this.removeTvInput(inputId);
        }

        @Override
        public void onInputUpdated(String inputId) {
            HdmiCecLocalDeviceAudioSystem.this.addOrUpdateTvInput(inputId);
        }
    };

    protected HdmiCecLocalDeviceAudioSystem(HdmiControlService service) {
        super(service, 5);
        this.mRoutingControlFeatureEnabled = this.mService.readBooleanSetting("hdmi_cec_switch_enabled", false);
        this.mSystemAudioControlFeatureEnabled = this.mService.readBooleanSetting("hdmi_system_audio_control_enabled", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    private void addOrUpdateTvInput(String inputId) {
        this.assertRunOnServiceThread();
        Object object = this.mLock;
        synchronized (object) {
            TvInputInfo tvInfo = this.mService.getTvInputManager().getTvInputInfo(inputId);
            if (tvInfo == null) {
                return;
            }
            HdmiDeviceInfo info = tvInfo.getHdmiDeviceInfo();
            if (info == null) {
                return;
            }
            this.mPortIdToTvInputs.put(info.getPortId(), inputId);
            this.mTvInputsToDeviceInfo.put(inputId, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    private void removeTvInput(String inputId) {
        this.assertRunOnServiceThread();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTvInputsToDeviceInfo.get(inputId) == null) {
                return;
            }
            int portId = this.mTvInputsToDeviceInfo.get(inputId).getPortId();
            this.mPortIdToTvInputs.remove(portId);
            this.mTvInputsToDeviceInfo.remove(inputId);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    final void addCecDevice(HdmiDeviceInfo info) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo old = this.addDeviceInfo(info);
        if (info.getPhysicalAddress() == this.mService.getPhysicalAddress()) {
            return;
        }
        if (old == null) {
            this.invokeDeviceEventListener(info, 1);
        } else if (!old.equals(info)) {
            this.invokeDeviceEventListener(old, 2);
            this.invokeDeviceEventListener(info, 1);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    final void removeCecDevice(int address) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo info = this.removeDeviceInfo(HdmiDeviceInfo.idForCecDevice(address));
        this.mCecMessageCache.flushMessagesFrom(address);
        this.invokeDeviceEventListener(info, 2);
    }

    @HdmiAnnotations.ServiceThreadOnly
    final void updateCecDevice(HdmiDeviceInfo info) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo old = this.addDeviceInfo(info);
        if (old == null) {
            this.invokeDeviceEventListener(info, 1);
        } else if (!old.equals(info)) {
            this.invokeDeviceEventListener(info, 3);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    @VisibleForTesting
    protected HdmiDeviceInfo addDeviceInfo(HdmiDeviceInfo deviceInfo) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo oldDeviceInfo = this.getCecDeviceInfo(deviceInfo.getLogicalAddress());
        if (oldDeviceInfo != null) {
            this.removeDeviceInfo(deviceInfo.getId());
        }
        this.mDeviceInfos.append(deviceInfo.getId(), deviceInfo);
        this.updateSafeDeviceInfoList();
        return oldDeviceInfo;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private HdmiDeviceInfo removeDeviceInfo(int id2) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo deviceInfo = this.mDeviceInfos.get(id2);
        if (deviceInfo != null) {
            this.mDeviceInfos.remove(id2);
        }
        this.updateSafeDeviceInfoList();
        return deviceInfo;
    }

    @HdmiAnnotations.ServiceThreadOnly
    HdmiDeviceInfo getCecDeviceInfo(int logicalAddress) {
        this.assertRunOnServiceThread();
        return this.mDeviceInfos.get(HdmiDeviceInfo.idForCecDevice(logicalAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    private void updateSafeDeviceInfoList() {
        this.assertRunOnServiceThread();
        List<HdmiDeviceInfo> copiedDevices = HdmiUtils.sparseArrayToList(this.mDeviceInfos);
        Object object = this.mLock;
        synchronized (object) {
            this.mSafeAllDeviceInfos = copiedDevices;
        }
    }

    @GuardedBy(value={"mLock"})
    List<HdmiDeviceInfo> getSafeCecDevicesLocked() {
        ArrayList<HdmiDeviceInfo> infoList = new ArrayList<HdmiDeviceInfo>();
        for (HdmiDeviceInfo info : this.mSafeAllDeviceInfos) {
            infoList.add(info);
        }
        return infoList;
    }

    private void invokeDeviceEventListener(HdmiDeviceInfo info, int status) {
        this.mService.invokeDeviceEventListeners(info, status);
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    void onHotplug(int portId, boolean connected) {
        this.assertRunOnServiceThread();
        if (connected) {
            this.mService.wakeUp();
        }
        if (this.mService.getPortInfo(portId).getType() == 1) {
            this.mCecMessageCache.flushAll();
        } else if (!connected && this.mPortIdToTvInputs.get(portId) != null) {
            String tvInputId = this.mPortIdToTvInputs.get(portId);
            HdmiDeviceInfo info = this.mTvInputsToDeviceInfo.get(tvInputId);
            if (info == null) {
                return;
            }
            this.removeCecDevice(info.getLogicalAddress());
        }
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void disableDevice(boolean initiatedByCec, HdmiCecLocalDevice.PendingActionClearedCallback callback) {
        super.disableDevice(initiatedByCec, callback);
        this.assertRunOnServiceThread();
        this.mService.unregisterTvInputCallback(this.mTvInputCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void onStandby(boolean initiatedByCec, int standbyAction) {
        this.assertRunOnServiceThread();
        this.mTvSystemAudioModeSupport = null;
        Object object = this.mLock;
        synchronized (object) {
            this.mService.writeStringSystemProperty("persist.sys.hdmi.last_system_audio_control", this.isSystemAudioActivated() ? "true" : "false");
        }
        this.terminateSystemAudioMode();
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void onAddressAllocated(int logicalAddress, int reason) {
        this.assertRunOnServiceThread();
        if (reason == 0) {
            this.mService.setAndBroadcastActiveSource(this.mService.getPhysicalAddress(), this.getDeviceInfo().getDeviceType(), 15);
        }
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildReportPhysicalAddressCommand(this.mAddress, this.mService.getPhysicalAddress(), this.mDeviceType));
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildDeviceVendorIdCommand(this.mAddress, this.mService.getVendorId()));
        this.mService.registerTvInputCallback(this.mTvInputCallback);
        int systemAudioControlOnPowerOnProp = SystemProperties.getInt("persist.sys.hdmi.system_audio_control_on_power_on", 0);
        boolean lastSystemAudioControlStatus = SystemProperties.getBoolean("persist.sys.hdmi.last_system_audio_control", true);
        this.systemAudioControlOnPowerOn(systemAudioControlOnPowerOnProp, lastSystemAudioControlStatus);
        this.clearDeviceInfoList();
        this.launchDeviceDiscovery();
        this.startQueuedActions();
    }

    @Override
    protected int findKeyReceiverAddress() {
        if (this.getActiveSource().isValid()) {
            return this.getActiveSource().logicalAddress;
        }
        return -1;
    }

    @VisibleForTesting
    protected void systemAudioControlOnPowerOn(int systemAudioOnPowerOnProp, boolean lastSystemAudioControlStatus) {
        if (systemAudioOnPowerOnProp == 0 || systemAudioOnPowerOnProp == 1 && lastSystemAudioControlStatus && this.isSystemAudioControlFeatureEnabled()) {
            this.addAndStartAction(new SystemAudioInitiationActionFromAvr(this));
        }
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected int getPreferredAddress() {
        this.assertRunOnServiceThread();
        return SystemProperties.getInt("persist.sys.hdmi.addr.audiosystem", 15);
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void setPreferredAddress(int addr) {
        this.assertRunOnServiceThread();
        this.mService.writeStringSystemProperty("persist.sys.hdmi.addr.audiosystem", String.valueOf(addr));
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleReportPhysicalAddress(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        int path = HdmiUtils.twoBytesToInt(message.getParams());
        int address = message.getSource();
        byte type = message.getParams()[2];
        if (this.hasAction(DeviceDiscoveryAction.class)) {
            Slog.i(TAG, "Ignored while Device Discovery Action is in progress: " + message);
            return true;
        }
        HdmiDeviceInfo oldDevice = this.getCecDeviceInfo(address);
        if (oldDevice == null || oldDevice.getPhysicalAddress() != path) {
            this.addCecDevice(new HdmiDeviceInfo(address, path, this.mService.pathToPortId(path), type, 0xFFFFFF, HdmiUtils.getDefaultDeviceName(address)));
            this.mService.sendCecCommand(HdmiCecMessageBuilder.buildGiveOsdNameCommand(this.mAddress, address));
            return true;
        }
        Slog.w(TAG, "Device info exists. Not updating on Physical Address.");
        return true;
    }

    @Override
    protected boolean handleReportPowerStatus(HdmiCecMessage command) {
        int newStatus = command.getParams()[0] & 0xFF;
        this.updateDevicePowerStatus(command.getSource(), newStatus);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSetOsdName(HdmiCecMessage message) {
        String osdName;
        int source = message.getSource();
        HdmiDeviceInfo deviceInfo = this.getCecDeviceInfo(source);
        if (deviceInfo == null) {
            Slog.i(TAG, "No source device info for <Set Osd Name>." + message);
            return true;
        }
        try {
            osdName = new String(message.getParams(), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            Slog.e(TAG, "Invalid <Set Osd Name> request:" + message, e);
            return true;
        }
        if (deviceInfo.getDisplayName().equals(osdName)) {
            Slog.d(TAG, "Ignore incoming <Set Osd Name> having same osd name:" + message);
            return true;
        }
        Slog.d(TAG, "Updating device OSD name from " + deviceInfo.getDisplayName() + " to " + osdName);
        this.updateCecDevice(new HdmiDeviceInfo(deviceInfo.getLogicalAddress(), deviceInfo.getPhysicalAddress(), deviceInfo.getPortId(), deviceInfo.getDeviceType(), deviceInfo.getVendorId(), osdName));
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleInitiateArc(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("HdmiCecLocalDeviceAudioSystemStub handleInitiateArc", new Object[0]);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleReportArcInitiate(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("HdmiCecLocalDeviceAudioSystemStub handleReportArcInitiate", new Object[0]);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleReportArcTermination(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("HdmiCecLocalDeviceAudioSystemStub handleReportArcTermination", new Object[0]);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGiveAudioStatus(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.isSystemAudioControlFeatureEnabled()) {
            this.reportAudioStatus(message.getSource());
        } else {
            this.mService.maySendFeatureAbortCommand(message, 4);
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGiveSystemAudioModeStatus(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        boolean isSystemAudioModeOnOrTurningOn = this.isSystemAudioActivated();
        if (!isSystemAudioModeOnOrTurningOn && message.getSource() == 0 && this.hasAction(SystemAudioInitiationActionFromAvr.class)) {
            isSystemAudioModeOnOrTurningOn = true;
        }
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildReportSystemAudioMode(this.mAddress, message.getSource(), isSystemAudioModeOnOrTurningOn));
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRequestArcInitiate(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        this.removeAction(ArcInitiationActionFromAvr.class);
        if (!this.mService.readBooleanSystemProperty("persist.sys.hdmi.property_arc_support", true)) {
            this.mService.maySendFeatureAbortCommand(message, 0);
        } else if (!this.isDirectConnectToTv()) {
            HdmiLogger.debug("AVR device is not directly connected with TV", new Object[0]);
            this.mService.maySendFeatureAbortCommand(message, 1);
        } else {
            this.addAndStartAction(new ArcInitiationActionFromAvr(this));
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRequestArcTermination(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!SystemProperties.getBoolean("persist.sys.hdmi.property_arc_support", true)) {
            this.mService.maySendFeatureAbortCommand(message, 0);
        } else if (!this.isArcEnabled()) {
            HdmiLogger.debug("ARC is not established between TV and AVR device", new Object[0]);
            this.mService.maySendFeatureAbortCommand(message, 1);
        } else {
            this.removeAction(ArcTerminationActionFromAvr.class);
            this.addAndStartAction(new ArcTerminationActionFromAvr(this));
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRequestShortAudioDescriptor(HdmiCecMessage message) {
        byte[] sadBytes;
        this.assertRunOnServiceThread();
        HdmiLogger.debug("HdmiCecLocalDeviceAudioSystemStub handleRequestShortAudioDescriptor", new Object[0]);
        if (!this.isSystemAudioControlFeatureEnabled()) {
            this.mService.maySendFeatureAbortCommand(message, 4);
            return true;
        }
        if (!this.isSystemAudioActivated()) {
            this.mService.maySendFeatureAbortCommand(message, 1);
            return true;
        }
        List<HdmiUtils.DeviceConfig> config = null;
        File file = new File(SHORT_AUDIO_DESCRIPTOR_CONFIG_PATH);
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                config = HdmiUtils.ShortAudioDescriptorXmlParser.parse(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                Slog.e(TAG, "Error reading file: " + file, e);
            }
            catch (XmlPullParserException e) {
                Slog.e(TAG, "Unable to parse file: " + file, e);
            }
        }
        int[] audioFormatCodes = this.parseAudioFormatCodes(message.getParams());
        if (config != null && config.size() > 0) {
            sadBytes = this.getSupportedShortAudioDescriptorsFromConfig(config, audioFormatCodes);
        } else {
            AudioDeviceInfo deviceInfo = this.getSystemAudioDeviceInfo();
            if (deviceInfo == null) {
                this.mService.maySendFeatureAbortCommand(message, 5);
                return true;
            }
            sadBytes = this.getSupportedShortAudioDescriptors(deviceInfo, audioFormatCodes);
        }
        if (sadBytes.length == 0) {
            this.mService.maySendFeatureAbortCommand(message, 3);
        } else {
            this.mService.sendCecCommand(HdmiCecMessageBuilder.buildReportShortAudioDescriptor(this.mAddress, message.getSource(), sadBytes));
        }
        return true;
    }

    private byte[] getSupportedShortAudioDescriptors(AudioDeviceInfo deviceInfo, int[] audioFormatCodes) {
        ArrayList<byte[]> sads = new ArrayList<byte[]>(audioFormatCodes.length);
        for (int audioFormatCode : audioFormatCodes) {
            byte[] sad = this.getSupportedShortAudioDescriptor(deviceInfo, audioFormatCode);
            if (sad == null) continue;
            if (sad.length == 3) {
                sads.add(sad);
                continue;
            }
            HdmiLogger.warning("Dropping Short Audio Descriptor with length %d for requested codec %x", sad.length, audioFormatCode);
        }
        return this.getShortAudioDescriptorBytes(sads);
    }

    private byte[] getSupportedShortAudioDescriptorsFromConfig(List<HdmiUtils.DeviceConfig> deviceConfig, int[] audioFormatCodes) {
        HdmiUtils.DeviceConfig deviceConfigToUse = null;
        for (HdmiUtils.DeviceConfig device : deviceConfig) {
            if (!device.name.equals("VX_AUDIO_DEVICE_IN_HDMI_ARC")) continue;
            deviceConfigToUse = device;
            break;
        }
        if (deviceConfigToUse == null) {
            Slog.w(TAG, "sadConfig.xml does not have required device info for VX_AUDIO_DEVICE_IN_HDMI_ARC");
            return new byte[0];
        }
        HashMap<Integer, byte[]> map = new HashMap<Integer, byte[]>();
        ArrayList<byte[]> sads = new ArrayList<byte[]>(audioFormatCodes.length);
        for (HdmiUtils.CodecSad codecSad : deviceConfigToUse.supportedCodecs) {
            map.put(codecSad.audioCodec, codecSad.sad);
        }
        for (int i = 0; i < audioFormatCodes.length; ++i) {
            byte[] sad;
            if (!map.containsKey(audioFormatCodes[i]) || (sad = (byte[])map.get(audioFormatCodes[i])) == null || sad.length != 3) continue;
            sads.add(sad);
        }
        return this.getShortAudioDescriptorBytes(sads);
    }

    private byte[] getShortAudioDescriptorBytes(ArrayList<byte[]> sads) {
        byte[] bytes = new byte[sads.size() * 3];
        int index = 0;
        for (byte[] sad : sads) {
            System.arraycopy(sad, 0, bytes, index, 3);
            index += 3;
        }
        return bytes;
    }

    private byte[] getSupportedShortAudioDescriptor(AudioDeviceInfo deviceInfo, int audioFormatCode) {
        switch (audioFormatCode) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getLpcmShortAudioDescriptor(deviceInfo);
            }
        }
        return null;
    }

    private byte[] getLpcmShortAudioDescriptor(AudioDeviceInfo deviceInfo) {
        return null;
    }

    private AudioDeviceInfo getSystemAudioDeviceInfo() {
        AudioManager audioManager = this.mService.getContext().getSystemService(AudioManager.class);
        if (audioManager == null) {
            HdmiLogger.error("Error getting system audio device because AudioManager not available.", new Object[0]);
            return null;
        }
        AudioDeviceInfo[] devices = audioManager.getDevices(1);
        HdmiLogger.debug("Found %d audio input devices", devices.length);
        for (AudioDeviceInfo device : devices) {
            HdmiLogger.debug("%s at port %s", device.getProductName(), device.getPort());
            HdmiLogger.debug("Supported encodings are %s", Arrays.stream(device.getEncodings()).mapToObj(AudioFormat::toLogFriendlyEncoding).collect(Collectors.joining(", ")));
            if (device.getType() != 10) continue;
            return device;
        }
        return null;
    }

    private int[] parseAudioFormatCodes(byte[] params) {
        int[] audioFormatCodes = new int[params.length];
        for (int i = 0; i < params.length; ++i) {
            int val = params[i];
            audioFormatCodes[i] = val >= 1 && val <= 15 ? val : 0;
        }
        return audioFormatCodes;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSystemAudioModeRequest(HdmiCecMessage message) {
        boolean systemAudioStatusOn;
        this.assertRunOnServiceThread();
        boolean bl = systemAudioStatusOn = message.getParams().length != 0;
        if (message.getSource() != 0) {
            if (systemAudioStatusOn) {
                this.handleSystemAudioModeOnFromNonTvDevice(message);
                return true;
            }
        } else {
            this.setTvSystemAudioModeSupport(true);
        }
        if (!this.checkSupportAndSetSystemAudioMode(systemAudioStatusOn)) {
            this.mService.maySendFeatureAbortCommand(message, 4);
            return true;
        }
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildSetSystemAudioMode(this.mAddress, 15, systemAudioStatusOn));
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSetSystemAudioMode(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.checkSupportAndSetSystemAudioMode(HdmiUtils.parseCommandParamSystemAudioStatus(message))) {
            this.mService.maySendFeatureAbortCommand(message, 4);
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSystemAudioModeStatus(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.checkSupportAndSetSystemAudioMode(HdmiUtils.parseCommandParamSystemAudioStatus(message))) {
            this.mService.maySendFeatureAbortCommand(message, 4);
        }
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setArcStatus(boolean enabled) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("Set Arc Status[old:%b new:%b]", this.mArcEstablished, enabled);
        this.enableAudioReturnChannel(enabled);
        this.notifyArcStatusToAudioService(enabled);
        this.mArcEstablished = enabled;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void enableAudioReturnChannel(boolean enabled) {
        this.assertRunOnServiceThread();
        this.mService.enableAudioReturnChannel(SystemProperties.getInt("ro.hdmi.property_sytem_audio_device_arc_port", 0), enabled);
    }

    private void notifyArcStatusToAudioService(boolean enabled) {
        this.mService.getAudioManager().setWiredDeviceConnectionState(-2147483616, enabled ? 1 : 0, "", "");
    }

    void reportAudioStatus(int source) {
        this.assertRunOnServiceThread();
        int volume = this.mService.getAudioManager().getStreamVolume(3);
        boolean mute = this.mService.getAudioManager().isStreamMute(3);
        int maxVolume = this.mService.getAudioManager().getStreamMaxVolume(3);
        int minVolume = this.mService.getAudioManager().getStreamMinVolume(3);
        int scaledVolume = VolumeControlAction.scaleToCecVolume(volume, maxVolume);
        HdmiLogger.debug("Reporting volume %d (%d-%d) as CEC volume %d", volume, minVolume, maxVolume, scaledVolume);
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildReportAudioStatus(this.mAddress, source, scaledVolume, mute));
    }

    protected boolean checkSupportAndSetSystemAudioMode(boolean newSystemAudioMode) {
        if (!this.isSystemAudioControlFeatureEnabled()) {
            HdmiLogger.debug("Cannot turn " + (newSystemAudioMode ? "on" : "off") + "system audio mode because the System Audio Control feature is disabled.", new Object[0]);
            return false;
        }
        HdmiLogger.debug("System Audio Mode change[old:%b new:%b]", this.isSystemAudioActivated(), newSystemAudioMode);
        if (newSystemAudioMode) {
            this.mService.wakeUp();
        }
        this.setSystemAudioMode(newSystemAudioMode);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemAudioMode(boolean newSystemAudioMode) {
        boolean currentMuteStatus;
        int targetPhysicalAddress = this.getActiveSource().physicalAddress;
        int port = this.mService.pathToPortId(targetPhysicalAddress);
        if (newSystemAudioMode && port >= 0) {
            this.switchToAudioInput();
        }
        if ((currentMuteStatus = this.mService.getAudioManager().isStreamMute(3)) == newSystemAudioMode && (this.mService.readBooleanSystemProperty("ro.hdmi.property_system_audio_mode_muting_enable", true) || newSystemAudioMode)) {
            this.mService.getAudioManager().adjustStreamVolume(3, newSystemAudioMode ? 100 : -100, 0);
        }
        this.updateAudioManagerForSystemAudio(newSystemAudioMode);
        Object object = this.mLock;
        synchronized (object) {
            if (this.isSystemAudioActivated() != newSystemAudioMode) {
                this.mService.setSystemAudioActivated(newSystemAudioMode);
                this.mService.announceSystemAudioModeChange(newSystemAudioMode);
            }
        }
        if (SystemProperties.getBoolean("persist.sys.hdmi.property_arc_support", true) && this.isDirectConnectToTv()) {
            if (newSystemAudioMode && !this.isArcEnabled()) {
                this.removeAction(ArcInitiationActionFromAvr.class);
                this.addAndStartAction(new ArcInitiationActionFromAvr(this));
            } else if (!newSystemAudioMode && this.isArcEnabled()) {
                this.removeAction(ArcTerminationActionFromAvr.class);
                this.addAndStartAction(new ArcTerminationActionFromAvr(this));
            }
        }
    }

    protected void switchToAudioInput() {
    }

    protected boolean isDirectConnectToTv() {
        int myPhysicalAddress = this.mService.getPhysicalAddress();
        return (myPhysicalAddress & 0xF000) == myPhysicalAddress;
    }

    private void updateAudioManagerForSystemAudio(boolean on) {
        int device = this.mService.getAudioManager().setHdmiSystemAudioSupported(on);
        HdmiLogger.debug("[A]UpdateSystemAudio mode[on=%b] output=[%X]", on, device);
    }

    void onSystemAduioControlFeatureSupportChanged(boolean enabled) {
        this.setSystemAudioControlFeatureEnabled(enabled);
        if (enabled) {
            this.addAndStartAction(new SystemAudioInitiationActionFromAvr(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    void setSystemAudioControlFeatureEnabled(boolean enabled) {
        this.assertRunOnServiceThread();
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemAudioControlFeatureEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    void setRoutingControlFeatureEnables(boolean enabled) {
        this.assertRunOnServiceThread();
        Object object = this.mLock;
        synchronized (object) {
            this.mRoutingControlFeatureEnabled = enabled;
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void doManualPortSwitching(int portId, IHdmiControlCallback callback) {
        int newPath;
        this.assertRunOnServiceThread();
        if (!this.mService.isValidPortId(portId)) {
            this.invokeCallback(callback, 3);
            return;
        }
        if (portId == this.getLocalActivePort()) {
            this.invokeCallback(callback, 0);
            return;
        }
        if (!this.mService.isControlEnabled()) {
            this.setRoutingPort(portId);
            this.setLocalActivePort(portId);
            this.invokeCallback(callback, 6);
            return;
        }
        int oldPath = this.getRoutingPort() != 0 ? this.mService.portIdToPath(this.getRoutingPort()) : this.getDeviceInfo().getPhysicalAddress();
        if (oldPath == (newPath = this.mService.portIdToPath(portId))) {
            return;
        }
        this.setRoutingPort(portId);
        this.setLocalActivePort(portId);
        HdmiCecMessage routingChange = HdmiCecMessageBuilder.buildRoutingChange(this.mAddress, oldPath, newPath);
        this.mService.sendCecCommand(routingChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSystemAudioControlFeatureEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSystemAudioControlFeatureEnabled;
        }
    }

    protected boolean isSystemAudioActivated() {
        return this.mService.isSystemAudioActivated();
    }

    protected void terminateSystemAudioMode() {
        this.removeAction(SystemAudioInitiationActionFromAvr.class);
        if (!this.isSystemAudioActivated()) {
            return;
        }
        if (this.checkSupportAndSetSystemAudioMode(false)) {
            this.mService.sendCecCommand(HdmiCecMessageBuilder.buildSetSystemAudioMode(this.mAddress, 15, false));
        }
    }

    void queryTvSystemAudioModeSupport(TvSystemAudioModeSupportedCallback callback) {
        if (this.mTvSystemAudioModeSupport == null) {
            this.addAndStartAction(new DetectTvSystemAudioModeSupportAction(this, callback));
        } else {
            callback.onResult(this.mTvSystemAudioModeSupport);
        }
    }

    void handleSystemAudioModeOnFromNonTvDevice(final HdmiCecMessage message) {
        if (!this.isSystemAudioControlFeatureEnabled()) {
            HdmiLogger.debug("Cannot turn onsystem audio mode because the System Audio Control feature is disabled.", new Object[0]);
            this.mService.maySendFeatureAbortCommand(message, 4);
            return;
        }
        this.mService.wakeUp();
        if (this.mService.pathToPortId(this.getActiveSource().physicalAddress) != -1) {
            this.setSystemAudioMode(true);
            this.mService.sendCecCommand(HdmiCecMessageBuilder.buildSetSystemAudioMode(this.mAddress, 15, true));
            return;
        }
        this.queryTvSystemAudioModeSupport(new TvSystemAudioModeSupportedCallback(){

            @Override
            public void onResult(boolean supported) {
                if (supported) {
                    HdmiCecLocalDeviceAudioSystem.this.setSystemAudioMode(true);
                    HdmiCecLocalDeviceAudioSystem.this.mService.sendCecCommand(HdmiCecMessageBuilder.buildSetSystemAudioMode(HdmiCecLocalDeviceAudioSystem.this.mAddress, 15, true));
                } else {
                    HdmiCecLocalDeviceAudioSystem.this.mService.maySendFeatureAbortCommand(message, 4);
                }
            }
        });
    }

    void setTvSystemAudioModeSupport(boolean supported) {
        this.mTvSystemAudioModeSupport = supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected boolean isArcEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mArcEstablished;
        }
    }

    @Override
    protected void switchInputOnReceivingNewActivePath(int physicalAddress) {
        int port = this.mService.pathToPortId(physicalAddress);
        if (this.isSystemAudioActivated() && port < 0) {
            this.routeToInputFromPortId(17);
        } else if (this.mIsSwitchDevice && port >= 0) {
            this.routeToInputFromPortId(port);
        }
    }

    protected void routeToInputFromPortId(int portId) {
        if (!this.isRoutingControlFeatureEnabled()) {
            HdmiLogger.debug("Routing Control Feature is not enabled.", new Object[0]);
            return;
        }
        if (this.mArcIntentUsed) {
            this.routeToTvInputFromPortId(portId);
        }
    }

    protected void routeToTvInputFromPortId(int portId) {
        if (portId < 0 || portId >= 21) {
            HdmiLogger.debug("Invalid port number for Tv Input switching.", new Object[0]);
            return;
        }
        this.mService.wakeUp();
        if (portId == 0 && this.mService.isPlaybackDevice()) {
            this.switchToHomeTvInput();
        } else {
            if (portId == 17) {
                this.switchToTvInput(SystemProperties.get("ro.hdmi.property_sytem_audio_device_arc_port"));
                this.setLocalActivePort(portId);
                return;
            }
            String uri = this.mPortIdToTvInputs.get(portId);
            if (uri != null) {
                this.switchToTvInput(uri);
            } else {
                HdmiLogger.debug("Port number does not match any Tv Input.", new Object[0]);
                return;
            }
        }
        this.setLocalActivePort(portId);
        this.setRoutingPort(portId);
    }

    private void switchToTvInput(String uri) {
        try {
            this.mService.getContext().startActivity(new Intent("android.intent.action.VIEW", TvContract.buildChannelUriForPassthroughInput(uri)).addFlags(0x10000000));
        }
        catch (ActivityNotFoundException e) {
            Slog.e(TAG, "Can't find activity to switch to " + uri, e);
        }
    }

    private void switchToHomeTvInput() {
        try {
            Intent activityIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME").setFlags(872480768);
            this.mService.getContext().startActivity(activityIntent);
        }
        catch (ActivityNotFoundException e) {
            Slog.e(TAG, "Can't find activity to switch to HOME", e);
        }
    }

    @Override
    protected void handleRoutingChangeAndInformation(int physicalAddress, HdmiCecMessage message) {
        int port = this.mService.pathToPortId(physicalAddress);
        if (port > 0) {
            return;
        }
        if (port < 0 && this.isSystemAudioActivated()) {
            this.handleRoutingChangeAndInformationForSystemAudio();
            return;
        }
        if (port == 0) {
            this.handleRoutingChangeAndInformationForSwitch(message);
        }
    }

    private void handleRoutingChangeAndInformationForSystemAudio() {
        this.routeToInputFromPortId(17);
    }

    private void handleRoutingChangeAndInformationForSwitch(HdmiCecMessage message) {
        if (this.getRoutingPort() == 0 && this.mService.isPlaybackDevice()) {
            this.routeToInputFromPortId(0);
            this.mService.setAndBroadcastActiveSourceFromOneDeviceType(message.getSource(), this.mService.getPhysicalAddress());
            return;
        }
        int routingInformationPath = this.mService.portIdToPath(this.getRoutingPort());
        if (routingInformationPath == this.mService.getPhysicalAddress()) {
            HdmiLogger.debug("Current device can't assign valid physical addressto devices under it any more. It's physical address is " + routingInformationPath, new Object[0]);
            return;
        }
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildRoutingInformation(this.mAddress, routingInformationPath));
        this.routeToInputFromPortId(this.getRoutingPort());
    }

    @Override
    protected void updateDevicePowerStatus(int logicalAddress, int newPowerStatus) {
        HdmiDeviceInfo info = this.getCecDeviceInfo(logicalAddress);
        if (info == null) {
            Slog.w(TAG, "Can not update power status of non-existing device:" + logicalAddress);
            return;
        }
        if (info.getDevicePowerStatus() == newPowerStatus) {
            return;
        }
        HdmiDeviceInfo newInfo = HdmiUtils.cloneHdmiDeviceInfo(info, newPowerStatus);
        this.addDeviceInfo(newInfo);
        this.invokeDeviceEventListener(newInfo, 3);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void launchDeviceDiscovery() {
        this.assertRunOnServiceThread();
        if (this.hasAction(DeviceDiscoveryAction.class)) {
            Slog.i(TAG, "Device Discovery Action is in progress. Restarting.");
            this.removeAction(DeviceDiscoveryAction.class);
        }
        DeviceDiscoveryAction action = new DeviceDiscoveryAction(this, new DeviceDiscoveryAction.DeviceDiscoveryCallback(){

            @Override
            public void onDeviceDiscoveryDone(List<HdmiDeviceInfo> deviceInfos) {
                for (HdmiDeviceInfo info : deviceInfos) {
                    HdmiCecLocalDeviceAudioSystem.this.addCecDevice(info);
                }
            }
        });
        this.addAndStartAction(action);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void clearDeviceInfoList() {
        this.assertRunOnServiceThread();
        for (HdmiDeviceInfo info : HdmiUtils.sparseArrayToList(this.mDeviceInfos)) {
            if (info.getPhysicalAddress() == this.mService.getPhysicalAddress()) continue;
            this.invokeDeviceEventListener(info, 2);
        }
        this.mDeviceInfos.clear();
        this.updateSafeDeviceInfoList();
    }

    @Override
    protected void dump(IndentingPrintWriter pw) {
        pw.println("HdmiCecLocalDeviceAudioSystem:");
        pw.increaseIndent();
        pw.println("isRoutingFeatureEnabled " + this.isRoutingControlFeatureEnabled());
        pw.println("mSystemAudioControlFeatureEnabled: " + this.mSystemAudioControlFeatureEnabled);
        pw.println("mTvSystemAudioModeSupport: " + this.mTvSystemAudioModeSupport);
        pw.println("mArcEstablished: " + this.mArcEstablished);
        pw.println("mArcIntentUsed: " + this.mArcIntentUsed);
        pw.println("mRoutingPort: " + this.getRoutingPort());
        pw.println("mLocalActivePort: " + this.getLocalActivePort());
        HdmiUtils.dumpMap(pw, "mPortIdToTvInputs:", this.mPortIdToTvInputs);
        HdmiUtils.dumpMap(pw, "mTvInputsToDeviceInfo:", this.mTvInputsToDeviceInfo);
        HdmiUtils.dumpSparseArray(pw, "mDeviceInfos:", this.mDeviceInfos);
        pw.decreaseIndent();
        super.dump(pw);
    }

    static interface TvSystemAudioModeSupportedCallback {
        public void onResult(boolean var1);
    }
}

