/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.IHdmiControlCallback;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.hdmi.Constants;
import com.android.server.hdmi.HdmiAnnotations;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.OneTouchPlayAction;
import java.util.List;

abstract class HdmiCecLocalDeviceSource
extends HdmiCecLocalDevice {
    private static final String TAG = "HdmiCecLocalDeviceSource";
    @VisibleForTesting
    protected boolean mIsActiveSource = false;
    protected boolean mIsSwitchDevice = SystemProperties.getBoolean("ro.hdmi.property_is_device_hdmi_cec_switch", false);
    @GuardedBy(value={"mLock"})
    @Constants.LocalActivePort
    private int mRoutingPort = 0;
    @GuardedBy(value={"mLock"})
    @Constants.LocalActivePort
    protected int mLocalActivePort = 0;
    @GuardedBy(value={"mLock"})
    protected boolean mRoutingControlFeatureEnabled;

    protected HdmiCecLocalDeviceSource(HdmiControlService service, int deviceType) {
        super(service, deviceType);
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    void onHotplug(int portId, boolean connected) {
        this.assertRunOnServiceThread();
        if (this.mService.getPortInfo(portId).getType() == 1) {
            this.mCecMessageCache.flushAll();
        }
        if (connected) {
            this.mService.wakeUp();
        }
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void sendStandby(int deviceId) {
        this.assertRunOnServiceThread();
        int targetAddress = 0;
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildStandby(this.mAddress, targetAddress));
    }

    @HdmiAnnotations.ServiceThreadOnly
    void oneTouchPlay(IHdmiControlCallback callback) {
        this.assertRunOnServiceThread();
        List<OneTouchPlayAction> actions = this.getActions(OneTouchPlayAction.class);
        if (!actions.isEmpty()) {
            Slog.i(TAG, "oneTouchPlay already in progress");
            actions.get(0).addCallback(callback);
            return;
        }
        OneTouchPlayAction action = OneTouchPlayAction.create(this, 0, callback);
        if (action == null) {
            Slog.w(TAG, "Cannot initiate oneTouchPlay");
            this.invokeCallback(callback, 5);
            return;
        }
        this.addAndStartAction(action);
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleActiveSource(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        int logicalAddress = message.getSource();
        int physicalAddress = HdmiUtils.twoBytesToInt(message.getParams());
        HdmiCecLocalDevice.ActiveSource activeSource = HdmiCecLocalDevice.ActiveSource.of(logicalAddress, physicalAddress);
        if (!this.getActiveSource().equals(activeSource)) {
            this.setActiveSource(activeSource);
        }
        this.setIsActiveSource(physicalAddress == this.mService.getPhysicalAddress());
        this.updateDevicePowerStatus(logicalAddress, 0);
        if (this.isRoutingControlFeatureEnabled()) {
            this.switchInputOnReceivingNewActivePath(physicalAddress);
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRequestActiveSource(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        this.maySendActiveSource(message.getSource());
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSetStreamPath(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        int physicalAddress = HdmiUtils.twoBytesToInt(message.getParams());
        if (physicalAddress == this.mService.getPhysicalAddress() && this.mService.isPlaybackDevice()) {
            this.setAndBroadcastActiveSource(message, physicalAddress);
        }
        this.switchInputOnReceivingNewActivePath(physicalAddress);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRoutingChange(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.isRoutingControlFeatureEnabled()) {
            this.mService.maySendFeatureAbortCommand(message, 4);
            return true;
        }
        int newPath = HdmiUtils.twoBytesToInt(message.getParams(), 2);
        if (!this.mIsSwitchDevice && newPath == this.mService.getPhysicalAddress() && this.mService.isPlaybackDevice()) {
            this.setAndBroadcastActiveSource(message, newPath);
        }
        this.handleRoutingChangeAndInformation(newPath, message);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRoutingInformation(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.isRoutingControlFeatureEnabled()) {
            this.mService.maySendFeatureAbortCommand(message, 4);
            return true;
        }
        int physicalAddress = HdmiUtils.twoBytesToInt(message.getParams());
        if (!this.mIsSwitchDevice && physicalAddress == this.mService.getPhysicalAddress() && this.mService.isPlaybackDevice()) {
            this.setAndBroadcastActiveSource(message, physicalAddress);
        }
        this.handleRoutingChangeAndInformation(physicalAddress, message);
        return true;
    }

    protected void switchInputOnReceivingNewActivePath(int physicalAddress) {
    }

    protected void handleRoutingChangeAndInformation(int physicalAddress, HdmiCecMessage message) {
    }

    protected void updateDevicePowerStatus(int logicalAddress, int newPowerStatus) {
    }

    protected void setAndBroadcastActiveSource(HdmiCecMessage message, int physicalAddress) {
        this.mService.setAndBroadcastActiveSource(physicalAddress, this.getDeviceInfo().getDeviceType(), message.getSource());
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setIsActiveSource(boolean on) {
        this.assertRunOnServiceThread();
        this.mIsActiveSource = on;
    }

    protected void wakeUpIfActiveSource() {
        if (!this.mIsActiveSource) {
            return;
        }
        this.mService.wakeUp();
    }

    protected void maySendActiveSource(int dest) {
        if (this.mIsActiveSource) {
            this.mService.sendCecCommand(HdmiCecMessageBuilder.buildActiveSource(this.mAddress, this.mService.getPhysicalAddress()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void setRoutingPort(@Constants.LocalActivePort int portId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRoutingPort = portId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Constants.LocalActivePort
    protected int getRoutingPort() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRoutingPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Constants.LocalActivePort
    protected int getLocalActivePort() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLocalActivePort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocalActivePort(@Constants.LocalActivePort int activePort) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocalActivePort = activePort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRoutingControlFeatureEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRoutingControlFeatureEnabled;
        }
    }

    protected boolean isSwitchingToTheSameInput(@Constants.LocalActivePort int activePort) {
        return activePort == this.getLocalActivePort();
    }
}

