/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.server.hdmi.HdmiCecMessage;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class HdmiCecMessageBuilder {
    private static final int OSD_NAME_MAX_LENGTH = 13;

    private HdmiCecMessageBuilder() {
    }

    static HdmiCecMessage of(int src, int dest, byte[] body) {
        byte opcode = body[0];
        byte[] params = Arrays.copyOfRange(body, 1, body.length);
        return new HdmiCecMessage(src, dest, opcode, params);
    }

    static HdmiCecMessage buildFeatureAbortCommand(int src, int dest, int originalOpcode, int reason) {
        byte[] params = new byte[]{(byte)(originalOpcode & 0xFF), (byte)(reason & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, dest, 0, params);
    }

    static HdmiCecMessage buildGivePhysicalAddress(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 131);
    }

    static HdmiCecMessage buildGiveOsdNameCommand(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 70);
    }

    static HdmiCecMessage buildGiveDeviceVendorIdCommand(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 140);
    }

    static HdmiCecMessage buildSetMenuLanguageCommand(int src, String language) {
        if (language.length() != 3) {
            return null;
        }
        String normalized = language.toLowerCase();
        byte[] params = new byte[]{(byte)(normalized.charAt(0) & 0xFF), (byte)(normalized.charAt(1) & 0xFF), (byte)(normalized.charAt(2) & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, 15, 50, params);
    }

    static HdmiCecMessage buildSetOsdNameCommand(int src, int dest, String name) {
        byte[] params;
        int length = Math.min(name.length(), 13);
        try {
            params = name.substring(0, length).getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return HdmiCecMessageBuilder.buildCommand(src, dest, 71, params);
    }

    static HdmiCecMessage buildReportPhysicalAddressCommand(int src, int address, int deviceType) {
        byte[] params = new byte[]{(byte)(address >> 8 & 0xFF), (byte)(address & 0xFF), (byte)(deviceType & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, 15, 132, params);
    }

    static HdmiCecMessage buildDeviceVendorIdCommand(int src, int vendorId) {
        byte[] params = new byte[]{(byte)(vendorId >> 16 & 0xFF), (byte)(vendorId >> 8 & 0xFF), (byte)(vendorId & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, 15, 135, params);
    }

    static HdmiCecMessage buildCecVersion(int src, int dest, int version) {
        byte[] params = new byte[]{(byte)(version & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, dest, 158, params);
    }

    static HdmiCecMessage buildRequestArcInitiation(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 195);
    }

    static HdmiCecMessage buildInitiateArc(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 192);
    }

    static HdmiCecMessage buildTerminateArc(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 197);
    }

    static HdmiCecMessage buildRequestArcTermination(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 196);
    }

    static HdmiCecMessage buildReportArcInitiated(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 193);
    }

    static HdmiCecMessage buildReportArcTerminated(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 194);
    }

    static HdmiCecMessage buildRequestShortAudioDescriptor(int src, int dest, int[] audioFormats) {
        byte[] params = new byte[Math.min(audioFormats.length, 4)];
        for (int i = 0; i < params.length; ++i) {
            params[i] = (byte)(audioFormats[i] & 0xFF);
        }
        return HdmiCecMessageBuilder.buildCommand(src, dest, 164, params);
    }

    static HdmiCecMessage buildTextViewOn(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 13);
    }

    static HdmiCecMessage buildRequestActiveSource(int src) {
        return HdmiCecMessageBuilder.buildCommand(src, 15, 133);
    }

    static HdmiCecMessage buildActiveSource(int src, int physicalAddress) {
        return HdmiCecMessageBuilder.buildCommand(src, 15, 130, HdmiCecMessageBuilder.physicalAddressToParam(physicalAddress));
    }

    static HdmiCecMessage buildInactiveSource(int src, int physicalAddress) {
        return HdmiCecMessageBuilder.buildCommand(src, 0, 157, HdmiCecMessageBuilder.physicalAddressToParam(physicalAddress));
    }

    static HdmiCecMessage buildSetStreamPath(int src, int streamPath) {
        return HdmiCecMessageBuilder.buildCommand(src, 15, 134, HdmiCecMessageBuilder.physicalAddressToParam(streamPath));
    }

    static HdmiCecMessage buildRoutingChange(int src, int oldPath, int newPath) {
        byte[] param = new byte[]{(byte)(oldPath >> 8 & 0xFF), (byte)(oldPath & 0xFF), (byte)(newPath >> 8 & 0xFF), (byte)(newPath & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, 15, 128, param);
    }

    static HdmiCecMessage buildRoutingInformation(int src, int physicalAddress) {
        return HdmiCecMessageBuilder.buildCommand(src, 15, 129, HdmiCecMessageBuilder.physicalAddressToParam(physicalAddress));
    }

    static HdmiCecMessage buildGiveDevicePowerStatus(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 143);
    }

    static HdmiCecMessage buildReportPowerStatus(int src, int dest, int powerStatus) {
        byte[] param = new byte[]{(byte)(powerStatus & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, dest, 144, param);
    }

    static HdmiCecMessage buildReportMenuStatus(int src, int dest, int menuStatus) {
        byte[] param = new byte[]{(byte)(menuStatus & 0xFF)};
        return HdmiCecMessageBuilder.buildCommand(src, dest, 142, param);
    }

    static HdmiCecMessage buildSystemAudioModeRequest(int src, int avr, int avrPhysicalAddress, boolean enableSystemAudio) {
        if (enableSystemAudio) {
            return HdmiCecMessageBuilder.buildCommand(src, avr, 112, HdmiCecMessageBuilder.physicalAddressToParam(avrPhysicalAddress));
        }
        return HdmiCecMessageBuilder.buildCommand(src, avr, 112);
    }

    static HdmiCecMessage buildSetSystemAudioMode(int src, int des, boolean systemAudioStatus) {
        return HdmiCecMessageBuilder.buildCommandWithBooleanParam(src, des, 114, systemAudioStatus);
    }

    static HdmiCecMessage buildReportSystemAudioMode(int src, int des, boolean systemAudioStatus) {
        return HdmiCecMessageBuilder.buildCommandWithBooleanParam(src, des, 126, systemAudioStatus);
    }

    static HdmiCecMessage buildReportShortAudioDescriptor(int src, int des, byte[] sadBytes) {
        return HdmiCecMessageBuilder.buildCommand(src, des, 163, sadBytes);
    }

    static HdmiCecMessage buildGiveAudioStatus(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 113);
    }

    static HdmiCecMessage buildReportAudioStatus(int src, int dest, int volume, boolean mute) {
        byte status = (byte)((byte)(mute ? 128 : 0) | (byte)volume & 0x7F);
        byte[] params = new byte[]{status};
        return HdmiCecMessageBuilder.buildCommand(src, dest, 122, params);
    }

    static HdmiCecMessage buildUserControlPressed(int src, int dest, int uiCommand) {
        return HdmiCecMessageBuilder.buildUserControlPressed(src, dest, new byte[]{(byte)(uiCommand & 0xFF)});
    }

    static HdmiCecMessage buildUserControlPressed(int src, int dest, byte[] commandParam) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 68, commandParam);
    }

    static HdmiCecMessage buildUserControlReleased(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 69);
    }

    static HdmiCecMessage buildGiveSystemAudioModeStatus(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 125);
    }

    public static HdmiCecMessage buildStandby(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 54);
    }

    static HdmiCecMessage buildVendorCommand(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 137, params);
    }

    static HdmiCecMessage buildVendorCommandWithId(int src, int dest, int vendorId, byte[] operands) {
        byte[] params = new byte[operands.length + 3];
        params[0] = (byte)(vendorId >> 16 & 0xFF);
        params[1] = (byte)(vendorId >> 8 & 0xFF);
        params[2] = (byte)(vendorId & 0xFF);
        System.arraycopy(operands, 0, params, 3, operands.length);
        return HdmiCecMessageBuilder.buildCommand(src, dest, 160, params);
    }

    static HdmiCecMessage buildRecordOn(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 9, params);
    }

    static HdmiCecMessage buildRecordOff(int src, int dest) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 11);
    }

    static HdmiCecMessage buildSetDigitalTimer(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 151, params);
    }

    static HdmiCecMessage buildSetAnalogueTimer(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 52, params);
    }

    static HdmiCecMessage buildSetExternalTimer(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 162, params);
    }

    static HdmiCecMessage buildClearDigitalTimer(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 153, params);
    }

    static HdmiCecMessage buildClearAnalogueTimer(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 51, params);
    }

    static HdmiCecMessage buildClearExternalTimer(int src, int dest, byte[] params) {
        return HdmiCecMessageBuilder.buildCommand(src, dest, 161, params);
    }

    private static HdmiCecMessage buildCommand(int src, int dest, int opcode) {
        return new HdmiCecMessage(src, dest, opcode, HdmiCecMessage.EMPTY_PARAM);
    }

    private static HdmiCecMessage buildCommand(int src, int dest, int opcode, byte[] params) {
        return new HdmiCecMessage(src, dest, opcode, params);
    }

    private static HdmiCecMessage buildCommandWithBooleanParam(int src, int des, int opcode, boolean param) {
        byte[] params = new byte[]{param ? (byte)1 : 0};
        return HdmiCecMessageBuilder.buildCommand(src, des, opcode, params);
    }

    private static byte[] physicalAddressToParam(int physicalAddress) {
        return new byte[]{(byte)(physicalAddress >> 8 & 0xFF), (byte)(physicalAddress & 0xFF)};
    }
}

