/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.util.Slog;
import com.android.server.hdmi.DeviceSelectAction;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.OneTouchRecordAction;
import com.android.server.hdmi.RequestArcTerminationAction;
import java.util.BitSet;
import java.util.List;

final class HotplugDetectionAction
extends HdmiCecFeatureAction {
    private static final String TAG = "HotPlugDetectionAction";
    private static final int POLLING_INTERVAL_MS = 5000;
    private static final int TIMEOUT_COUNT = 3;
    private static final int AVR_COUNT_MAX = 3;
    private static final int STATE_WAIT_FOR_NEXT_POLLING = 1;
    private static final int NUM_OF_ADDRESS = 15;
    private int mTimeoutCount = 0;
    private int mAvrStatusCount = 0;

    HotplugDetectionAction(HdmiCecLocalDevice source) {
        super(source);
    }

    @Override
    boolean start() {
        Slog.v(TAG, "Hot-plug dection started.");
        this.mState = 1;
        this.mTimeoutCount = 0;
        this.addTimer(this.mState, 5000);
        return true;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        if (this.mState == 1) {
            this.mTimeoutCount = (this.mTimeoutCount + 1) % 3;
            this.pollDevices();
        }
    }

    void pollAllDevicesNow() {
        this.mActionTimer.clearTimerMessage();
        this.mTimeoutCount = 0;
        this.mState = 1;
        this.pollAllDevices();
        this.addTimer(this.mState, 5000);
    }

    private void pollDevices() {
        if (this.mTimeoutCount == 0) {
            this.pollAllDevices();
        } else if (this.tv().isSystemAudioActivated()) {
            this.pollAudioSystem();
        }
        this.addTimer(this.mState, 5000);
    }

    private void pollAllDevices() {
        Slog.v(TAG, "Poll all devices.");
        this.pollDevices(new HdmiControlService.DevicePollingCallback(){

            @Override
            public void onPollingFinished(List<Integer> ackedAddress) {
                HotplugDetectionAction.this.checkHotplug(ackedAddress, false);
            }
        }, 65537, 1);
    }

    private void pollAudioSystem() {
        Slog.v(TAG, "Poll audio system.");
        this.pollDevices(new HdmiControlService.DevicePollingCallback(){

            @Override
            public void onPollingFinished(List<Integer> ackedAddress) {
                HotplugDetectionAction.this.checkHotplug(ackedAddress, true);
            }
        }, 65538, 1);
    }

    private void checkHotplug(List<Integer> ackedAddress, boolean audioOnly) {
        BitSet currentInfos = HotplugDetectionAction.infoListToBitSet(this.tv().getDeviceInfoList(false), audioOnly);
        BitSet polledResult = HotplugDetectionAction.addressListToBitSet(ackedAddress);
        BitSet removed = HotplugDetectionAction.complement(currentInfos, polledResult);
        int index = -1;
        while ((index = removed.nextSetBit(index + 1)) != -1) {
            HdmiDeviceInfo avr;
            if (index == 5 && (avr = this.tv().getAvrDeviceInfo()) != null && this.tv().isConnected(avr.getPortId())) {
                ++this.mAvrStatusCount;
                Slog.w(TAG, "Ack not returned from AVR. count: " + this.mAvrStatusCount);
                if (this.mAvrStatusCount < 3) continue;
            }
            Slog.v(TAG, "Remove device by hot-plug detection:" + index);
            this.removeDevice(index);
        }
        if (!removed.get(5)) {
            this.mAvrStatusCount = 0;
        }
        BitSet added = HotplugDetectionAction.complement(polledResult, currentInfos);
        index = -1;
        while ((index = added.nextSetBit(index + 1)) != -1) {
            Slog.v(TAG, "Add device by hot-plug detection:" + index);
            this.addDevice(index);
        }
    }

    private static BitSet infoListToBitSet(List<HdmiDeviceInfo> infoList, boolean audioOnly) {
        BitSet set = new BitSet(15);
        for (HdmiDeviceInfo info : infoList) {
            if (audioOnly) {
                if (info.getDeviceType() != 5) continue;
                set.set(info.getLogicalAddress());
                continue;
            }
            set.set(info.getLogicalAddress());
        }
        return set;
    }

    private static BitSet addressListToBitSet(List<Integer> list) {
        BitSet set = new BitSet(15);
        for (Integer value : list) {
            set.set(value);
        }
        return set;
    }

    private static BitSet complement(BitSet first, BitSet second) {
        BitSet clone = (BitSet)first.clone();
        clone.andNot(second);
        return clone;
    }

    private void addDevice(int addedAddress) {
        this.sendCommand(HdmiCecMessageBuilder.buildGivePhysicalAddress(this.getSourceAddress(), addedAddress));
    }

    private void removeDevice(int removedAddress) {
        this.mayChangeRoutingPath(removedAddress);
        this.mayCancelDeviceSelect(removedAddress);
        this.mayCancelOneTouchRecord(removedAddress);
        this.mayDisableSystemAudioAndARC(removedAddress);
        this.tv().removeCecDevice(removedAddress);
    }

    private void mayChangeRoutingPath(int address) {
        HdmiDeviceInfo info = this.tv().getCecDeviceInfo(address);
        if (info != null) {
            this.tv().handleRemoveActiveRoutingPath(info.getPhysicalAddress());
        }
    }

    private void mayCancelDeviceSelect(int address) {
        List<DeviceSelectAction> actions = this.getActions(DeviceSelectAction.class);
        if (actions.isEmpty()) {
            return;
        }
        DeviceSelectAction action = actions.get(0);
        if (action.getTargetAddress() == address) {
            this.removeAction(DeviceSelectAction.class);
        }
    }

    private void mayCancelOneTouchRecord(int address) {
        List<OneTouchRecordAction> actions = this.getActions(OneTouchRecordAction.class);
        for (OneTouchRecordAction action : actions) {
            if (action.getRecorderAddress() != address) continue;
            this.removeAction(action);
        }
    }

    private void mayDisableSystemAudioAndARC(int address) {
        if (HdmiUtils.getTypeFromAddress(address) != 5) {
            return;
        }
        this.tv().setSystemAudioMode(false);
        if (this.tv().isArcEstablished()) {
            this.tv().enableAudioReturnChannel(false);
            this.addAndStartAction(new RequestArcTerminationAction(this.localDevice(), address));
        }
    }
}

