/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecKeycode;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;

final class SendKeyAction
extends HdmiCecFeatureAction {
    private static final String TAG = "SendKeyAction";
    private static final int AWAIT_LONGPRESS_MS = 400;
    private static final int AWAIT_RELEASE_KEY_MS = 1000;
    private static final int STATE_CHECKING_LONGPRESS = 1;
    private static final int STATE_PROCESSING_KEYCODE = 2;
    private final int mTargetAddress;
    private int mLastKeycode;
    private long mLastSendKeyTime;

    SendKeyAction(HdmiCecLocalDevice source, int targetAddress, int keycode) {
        super(source);
        this.mTargetAddress = targetAddress;
        this.mLastKeycode = keycode;
    }

    @Override
    public boolean start() {
        this.sendKeyDown(this.mLastKeycode);
        this.mLastSendKeyTime = this.getCurrentTime();
        if (!HdmiCecKeycode.isRepeatableKey(this.mLastKeycode)) {
            this.sendKeyUp();
            this.finish();
            return true;
        }
        this.mState = 1;
        this.addTimer(this.mState, 400);
        return true;
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    void processKeyEvent(int keycode, boolean isPressed) {
        if (this.mState != 1 && this.mState != 2) {
            Slog.w(TAG, "Not in a valid state");
            return;
        }
        if (isPressed) {
            if (keycode != this.mLastKeycode) {
                this.sendKeyDown(keycode);
                this.mLastSendKeyTime = this.getCurrentTime();
                if (!HdmiCecKeycode.isRepeatableKey(keycode)) {
                    this.sendKeyUp();
                    this.finish();
                    return;
                }
            } else if (this.getCurrentTime() - this.mLastSendKeyTime >= 300L) {
                this.sendKeyDown(keycode);
                this.mLastSendKeyTime = this.getCurrentTime();
            }
            this.mActionTimer.clearTimerMessage();
            this.addTimer(this.mState, 1000);
            this.mLastKeycode = keycode;
        } else if (keycode == this.mLastKeycode) {
            this.sendKeyUp();
            this.finish();
        }
    }

    private void sendKeyDown(int keycode) {
        byte[] cecKeycodeAndParams = HdmiCecKeycode.androidKeyToCecKey(keycode);
        if (cecKeycodeAndParams == null) {
            return;
        }
        if (this.mTargetAddress == 5 && this.localDevice().mAddress != 0) {
            this.sendCommand(HdmiCecMessageBuilder.buildUserControlPressed(this.getSourceAddress(), this.mTargetAddress, cecKeycodeAndParams), new HdmiControlService.SendMessageCallback(){

                @Override
                public void onSendCompleted(int error) {
                    if (error != 0) {
                        HdmiLogger.debug("AVR did not respond to <User Control Pressed>", new Object[0]);
                        SendKeyAction.this.localDevice().mService.setSystemAudioActivated(false);
                    }
                }
            });
        } else {
            this.sendCommand(HdmiCecMessageBuilder.buildUserControlPressed(this.getSourceAddress(), this.mTargetAddress, cecKeycodeAndParams));
        }
    }

    private void sendKeyUp() {
        this.sendCommand(HdmiCecMessageBuilder.buildUserControlReleased(this.getSourceAddress(), this.mTargetAddress));
    }

    @Override
    public boolean processCommand(HdmiCecMessage cmd) {
        return false;
    }

    @Override
    public void handleTimerEvent(int state) {
        switch (this.mState) {
            case 1: {
                this.mActionTimer.clearTimerMessage();
                this.mState = 2;
                this.sendKeyDown(this.mLastKeycode);
                this.mLastSendKeyTime = this.getCurrentTime();
                this.addTimer(this.mState, 1000);
                break;
            }
            case 2: {
                this.sendKeyUp();
                this.finish();
                break;
            }
            default: {
                Slog.w(TAG, "Not in a valid state");
            }
        }
    }
}

