/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;

final class SetArcTransmissionStateAction
extends HdmiCecFeatureAction {
    private static final String TAG = "SetArcTransmissionStateAction";
    private static final int STATE_WAITING_TIMEOUT = 1;
    private final boolean mEnabled;
    private final int mAvrAddress;

    SetArcTransmissionStateAction(HdmiCecLocalDevice source, int avrAddress, boolean enabled) {
        super(source);
        HdmiUtils.verifyAddressType(this.getSourceAddress(), 0);
        HdmiUtils.verifyAddressType(avrAddress, 5);
        this.mAvrAddress = avrAddress;
        this.mEnabled = enabled;
    }

    @Override
    boolean start() {
        if (this.mEnabled) {
            this.setArcStatus(true);
            this.mState = 1;
            this.addTimer(this.mState, 2000);
            this.sendReportArcInitiated();
        } else {
            this.setArcStatus(false);
            this.finish();
        }
        return true;
    }

    private void sendReportArcInitiated() {
        HdmiCecMessage command = HdmiCecMessageBuilder.buildReportArcInitiated(this.getSourceAddress(), this.mAvrAddress);
        this.sendCommand(command, new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                switch (error) {
                    case 0: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 1: {
                        SetArcTransmissionStateAction.this.setArcStatus(false);
                        HdmiLogger.debug("Failed to send <Report Arc Initiated>.", new Object[0]);
                        SetArcTransmissionStateAction.this.finish();
                    }
                }
            }
        });
    }

    private void setArcStatus(boolean enabled) {
        boolean wasEnabled = this.tv().setArcStatus(enabled);
        Slog.i(TAG, "Change arc status [old:" + wasEnabled + ", new:" + enabled + "]");
        if (!enabled && wasEnabled) {
            this.sendCommand(HdmiCecMessageBuilder.buildReportArcTerminated(this.getSourceAddress(), this.mAvrAddress));
        }
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        int originalOpcode;
        if (this.mState != 1) {
            return false;
        }
        int opcode = cmd.getOpcode();
        if (opcode == 0 && (originalOpcode = cmd.getParams()[0] & 0xFF) == 193) {
            HdmiLogger.debug("Feature aborted for <Report Arc Initiated>", new Object[0]);
            this.setArcStatus(false);
            this.finish();
            return true;
        }
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state || this.mState != 1) {
            return;
        }
        this.finish();
    }
}

