/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.internal.annotations.VisibleForTesting;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiLogger;

public class SystemAudioInitiationActionFromAvr
extends HdmiCecFeatureAction {
    private static final int STATE_WAITING_FOR_ACTIVE_SOURCE = 1;
    private static final int STATE_WAITING_FOR_TV_SUPPORT = 2;
    @VisibleForTesting
    static final int MAX_RETRY_COUNT = 5;
    private int mSendRequestActiveSourceRetryCount = 0;
    private int mSendSetSystemAudioModeRetryCount = 0;

    SystemAudioInitiationActionFromAvr(HdmiCecLocalDevice source) {
        super(source);
    }

    @Override
    boolean start() {
        if (this.audioSystem().getActiveSource().physicalAddress == 65535) {
            this.mState = 1;
            this.addTimer(this.mState, 2000);
            this.sendRequestActiveSource();
        } else {
            this.queryTvSystemAudioModeSupport();
        }
        return true;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        switch (cmd.getOpcode()) {
            case 130: {
                if (this.mState != 1) {
                    return false;
                }
                this.mActionTimer.clearTimerMessage();
                this.audioSystem().handleActiveSource(cmd);
                this.mState = 2;
                this.queryTvSystemAudioModeSupport();
                return true;
            }
        }
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.handleActiveSourceTimeout();
            }
        }
    }

    protected void sendRequestActiveSource() {
        this.sendCommand(HdmiCecMessageBuilder.buildRequestActiveSource(this.getSourceAddress()), result -> {
            if (result != 0) {
                if (this.mSendRequestActiveSourceRetryCount < 5) {
                    ++this.mSendRequestActiveSourceRetryCount;
                    this.sendRequestActiveSource();
                } else {
                    this.audioSystem().checkSupportAndSetSystemAudioMode(false);
                    this.finish();
                }
            }
        });
    }

    protected void sendSetSystemAudioMode(boolean on, int dest) {
        this.sendCommand(HdmiCecMessageBuilder.buildSetSystemAudioMode(this.getSourceAddress(), dest, on), result -> {
            if (result != 0) {
                if (this.mSendSetSystemAudioModeRetryCount < 5) {
                    ++this.mSendSetSystemAudioModeRetryCount;
                    this.sendSetSystemAudioMode(on, dest);
                } else {
                    this.audioSystem().checkSupportAndSetSystemAudioMode(false);
                    this.finish();
                }
            }
        });
    }

    private void handleActiveSourceTimeout() {
        HdmiLogger.debug("Cannot get active source.", new Object[0]);
        if (this.audioSystem().mService.isPlaybackDevice()) {
            this.audioSystem().mService.setAndBroadcastActiveSourceFromOneDeviceType(15, this.getSourcePath());
            this.mState = 2;
            this.queryTvSystemAudioModeSupport();
        } else {
            this.audioSystem().checkSupportAndSetSystemAudioMode(false);
        }
        this.finish();
    }

    private void queryTvSystemAudioModeSupport() {
        this.audioSystem().queryTvSystemAudioModeSupport(supported -> {
            if (supported) {
                if (this.audioSystem().checkSupportAndSetSystemAudioMode(true)) {
                    this.sendSetSystemAudioMode(true, 15);
                }
                this.finish();
            } else {
                this.audioSystem().checkSupportAndSetSystemAudioMode(false);
                this.finish();
            }
        });
    }

    private void switchToRelevantInputForDeviceAt(int physicalAddress) {
    }
}

