/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.incident;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.IIncidentAuthListener;
import android.os.IIncidentCompanion;
import android.os.IIncidentManager;
import android.os.IncidentManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import com.android.server.incident.PendingReports;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

public class IncidentCompanionService
extends SystemService {
    static final String TAG = "IncidentCompanionService";
    private static String[] RESTRICTED_IMAGE_DUMP_ARGS = new String[]{"--hal", "--restricted_image"};
    private static final String[] DUMP_AND_USAGE_STATS_PERMISSIONS = new String[]{"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"};
    private PendingReports mPendingReports;

    public IncidentCompanionService(Context context) {
        super(context);
        this.mPendingReports = new PendingReports(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("incidentcompanion", new BinderService());
    }

    @Override
    public void onBootPhase(int phase) {
        super.onBootPhase(phase);
        switch (phase) {
            case 1000: {
                this.mPendingReports.onBootCompleted();
            }
        }
    }

    private IIncidentManager getIIncidentManager() throws RemoteException {
        return IIncidentManager.Stub.asInterface(ServiceManager.getService("incident"));
    }

    public static int getAndValidateUser(Context context) {
        UserInfo currentUser;
        try {
            currentUser = ActivityManager.getService().getCurrentUser();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
        UserManager um = UserManager.get(context);
        UserInfo primaryUser = um.getPrimaryUser();
        if (currentUser == null) {
            Log.w(TAG, "No current user.  Nobody to approve the report. The report will be denied.");
            return -10000;
        }
        if (primaryUser == null) {
            Log.w(TAG, "No primary user.  Nobody to approve the report. The report will be denied.");
            return -10000;
        }
        if (primaryUser.id != currentUser.id) {
            Log.w(TAG, "Only the primary user can approve bugreports, but they are not the current user. The report will be denied.");
            return -10000;
        }
        return primaryUser.id;
    }

    private final class BinderService
    extends IIncidentCompanion.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void authorizeReport(int callingUid, String callingPackage, String receiverClass, String reportId, int flags, IIncidentAuthListener listener) {
            this.enforceRequestAuthorizationPermission();
            long ident = Binder.clearCallingIdentity();
            try {
                IncidentCompanionService.this.mPendingReports.authorizeReport(callingUid, callingPackage, receiverClass, reportId, flags, listener);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelAuthorization(IIncidentAuthListener listener) {
            this.enforceRequestAuthorizationPermission();
            long ident = Binder.clearCallingIdentity();
            try {
                IncidentCompanionService.this.mPendingReports.cancelAuthorization(listener);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendReportReadyBroadcast(String pkg, String cls) {
            this.enforceRequestAuthorizationPermission();
            long ident = Binder.clearCallingIdentity();
            try {
                Context context = IncidentCompanionService.this.getContext();
                int primaryUser = IncidentCompanionService.getAndValidateUser(context);
                if (primaryUser == -10000) {
                    return;
                }
                Intent intent = new Intent("android.intent.action.INCIDENT_REPORT_READY");
                intent.setComponent(new ComponentName(pkg, cls));
                Log.d(IncidentCompanionService.TAG, "sendReportReadyBroadcast sending primaryUser=" + primaryUser + " userHandle=" + UserHandle.getUserHandleForUid(primaryUser) + " intent=" + intent);
                context.sendBroadcastAsUserMultiplePermissions(intent, UserHandle.getUserHandleForUid(primaryUser), DUMP_AND_USAGE_STATS_PERMISSIONS);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public List<String> getPendingReports() {
            this.enforceAuthorizePermission();
            return IncidentCompanionService.this.mPendingReports.getPendingReports();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void approveReport(String uri) {
            this.enforceAuthorizePermission();
            long ident = Binder.clearCallingIdentity();
            try {
                IncidentCompanionService.this.mPendingReports.approveReport(uri);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void denyReport(String uri) {
            this.enforceAuthorizePermission();
            long ident = Binder.clearCallingIdentity();
            try {
                IncidentCompanionService.this.mPendingReports.denyReport(uri);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getIncidentReportList(String pkg, String cls) throws RemoteException {
            this.enforceAccessReportsPermissions(null);
            long ident = Binder.clearCallingIdentity();
            try {
                List<String> list = IncidentCompanionService.this.getIIncidentManager().getIncidentReportList(pkg, cls);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteIncidentReports(String pkg, String cls, String id2) throws RemoteException {
            if (pkg == null || cls == null || id2 == null || pkg.length() == 0 || cls.length() == 0 || id2.length() == 0) {
                throw new RuntimeException("Invalid pkg, cls or id");
            }
            this.enforceAccessReportsPermissions(pkg);
            long ident = Binder.clearCallingIdentity();
            try {
                IncidentCompanionService.this.getIIncidentManager().deleteIncidentReports(pkg, cls, id2);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteAllIncidentReports(String pkg) throws RemoteException {
            if (pkg == null || pkg.length() == 0) {
                throw new RuntimeException("Invalid pkg");
            }
            this.enforceAccessReportsPermissions(pkg);
            long ident = Binder.clearCallingIdentity();
            try {
                IncidentCompanionService.this.getIIncidentManager().deleteAllIncidentReports(pkg);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IncidentManager.IncidentReport getIncidentReport(String pkg, String cls, String id2) throws RemoteException {
            if (pkg == null || cls == null || id2 == null || pkg.length() == 0 || cls.length() == 0 || id2.length() == 0) {
                throw new RuntimeException("Invalid pkg, cls or id");
            }
            this.enforceAccessReportsPermissions(pkg);
            long ident = Binder.clearCallingIdentity();
            try {
                IncidentManager.IncidentReport incidentReport = IncidentCompanionService.this.getIIncidentManager().getIncidentReport(pkg, cls, id2);
                return incidentReport;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
            if (!DumpUtils.checkDumpPermission(IncidentCompanionService.this.getContext(), IncidentCompanionService.TAG, writer)) {
                return;
            }
            if (args.length == 1 && "--restricted_image".equals(args[0])) {
                this.dumpRestrictedImages(fd);
            } else {
                IncidentCompanionService.this.mPendingReports.dump(fd, writer, args);
            }
        }

        private void dumpRestrictedImages(FileDescriptor fd) {
            if (!Build.IS_ENG && !Build.IS_USERDEBUG) {
                return;
            }
            Resources res = IncidentCompanionService.this.getContext().getResources();
            for (String name : res.getStringArray(17236050)) {
                Log.d(IncidentCompanionService.TAG, "Looking up service " + name);
                IBinder service = ServiceManager.getService(name);
                if (service == null) continue;
                Log.d(IncidentCompanionService.TAG, "Calling dump on service: " + name);
                try {
                    service.dump(fd, RESTRICTED_IMAGE_DUMP_ARGS);
                }
                catch (RemoteException ex) {
                    Log.w(IncidentCompanionService.TAG, "dump --restricted_image of " + name + " threw", ex);
                }
            }
        }

        private void enforceRequestAuthorizationPermission() {
            IncidentCompanionService.this.getContext().enforceCallingOrSelfPermission("android.permission.REQUEST_INCIDENT_REPORT_APPROVAL", null);
        }

        private void enforceAuthorizePermission() {
            IncidentCompanionService.this.getContext().enforceCallingOrSelfPermission("android.permission.APPROVE_INCIDENT_REPORTS", null);
        }

        private void enforceAccessReportsPermissions(String pkg) {
            if (IncidentCompanionService.this.getContext().checkCallingPermission("android.permission.APPROVE_INCIDENT_REPORTS") != 0) {
                IncidentCompanionService.this.getContext().enforceCallingOrSelfPermission("android.permission.DUMP", null);
                IncidentCompanionService.this.getContext().enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", null);
                if (pkg != null) {
                    this.enforceCallerIsSameApp(pkg);
                }
            }
        }

        private void enforceCallerIsSameApp(String pkg) throws SecurityException {
            try {
                int uid = Binder.getCallingUid();
                int userId = UserHandle.getCallingUserId();
                ApplicationInfo ai = IncidentCompanionService.this.getContext().getPackageManager().getApplicationInfoAsUser(pkg, 0, userId);
                if (ai == null) {
                    throw new SecurityException("Unknown package " + pkg);
                }
                if (!UserHandle.isSameApp(ai.uid, uid)) {
                    throw new SecurityException("Calling uid " + uid + " gave package " + pkg + " which is owned by uid " + ai.uid);
                }
            }
            catch (PackageManager.NameNotFoundException re) {
                throw new SecurityException("Unknown package " + pkg + "\n" + re);
            }
        }
    }
}

