/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.incident;

import android.app.AppOpsManager;
import android.app.BroadcastOptions;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Handler;
import android.os.IIncidentAuthListener;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import com.android.server.incident.IncidentCompanionService;
import com.android.server.incident.RequestQueue;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

class PendingReports {
    static final String TAG = "IncidentCompanionService";
    private final Handler mHandler = new Handler();
    private final RequestQueue mRequestQueue = new RequestQueue(this.mHandler);
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final AppOpsManager mAppOpsManager;
    private final Object mLock = new Object();
    private final ArrayList<PendingReportRec> mPending = new ArrayList();
    private int mNextPendingId = 1;

    PendingReports(Context context) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mAppOpsManager = context.getSystemService(AppOpsManager.class);
    }

    public void authorizeReport(int callingUid, String callingPackage, String receiverClass, String reportId, int flags, IIncidentAuthListener listener) {
        this.mRequestQueue.enqueue(listener.asBinder(), true, () -> this.authorizeReportImpl(callingUid, callingPackage, receiverClass, reportId, flags, listener));
    }

    public void cancelAuthorization(IIncidentAuthListener listener) {
        this.mRequestQueue.enqueue(listener.asBinder(), false, () -> this.cancelReportImpl(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPendingReports() {
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mPending.size();
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                result.add(this.mPending.get(i).getUri().toString());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void approveReport(String uri) {
        PendingReportRec rec;
        Object object = this.mLock;
        synchronized (object) {
            rec = this.findAndRemovePendingReportRecLocked(uri);
            if (rec == null) {
                Log.e(TAG, "confirmApproved: Couldn't find record for uri: " + uri);
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var3_2
            this.sendBroadcast();
        }
        Log.i(TAG, "Approved report: " + uri);
        try {
            rec.listener.onReportApproved();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Failed calling back for approval for: " + uri, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void denyReport(String uri) {
        PendingReportRec rec;
        Object object = this.mLock;
        synchronized (object) {
            rec = this.findAndRemovePendingReportRecLocked(uri);
            if (rec == null) {
                Log.e(TAG, "confirmDenied: Couldn't find record for uri: " + uri);
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var3_2
            this.sendBroadcast();
        }
        Log.i(TAG, "Denied report: " + uri);
        try {
            rec.listener.onReportDenied();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Failed calling back for denial for: " + uri, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (args.length == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Object object = this.mLock;
            synchronized (object) {
                int size = this.mPending.size();
                writer.println("mPending: (" + size + ")");
                for (int i = 0; i < size; ++i) {
                    PendingReportRec entry = this.mPending.get(i);
                    writer.println(String.format("  %11d %s: %s", entry.addedRealtime, df.format(new Date(entry.addedWalltime)), entry.getUri().toString()));
                }
            }
        }
    }

    public void onBootCompleted() {
        this.mRequestQueue.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authorizeReportImpl(int callingUid, String callingPackage, String receiverClass, String reportId, int flags, IIncidentAuthListener listener) {
        if (callingUid != 0 && !this.isPackageInUid(callingUid, callingPackage)) {
            Log.w(TAG, "Calling uid " + callingUid + " doesn't match package " + callingPackage);
            this.denyReportBeforeAddingRec(listener, callingPackage);
            return;
        }
        int primaryUser = this.getAndValidateUser();
        if (primaryUser == -10000) {
            this.denyReportBeforeAddingRec(listener, callingPackage);
            return;
        }
        ComponentName receiver = this.getApproverComponent(primaryUser);
        if (receiver == null) {
            this.denyReportBeforeAddingRec(listener, callingPackage);
            return;
        }
        PendingReportRec rec = null;
        Object object = this.mLock;
        synchronized (object) {
            rec = new PendingReportRec(callingPackage, receiverClass, reportId, flags, listener);
            this.mPending.add(rec);
        }
        try {
            listener.asBinder().linkToDeath(() -> {
                Log.i(TAG, "Got death notification listener=" + listener);
                this.cancelReportImpl(listener, receiver, primaryUser);
            }, 0);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Remote died while trying to register death listener: " + rec.getUri());
            this.cancelReportImpl(listener, receiver, primaryUser);
        }
        this.sendBroadcast(receiver, primaryUser);
    }

    private void cancelReportImpl(IIncidentAuthListener listener) {
        int primaryUser = this.getAndValidateUser();
        ComponentName receiver = this.getApproverComponent(primaryUser);
        if (primaryUser != -10000 && receiver != null) {
            this.cancelReportImpl(listener, receiver, primaryUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelReportImpl(IIncidentAuthListener listener, ComponentName receiver, int primaryUser) {
        Object object = this.mLock;
        synchronized (object) {
            this.removePendingReportRecLocked(listener);
        }
        this.sendBroadcast(receiver, primaryUser);
    }

    private void sendBroadcast() {
        int primaryUser = this.getAndValidateUser();
        if (primaryUser == -10000) {
            return;
        }
        ComponentName receiver = this.getApproverComponent(primaryUser);
        if (receiver == null) {
            return;
        }
        this.sendBroadcast(receiver, primaryUser);
    }

    private void sendBroadcast(ComponentName receiver, int primaryUser) {
        Intent intent = new Intent("android.intent.action.PENDING_INCIDENT_REPORTS_CHANGED");
        intent.setComponent(receiver);
        BroadcastOptions options = BroadcastOptions.makeBasic();
        options.setBackgroundActivityStartsAllowed(true);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.getUserHandleForUid(primaryUser), "android.permission.APPROVE_INCIDENT_REPORTS", options.toBundle());
    }

    private PendingReportRec findAndRemovePendingReportRecLocked(String uriString) {
        int id2;
        Uri uri = Uri.parse(uriString);
        try {
            String idStr = uri.getQueryParameter("id");
            id2 = Integer.parseInt(idStr);
        }
        catch (NumberFormatException ex) {
            Log.w(TAG, "Can't parse id from: " + uriString);
            return null;
        }
        Iterator<PendingReportRec> i = this.mPending.iterator();
        while (i.hasNext()) {
            PendingReportRec rec = i.next();
            if (rec.id != id2) continue;
            i.remove();
            return rec;
        }
        return null;
    }

    private void removePendingReportRecLocked(IIncidentAuthListener listener) {
        Iterator<PendingReportRec> i = this.mPending.iterator();
        while (i.hasNext()) {
            PendingReportRec rec = i.next();
            if (rec.listener.asBinder() != listener.asBinder()) continue;
            Log.i(TAG, "  ...Removed PendingReportRec index=" + i + ": " + rec.getUri());
            i.remove();
        }
    }

    private void denyReportBeforeAddingRec(IIncidentAuthListener listener, String pkg) {
        try {
            listener.onReportDenied();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Failed calling back for denial for " + pkg, ex);
        }
    }

    private int getAndValidateUser() {
        return IncidentCompanionService.getAndValidateUser(this.mContext);
    }

    private ComponentName getApproverComponent(int userId) {
        Intent intent = new Intent("android.intent.action.PENDING_INCIDENT_REPORTS_CHANGED");
        List<ResolveInfo> matches = this.mPackageManager.queryBroadcastReceiversAsUser(intent, 0x1C0000, userId);
        if (matches.size() == 1) {
            return matches.get(0).getComponentInfo().getComponentName();
        }
        Log.w(TAG, "Didn't find exactly one BroadcastReceiver to handle android.intent.action.PENDING_INCIDENT_REPORTS_CHANGED. The report will be denied. size=" + matches.size() + ": matches=" + matches);
        return null;
    }

    private boolean isPackageInUid(int uid, String packageName) {
        try {
            this.mAppOpsManager.checkPackage(uid, packageName);
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    private final class PendingReportRec {
        public int id;
        public String callingPackage;
        public int flags;
        public IIncidentAuthListener listener;
        public long addedRealtime;
        public long addedWalltime;
        public String receiverClass;
        public String reportId;

        PendingReportRec(String callingPackage, String receiverClass, String reportId, int flags, IIncidentAuthListener listener) {
            this.id = PendingReports.this.mNextPendingId++;
            this.callingPackage = callingPackage;
            this.flags = flags;
            this.listener = listener;
            this.addedRealtime = SystemClock.elapsedRealtime();
            this.addedWalltime = System.currentTimeMillis();
            this.receiverClass = receiverClass;
            this.reportId = reportId;
        }

        Uri getUri() {
            Uri.Builder builder = new Uri.Builder().scheme("content").authority("android.os.IncidentManager").path("/pending").appendQueryParameter("id", Integer.toString(this.id)).appendQueryParameter("pkg", this.callingPackage).appendQueryParameter("flags", Integer.toString(this.flags)).appendQueryParameter("t", Long.toString(this.addedWalltime));
            if (this.receiverClass != null && this.receiverClass.length() > 0) {
                builder.appendQueryParameter("receiver", this.receiverClass);
            }
            if (this.reportId != null && this.reportId.length() > 0) {
                builder.appendQueryParameter("r", this.reportId);
            }
            return builder.build();
        }
    }
}

