/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.infra;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.infra.AbstractPerUserSystemService;
import com.android.server.infra.ServiceNameResolver;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public abstract class AbstractMasterSystemService<M extends AbstractMasterSystemService<M, S>, S extends AbstractPerUserSystemService<S, M>>
extends SystemService {
    public static final int PACKAGE_UPDATE_POLICY_NO_REFRESH = 0;
    public static final int PACKAGE_UPDATE_POLICY_REFRESH_LAZY = 1;
    public static final int PACKAGE_UPDATE_POLICY_REFRESH_EAGER = 2;
    protected final String mTag = this.getClass().getSimpleName();
    protected final Object mLock = new Object();
    protected final ServiceNameResolver mServiceNameResolver;
    public boolean verbose = false;
    public boolean debug = false;
    @GuardedBy(value={"mLock"})
    protected boolean mAllowInstantService;
    @GuardedBy(value={"mLock"})
    private final SparseBooleanArray mDisabledByUserRestriction;
    @GuardedBy(value={"mLock"})
    private final SparseArray<S> mServicesCache = new SparseArray();
    private final int mPackageUpdatePolicy;
    @GuardedBy(value={"mLock"})
    private SparseArray<String> mUpdatingPackageNames;

    protected AbstractMasterSystemService(Context context, ServiceNameResolver serviceNameResolver, String disallowProperty) {
        this(context, serviceNameResolver, disallowProperty, 1);
    }

    protected AbstractMasterSystemService(Context context, ServiceNameResolver serviceNameResolver, String disallowProperty, int packageUpdatePolicy) {
        super(context);
        this.mPackageUpdatePolicy = packageUpdatePolicy;
        this.mServiceNameResolver = serviceNameResolver;
        if (this.mServiceNameResolver != null) {
            this.mServiceNameResolver.setOnTemporaryServiceNameChangedCallback((u, s, t) -> this.onServiceNameChanged(u, s, t));
        }
        if (disallowProperty == null) {
            this.mDisabledByUserRestriction = null;
        } else {
            this.mDisabledByUserRestriction = new SparseBooleanArray();
            UserManager um = context.getSystemService(UserManager.class);
            UserManagerInternal umi = LocalServices.getService(UserManagerInternal.class);
            List<UserInfo> users = um.getUsers();
            for (int i = 0; i < users.size(); ++i) {
                int userId2 = users.get((int)i).id;
                boolean disabled = umi.getUserRestriction(userId2, disallowProperty);
                if (!disabled) continue;
                Slog.i(this.mTag, "Disabling by restrictions user " + userId2);
                this.mDisabledByUserRestriction.put(userId2, disabled);
            }
            umi.addUserRestrictionsListener((userId, newRestrictions, prevRestrictions) -> {
                boolean disabledNow = newRestrictions.getBoolean(disallowProperty, false);
                Object object = this.mLock;
                synchronized (object) {
                    boolean disabledBefore = this.mDisabledByUserRestriction.get(userId);
                    if (disabledBefore == disabledNow && this.debug) {
                        Slog.d(this.mTag, "Restriction did not change for user " + userId);
                        return;
                    }
                    Slog.i(this.mTag, "Updating for user " + userId + ": disabled=" + disabledNow);
                    this.mDisabledByUserRestriction.put(userId, disabledNow);
                    this.updateCachedServiceLocked(userId, disabledNow);
                }
            });
        }
        this.startTrackingPackageChanges();
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            new SettingsObserver(BackgroundThread.getHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedServiceLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCleanupUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeCachedServiceLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getAllowInstantService() {
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            return this.mAllowInstantService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBindInstantServiceAllowed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAllowInstantService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAllowInstantService(boolean mode) {
        Slog.i(this.mTag, "setAllowInstantService(): " + mode);
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            this.mAllowInstantService = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTemporaryService(int userId, String componentName, int durationMs) {
        Slog.i(this.mTag, "setTemporaryService(" + userId + ") to " + componentName + " for " + durationMs + "ms");
        this.enforceCallingPermissionForManagement();
        Preconditions.checkNotNull(componentName);
        int maxDurationMs = this.getMaximumTemporaryServiceDurationMs();
        if (durationMs > maxDurationMs) {
            throw new IllegalArgumentException("Max duration is " + maxDurationMs + " (called with " + durationMs + ")");
        }
        Object object = this.mLock;
        synchronized (object) {
            S oldService = this.peekServiceForUserLocked(userId);
            if (oldService != null) {
                ((AbstractPerUserSystemService)oldService).removeSelfFromCacheLocked();
            }
            this.mServiceNameResolver.setTemporaryService(userId, componentName, durationMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setDefaultServiceEnabled(int userId, boolean enabled) {
        Slog.i(this.mTag, "setDefaultServiceEnabled() for userId " + userId + ": " + enabled);
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = this.mServiceNameResolver.setDefaultServiceEnabled(userId, enabled);
            if (!changed) {
                if (this.verbose) {
                    Slog.v(this.mTag, "setDefaultServiceEnabled(" + userId + "): already " + enabled);
                }
                return false;
            }
            S oldService = this.peekServiceForUserLocked(userId);
            if (oldService != null) {
                ((AbstractPerUserSystemService)oldService).removeSelfFromCacheLocked();
            }
            this.updateCachedServiceLocked(userId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDefaultServiceEnabled(int userId) {
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            return this.mServiceNameResolver.isDefaultServiceEnabled(userId);
        }
    }

    protected int getMaximumTemporaryServiceDurationMs() {
        throw new UnsupportedOperationException("Not implemented by " + this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetTemporaryService(int userId) {
        Slog.i(this.mTag, "resetTemporaryService(): " + userId);
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            S service = this.getServiceForUserLocked(userId);
            if (service != null) {
                ((AbstractPerUserSystemService)service).resetTemporaryServiceLocked();
            }
        }
    }

    protected void enforceCallingPermissionForManagement() {
        throw new UnsupportedOperationException("Not implemented by " + this.getClass());
    }

    protected abstract S newServiceLocked(int var1, boolean var2);

    protected void registerForExtraSettingsChanges(ContentResolver resolver, ContentObserver observer) {
    }

    protected void onSettingsChanged(int userId, String property) {
    }

    @GuardedBy(value={"mLock"})
    protected S getServiceForUserLocked(int userId) {
        int resolvedUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, null, null);
        AbstractPerUserSystemService service = (AbstractPerUserSystemService)this.mServicesCache.get(resolvedUserId);
        if (service == null) {
            boolean disabled = this.isDisabledLocked(userId);
            service = this.newServiceLocked(resolvedUserId, disabled);
            if (!disabled) {
                this.onServiceEnabledLocked(service, resolvedUserId);
            }
            this.mServicesCache.put(userId, service);
        }
        return (S)service;
    }

    @GuardedBy(value={"mLock"})
    protected S peekServiceForUserLocked(int userId) {
        int resolvedUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, null, null);
        return (S)((AbstractPerUserSystemService)this.mServicesCache.get(resolvedUserId));
    }

    @GuardedBy(value={"mLock"})
    protected void updateCachedServiceLocked(int userId) {
        this.updateCachedServiceLocked(userId, this.isDisabledLocked(userId));
    }

    protected boolean isDisabledLocked(int userId) {
        return this.mDisabledByUserRestriction == null ? false : this.mDisabledByUserRestriction.get(userId);
    }

    @GuardedBy(value={"mLock"})
    protected S updateCachedServiceLocked(int userId, boolean disabled) {
        S service = this.getServiceForUserLocked(userId);
        if (service != null) {
            ((AbstractPerUserSystemService)service).updateLocked(disabled);
            if (!((AbstractPerUserSystemService)service).isEnabledLocked()) {
                this.removeCachedServiceLocked(userId);
            } else {
                this.onServiceEnabledLocked(service, userId);
            }
        }
        return service;
    }

    protected String getServiceSettingsProperty() {
        return null;
    }

    protected void onServiceEnabledLocked(S service, int userId) {
    }

    @GuardedBy(value={"mLock"})
    protected final S removeCachedServiceLocked(int userId) {
        S service = this.peekServiceForUserLocked(userId);
        if (service != null) {
            this.mServicesCache.delete(userId);
            this.onServiceRemoved(service, userId);
        }
        return service;
    }

    protected void onServicePackageUpdatingLocked(int userId) {
        if (this.verbose) {
            Slog.v(this.mTag, "onServicePackageUpdatingLocked(" + userId + ")");
        }
    }

    protected void onServicePackageUpdatedLocked(int userId) {
        if (this.verbose) {
            Slog.v(this.mTag, "onServicePackageUpdated(" + userId + ")");
        }
    }

    protected void onServiceRemoved(S service, int userId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onServiceNameChanged(int userId, String serviceName, boolean isTemporary) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedServiceLocked(userId);
        }
    }

    @GuardedBy(value={"mLock"})
    protected void visitServicesLocked(Visitor<S> visitor) {
        int size = this.mServicesCache.size();
        for (int i = 0; i < size; ++i) {
            visitor.visit((AbstractPerUserSystemService)this.mServicesCache.valueAt(i));
        }
    }

    @GuardedBy(value={"mLock"})
    protected void clearCacheLocked() {
        this.mServicesCache.clear();
    }

    protected final void assertCalledByPackageOwner(String packageName) {
        Preconditions.checkNotNull(packageName);
        int uid = Binder.getCallingUid();
        String[] packages = this.getContext().getPackageManager().getPackagesForUid(uid);
        if (packages != null) {
            for (String candidate : packages) {
                if (!packageName.equals(candidate)) continue;
                return;
            }
        }
        throw new SecurityException("UID " + uid + " does not own " + packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpLocked(String prefix, PrintWriter pw) {
        boolean realDebug = this.debug;
        boolean realVerbose = this.verbose;
        String prefix2 = "    ";
        try {
            this.verbose = true;
            this.debug = true;
            int size = this.mServicesCache.size();
            pw.print(prefix);
            pw.print("Debug: ");
            pw.print(realDebug);
            pw.print(" Verbose: ");
            pw.println(realVerbose);
            pw.print("Refresh on package update: ");
            pw.println(this.mPackageUpdatePolicy);
            if (this.mUpdatingPackageNames != null) {
                pw.print("Packages being updated: ");
                pw.println(this.mUpdatingPackageNames);
            }
            if (this.mServiceNameResolver != null) {
                pw.print(prefix);
                pw.print("Name resolver: ");
                this.mServiceNameResolver.dumpShort(pw);
                pw.println();
                UserManager um = this.getContext().getSystemService(UserManager.class);
                List<UserInfo> users = um.getUsers();
                for (int i = 0; i < users.size(); ++i) {
                    int userId = users.get((int)i).id;
                    pw.print("    ");
                    pw.print(userId);
                    pw.print(": ");
                    this.mServiceNameResolver.dumpShort(pw, userId);
                    pw.println();
                }
            }
            pw.print(prefix);
            pw.print("Users disabled by restriction: ");
            pw.println(this.mDisabledByUserRestriction);
            pw.print(prefix);
            pw.print("Allow instant service: ");
            pw.println(this.mAllowInstantService);
            String settingsProperty = this.getServiceSettingsProperty();
            if (settingsProperty != null) {
                pw.print(prefix);
                pw.print("Settings property: ");
                pw.println(settingsProperty);
            }
            pw.print(prefix);
            pw.print("Cached services: ");
            if (size == 0) {
                pw.println("none");
            } else {
                pw.println(size);
                for (int i = 0; i < size; ++i) {
                    pw.print(prefix);
                    pw.print("Service at ");
                    pw.print(i);
                    pw.println(": ");
                    AbstractPerUserSystemService service = (AbstractPerUserSystemService)this.mServicesCache.valueAt(i);
                    service.dumpLocked("    ", pw);
                    pw.println();
                }
            }
        }
        finally {
            this.debug = realDebug;
            this.verbose = realVerbose;
        }
    }

    private void startTrackingPackageChanges() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageUpdateStarted(String packageName, int uid) {
                String activePackageName;
                if (AbstractMasterSystemService.this.verbose) {
                    Slog.v(AbstractMasterSystemService.this.mTag, "onPackageUpdateStarted(): " + packageName);
                }
                if (!packageName.equals(activePackageName = this.getActiveServicePackageNameLocked())) {
                    return;
                }
                int userId = this.getChangingUserId();
                Object object = AbstractMasterSystemService.this.mLock;
                synchronized (object) {
                    if (AbstractMasterSystemService.this.mUpdatingPackageNames == null) {
                        AbstractMasterSystemService.this.mUpdatingPackageNames = new SparseArray(AbstractMasterSystemService.this.mServicesCache.size());
                    }
                    AbstractMasterSystemService.this.mUpdatingPackageNames.put(userId, packageName);
                    AbstractMasterSystemService.this.onServicePackageUpdatingLocked(userId);
                    if (AbstractMasterSystemService.this.mPackageUpdatePolicy != 0) {
                        if (AbstractMasterSystemService.this.debug) {
                            Slog.d(AbstractMasterSystemService.this.mTag, "Removing service for user " + userId + " because package " + activePackageName + " is being updated");
                        }
                        AbstractMasterSystemService.this.removeCachedServiceLocked(userId);
                        if (AbstractMasterSystemService.this.mPackageUpdatePolicy == 2) {
                            if (AbstractMasterSystemService.this.debug) {
                                Slog.d(AbstractMasterSystemService.this.mTag, "Eagerly recreating service for user " + userId);
                            }
                            AbstractMasterSystemService.this.getServiceForUserLocked(userId);
                        }
                    } else if (AbstractMasterSystemService.this.debug) {
                        Slog.d(AbstractMasterSystemService.this.mTag, "Holding service for user " + userId + " while package " + activePackageName + " is being updated");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageUpdateFinished(String packageName, int uid) {
                if (AbstractMasterSystemService.this.verbose) {
                    Slog.v(AbstractMasterSystemService.this.mTag, "onPackageUpdateFinished(): " + packageName);
                }
                int userId = this.getChangingUserId();
                Object object = AbstractMasterSystemService.this.mLock;
                synchronized (object) {
                    String activePackageName;
                    String string2 = activePackageName = AbstractMasterSystemService.this.mUpdatingPackageNames == null ? null : (String)AbstractMasterSystemService.this.mUpdatingPackageNames.get(userId);
                    if (packageName.equals(activePackageName)) {
                        if (AbstractMasterSystemService.this.mUpdatingPackageNames != null) {
                            AbstractMasterSystemService.this.mUpdatingPackageNames.remove(userId);
                            if (AbstractMasterSystemService.this.mUpdatingPackageNames.size() == 0) {
                                AbstractMasterSystemService.this.mUpdatingPackageNames = null;
                            }
                        }
                        AbstractMasterSystemService.this.onServicePackageUpdatedLocked(userId);
                    } else {
                        this.handlePackageUpdateLocked(packageName);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                Object object = AbstractMasterSystemService.this.mLock;
                synchronized (object) {
                    ComponentName componentName;
                    int userId = this.getChangingUserId();
                    Object service = AbstractMasterSystemService.this.peekServiceForUserLocked(userId);
                    if (service != null && (componentName = ((AbstractPerUserSystemService)service).getServiceComponentName()) != null && packageName.equals(componentName.getPackageName())) {
                        this.handleActiveServiceRemoved(userId);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                Object object = AbstractMasterSystemService.this.mLock;
                synchronized (object) {
                    String activePackageName = this.getActiveServicePackageNameLocked();
                    for (String pkg : packages) {
                        if (pkg.equals(activePackageName)) {
                            if (!doit) {
                                return true;
                            }
                            AbstractMasterSystemService.this.removeCachedServiceLocked(this.getChangingUserId());
                            continue;
                        }
                        this.handlePackageUpdateLocked(pkg);
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleActiveServiceRemoved(int userId) {
                Object object = AbstractMasterSystemService.this.mLock;
                synchronized (object) {
                    AbstractMasterSystemService.this.removeCachedServiceLocked(userId);
                }
                String serviceSettingsProperty = AbstractMasterSystemService.this.getServiceSettingsProperty();
                if (serviceSettingsProperty != null) {
                    Settings.Secure.putStringForUser(AbstractMasterSystemService.this.getContext().getContentResolver(), serviceSettingsProperty, null, userId);
                }
            }

            private String getActiveServicePackageNameLocked() {
                int userId = this.getChangingUserId();
                Object service = AbstractMasterSystemService.this.peekServiceForUserLocked(userId);
                if (service == null) {
                    return null;
                }
                ComponentName serviceComponent = ((AbstractPerUserSystemService)service).getServiceComponentName();
                if (serviceComponent == null) {
                    return null;
                }
                return serviceComponent.getPackageName();
            }

            @GuardedBy(value={"mLock"})
            private void handlePackageUpdateLocked(String packageName) {
                AbstractMasterSystemService.this.visitServicesLocked(s -> s.handlePackageUpdateLocked(packageName));
            }
        };
        monitor.register(this.getContext(), null, UserHandle.ALL, true);
    }

    private final class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
            ContentResolver resolver = AbstractMasterSystemService.this.getContext().getContentResolver();
            String serviceProperty = AbstractMasterSystemService.this.getServiceSettingsProperty();
            if (serviceProperty != null) {
                resolver.registerContentObserver(Settings.Secure.getUriFor(serviceProperty), false, this, -1);
            }
            resolver.registerContentObserver(Settings.Secure.getUriFor("user_setup_complete"), false, this, -1);
            AbstractMasterSystemService.this.registerForExtraSettingsChanges(resolver, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            String property;
            if (AbstractMasterSystemService.this.verbose) {
                Slog.v(AbstractMasterSystemService.this.mTag, "onChange(): uri=" + uri + ", userId=" + userId);
            }
            if ((property = uri.getLastPathSegment()).equals(AbstractMasterSystemService.this.getServiceSettingsProperty()) || property.equals("user_setup_complete")) {
                Object object = AbstractMasterSystemService.this.mLock;
                synchronized (object) {
                    AbstractMasterSystemService.this.updateCachedServiceLocked(userId);
                }
            } else {
                AbstractMasterSystemService.this.onSettingsChanged(userId, property);
            }
        }
    }

    public static interface Visitor<S> {
        public void visit(S var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PackageUpdatePolicy {
    }
}

