/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.infra;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.drawable.Drawable;
import android.os.RemoteException;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.SystemService;
import com.android.server.infra.AbstractMasterSystemService;
import java.io.PrintWriter;

public abstract class AbstractPerUserSystemService<S extends AbstractPerUserSystemService<S, M>, M extends AbstractMasterSystemService<M, S>> {
    protected final int mUserId;
    protected final Object mLock;
    protected final String mTag = this.getClass().getSimpleName();
    protected final M mMaster;
    @GuardedBy(value={"mLock"})
    private boolean mDisabled;
    @GuardedBy(value={"mLock"})
    private boolean mSetupComplete;
    @GuardedBy(value={"mLock"})
    private ServiceInfo mServiceInfo;

    protected AbstractPerUserSystemService(M master, Object lock, int userId) {
        this.mMaster = master;
        this.mLock = lock;
        this.mUserId = userId;
    }

    protected ServiceInfo newServiceInfoLocked(ComponentName serviceComponent) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("not overridden");
    }

    protected void handlePackageUpdateLocked(String packageName) {
    }

    @GuardedBy(value={"mLock"})
    protected boolean isEnabledLocked() {
        return this.mSetupComplete && this.mServiceInfo != null && !this.mDisabled;
    }

    protected final boolean isDisabledByUserRestrictionsLocked() {
        return this.mDisabled;
    }

    @GuardedBy(value={"mLock"})
    protected boolean updateLocked(boolean disabled) {
        boolean wasEnabled = this.isEnabledLocked();
        if (((AbstractMasterSystemService)this.mMaster).verbose) {
            Slog.v(this.mTag, "updateLocked(u=" + this.mUserId + "): wasEnabled=" + wasEnabled + ", mSetupComplete=" + this.mSetupComplete + ", disabled=" + disabled + ", mDisabled=" + this.mDisabled);
        }
        String setupComplete = Settings.Secure.getStringForUser(this.getContext().getContentResolver(), "user_setup_complete", this.mUserId);
        this.mSetupComplete = "1".equals(setupComplete);
        this.mDisabled = disabled;
        this.updateServiceInfoLocked();
        return wasEnabled != this.isEnabledLocked();
    }

    protected final ComponentName updateServiceInfoLocked() {
        ComponentName serviceComponent = null;
        if (((AbstractMasterSystemService)this.mMaster).mServiceNameResolver != null) {
            ServiceInfo serviceInfo = null;
            String componentName = this.getComponentNameLocked();
            if (!TextUtils.isEmpty(componentName)) {
                try {
                    serviceComponent = ComponentName.unflattenFromString(componentName);
                    serviceInfo = AppGlobals.getPackageManager().getServiceInfo(serviceComponent, 0, this.mUserId);
                    if (serviceInfo == null) {
                        Slog.e(this.mTag, "Bad service name: " + componentName);
                    }
                }
                catch (RemoteException | RuntimeException e) {
                    Slog.e(this.mTag, "Error getting service info for '" + componentName + "': " + e);
                    serviceInfo = null;
                }
            }
            try {
                if (serviceInfo != null) {
                    this.mServiceInfo = this.newServiceInfoLocked(serviceComponent);
                    if (((AbstractMasterSystemService)this.mMaster).debug) {
                        Slog.d(this.mTag, "Set component for user " + this.mUserId + " as " + serviceComponent + " and info as " + this.mServiceInfo);
                    }
                } else {
                    this.mServiceInfo = null;
                    if (((AbstractMasterSystemService)this.mMaster).debug) {
                        Slog.d(this.mTag, "Reset component for user " + this.mUserId + ":" + componentName);
                    }
                }
            }
            catch (Exception e) {
                Slog.e(this.mTag, "Bad ServiceInfo for '" + componentName + "': " + e);
                this.mServiceInfo = null;
            }
        }
        return serviceComponent;
    }

    public final int getUserId() {
        return this.mUserId;
    }

    public final M getMaster() {
        return this.mMaster;
    }

    @GuardedBy(value={"mLock"})
    protected final int getServiceUidLocked() {
        if (this.mServiceInfo == null) {
            if (((AbstractMasterSystemService)this.mMaster).verbose) {
                Slog.v(this.mTag, "getServiceUidLocked(): no mServiceInfo");
            }
            return -1;
        }
        return this.mServiceInfo.applicationInfo.uid;
    }

    protected final String getComponentNameLocked() {
        return ((AbstractMasterSystemService)this.mMaster).mServiceNameResolver.getServiceName(this.mUserId);
    }

    public final boolean isTemporaryServiceSetLocked() {
        return ((AbstractMasterSystemService)this.mMaster).mServiceNameResolver.isTemporary(this.mUserId);
    }

    protected final void resetTemporaryServiceLocked() {
        ((AbstractMasterSystemService)this.mMaster).mServiceNameResolver.resetTemporaryService(this.mUserId);
    }

    public final ServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentName getServiceComponentName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mServiceInfo == null ? null : this.mServiceInfo.getComponentName();
        }
    }

    public final String getServicePackageName() {
        ComponentName serviceComponent = this.getServiceComponentName();
        return serviceComponent == null ? null : serviceComponent.getPackageName();
    }

    @GuardedBy(value={"mLock"})
    public final CharSequence getServiceLabelLocked() {
        return this.mServiceInfo == null ? null : this.mServiceInfo.loadSafeLabel(this.getContext().getPackageManager(), 0.0f, 5);
    }

    @GuardedBy(value={"mLock"})
    public final Drawable getServiceIconLocked() {
        return this.mServiceInfo == null ? null : this.mServiceInfo.loadIcon(this.getContext().getPackageManager());
    }

    protected final void removeSelfFromCacheLocked() {
        ((AbstractMasterSystemService)this.mMaster).removeCachedServiceLocked(this.mUserId);
    }

    public final boolean isDebug() {
        return ((AbstractMasterSystemService)this.mMaster).debug;
    }

    public final boolean isVerbose() {
        return ((AbstractMasterSystemService)this.mMaster).verbose;
    }

    public final int getTargedSdkLocked() {
        return this.mServiceInfo == null ? 0 : this.mServiceInfo.applicationInfo.targetSdkVersion;
    }

    protected final boolean isSetupCompletedLocked() {
        return this.mSetupComplete;
    }

    protected final Context getContext() {
        return ((SystemService)this.mMaster).getContext();
    }

    @GuardedBy(value={"mLock"})
    protected void dumpLocked(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("User: ");
        pw.println(this.mUserId);
        if (this.mServiceInfo != null) {
            pw.print(prefix);
            pw.print("Service Label: ");
            pw.println(this.getServiceLabelLocked());
            pw.print(prefix);
            pw.print("Target SDK: ");
            pw.println(this.getTargedSdkLocked());
        }
        if (((AbstractMasterSystemService)this.mMaster).mServiceNameResolver != null) {
            pw.print(prefix);
            pw.print("Name resolver: ");
            ((AbstractMasterSystemService)this.mMaster).mServiceNameResolver.dumpShort(pw, this.mUserId);
            pw.println();
        }
        pw.print(prefix);
        pw.print("Disabled by UserManager: ");
        pw.println(this.mDisabled);
        pw.print(prefix);
        pw.print("Setup complete: ");
        pw.println(this.mSetupComplete);
        if (this.mServiceInfo != null) {
            pw.print(prefix);
            pw.print("Service UID: ");
            pw.println(this.mServiceInfo.applicationInfo.uid);
        }
        pw.println();
    }
}

