/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.infra;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.server.infra.ServiceNameResolver;
import java.io.PrintWriter;

public final class FrameworkResourcesServiceNameResolver
implements ServiceNameResolver {
    private static final String TAG = FrameworkResourcesServiceNameResolver.class.getSimpleName();
    private static final int MSG_RESET_TEMPORARY_SERVICE = 0;
    private final Context mContext;
    private final Object mLock = new Object();
    private final int mResourceId;
    private ServiceNameResolver.NameResolverListener mOnSetCallback;
    @GuardedBy(value={"mLock"})
    private final SparseArray<String> mTemporaryServiceNames = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final SparseBooleanArray mDefaultServicesDisabled = new SparseBooleanArray();
    @GuardedBy(value={"mLock"})
    private long mTemporaryServiceExpiration;
    @GuardedBy(value={"mLock"})
    private Handler mTemporaryHandler;

    public FrameworkResourcesServiceNameResolver(Context context, int resourceId) {
        this.mContext = context;
        this.mResourceId = resourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnTemporaryServiceNameChangedCallback(ServiceNameResolver.NameResolverListener callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnSetCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultServiceName(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            String name = this.mContext.getString(this.mResourceId);
            return TextUtils.isEmpty(name) ? null : name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServiceName(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            String temporaryName = this.mTemporaryServiceNames.get(userId);
            if (temporaryName != null) {
                Slog.w(TAG, "getServiceName(): using temporary name " + temporaryName + " for user " + userId);
                return temporaryName;
            }
            boolean disabled = this.mDefaultServicesDisabled.get(userId);
            if (disabled) {
                Slog.w(TAG, "getServiceName(): temporary name not set and default disabled for user " + userId);
                return null;
            }
            return this.getDefaultServiceName(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTemporaryServiceNames.get(userId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTemporaryService(final int userId, String componentName, int durationMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTemporaryServiceNames.put(userId, componentName);
            if (this.mTemporaryHandler == null) {
                this.mTemporaryHandler = new Handler(Looper.getMainLooper(), null, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleMessage(Message msg) {
                        if (msg.what == 0) {
                            Object object = FrameworkResourcesServiceNameResolver.this.mLock;
                            synchronized (object) {
                                FrameworkResourcesServiceNameResolver.this.resetTemporaryService(userId);
                            }
                        } else {
                            Slog.wtf(TAG, "invalid handler msg: " + msg);
                        }
                    }
                };
            } else {
                this.mTemporaryHandler.removeMessages(0);
            }
            this.mTemporaryServiceExpiration = SystemClock.elapsedRealtime() + (long)durationMs;
            this.mTemporaryHandler.sendEmptyMessageDelayed(0, durationMs);
            this.notifyTemporaryServiceNameChangedLocked(userId, componentName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTemporaryService(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.i(TAG, "resetting temporary service for user " + userId + " from " + this.mTemporaryServiceNames.get(userId));
            this.mTemporaryServiceNames.remove(userId);
            if (this.mTemporaryHandler != null) {
                this.mTemporaryHandler.removeMessages(0);
                this.mTemporaryHandler = null;
            }
            this.notifyTemporaryServiceNameChangedLocked(userId, null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDefaultServiceEnabled(int userId, boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            boolean currentlyEnabled = this.isDefaultServiceEnabledLocked(userId);
            if (currentlyEnabled == enabled) {
                Slog.i(TAG, "setDefaultServiceEnabled(" + userId + "): already " + enabled);
                return false;
            }
            if (enabled) {
                Slog.i(TAG, "disabling default service for user " + userId);
                this.mDefaultServicesDisabled.removeAt(userId);
            } else {
                Slog.i(TAG, "enabling default service for user " + userId);
                this.mDefaultServicesDisabled.put(userId, true);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefaultServiceEnabled(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.isDefaultServiceEnabledLocked(userId);
        }
    }

    private boolean isDefaultServiceEnabledLocked(int userId) {
        return !this.mDefaultServicesDisabled.get(userId);
    }

    public String toString() {
        return "FrameworkResourcesServiceNamer[temps=" + this.mTemporaryServiceNames + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpShort(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print("FrameworkResourcesServiceNamer: resId=");
            pw.print(this.mResourceId);
            pw.print(", numberTemps=");
            pw.print(this.mTemporaryServiceNames.size());
            pw.print(", enabledDefaults=");
            pw.print(this.mDefaultServicesDisabled.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpShort(PrintWriter pw, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            String temporaryName = this.mTemporaryServiceNames.get(userId);
            if (temporaryName != null) {
                pw.print("tmpName=");
                pw.print(temporaryName);
                long ttl = this.mTemporaryServiceExpiration - SystemClock.elapsedRealtime();
                pw.print(" (expires in ");
                TimeUtils.formatDuration(ttl, pw);
                pw.print("), ");
            }
            pw.print("defaultName=");
            pw.print(this.getDefaultServiceName(userId));
            boolean disabled = this.mDefaultServicesDisabled.get(userId);
            pw.println(disabled ? " (disabled)" : " (enabled)");
        }
    }

    private void notifyTemporaryServiceNameChangedLocked(int userId, String newTemporaryName, boolean isTemporary) {
        if (this.mOnSetCallback != null) {
            this.mOnSetCallback.onNameResolved(userId, newTemporaryName, isTemporary);
        }
    }
}

