/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.infra;

import android.content.Context;
import android.provider.Settings;
import com.android.server.infra.ServiceNameResolver;
import java.io.PrintWriter;

public final class SecureSettingsServiceNameResolver
implements ServiceNameResolver {
    private final Context mContext;
    private final String mProperty;

    public SecureSettingsServiceNameResolver(Context context, String property) {
        this.mContext = context;
        this.mProperty = property;
    }

    @Override
    public String getDefaultServiceName(int userId) {
        return Settings.Secure.getStringForUser(this.mContext.getContentResolver(), this.mProperty, userId);
    }

    @Override
    public void dumpShort(PrintWriter pw) {
        pw.print("SecureSettingsServiceNamer: prop=");
        pw.print(this.mProperty);
    }

    @Override
    public void dumpShort(PrintWriter pw, int userId) {
        pw.print("defaultService=");
        pw.print(this.getDefaultServiceName(userId));
    }

    public String toString() {
        return "SecureSettingsServiceNameResolver[" + this.mProperty + "]";
    }
}

