/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.input;

import android.text.TextUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.XmlUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

class ConfigurationProcessor {
    private static final String TAG = "ConfigurationProcessor";

    ConfigurationProcessor() {
    }

    static List<String> processExcludedDeviceNames(InputStream xml2) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        try (InputStreamReader confReader = new InputStreamReader(xml2);){
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(confReader);
            XmlUtils.beginDocument(parser, "devices");
            while (true) {
                XmlUtils.nextElement(parser);
                if (!"device".equals(parser.getName())) {
                    break;
                }
                String name = parser.getAttributeValue(null, "name");
                if (name == null) continue;
                names.add(name);
            }
        }
        return names;
    }

    @VisibleForTesting
    static List<Pair<String, String>> processInputPortAssociations(InputStream xml2) throws Exception {
        ArrayList<Pair<String, String>> associations = new ArrayList<Pair<String, String>>();
        try (InputStreamReader confReader = new InputStreamReader(xml2);){
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(confReader);
            XmlUtils.beginDocument(parser, "ports");
            while (true) {
                XmlUtils.nextElement(parser);
                String entryName = parser.getName();
                if (!"port".equals(entryName)) {
                    break;
                }
                String inputPort = parser.getAttributeValue(null, "input");
                String displayPort = parser.getAttributeValue(null, "display");
                if (TextUtils.isEmpty(inputPort) || TextUtils.isEmpty(displayPort)) {
                    Slog.wtf(TAG, "Ignoring incomplete entry");
                    continue;
                }
                try {
                    Integer.parseUnsignedInt(displayPort);
                }
                catch (NumberFormatException e) {
                    Slog.wtf(TAG, "Display port should be an integer");
                    continue;
                }
                associations.add(new Pair<String, String>(inputPort, displayPort));
            }
        }
        return associations;
    }
}

