/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.input;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayViewport;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputManager;
import android.hardware.input.ITabletModeChangedListener;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputManagerInternal;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.LocaleList;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.IInputFilter;
import android.view.IInputFilterHost;
import android.view.IInputMonitorHost;
import android.view.IWindow;
import android.view.InputApplicationHandle;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputMonitor;
import android.view.InputWindowHandle;
import android.view.KeyEvent;
import android.view.PointerIcon;
import android.view.ViewConfiguration;
import android.widget.Toast;
import com.android.internal.R;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.DisplayThread;
import com.android.server.LocalServices;
import com.android.server.Watchdog;
import com.android.server.input.ConfigurationProcessor;
import com.android.server.input.PersistentDataStore;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class InputManagerService
extends IInputManager.Stub
implements Watchdog.Monitor {
    static final String TAG = "InputManager";
    static final boolean DEBUG = false;
    private static final String EXCLUDED_DEVICES_PATH = "etc/excluded-input-devices.xml";
    private static final String PORT_ASSOCIATIONS_PATH = "etc/input-port-associations.xml";
    private static final int MSG_DELIVER_INPUT_DEVICES_CHANGED = 1;
    private static final int MSG_SWITCH_KEYBOARD_LAYOUT = 2;
    private static final int MSG_RELOAD_KEYBOARD_LAYOUTS = 3;
    private static final int MSG_UPDATE_KEYBOARD_LAYOUTS = 4;
    private static final int MSG_RELOAD_DEVICE_ALIASES = 5;
    private static final int MSG_DELIVER_TABLET_MODE_CHANGED = 6;
    private final long mPtr;
    private final Context mContext;
    private final InputManagerHandler mHandler;
    private Context mDisplayContext;
    private final File mDoubleTouchGestureEnableFile;
    private WindowManagerCallbacks mWindowManagerCallbacks;
    private WiredAccessoryCallbacks mWiredAccessoryCallbacks;
    private boolean mSystemReady;
    private NotificationManager mNotificationManager;
    private final Object mTabletModeLock = new Object();
    private final SparseArray<TabletModeChangedListenerRecord> mTabletModeChangedListeners = new SparseArray();
    private final List<TabletModeChangedListenerRecord> mTempTabletModeChangedListenersToNotify = new ArrayList<TabletModeChangedListenerRecord>();
    private final PersistentDataStore mDataStore = new PersistentDataStore();
    private Object mInputDevicesLock = new Object();
    private boolean mInputDevicesChangedPending;
    private InputDevice[] mInputDevices = new InputDevice[0];
    private final SparseArray<InputDevicesChangedListenerRecord> mInputDevicesChangedListeners = new SparseArray();
    private final ArrayList<InputDevicesChangedListenerRecord> mTempInputDevicesChangedListenersToNotify = new ArrayList();
    private final ArrayList<InputDevice> mTempFullKeyboards = new ArrayList();
    private boolean mKeyboardLayoutNotificationShown;
    private PendingIntent mKeyboardLayoutIntent;
    private Toast mSwitchedKeyboardLayoutToast;
    private Object mVibratorLock = new Object();
    private HashMap<IBinder, VibratorToken> mVibratorTokens = new HashMap();
    private int mNextVibratorTokenValue;
    final Object mInputFilterLock = new Object();
    IInputFilter mInputFilter;
    InputFilterHost mInputFilterHost;
    private IWindow mFocusedWindow;
    private boolean mFocusedWindowHasCapture;
    private static final int INPUT_EVENT_INJECTION_SUCCEEDED = 0;
    private static final int INPUT_EVENT_INJECTION_PERMISSION_DENIED = 1;
    private static final int INPUT_EVENT_INJECTION_FAILED = 2;
    private static final int INPUT_EVENT_INJECTION_TIMED_OUT = 3;
    private static final int INJECTION_TIMEOUT_MILLIS = 30000;
    public static final int KEY_STATE_UNKNOWN = -1;
    public static final int KEY_STATE_UP = 0;
    public static final int KEY_STATE_DOWN = 1;
    public static final int KEY_STATE_VIRTUAL = 2;
    public static final int BTN_MOUSE = 272;
    public static final int SW_LID = 0;
    public static final int SW_TABLET_MODE = 1;
    public static final int SW_KEYPAD_SLIDE = 10;
    public static final int SW_HEADPHONE_INSERT = 2;
    public static final int SW_MICROPHONE_INSERT = 4;
    public static final int SW_LINEOUT_INSERT = 6;
    public static final int SW_JACK_PHYSICAL_INSERT = 7;
    public static final int SW_CAMERA_LENS_COVER = 9;
    public static final int SW_LID_BIT = 1;
    public static final int SW_TABLET_MODE_BIT = 2;
    public static final int SW_KEYPAD_SLIDE_BIT = 1024;
    public static final int SW_HEADPHONE_INSERT_BIT = 4;
    public static final int SW_MICROPHONE_INSERT_BIT = 16;
    public static final int SW_LINEOUT_INSERT_BIT = 64;
    public static final int SW_JACK_PHYSICAL_INSERT_BIT = 128;
    public static final int SW_JACK_BITS = 212;
    public static final int SW_CAMERA_LENS_COVER_BIT = 512;
    final boolean mUseDevInputEventForAudioJack;

    private static native long nativeInit(InputManagerService var0, Context var1, MessageQueue var2);

    private static native void nativeStart(long var0);

    private static native void nativeSetDisplayViewports(long var0, DisplayViewport[] var2);

    private static native int nativeGetScanCodeState(long var0, int var2, int var3, int var4);

    private static native int nativeGetKeyCodeState(long var0, int var2, int var3, int var4);

    private static native int nativeGetSwitchState(long var0, int var2, int var3, int var4);

    private static native boolean nativeHasKeys(long var0, int var2, int var3, int[] var4, boolean[] var5);

    private static native void nativeRegisterInputChannel(long var0, InputChannel var2, int var3);

    private static native void nativeRegisterInputMonitor(long var0, InputChannel var2, int var3, boolean var4);

    private static native void nativeUnregisterInputChannel(long var0, InputChannel var2);

    private static native void nativePilferPointers(long var0, IBinder var2);

    private static native void nativeSetInputFilterEnabled(long var0, boolean var2);

    private static native int nativeInjectInputEvent(long var0, InputEvent var2, int var3, int var4, int var5, int var6, int var7);

    private static native void nativeToggleCapsLock(long var0, int var2);

    private static native void nativeSetInputWindows(long var0, InputWindowHandle[] var2, int var3);

    private static native void nativeSetInputDispatchMode(long var0, boolean var2, boolean var3);

    private static native void nativeSetSystemUiVisibility(long var0, int var2);

    private static native void nativeSetFocusedApplication(long var0, int var2, InputApplicationHandle var3);

    private static native void nativeSetFocusedDisplay(long var0, int var2);

    private static native void nativeSetPointerSpeed(long var0, int var2);

    private static native void nativeSetShowTouches(long var0, boolean var2);

    private static native void nativeSetInteractive(long var0, boolean var2);

    private static native void nativeReloadCalibration(long var0);

    private static native void nativeVibrate(long var0, int var2, long[] var3, int var4, int var5);

    private static native void nativeCancelVibrate(long var0, int var2, int var3);

    private static native void nativeReloadKeyboardLayouts(long var0);

    private static native void nativeReloadDeviceAliases(long var0);

    private static native String nativeDump(long var0);

    private static native void nativeMonitor(long var0);

    private static native boolean nativeIsInputDeviceEnabled(long var0, int var2);

    private static native void nativeEnableInputDevice(long var0, int var2);

    private static native void nativeDisableInputDevice(long var0, int var2);

    private static native void nativeSetPointerIconType(long var0, int var2);

    private static native void nativeReloadPointerIcons(long var0);

    private static native void nativeSetCustomPointerIcon(long var0, PointerIcon var2);

    private static native void nativeSetPointerCapture(long var0, boolean var2);

    private static native boolean nativeCanDispatchToDisplay(long var0, int var2, int var3);

    public InputManagerService(Context context) {
        this.mContext = context;
        this.mHandler = new InputManagerHandler(DisplayThread.get().getLooper());
        this.mUseDevInputEventForAudioJack = context.getResources().getBoolean(17891557);
        Slog.i(TAG, "Initializing input manager, mUseDevInputEventForAudioJack=" + this.mUseDevInputEventForAudioJack);
        this.mPtr = InputManagerService.nativeInit(this, this.mContext, this.mHandler.getLooper().getQueue());
        String doubleTouchGestureEnablePath = context.getResources().getString(17039722);
        this.mDoubleTouchGestureEnableFile = TextUtils.isEmpty(doubleTouchGestureEnablePath) ? null : new File(doubleTouchGestureEnablePath);
        LocalServices.addService(InputManagerInternal.class, new LocalService());
    }

    public void setWindowManagerCallbacks(WindowManagerCallbacks callbacks) {
        this.mWindowManagerCallbacks = callbacks;
    }

    public void setWiredAccessoryCallbacks(WiredAccessoryCallbacks callbacks) {
        this.mWiredAccessoryCallbacks = callbacks;
    }

    public void start() {
        Slog.i(TAG, "Starting input manager");
        InputManagerService.nativeStart(this.mPtr);
        Watchdog.getInstance().addMonitor(this);
        this.registerPointerSpeedSettingObserver();
        this.registerShowTouchesSettingObserver();
        this.registerAccessibilityLargePointerSettingObserver();
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                InputManagerService.this.updatePointerSpeedFromSettings();
                InputManagerService.this.updateShowTouchesFromSettings();
                InputManagerService.this.updateAccessibilityLargePointerFromSettings();
            }
        }, new IntentFilter("android.intent.action.USER_SWITCHED"), null, this.mHandler);
        this.updatePointerSpeedFromSettings();
        this.updateShowTouchesFromSettings();
        this.updateAccessibilityLargePointerFromSettings();
    }

    public void systemRunning() {
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mSystemReady = true;
        IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REPLACED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                InputManagerService.this.updateKeyboardLayouts();
            }
        }, filter, null, this.mHandler);
        filter = new IntentFilter("android.bluetooth.device.action.ALIAS_CHANGED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                InputManagerService.this.reloadDeviceAliases();
            }
        }, filter, null, this.mHandler);
        this.mHandler.sendEmptyMessage(5);
        this.mHandler.sendEmptyMessage(4);
        if (this.mWiredAccessoryCallbacks != null) {
            this.mWiredAccessoryCallbacks.systemReady();
        }
    }

    private void reloadKeyboardLayouts() {
        InputManagerService.nativeReloadKeyboardLayouts(this.mPtr);
    }

    private void reloadDeviceAliases() {
        InputManagerService.nativeReloadDeviceAliases(this.mPtr);
    }

    private void setDisplayViewportsInternal(List<DisplayViewport> viewports) {
        InputManagerService.nativeSetDisplayViewports(this.mPtr, viewports.toArray(new DisplayViewport[0]));
    }

    public int getKeyCodeState(int deviceId, int sourceMask, int keyCode) {
        return InputManagerService.nativeGetKeyCodeState(this.mPtr, deviceId, sourceMask, keyCode);
    }

    public int getScanCodeState(int deviceId, int sourceMask, int scanCode) {
        return InputManagerService.nativeGetScanCodeState(this.mPtr, deviceId, sourceMask, scanCode);
    }

    public int getSwitchState(int deviceId, int sourceMask, int switchCode) {
        return InputManagerService.nativeGetSwitchState(this.mPtr, deviceId, sourceMask, switchCode);
    }

    @Override
    public boolean hasKeys(int deviceId, int sourceMask, int[] keyCodes, boolean[] keyExists) {
        if (keyCodes == null) {
            throw new IllegalArgumentException("keyCodes must not be null.");
        }
        if (keyExists == null || keyExists.length < keyCodes.length) {
            throw new IllegalArgumentException("keyExists must not be null and must be at least as large as keyCodes.");
        }
        return InputManagerService.nativeHasKeys(this.mPtr, deviceId, sourceMask, keyCodes, keyExists);
    }

    public InputChannel monitorInput(String inputChannelName, int displayId) {
        if (inputChannelName == null) {
            throw new IllegalArgumentException("inputChannelName must not be null.");
        }
        if (displayId < 0) {
            throw new IllegalArgumentException("displayId must >= 0.");
        }
        InputChannel[] inputChannels = InputChannel.openInputChannelPair(inputChannelName);
        inputChannels[0].setToken(new Binder());
        InputManagerService.nativeRegisterInputMonitor(this.mPtr, inputChannels[0], displayId, false);
        inputChannels[0].dispose();
        return inputChannels[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputMonitor monitorGestureInput(String inputChannelName, int displayId) {
        if (!this.checkCallingPermission("android.permission.MONITOR_INPUT", "monitorInputRegion()")) {
            throw new SecurityException("Requires MONITOR_INPUT permission");
        }
        Objects.requireNonNull(inputChannelName, "inputChannelName must not be null.");
        if (displayId < 0) {
            throw new IllegalArgumentException("displayId must >= 0.");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            InputChannel[] inputChannels = InputChannel.openInputChannelPair(inputChannelName);
            InputMonitorHost host = new InputMonitorHost(inputChannels[0]);
            inputChannels[0].setToken(host.asBinder());
            InputManagerService.nativeRegisterInputMonitor(this.mPtr, inputChannels[0], displayId, true);
            InputMonitor inputMonitor = new InputMonitor(inputChannelName, inputChannels[1], host);
            return inputMonitor;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    public void registerInputChannel(InputChannel inputChannel, IBinder token) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null.");
        }
        if (token == null) {
            token = new Binder();
        }
        inputChannel.setToken(token);
        InputManagerService.nativeRegisterInputChannel(this.mPtr, inputChannel, -1);
    }

    public void unregisterInputChannel(InputChannel inputChannel) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null.");
        }
        InputManagerService.nativeUnregisterInputChannel(this.mPtr, inputChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputFilter(IInputFilter filter) {
        Object object = this.mInputFilterLock;
        synchronized (object) {
            IInputFilter oldFilter = this.mInputFilter;
            if (oldFilter == filter) {
                return;
            }
            if (oldFilter != null) {
                this.mInputFilter = null;
                this.mInputFilterHost.disconnectLocked();
                this.mInputFilterHost = null;
                try {
                    oldFilter.uninstall();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (filter != null) {
                this.mInputFilter = filter;
                this.mInputFilterHost = new InputFilterHost();
                try {
                    filter.install(this.mInputFilterHost);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            InputManagerService.nativeSetInputFilterEnabled(this.mPtr, filter != null);
        }
    }

    @Override
    public boolean injectInputEvent(InputEvent event, int mode) {
        return this.injectInputEventInternal(event, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean injectInputEventInternal(InputEvent event, int mode) {
        int result;
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("mode is invalid");
        }
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        try {
            result = InputManagerService.nativeInjectInputEvent(this.mPtr, event, pid, uid, mode, 30000, 0x8000000);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        switch (result) {
            case 1: {
                Slog.w(TAG, "Input event injection from pid " + pid + " permission denied.");
                throw new SecurityException("Injecting to another application requires INJECT_EVENTS permission");
            }
            case 0: {
                return true;
            }
            case 3: {
                Slog.w(TAG, "Input event injection from pid " + pid + " timed out.");
                return false;
            }
        }
        Slog.w(TAG, "Input event injection from pid " + pid + " failed.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputDevice getInputDevice(int deviceId) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            for (InputDevice inputDevice : this.mInputDevices) {
                if (inputDevice.getId() != deviceId) continue;
                return inputDevice;
            }
        }
        return null;
    }

    @Override
    public boolean isInputDeviceEnabled(int deviceId) {
        return InputManagerService.nativeIsInputDeviceEnabled(this.mPtr, deviceId);
    }

    @Override
    public void enableInputDevice(int deviceId) {
        if (!this.checkCallingPermission("android.permission.DISABLE_INPUT_DEVICE", "enableInputDevice()")) {
            throw new SecurityException("Requires DISABLE_INPUT_DEVICE permission");
        }
        InputManagerService.nativeEnableInputDevice(this.mPtr, deviceId);
    }

    @Override
    public void disableInputDevice(int deviceId) {
        if (!this.checkCallingPermission("android.permission.DISABLE_INPUT_DEVICE", "disableInputDevice()")) {
            throw new SecurityException("Requires DISABLE_INPUT_DEVICE permission");
        }
        InputManagerService.nativeDisableInputDevice(this.mPtr, deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getInputDeviceIds() {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int count = this.mInputDevices.length;
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = this.mInputDevices[i].getId();
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputDevice[] getInputDevices() {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            return this.mInputDevices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInputDevicesChangedListener(IInputDevicesChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int callingPid = Binder.getCallingPid();
            if (this.mInputDevicesChangedListeners.get(callingPid) != null) {
                throw new SecurityException("The calling process has already registered an InputDevicesChangedListener.");
            }
            InputDevicesChangedListenerRecord record = new InputDevicesChangedListenerRecord(callingPid, listener);
            try {
                IBinder binder = listener.asBinder();
                binder.linkToDeath(record, 0);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
            this.mInputDevicesChangedListeners.put(callingPid, record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDevicesChangedListenerDied(int pid) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.mInputDevicesChangedListeners.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverInputDevicesChanged(InputDevice[] oldInputDevices) {
        int[] deviceIdAndGeneration;
        int numListeners;
        int numFullKeyboardsAdded = 0;
        this.mTempInputDevicesChangedListenersToNotify.clear();
        this.mTempFullKeyboards.clear();
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            if (!this.mInputDevicesChangedPending) {
                return;
            }
            this.mInputDevicesChangedPending = false;
            numListeners = this.mInputDevicesChangedListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mTempInputDevicesChangedListenersToNotify.add(this.mInputDevicesChangedListeners.valueAt(i));
            }
            int numDevices = this.mInputDevices.length;
            deviceIdAndGeneration = new int[numDevices * 2];
            for (int i = 0; i < numDevices; ++i) {
                InputDevice inputDevice = this.mInputDevices[i];
                deviceIdAndGeneration[i * 2] = inputDevice.getId();
                deviceIdAndGeneration[i * 2 + 1] = inputDevice.getGeneration();
                if (inputDevice.isVirtual() || !inputDevice.isFullKeyboard()) continue;
                if (!InputManagerService.containsInputDeviceWithDescriptor(oldInputDevices, inputDevice.getDescriptor())) {
                    this.mTempFullKeyboards.add(numFullKeyboardsAdded++, inputDevice);
                    continue;
                }
                this.mTempFullKeyboards.add(inputDevice);
            }
        }
        for (int i = 0; i < numListeners; ++i) {
            this.mTempInputDevicesChangedListenersToNotify.get(i).notifyInputDevicesChanged(deviceIdAndGeneration);
        }
        this.mTempInputDevicesChangedListenersToNotify.clear();
        ArrayList<InputDevice> keyboardsMissingLayout = new ArrayList<InputDevice>();
        int numFullKeyboards = this.mTempFullKeyboards.size();
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            for (int i = 0; i < numFullKeyboards; ++i) {
                InputDevice inputDevice = this.mTempFullKeyboards.get(i);
                String layout2 = this.getCurrentKeyboardLayoutForInputDevice(inputDevice.getIdentifier());
                if (layout2 == null && (layout2 = this.getDefaultKeyboardLayout(inputDevice)) != null) {
                    this.setCurrentKeyboardLayoutForInputDevice(inputDevice.getIdentifier(), layout2);
                }
                if (layout2 != null) continue;
                keyboardsMissingLayout.add(inputDevice);
            }
        }
        if (this.mNotificationManager != null) {
            if (!keyboardsMissingLayout.isEmpty()) {
                if (keyboardsMissingLayout.size() > 1) {
                    this.showMissingKeyboardLayoutNotification(null);
                } else {
                    this.showMissingKeyboardLayoutNotification((InputDevice)keyboardsMissingLayout.get(0));
                }
            } else if (this.mKeyboardLayoutNotificationShown) {
                this.hideMissingKeyboardLayoutNotification();
            }
        }
        this.mTempFullKeyboards.clear();
    }

    private String getDefaultKeyboardLayout(final InputDevice d) {
        Locale locale;
        int localeIndex;
        int numLocales;
        LocaleList locales;
        KeyboardLayout layout2;
        int i;
        final Locale systemLocale = this.mContext.getResources().getConfiguration().locale;
        if (TextUtils.isEmpty(systemLocale.getLanguage())) {
            return null;
        }
        final ArrayList layouts = new ArrayList();
        this.visitAllKeyboardLayouts(new KeyboardLayoutVisitor(){

            @Override
            public void visitKeyboardLayout(Resources resources, int keyboardLayoutResId, KeyboardLayout layout2) {
                if (layout2.getVendorId() != d.getVendorId() || layout2.getProductId() != d.getProductId()) {
                    return;
                }
                LocaleList locales = layout2.getLocales();
                int numLocales = locales.size();
                for (int localeIndex = 0; localeIndex < numLocales; ++localeIndex) {
                    if (!InputManagerService.isCompatibleLocale(systemLocale, locales.get(localeIndex))) continue;
                    layouts.add(layout2);
                    break;
                }
            }
        });
        if (layouts.isEmpty()) {
            return null;
        }
        Collections.sort(layouts);
        int N = layouts.size();
        for (i = 0; i < N; ++i) {
            layout2 = (KeyboardLayout)layouts.get(i);
            locales = layout2.getLocales();
            numLocales = locales.size();
            for (localeIndex = 0; localeIndex < numLocales; ++localeIndex) {
                locale = locales.get(localeIndex);
                if (!locale.getCountry().equals(systemLocale.getCountry()) || !locale.getVariant().equals(systemLocale.getVariant())) continue;
                return layout2.getDescriptor();
            }
        }
        for (i = 0; i < N; ++i) {
            layout2 = (KeyboardLayout)layouts.get(i);
            locales = layout2.getLocales();
            numLocales = locales.size();
            for (localeIndex = 0; localeIndex < numLocales; ++localeIndex) {
                locale = locales.get(localeIndex);
                if (!locale.getCountry().equals(systemLocale.getCountry())) continue;
                return layout2.getDescriptor();
            }
        }
        return ((KeyboardLayout)layouts.get(0)).getDescriptor();
    }

    private static boolean isCompatibleLocale(Locale systemLocale, Locale keyboardLocale) {
        if (!systemLocale.getLanguage().equals(keyboardLocale.getLanguage())) {
            return false;
        }
        return TextUtils.isEmpty(systemLocale.getCountry()) || TextUtils.isEmpty(keyboardLocale.getCountry()) || systemLocale.getCountry().equals(keyboardLocale.getCountry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TouchCalibration getTouchCalibrationForInputDevice(String inputDeviceDescriptor, int surfaceRotation) {
        if (inputDeviceDescriptor == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            return this.mDataStore.getTouchCalibration(inputDeviceDescriptor, surfaceRotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTouchCalibrationForInputDevice(String inputDeviceDescriptor, int surfaceRotation, TouchCalibration calibration) {
        if (!this.checkCallingPermission("android.permission.SET_INPUT_CALIBRATION", "setTouchCalibrationForInputDevice()")) {
            throw new SecurityException("Requires SET_INPUT_CALIBRATION permission");
        }
        if (inputDeviceDescriptor == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (calibration == null) {
            throw new IllegalArgumentException("calibration must not be null");
        }
        if (surfaceRotation < 0 || surfaceRotation > 3) {
            throw new IllegalArgumentException("surfaceRotation value out of bounds");
        }
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            try {
                if (this.mDataStore.setTouchCalibration(inputDeviceDescriptor, surfaceRotation, calibration)) {
                    InputManagerService.nativeReloadCalibration(this.mPtr);
                }
            }
            finally {
                this.mDataStore.saveIfNeeded();
            }
        }
    }

    @Override
    public int isInTabletMode() {
        if (!this.checkCallingPermission("android.permission.TABLET_MODE", "isInTabletMode()")) {
            throw new SecurityException("Requires TABLET_MODE permission");
        }
        return this.getSwitchState(-1, -256, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTabletModeChangedListener(ITabletModeChangedListener listener) {
        if (!this.checkCallingPermission("android.permission.TABLET_MODE", "registerTabletModeChangedListener()")) {
            throw new SecurityException("Requires TABLET_MODE_LISTENER permission");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mTabletModeLock;
        synchronized (object) {
            int callingPid = Binder.getCallingPid();
            if (this.mTabletModeChangedListeners.get(callingPid) != null) {
                throw new IllegalStateException("The calling process has already registered a TabletModeChangedListener.");
            }
            TabletModeChangedListenerRecord record = new TabletModeChangedListenerRecord(callingPid, listener);
            try {
                IBinder binder = listener.asBinder();
                binder.linkToDeath(record, 0);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
            this.mTabletModeChangedListeners.put(callingPid, record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTabletModeChangedListenerDied(int pid) {
        Object object = this.mTabletModeLock;
        synchronized (object) {
            this.mTabletModeChangedListeners.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTabletModeChanged(long whenNanos, boolean inTabletMode) {
        int numListeners;
        this.mTempTabletModeChangedListenersToNotify.clear();
        Object object = this.mTabletModeLock;
        synchronized (object) {
            numListeners = this.mTabletModeChangedListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mTempTabletModeChangedListenersToNotify.add(this.mTabletModeChangedListeners.valueAt(i));
            }
        }
        for (int i = 0; i < numListeners; ++i) {
            this.mTempTabletModeChangedListenersToNotify.get(i).notifyTabletModeChanged(whenNanos, inTabletMode);
        }
    }

    private void showMissingKeyboardLayoutNotification(InputDevice device) {
        if (!this.mKeyboardLayoutNotificationShown) {
            Intent intent = new Intent("android.settings.HARD_KEYBOARD_SETTINGS");
            if (device != null) {
                intent.putExtra("input_device_identifier", device.getIdentifier());
            }
            intent.setFlags(337641472);
            PendingIntent keyboardLayoutIntent = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
            Resources r = this.mContext.getResources();
            Notification notification = new Notification.Builder(this.mContext, SystemNotificationChannels.PHYSICAL_KEYBOARD).setContentTitle(r.getString(17040983)).setContentText(r.getString(17040982)).setContentIntent(keyboardLayoutIntent).setSmallIcon(17302797).setColor(this.mContext.getColor(17170460)).build();
            this.mNotificationManager.notifyAsUser(null, 19, notification, UserHandle.ALL);
            this.mKeyboardLayoutNotificationShown = true;
        }
    }

    private void hideMissingKeyboardLayoutNotification() {
        if (this.mKeyboardLayoutNotificationShown) {
            this.mKeyboardLayoutNotificationShown = false;
            this.mNotificationManager.cancelAsUser(null, 19, UserHandle.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKeyboardLayouts() {
        final HashSet<String> availableKeyboardLayouts = new HashSet<String>();
        this.visitAllKeyboardLayouts(new KeyboardLayoutVisitor(){

            @Override
            public void visitKeyboardLayout(Resources resources, int keyboardLayoutResId, KeyboardLayout layout2) {
                availableKeyboardLayouts.add(layout2.getDescriptor());
            }
        });
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            try {
                this.mDataStore.removeUninstalledKeyboardLayouts(availableKeyboardLayouts);
            }
            finally {
                this.mDataStore.saveIfNeeded();
            }
        }
        this.reloadKeyboardLayouts();
    }

    private static boolean containsInputDeviceWithDescriptor(InputDevice[] inputDevices, String descriptor) {
        for (InputDevice inputDevice : inputDevices) {
            if (!inputDevice.getDescriptor().equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public KeyboardLayout[] getKeyboardLayouts() {
        final ArrayList list = new ArrayList();
        this.visitAllKeyboardLayouts(new KeyboardLayoutVisitor(){

            @Override
            public void visitKeyboardLayout(Resources resources, int keyboardLayoutResId, KeyboardLayout layout2) {
                list.add(layout2);
            }
        });
        return list.toArray(new KeyboardLayout[list.size()]);
    }

    @Override
    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(final InputDeviceIdentifier identifier) {
        final String[] enabledLayoutDescriptors = this.getEnabledKeyboardLayoutsForInputDevice(identifier);
        final ArrayList enabledLayouts = new ArrayList(enabledLayoutDescriptors.length);
        final ArrayList potentialLayouts = new ArrayList();
        this.visitAllKeyboardLayouts(new KeyboardLayoutVisitor(){
            boolean mHasSeenDeviceSpecificLayout;

            @Override
            public void visitKeyboardLayout(Resources resources, int keyboardLayoutResId, KeyboardLayout layout2) {
                for (String s : enabledLayoutDescriptors) {
                    if (s == null || !s.equals(layout2.getDescriptor())) continue;
                    enabledLayouts.add(layout2);
                    return;
                }
                if (layout2.getVendorId() == identifier.getVendorId() && layout2.getProductId() == identifier.getProductId()) {
                    if (!this.mHasSeenDeviceSpecificLayout) {
                        this.mHasSeenDeviceSpecificLayout = true;
                        potentialLayouts.clear();
                    }
                    potentialLayouts.add(layout2);
                } else if (layout2.getVendorId() == -1 && layout2.getProductId() == -1 && !this.mHasSeenDeviceSpecificLayout) {
                    potentialLayouts.add(layout2);
                }
            }
        });
        int enabledLayoutSize = enabledLayouts.size();
        int potentialLayoutSize = potentialLayouts.size();
        KeyboardLayout[] layouts = new KeyboardLayout[enabledLayoutSize + potentialLayoutSize];
        enabledLayouts.toArray(layouts);
        for (int i = 0; i < potentialLayoutSize; ++i) {
            layouts[enabledLayoutSize + i] = (KeyboardLayout)potentialLayouts.get(i);
        }
        return layouts;
    }

    @Override
    public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) {
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        final KeyboardLayout[] result = new KeyboardLayout[1];
        this.visitKeyboardLayout(keyboardLayoutDescriptor, new KeyboardLayoutVisitor(){

            @Override
            public void visitKeyboardLayout(Resources resources, int keyboardLayoutResId, KeyboardLayout layout2) {
                result[0] = layout2;
            }
        });
        if (result[0] == null) {
            Slog.w(TAG, "Could not get keyboard layout with descriptor '" + keyboardLayoutDescriptor + "'.");
        }
        return result[0];
    }

    private void visitAllKeyboardLayouts(KeyboardLayoutVisitor visitor) {
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS");
        for (ResolveInfo resolveInfo : pm.queryBroadcastReceivers(intent, 786560)) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            int priority = resolveInfo.priority;
            this.visitKeyboardLayoutsInPackage(pm, activityInfo, null, priority, visitor);
        }
    }

    private void visitKeyboardLayout(String keyboardLayoutDescriptor, KeyboardLayoutVisitor visitor) {
        KeyboardLayoutDescriptor d = KeyboardLayoutDescriptor.parse(keyboardLayoutDescriptor);
        if (d != null) {
            PackageManager pm = this.mContext.getPackageManager();
            try {
                ActivityInfo receiver = pm.getReceiverInfo(new ComponentName(d.packageName, d.receiverName), 786560);
                this.visitKeyboardLayoutsInPackage(pm, receiver, d.keyboardLayoutName, 0, visitor);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void visitKeyboardLayoutsInPackage(PackageManager pm, ActivityInfo receiver, String keyboardName, int requestedPriority, KeyboardLayoutVisitor visitor) {
        metaData = receiver.metaData;
        if (metaData == null) {
            return;
        }
        configResId = metaData.getInt("android.hardware.input.metadata.KEYBOARD_LAYOUTS");
        if (configResId == 0) {
            Slog.w("InputManager", "Missing meta-data 'android.hardware.input.metadata.KEYBOARD_LAYOUTS' on receiver " + receiver.packageName + "/" + receiver.name);
            return;
        }
        receiverLabel = receiver.loadLabel(pm);
        collection = receiverLabel != null ? receiverLabel.toString() : "";
        priority = (receiver.applicationInfo.flags & 1) != 0 ? requestedPriority : 0;
        try {
            resources = pm.getResourcesForApplication(receiver.applicationInfo);
            parser = resources.getXml(configResId);
            try {
                XmlUtils.beginDocument(parser, "keyboard-layouts");
                while (true) lbl-1000:
                // 6 sources

                {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (element.equals("keyboard-layout")) {
                        a = resources.obtainAttributes(parser, R.styleable.KeyboardLayout);
                        try {
                            name = a.getString(1);
                            label = a.getString(0);
                            keyboardLayoutResId = a.getResourceId(2, 0);
                            languageTags = a.getString(3);
                            locales = InputManagerService.getLocalesFromLanguageTags(languageTags);
                            vid = a.getInt(5, -1);
                            pid = a.getInt(4, -1);
                            if (name == null || label == null || keyboardLayoutResId == 0) {
                                Slog.w("InputManager", "Missing required 'name', 'label' or 'keyboardLayout' attributes in keyboard layout resource from receiver " + receiver.packageName + "/" + receiver.name);
                            }
                            descriptor = KeyboardLayoutDescriptor.format(receiver.packageName, receiver.name, name);
                            if (keyboardName != null && !name.equals(keyboardName)) ** GOTO lbl-1000
                            layout = new KeyboardLayout(descriptor, label, collection, priority, locales, vid, pid);
                            visitor.visitKeyboardLayout(resources, keyboardLayoutResId, layout);
                        }
                        finally {
                            a.recycle();
                        }
                        continue;
                    }
                    Slog.w("InputManager", "Skipping unrecognized element '" + element + "' in keyboard layout resource from receiver " + receiver.packageName + "/" + receiver.name);
                }
            }
            finally {
                parser.close();
            }
        }
        catch (Exception ex) {
            Slog.w("InputManager", "Could not parse keyboard layout resource from receiver " + receiver.packageName + "/" + receiver.name, ex);
        }
    }

    private static LocaleList getLocalesFromLanguageTags(String languageTags) {
        if (TextUtils.isEmpty(languageTags)) {
            return LocaleList.getEmptyLocaleList();
        }
        return LocaleList.forLanguageTags(languageTags.replace('|', ','));
    }

    private String getLayoutDescriptor(InputDeviceIdentifier identifier) {
        if (identifier == null || identifier.getDescriptor() == null) {
            throw new IllegalArgumentException("identifier and descriptor must not be null");
        }
        if (identifier.getVendorId() == 0 && identifier.getProductId() == 0) {
            return identifier.getDescriptor();
        }
        StringBuilder bob = new StringBuilder();
        bob.append("vendor:").append(identifier.getVendorId());
        bob.append(",product:").append(identifier.getProductId());
        return bob.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) {
        String key = this.getLayoutDescriptor(identifier);
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            String layout2 = null;
            layout2 = this.mDataStore.getCurrentKeyboardLayout(key);
            if (layout2 == null && !key.equals(identifier.getDescriptor())) {
                layout2 = this.mDataStore.getCurrentKeyboardLayout(identifier.getDescriptor());
            }
            return layout2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (!this.checkCallingPermission("android.permission.SET_KEYBOARD_LAYOUT", "setCurrentKeyboardLayoutForInputDevice()")) {
            throw new SecurityException("Requires SET_KEYBOARD_LAYOUT permission");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        String key = this.getLayoutDescriptor(identifier);
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            try {
                if (this.mDataStore.setCurrentKeyboardLayout(key, keyboardLayoutDescriptor)) {
                    this.mHandler.sendEmptyMessage(3);
                }
            }
            finally {
                this.mDataStore.saveIfNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        String key = this.getLayoutDescriptor(identifier);
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            String[] layouts = this.mDataStore.getKeyboardLayouts(key);
            if (!(layouts != null && layouts.length != 0 || key.equals(identifier.getDescriptor()))) {
                layouts = this.mDataStore.getKeyboardLayouts(identifier.getDescriptor());
            }
            return layouts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (!this.checkCallingPermission("android.permission.SET_KEYBOARD_LAYOUT", "addKeyboardLayoutForInputDevice()")) {
            throw new SecurityException("Requires SET_KEYBOARD_LAYOUT permission");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        String key = this.getLayoutDescriptor(identifier);
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            try {
                String oldLayout = this.mDataStore.getCurrentKeyboardLayout(key);
                if (oldLayout == null && !key.equals(identifier.getDescriptor())) {
                    oldLayout = this.mDataStore.getCurrentKeyboardLayout(identifier.getDescriptor());
                }
                if (this.mDataStore.addKeyboardLayout(key, keyboardLayoutDescriptor) && !Objects.equals(oldLayout, this.mDataStore.getCurrentKeyboardLayout(key))) {
                    this.mHandler.sendEmptyMessage(3);
                }
            }
            finally {
                this.mDataStore.saveIfNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (!this.checkCallingPermission("android.permission.SET_KEYBOARD_LAYOUT", "removeKeyboardLayoutForInputDevice()")) {
            throw new SecurityException("Requires SET_KEYBOARD_LAYOUT permission");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        String key = this.getLayoutDescriptor(identifier);
        PersistentDataStore persistentDataStore = this.mDataStore;
        synchronized (persistentDataStore) {
            try {
                String oldLayout = this.mDataStore.getCurrentKeyboardLayout(key);
                if (oldLayout == null && !key.equals(identifier.getDescriptor())) {
                    oldLayout = this.mDataStore.getCurrentKeyboardLayout(identifier.getDescriptor());
                }
                boolean removed = this.mDataStore.removeKeyboardLayout(key, keyboardLayoutDescriptor);
                if (!key.equals(identifier.getDescriptor())) {
                    removed |= this.mDataStore.removeKeyboardLayout(identifier.getDescriptor(), keyboardLayoutDescriptor);
                }
                if (removed && !Objects.equals(oldLayout, this.mDataStore.getCurrentKeyboardLayout(key))) {
                    this.mHandler.sendEmptyMessage(3);
                }
            }
            finally {
                this.mDataStore.saveIfNeeded();
            }
        }
    }

    public void switchKeyboardLayout(int deviceId, int direction) {
        this.mHandler.obtainMessage(2, deviceId, direction).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSwitchKeyboardLayout(int deviceId, int direction) {
        InputDevice device = this.getInputDevice(deviceId);
        if (device != null) {
            String keyboardLayoutDescriptor;
            boolean changed;
            String key = this.getLayoutDescriptor(device.getIdentifier());
            PersistentDataStore persistentDataStore = this.mDataStore;
            synchronized (persistentDataStore) {
                try {
                    changed = this.mDataStore.switchKeyboardLayout(key, direction);
                    keyboardLayoutDescriptor = this.mDataStore.getCurrentKeyboardLayout(key);
                }
                finally {
                    this.mDataStore.saveIfNeeded();
                }
            }
            if (changed) {
                KeyboardLayout keyboardLayout;
                if (this.mSwitchedKeyboardLayoutToast != null) {
                    this.mSwitchedKeyboardLayoutToast.cancel();
                    this.mSwitchedKeyboardLayoutToast = null;
                }
                if (keyboardLayoutDescriptor != null && (keyboardLayout = this.getKeyboardLayout(keyboardLayoutDescriptor)) != null) {
                    this.mSwitchedKeyboardLayoutToast = Toast.makeText(this.mContext, keyboardLayout.getLabel(), 0);
                    this.mSwitchedKeyboardLayoutToast.show();
                }
                this.reloadKeyboardLayouts();
            }
        }
    }

    public void setFocusedApplication(int displayId, InputApplicationHandle application) {
        InputManagerService.nativeSetFocusedApplication(this.mPtr, displayId, application);
    }

    public void setFocusedDisplay(int displayId) {
        InputManagerService.nativeSetFocusedDisplay(this.mPtr, displayId);
    }

    public void onDisplayRemoved(int displayId) {
        InputManagerService.nativeSetInputWindows(this.mPtr, null, displayId);
    }

    @Override
    public void requestPointerCapture(IBinder windowToken, boolean enabled) {
        if (this.mFocusedWindow == null || this.mFocusedWindow.asBinder() != windowToken) {
            Slog.e(TAG, "requestPointerCapture called for a window that has no focus: " + windowToken);
            return;
        }
        if (this.mFocusedWindowHasCapture == enabled) {
            Slog.i(TAG, "requestPointerCapture: already " + (enabled ? "enabled" : "disabled"));
            return;
        }
        this.setPointerCapture(enabled);
    }

    private void setPointerCapture(boolean enabled) {
        if (this.mFocusedWindowHasCapture != enabled) {
            this.mFocusedWindowHasCapture = enabled;
            try {
                this.mFocusedWindow.dispatchPointerCaptureChanged(enabled);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            InputManagerService.nativeSetPointerCapture(this.mPtr, enabled);
        }
    }

    public void setInputDispatchMode(boolean enabled, boolean frozen) {
        InputManagerService.nativeSetInputDispatchMode(this.mPtr, enabled, frozen);
    }

    public void setSystemUiVisibility(int visibility) {
        InputManagerService.nativeSetSystemUiVisibility(this.mPtr, visibility);
    }

    @Override
    public void tryPointerSpeed(int speed) {
        if (!this.checkCallingPermission("android.permission.SET_POINTER_SPEED", "tryPointerSpeed()")) {
            throw new SecurityException("Requires SET_POINTER_SPEED permission");
        }
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        this.setPointerSpeedUnchecked(speed);
    }

    public void updatePointerSpeedFromSettings() {
        int speed = this.getPointerSpeedSetting();
        this.setPointerSpeedUnchecked(speed);
    }

    private void setPointerSpeedUnchecked(int speed) {
        speed = Math.min(Math.max(speed, -7), 7);
        InputManagerService.nativeSetPointerSpeed(this.mPtr, speed);
    }

    private void registerPointerSpeedSettingObserver() {
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("pointer_speed"), true, new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange) {
                InputManagerService.this.updatePointerSpeedFromSettings();
            }
        }, -1);
    }

    private int getPointerSpeedSetting() {
        int speed = 0;
        try {
            speed = Settings.System.getIntForUser(this.mContext.getContentResolver(), "pointer_speed", -2);
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return speed;
    }

    public void updateShowTouchesFromSettings() {
        int setting = this.getShowTouchesSetting(0);
        InputManagerService.nativeSetShowTouches(this.mPtr, setting != 0);
    }

    private void registerShowTouchesSettingObserver() {
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("show_touches"), true, new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange) {
                InputManagerService.this.updateShowTouchesFromSettings();
            }
        }, -1);
    }

    public void updateAccessibilityLargePointerFromSettings() {
        int accessibilityConfig = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_large_pointer_icon", 0, -2);
        PointerIcon.setUseLargeIcons(accessibilityConfig == 1);
        InputManagerService.nativeReloadPointerIcons(this.mPtr);
    }

    private void registerAccessibilityLargePointerSettingObserver() {
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_large_pointer_icon"), true, new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange) {
                InputManagerService.this.updateAccessibilityLargePointerFromSettings();
            }
        }, -1);
    }

    private int getShowTouchesSetting(int defaultValue) {
        int result = defaultValue;
        try {
            result = Settings.System.getIntForUser(this.mContext.getContentResolver(), "show_touches", -2);
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vibrate(int deviceId, long[] pattern, int repeat, IBinder token) {
        VibratorToken v;
        if (repeat >= pattern.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.mVibratorLock;
        synchronized (object) {
            v = this.mVibratorTokens.get(token);
            if (v == null) {
                v = new VibratorToken(deviceId, token, this.mNextVibratorTokenValue++);
                try {
                    token.linkToDeath(v, 0);
                }
                catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }
                this.mVibratorTokens.put(token, v);
            }
        }
        object = v;
        synchronized (object) {
            v.mVibrating = true;
            InputManagerService.nativeVibrate(this.mPtr, deviceId, pattern, repeat, v.mTokenValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVibrate(int deviceId, IBinder token) {
        Object object = this.mVibratorLock;
        synchronized (object) {
            VibratorToken v = this.mVibratorTokens.get(token);
            if (v == null || v.mDeviceId != deviceId) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
            this.cancelVibrateIfNeeded(v);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onVibratorTokenDied(VibratorToken v) {
        Object object = this.mVibratorLock;
        synchronized (object) {
            this.mVibratorTokens.remove(v.mToken);
        }
        this.cancelVibrateIfNeeded(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelVibrateIfNeeded(VibratorToken v) {
        VibratorToken vibratorToken = v;
        synchronized (vibratorToken) {
            if (v.mVibrating) {
                InputManagerService.nativeCancelVibrate(this.mPtr, v.mDeviceId, v.mTokenValue);
                v.mVibrating = false;
            }
        }
    }

    @Override
    public void setPointerIconType(int iconId) {
        InputManagerService.nativeSetPointerIconType(this.mPtr, iconId);
    }

    @Override
    public void setCustomPointerIcon(PointerIcon icon) {
        Preconditions.checkNotNull(icon);
        InputManagerService.nativeSetCustomPointerIcon(this.mPtr, icon);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("INPUT MANAGER (dumpsys input)\n");
        String dumpStr = InputManagerService.nativeDump(this.mPtr);
        if (dumpStr != null) {
            pw.println(dumpStr);
        }
    }

    private boolean checkCallingPermission(String permission2, String func) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        if (this.mContext.checkCallingPermission(permission2) == 0) {
            return true;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w(TAG, msg);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mInputFilterLock;
        synchronized (object) {
        }
        InputManagerService.nativeMonitor(this.mPtr);
    }

    private void notifyConfigurationChanged(long whenNanos) {
        this.mWindowManagerCallbacks.notifyConfigurationChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInputDevicesChanged(InputDevice[] inputDevices) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            if (!this.mInputDevicesChangedPending) {
                this.mInputDevicesChangedPending = true;
                this.mHandler.obtainMessage(1, this.mInputDevices).sendToTarget();
            }
            this.mInputDevices = inputDevices;
        }
    }

    private void notifySwitch(long whenNanos, int switchValues, int switchMask) {
        if ((switchMask & 1) != 0) {
            boolean lidOpen = (switchValues & 1) == 0;
            this.mWindowManagerCallbacks.notifyLidSwitchChanged(whenNanos, lidOpen);
        }
        if ((switchMask & 0x200) != 0) {
            boolean lensCovered = (switchValues & 0x200) != 0;
            this.mWindowManagerCallbacks.notifyCameraLensCoverSwitchChanged(whenNanos, lensCovered);
        }
        if (this.mUseDevInputEventForAudioJack && (switchMask & 0xD4) != 0) {
            this.mWiredAccessoryCallbacks.notifyWiredAccessoryChanged(whenNanos, switchValues, switchMask);
        }
        if ((switchMask & 2) != 0) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = (int)(whenNanos & 0xFFFFFFFFFFFFFFFFL);
            args.argi2 = (int)(whenNanos >> 32);
            args.arg1 = (switchValues & 2) != 0;
            this.mHandler.obtainMessage(6, args).sendToTarget();
        }
    }

    private void notifyInputChannelBroken(IBinder token) {
        this.mWindowManagerCallbacks.notifyInputChannelBroken(token);
    }

    private void notifyFocusChanged(IBinder oldToken, IBinder newToken) {
        if (this.mFocusedWindow != null) {
            if (this.mFocusedWindow.asBinder() == newToken) {
                Slog.w(TAG, "notifyFocusChanged called with unchanged mFocusedWindow=" + this.mFocusedWindow);
                return;
            }
            this.setPointerCapture(false);
        }
        this.mFocusedWindow = IWindow.Stub.asInterface(newToken);
    }

    private long notifyANR(IBinder token, String reason) {
        return this.mWindowManagerCallbacks.notifyANR(token, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean filterInputEvent(InputEvent event, int policyFlags) {
        Object object = this.mInputFilterLock;
        synchronized (object) {
            if (this.mInputFilter != null) {
                try {
                    this.mInputFilter.filterInputEvent(event, policyFlags);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
            event.recycle();
            return true;
        }
    }

    private int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags) {
        return this.mWindowManagerCallbacks.interceptKeyBeforeQueueing(event, policyFlags);
    }

    private int interceptMotionBeforeQueueingNonInteractive(int displayId, long whenNanos, int policyFlags) {
        return this.mWindowManagerCallbacks.interceptMotionBeforeQueueingNonInteractive(displayId, whenNanos, policyFlags);
    }

    private long interceptKeyBeforeDispatching(IBinder focus, KeyEvent event, int policyFlags) {
        return this.mWindowManagerCallbacks.interceptKeyBeforeDispatching(focus, event, policyFlags);
    }

    private KeyEvent dispatchUnhandledKey(IBinder focus, KeyEvent event, int policyFlags) {
        return this.mWindowManagerCallbacks.dispatchUnhandledKey(focus, event, policyFlags);
    }

    private boolean checkInjectEventsPermission(int injectorPid, int injectorUid) {
        return this.mContext.checkPermission("android.permission.INJECT_EVENTS", injectorPid, injectorUid) == 0;
    }

    private void onPointerDownOutsideFocus(IBinder touchedToken) {
        this.mWindowManagerCallbacks.onPointerDownOutsideFocus(touchedToken);
    }

    private int getVirtualKeyQuietTimeMillis() {
        return this.mContext.getResources().getInteger(17694906);
    }

    private static String[] getExcludedDeviceNames() {
        File[] baseDirs;
        ArrayList<String> names = new ArrayList<String>();
        for (File baseDir : baseDirs = new File[]{Environment.getRootDirectory(), Environment.getVendorDirectory()}) {
            File confFile = new File(baseDir, EXCLUDED_DEVICES_PATH);
            try {
                FileInputStream stream = new FileInputStream(confFile);
                names.addAll(ConfigurationProcessor.processExcludedDeviceNames(stream));
            }
            catch (FileNotFoundException stream) {
            }
            catch (Exception e) {
                Slog.e(TAG, "Could not parse '" + confFile.getAbsolutePath() + "'", e);
            }
        }
        return names.toArray(new String[0]);
    }

    private static <T> List<T> flatten(List<Pair<T, T>> pairs) {
        ArrayList<Object> list = new ArrayList<Object>(pairs.size() * 2);
        for (Pair<T, T> pair : pairs) {
            list.add(pair.first);
            list.add(pair.second);
        }
        return list;
    }

    private static String[] getInputPortAssociations() {
        File baseDir = Environment.getVendorDirectory();
        File confFile = new File(baseDir, PORT_ASSOCIATIONS_PATH);
        try {
            FileInputStream stream = new FileInputStream(confFile);
            List associations = ConfigurationProcessor.processInputPortAssociations(stream);
            List<String> associationList = InputManagerService.flatten(associations);
            return associationList.toArray(new String[0]);
        }
        catch (FileNotFoundException stream) {
        }
        catch (Exception e) {
            Slog.e(TAG, "Could not parse '" + confFile.getAbsolutePath() + "'", e);
        }
        return new String[0];
    }

    public boolean canDispatchToDisplay(int deviceId, int displayId) {
        return InputManagerService.nativeCanDispatchToDisplay(this.mPtr, deviceId, displayId);
    }

    private int getKeyRepeatTimeout() {
        return ViewConfiguration.getKeyRepeatTimeout();
    }

    private int getKeyRepeatDelay() {
        return ViewConfiguration.getKeyRepeatDelay();
    }

    private int getHoverTapTimeout() {
        return ViewConfiguration.getHoverTapTimeout();
    }

    private int getHoverTapSlop() {
        return ViewConfiguration.getHoverTapSlop();
    }

    private int getDoubleTapTimeout() {
        return ViewConfiguration.getDoubleTapTimeout();
    }

    private int getLongPressTimeout() {
        return ViewConfiguration.getLongPressTimeout();
    }

    private int getPointerLayer() {
        return this.mWindowManagerCallbacks.getPointerLayer();
    }

    private PointerIcon getPointerIcon(int displayId) {
        return PointerIcon.getDefaultIcon(this.getContextForDisplay(displayId));
    }

    private Context getContextForDisplay(int displayId) {
        if (this.mDisplayContext != null && this.mDisplayContext.getDisplay().getDisplayId() == displayId) {
            return this.mDisplayContext;
        }
        if (this.mContext.getDisplay().getDisplayId() == displayId) {
            this.mDisplayContext = this.mContext;
            return this.mDisplayContext;
        }
        DisplayManager displayManager = this.mContext.getSystemService(DisplayManager.class);
        Display display = displayManager.getDisplay(displayId);
        this.mDisplayContext = this.mContext.createDisplayContext(display);
        return this.mDisplayContext;
    }

    private int getPointerDisplayId() {
        return this.mWindowManagerCallbacks.getPointerDisplayId();
    }

    private String[] getKeyboardLayoutOverlay(InputDeviceIdentifier identifier) {
        if (!this.mSystemReady) {
            return null;
        }
        String keyboardLayoutDescriptor = this.getCurrentKeyboardLayoutForInputDevice(identifier);
        if (keyboardLayoutDescriptor == null) {
            return null;
        }
        final String[] result = new String[2];
        this.visitKeyboardLayout(keyboardLayoutDescriptor, new KeyboardLayoutVisitor(){

            @Override
            public void visitKeyboardLayout(Resources resources, int keyboardLayoutResId, KeyboardLayout layout2) {
                try {
                    result[0] = layout2.getDescriptor();
                    result[1] = Streams.readFully(new InputStreamReader(resources.openRawResource(keyboardLayoutResId)));
                }
                catch (IOException iOException) {
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        });
        if (result[0] == null) {
            Slog.w(TAG, "Could not get keyboard layout with descriptor '" + keyboardLayoutDescriptor + "'.");
            return null;
        }
        return result;
    }

    private String getDeviceAlias(String uniqueId) {
        if (BluetoothAdapter.checkBluetoothAddress(uniqueId)) {
            return null;
        }
        return null;
    }

    private final class LocalService
    extends InputManagerInternal {
        private LocalService() {
        }

        @Override
        public void setDisplayViewports(List<DisplayViewport> viewports) {
            InputManagerService.this.setDisplayViewportsInternal(viewports);
        }

        @Override
        public boolean injectInputEvent(InputEvent event, int mode) {
            return InputManagerService.this.injectInputEventInternal(event, mode);
        }

        @Override
        public void setInteractive(boolean interactive) {
            InputManagerService.nativeSetInteractive(InputManagerService.this.mPtr, interactive);
        }

        @Override
        public void toggleCapsLock(int deviceId) {
            InputManagerService.nativeToggleCapsLock(InputManagerService.this.mPtr, deviceId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPulseGestureEnabled(boolean enabled) {
            if (InputManagerService.this.mDoubleTouchGestureEnableFile != null) {
                FileWriter writer = null;
                try {
                    writer = new FileWriter(InputManagerService.this.mDoubleTouchGestureEnableFile);
                    writer.write(enabled ? "1" : "0");
                }
                catch (IOException e) {
                    try {
                        Log.wtf(InputManagerService.TAG, "Unable to setPulseGestureEnabled", e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(writer);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(writer);
                }
                IoUtils.closeQuietly(writer);
            }
        }
    }

    private final class VibratorToken
    implements IBinder.DeathRecipient {
        public final int mDeviceId;
        public final IBinder mToken;
        public final int mTokenValue;
        public boolean mVibrating;

        public VibratorToken(int deviceId, IBinder token, int tokenValue) {
            this.mDeviceId = deviceId;
            this.mToken = token;
            this.mTokenValue = tokenValue;
        }

        @Override
        public void binderDied() {
            InputManagerService.this.onVibratorTokenDied(this);
        }
    }

    private final class TabletModeChangedListenerRecord
    implements IBinder.DeathRecipient {
        private final int mPid;
        private final ITabletModeChangedListener mListener;

        public TabletModeChangedListenerRecord(int pid, ITabletModeChangedListener listener) {
            this.mPid = pid;
            this.mListener = listener;
        }

        @Override
        public void binderDied() {
            InputManagerService.this.onTabletModeChangedListenerDied(this.mPid);
        }

        public void notifyTabletModeChanged(long whenNanos, boolean inTabletMode) {
            try {
                this.mListener.onTabletModeChanged(whenNanos, inTabletMode);
            }
            catch (RemoteException ex) {
                Slog.w(InputManagerService.TAG, "Failed to notify process " + this.mPid + " that tablet mode changed, assuming it died.", ex);
                this.binderDied();
            }
        }
    }

    private final class InputDevicesChangedListenerRecord
    implements IBinder.DeathRecipient {
        private final int mPid;
        private final IInputDevicesChangedListener mListener;

        public InputDevicesChangedListenerRecord(int pid, IInputDevicesChangedListener listener) {
            this.mPid = pid;
            this.mListener = listener;
        }

        @Override
        public void binderDied() {
            InputManagerService.this.onInputDevicesChangedListenerDied(this.mPid);
        }

        public void notifyInputDevicesChanged(int[] info) {
            try {
                this.mListener.onInputDevicesChanged(info);
            }
            catch (RemoteException ex) {
                Slog.w(InputManagerService.TAG, "Failed to notify process " + this.mPid + " that input devices changed, assuming it died.", ex);
                this.binderDied();
            }
        }
    }

    private static interface KeyboardLayoutVisitor {
        public void visitKeyboardLayout(Resources var1, int var2, KeyboardLayout var3);
    }

    private static final class KeyboardLayoutDescriptor {
        public String packageName;
        public String receiverName;
        public String keyboardLayoutName;

        private KeyboardLayoutDescriptor() {
        }

        public static String format(String packageName, String receiverName, String keyboardName) {
            return packageName + "/" + receiverName + "/" + keyboardName;
        }

        public static KeyboardLayoutDescriptor parse(String descriptor) {
            int pos = descriptor.indexOf(47);
            if (pos < 0 || pos + 1 == descriptor.length()) {
                return null;
            }
            int pos2 = descriptor.indexOf(47, pos + 1);
            if (pos2 < pos + 2 || pos2 + 1 == descriptor.length()) {
                return null;
            }
            KeyboardLayoutDescriptor result = new KeyboardLayoutDescriptor();
            result.packageName = descriptor.substring(0, pos);
            result.receiverName = descriptor.substring(pos + 1, pos2);
            result.keyboardLayoutName = descriptor.substring(pos2 + 1);
            return result;
        }
    }

    private final class InputMonitorHost
    extends IInputMonitorHost.Stub {
        private final InputChannel mInputChannel;

        InputMonitorHost(InputChannel channel) {
            this.mInputChannel = channel;
        }

        @Override
        public void pilferPointers() {
            InputManagerService.nativePilferPointers(InputManagerService.this.mPtr, this.asBinder());
        }

        @Override
        public void dispose() {
            InputManagerService.nativeUnregisterInputChannel(InputManagerService.this.mPtr, this.mInputChannel);
            this.mInputChannel.dispose();
        }
    }

    private final class InputFilterHost
    extends IInputFilterHost.Stub {
        private boolean mDisconnected;

        private InputFilterHost() {
        }

        public void disconnectLocked() {
            this.mDisconnected = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendInputEvent(InputEvent event, int policyFlags) {
            if (event == null) {
                throw new IllegalArgumentException("event must not be null");
            }
            Object object = InputManagerService.this.mInputFilterLock;
            synchronized (object) {
                if (!this.mDisconnected) {
                    InputManagerService.nativeInjectInputEvent(InputManagerService.this.mPtr, event, 0, 0, 0, 0, policyFlags | 0x4000000);
                }
            }
        }
    }

    private final class InputManagerHandler
    extends Handler {
        public InputManagerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    InputManagerService.this.deliverInputDevicesChanged((InputDevice[])msg.obj);
                    break;
                }
                case 2: {
                    InputManagerService.this.handleSwitchKeyboardLayout(msg.arg1, msg.arg2);
                    break;
                }
                case 3: {
                    InputManagerService.this.reloadKeyboardLayouts();
                    break;
                }
                case 4: {
                    InputManagerService.this.updateKeyboardLayouts();
                    break;
                }
                case 5: {
                    InputManagerService.this.reloadDeviceAliases();
                    break;
                }
                case 6: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    long whenNanos = (long)args.argi1 & 0xFFFFFFFFL | (long)args.argi2 << 32;
                    boolean inTabletMode = (Boolean)args.arg1;
                    InputManagerService.this.deliverTabletModeChanged(whenNanos, inTabletMode);
                }
            }
        }
    }

    public static interface WiredAccessoryCallbacks {
        public void notifyWiredAccessoryChanged(long var1, int var3, int var4);

        public void systemReady();
    }

    public static interface WindowManagerCallbacks {
        public void notifyConfigurationChanged();

        public void notifyLidSwitchChanged(long var1, boolean var3);

        public void notifyCameraLensCoverSwitchChanged(long var1, boolean var3);

        public void notifyInputChannelBroken(IBinder var1);

        public long notifyANR(IBinder var1, String var2);

        public int interceptKeyBeforeQueueing(KeyEvent var1, int var2);

        public int interceptMotionBeforeQueueingNonInteractive(int var1, long var2, int var4);

        public long interceptKeyBeforeDispatching(IBinder var1, KeyEvent var2, int var3);

        public KeyEvent dispatchUnhandledKey(IBinder var1, KeyEvent var2, int var3);

        public int getPointerLayer();

        public int getPointerDisplayId();

        public void onPointerDownOutsideFocus(IBinder var1);
    }
}

