/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.input;

import android.hardware.input.TouchCalibration;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class PersistentDataStore {
    static final String TAG = "InputManager";
    private final HashMap<String, InputDeviceState> mInputDevices = new HashMap();
    private final AtomicFile mAtomicFile = new AtomicFile(new File("/data/system/input-manager-state.xml"), "input-state");
    private boolean mLoaded;
    private boolean mDirty;

    public void saveIfNeeded() {
        if (this.mDirty) {
            this.save();
            this.mDirty = false;
        }
    }

    public TouchCalibration getTouchCalibration(String inputDeviceDescriptor, int surfaceRotation) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, false);
        if (state == null) {
            return TouchCalibration.IDENTITY;
        }
        TouchCalibration cal = state.getTouchCalibration(surfaceRotation);
        if (cal == null) {
            return TouchCalibration.IDENTITY;
        }
        return cal;
    }

    public boolean setTouchCalibration(String inputDeviceDescriptor, int surfaceRotation, TouchCalibration calibration) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, true);
        if (state.setTouchCalibration(surfaceRotation, calibration)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public String getCurrentKeyboardLayout(String inputDeviceDescriptor) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, false);
        return state != null ? state.getCurrentKeyboardLayout() : null;
    }

    public boolean setCurrentKeyboardLayout(String inputDeviceDescriptor, String keyboardLayoutDescriptor) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, true);
        if (state.setCurrentKeyboardLayout(keyboardLayoutDescriptor)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public String[] getKeyboardLayouts(String inputDeviceDescriptor) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, false);
        if (state == null) {
            return ArrayUtils.emptyArray(String.class);
        }
        return state.getKeyboardLayouts();
    }

    public boolean addKeyboardLayout(String inputDeviceDescriptor, String keyboardLayoutDescriptor) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, true);
        if (state.addKeyboardLayout(keyboardLayoutDescriptor)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean removeKeyboardLayout(String inputDeviceDescriptor, String keyboardLayoutDescriptor) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, true);
        if (state.removeKeyboardLayout(keyboardLayoutDescriptor)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean switchKeyboardLayout(String inputDeviceDescriptor, int direction) {
        InputDeviceState state = this.getInputDeviceState(inputDeviceDescriptor, false);
        if (state != null && state.switchKeyboardLayout(direction)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean removeUninstalledKeyboardLayouts(Set<String> availableKeyboardLayouts) {
        boolean changed = false;
        for (InputDeviceState state : this.mInputDevices.values()) {
            if (!state.removeUninstalledKeyboardLayouts(availableKeyboardLayouts)) continue;
            changed = true;
        }
        if (changed) {
            this.setDirty();
            return true;
        }
        return false;
    }

    private InputDeviceState getInputDeviceState(String inputDeviceDescriptor, boolean createIfAbsent) {
        this.loadIfNeeded();
        InputDeviceState state = this.mInputDevices.get(inputDeviceDescriptor);
        if (state == null && createIfAbsent) {
            state = new InputDeviceState();
            this.mInputDevices.put(inputDeviceDescriptor, state);
            this.setDirty();
        }
        return state;
    }

    private void loadIfNeeded() {
        if (!this.mLoaded) {
            this.load();
            this.mLoaded = true;
        }
    }

    private void setDirty() {
        this.mDirty = true;
    }

    private void clearState() {
        this.mInputDevices.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        FileInputStream is;
        this.clearState();
        try {
            is = this.mAtomicFile.openRead();
        }
        catch (FileNotFoundException ex) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new BufferedInputStream(is), StandardCharsets.UTF_8.name());
            this.loadFromXml(parser);
        }
        catch (IOException ex) {
            Slog.w(TAG, "Failed to load input manager persistent store data.", ex);
            this.clearState();
        }
        catch (XmlPullParserException ex) {
            Slog.w(TAG, "Failed to load input manager persistent store data.", ex);
            this.clearState();
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        try {
            FileOutputStream os = this.mAtomicFile.startWrite();
            boolean success = false;
            try {
                FastXmlSerializer serializer = new FastXmlSerializer();
                serializer.setOutput(new BufferedOutputStream(os), StandardCharsets.UTF_8.name());
                this.saveToXml(serializer);
                serializer.flush();
                success = true;
            }
            finally {
                if (success) {
                    this.mAtomicFile.finishWrite(os);
                } else {
                    this.mAtomicFile.failWrite(os);
                }
            }
        }
        catch (IOException ex) {
            Slog.w(TAG, "Failed to save input manager persistent store data.", ex);
        }
    }

    private void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        XmlUtils.beginDocument(parser, "input-manager-state");
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!parser.getName().equals("input-devices")) continue;
            this.loadInputDevicesFromXml(parser);
        }
    }

    private void loadInputDevicesFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!parser.getName().equals("input-device")) continue;
            String descriptor = parser.getAttributeValue(null, "descriptor");
            if (descriptor == null) {
                throw new XmlPullParserException("Missing descriptor attribute on input-device.");
            }
            if (this.mInputDevices.containsKey(descriptor)) {
                throw new XmlPullParserException("Found duplicate input device.");
            }
            InputDeviceState state = new InputDeviceState();
            state.loadFromXml(parser);
            this.mInputDevices.put(descriptor, state);
        }
    }

    private void saveToXml(XmlSerializer serializer) throws IOException {
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startTag(null, "input-manager-state");
        serializer.startTag(null, "input-devices");
        for (Map.Entry<String, InputDeviceState> entry : this.mInputDevices.entrySet()) {
            String descriptor = entry.getKey();
            InputDeviceState state = entry.getValue();
            serializer.startTag(null, "input-device");
            serializer.attribute(null, "descriptor", descriptor);
            state.saveToXml(serializer);
            serializer.endTag(null, "input-device");
        }
        serializer.endTag(null, "input-devices");
        serializer.endTag(null, "input-manager-state");
        serializer.endDocument();
    }

    private static final class InputDeviceState {
        private static final String[] CALIBRATION_NAME = new String[]{"x_scale", "x_ymix", "x_offset", "y_xmix", "y_scale", "y_offset"};
        private TouchCalibration[] mTouchCalibration = new TouchCalibration[4];
        private String mCurrentKeyboardLayout;
        private ArrayList<String> mKeyboardLayouts = new ArrayList();

        private InputDeviceState() {
        }

        public TouchCalibration getTouchCalibration(int surfaceRotation) {
            try {
                return this.mTouchCalibration[surfaceRotation];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Slog.w(PersistentDataStore.TAG, "Cannot get touch calibration.", ex);
                return null;
            }
        }

        public boolean setTouchCalibration(int surfaceRotation, TouchCalibration calibration) {
            try {
                if (!calibration.equals(this.mTouchCalibration[surfaceRotation])) {
                    this.mTouchCalibration[surfaceRotation] = calibration;
                    return true;
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Slog.w(PersistentDataStore.TAG, "Cannot set touch calibration.", ex);
                return false;
            }
        }

        public String getCurrentKeyboardLayout() {
            return this.mCurrentKeyboardLayout;
        }

        public boolean setCurrentKeyboardLayout(String keyboardLayout) {
            if (Objects.equals(this.mCurrentKeyboardLayout, keyboardLayout)) {
                return false;
            }
            this.addKeyboardLayout(keyboardLayout);
            this.mCurrentKeyboardLayout = keyboardLayout;
            return true;
        }

        public String[] getKeyboardLayouts() {
            if (this.mKeyboardLayouts.isEmpty()) {
                return ArrayUtils.emptyArray(String.class);
            }
            return this.mKeyboardLayouts.toArray(new String[this.mKeyboardLayouts.size()]);
        }

        public boolean addKeyboardLayout(String keyboardLayout) {
            int index = Collections.binarySearch(this.mKeyboardLayouts, keyboardLayout);
            if (index >= 0) {
                return false;
            }
            this.mKeyboardLayouts.add(-index - 1, keyboardLayout);
            if (this.mCurrentKeyboardLayout == null) {
                this.mCurrentKeyboardLayout = keyboardLayout;
            }
            return true;
        }

        public boolean removeKeyboardLayout(String keyboardLayout) {
            int index = Collections.binarySearch(this.mKeyboardLayouts, keyboardLayout);
            if (index < 0) {
                return false;
            }
            this.mKeyboardLayouts.remove(index);
            this.updateCurrentKeyboardLayoutIfRemoved(keyboardLayout, index);
            return true;
        }

        private void updateCurrentKeyboardLayoutIfRemoved(String removedKeyboardLayout, int removedIndex) {
            if (Objects.equals(this.mCurrentKeyboardLayout, removedKeyboardLayout)) {
                if (!this.mKeyboardLayouts.isEmpty()) {
                    int index = removedIndex;
                    if (index == this.mKeyboardLayouts.size()) {
                        index = 0;
                    }
                    this.mCurrentKeyboardLayout = this.mKeyboardLayouts.get(index);
                } else {
                    this.mCurrentKeyboardLayout = null;
                }
            }
        }

        public boolean switchKeyboardLayout(int direction) {
            int size = this.mKeyboardLayouts.size();
            if (size < 2) {
                return false;
            }
            int index = Collections.binarySearch(this.mKeyboardLayouts, this.mCurrentKeyboardLayout);
            assert (index >= 0);
            index = direction > 0 ? (index + 1) % size : (index + size - 1) % size;
            this.mCurrentKeyboardLayout = this.mKeyboardLayouts.get(index);
            return true;
        }

        public boolean removeUninstalledKeyboardLayouts(Set<String> availableKeyboardLayouts) {
            boolean changed = false;
            int i = this.mKeyboardLayouts.size();
            while (i-- > 0) {
                String keyboardLayout = this.mKeyboardLayouts.get(i);
                if (availableKeyboardLayouts.contains(keyboardLayout)) continue;
                Slog.i(PersistentDataStore.TAG, "Removing uninstalled keyboard layout " + keyboardLayout);
                this.mKeyboardLayouts.remove(i);
                this.updateCurrentKeyboardLayoutIfRemoved(keyboardLayout, i);
                changed = true;
            }
            return changed;
        }

        public void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                if (parser.getName().equals("keyboard-layout")) {
                    String descriptor = parser.getAttributeValue(null, "descriptor");
                    if (descriptor == null) {
                        throw new XmlPullParserException("Missing descriptor attribute on keyboard-layout.");
                    }
                    String current = parser.getAttributeValue(null, "current");
                    if (this.mKeyboardLayouts.contains(descriptor)) {
                        throw new XmlPullParserException("Found duplicate keyboard layout.");
                    }
                    this.mKeyboardLayouts.add(descriptor);
                    if (current == null || !current.equals("true")) continue;
                    if (this.mCurrentKeyboardLayout != null) {
                        throw new XmlPullParserException("Found multiple current keyboard layouts.");
                    }
                    this.mCurrentKeyboardLayout = descriptor;
                    continue;
                }
                if (!parser.getName().equals("calibration")) continue;
                String format = parser.getAttributeValue(null, "format");
                String rotation = parser.getAttributeValue(null, "rotation");
                int r = -1;
                if (format == null) {
                    throw new XmlPullParserException("Missing format attribute on calibration.");
                }
                if (!format.equals("affine")) {
                    throw new XmlPullParserException("Unsupported format for calibration.");
                }
                if (rotation != null) {
                    try {
                        r = InputDeviceState.stringToSurfaceRotation(rotation);
                    }
                    catch (IllegalArgumentException e) {
                        throw new XmlPullParserException("Unsupported rotation for calibration.");
                    }
                }
                float[] matrix = TouchCalibration.IDENTITY.getAffineTransform();
                int depth = parser.getDepth();
                block3: while (XmlUtils.nextElementWithin(parser, depth)) {
                    String tag = parser.getName().toLowerCase();
                    String value = parser.nextText();
                    for (int i = 0; i < matrix.length && i < CALIBRATION_NAME.length; ++i) {
                        if (!tag.equals(CALIBRATION_NAME[i])) continue;
                        matrix[i] = Float.parseFloat(value);
                        continue block3;
                    }
                }
                if (r == -1) {
                    for (r = 0; r < this.mTouchCalibration.length; ++r) {
                        this.mTouchCalibration[r] = new TouchCalibration(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
                    }
                    continue;
                }
                this.mTouchCalibration[r] = new TouchCalibration(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
            }
            Collections.sort(this.mKeyboardLayouts);
            if (this.mCurrentKeyboardLayout == null && !this.mKeyboardLayouts.isEmpty()) {
                this.mCurrentKeyboardLayout = this.mKeyboardLayouts.get(0);
            }
        }

        public void saveToXml(XmlSerializer serializer) throws IOException {
            for (String layout2 : this.mKeyboardLayouts) {
                serializer.startTag(null, "keyboard-layout");
                serializer.attribute(null, "descriptor", layout2);
                if (layout2.equals(this.mCurrentKeyboardLayout)) {
                    serializer.attribute(null, "current", "true");
                }
                serializer.endTag(null, "keyboard-layout");
            }
            for (int i = 0; i < this.mTouchCalibration.length; ++i) {
                if (this.mTouchCalibration[i] == null) continue;
                String rotation = InputDeviceState.surfaceRotationToString(i);
                float[] transform = this.mTouchCalibration[i].getAffineTransform();
                serializer.startTag(null, "calibration");
                serializer.attribute(null, "format", "affine");
                serializer.attribute(null, "rotation", rotation);
                for (int j = 0; j < transform.length && j < CALIBRATION_NAME.length; ++j) {
                    serializer.startTag(null, CALIBRATION_NAME[j]);
                    serializer.text(Float.toString(transform[j]));
                    serializer.endTag(null, CALIBRATION_NAME[j]);
                }
                serializer.endTag(null, "calibration");
            }
        }

        private static String surfaceRotationToString(int surfaceRotation) {
            switch (surfaceRotation) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "90";
                }
                case 2: {
                    return "180";
                }
                case 3: {
                    return "270";
                }
            }
            throw new IllegalArgumentException("Unsupported surface rotation value" + surfaceRotation);
        }

        private static int stringToSurfaceRotation(String s) {
            if ("0".equals(s)) {
                return 0;
            }
            if ("90".equals(s)) {
                return 1;
            }
            if ("180".equals(s)) {
                return 2;
            }
            if ("270".equals(s)) {
                return 3;
            }
            throw new IllegalArgumentException("Unsupported surface rotation string '" + s + "'");
        }
    }
}

