/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.inputmethod;

import android.os.Environment;
import android.os.FileUtils;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.util.FastXmlSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

final class AdditionalSubtypeUtils {
    private static final String TAG = "AdditionalSubtypeUtils";
    private static final String SYSTEM_PATH = "system";
    private static final String INPUT_METHOD_PATH = "inputmethod";
    private static final String ADDITIONAL_SUBTYPES_FILE_NAME = "subtypes.xml";
    private static final String NODE_SUBTYPES = "subtypes";
    private static final String NODE_SUBTYPE = "subtype";
    private static final String NODE_IMI = "imi";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_IME_SUBTYPE_ID = "subtypeId";
    private static final String ATTR_IME_SUBTYPE_LOCALE = "imeSubtypeLocale";
    private static final String ATTR_IME_SUBTYPE_LANGUAGE_TAG = "languageTag";
    private static final String ATTR_IME_SUBTYPE_MODE = "imeSubtypeMode";
    private static final String ATTR_IME_SUBTYPE_EXTRA_VALUE = "imeSubtypeExtraValue";
    private static final String ATTR_IS_AUXILIARY = "isAuxiliary";
    private static final String ATTR_IS_ASCII_CAPABLE = "isAsciiCapable";

    private AdditionalSubtypeUtils() {
    }

    private static File getInputMethodDir(int userId) {
        File systemDir = userId == 0 ? new File(Environment.getDataDirectory(), SYSTEM_PATH) : Environment.getUserSystemDirectory(userId);
        return new File(systemDir, INPUT_METHOD_PATH);
    }

    private static AtomicFile getAdditionalSubtypeFile(File inputMethodDir) {
        File subtypeFile = new File(inputMethodDir, ADDITIONAL_SUBTYPES_FILE_NAME);
        return new AtomicFile(subtypeFile, "input-subtypes");
    }

    static void save(ArrayMap<String, List<InputMethodSubtype>> allSubtypes, ArrayMap<String, InputMethodInfo> methodMap, int userId) {
        block11: {
            File inputMethodDir = AdditionalSubtypeUtils.getInputMethodDir(userId);
            if (allSubtypes.isEmpty()) {
                if (!inputMethodDir.exists()) {
                    return;
                }
                AtomicFile subtypesFile = AdditionalSubtypeUtils.getAdditionalSubtypeFile(inputMethodDir);
                if (subtypesFile.exists()) {
                    subtypesFile.delete();
                }
                if (FileUtils.listFilesOrEmpty(inputMethodDir).length == 0 && !inputMethodDir.delete()) {
                    Slog.e(TAG, "Failed to delete the empty parent directory " + inputMethodDir);
                }
                return;
            }
            if (!inputMethodDir.exists() && !inputMethodDir.mkdirs()) {
                Slog.e(TAG, "Failed to create a parent directory " + inputMethodDir);
                return;
            }
            boolean isSetMethodMap = methodMap != null && methodMap.size() > 0;
            FileOutputStream fos = null;
            AtomicFile subtypesFile = AdditionalSubtypeUtils.getAdditionalSubtypeFile(inputMethodDir);
            try {
                fos = subtypesFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, NODE_SUBTYPES);
                for (String imiId : allSubtypes.keySet()) {
                    if (isSetMethodMap && !methodMap.containsKey(imiId)) {
                        Slog.w(TAG, "IME uninstalled or not valid.: " + imiId);
                        continue;
                    }
                    out.startTag(null, NODE_IMI);
                    out.attribute(null, ATTR_ID, imiId);
                    List<InputMethodSubtype> subtypesList = allSubtypes.get(imiId);
                    int numSubtypes = subtypesList.size();
                    for (int i = 0; i < numSubtypes; ++i) {
                        InputMethodSubtype subtype = subtypesList.get(i);
                        out.startTag(null, NODE_SUBTYPE);
                        if (subtype.hasSubtypeId()) {
                            out.attribute(null, ATTR_IME_SUBTYPE_ID, String.valueOf(subtype.getSubtypeId()));
                        }
                        out.attribute(null, ATTR_ICON, String.valueOf(subtype.getIconResId()));
                        out.attribute(null, ATTR_LABEL, String.valueOf(subtype.getNameResId()));
                        out.attribute(null, ATTR_IME_SUBTYPE_LOCALE, subtype.getLocale());
                        out.attribute(null, ATTR_IME_SUBTYPE_LANGUAGE_TAG, subtype.getLanguageTag());
                        out.attribute(null, ATTR_IME_SUBTYPE_MODE, subtype.getMode());
                        out.attribute(null, ATTR_IME_SUBTYPE_EXTRA_VALUE, subtype.getExtraValue());
                        out.attribute(null, ATTR_IS_AUXILIARY, String.valueOf(subtype.isAuxiliary() ? 1 : 0));
                        out.attribute(null, ATTR_IS_ASCII_CAPABLE, String.valueOf(subtype.isAsciiCapable() ? 1 : 0));
                        out.endTag(null, NODE_SUBTYPE);
                    }
                    out.endTag(null, NODE_IMI);
                }
                out.endTag(null, NODE_SUBTYPES);
                out.endDocument();
                subtypesFile.finishWrite(fos);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error writing subtypes", e);
                if (fos == null) break block11;
                subtypesFile.failWrite(fos);
            }
        }
    }

    static void load(ArrayMap<String, List<InputMethodSubtype>> allSubtypes, int userId) {
        allSubtypes.clear();
        AtomicFile subtypesFile = AdditionalSubtypeUtils.getAdditionalSubtypeFile(AdditionalSubtypeUtils.getInputMethodDir(userId));
        if (!subtypesFile.exists()) {
            return;
        }
        try (FileInputStream fis = subtypesFile.openRead();){
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            int type = parser.getEventType();
            while ((type = parser.next()) != 2 && type != 1) {
            }
            String firstNodeName = parser.getName();
            if (!NODE_SUBTYPES.equals(firstNodeName)) {
                throw new XmlPullParserException("Xml doesn't start with subtypes");
            }
            int depth = parser.getDepth();
            String currentImiId = null;
            ArrayList<InputMethodSubtype> tempSubtypesArray = null;
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                String nodeName = parser.getName();
                if (NODE_IMI.equals(nodeName)) {
                    currentImiId = parser.getAttributeValue(null, ATTR_ID);
                    if (TextUtils.isEmpty(currentImiId)) {
                        Slog.w(TAG, "Invalid imi id found in subtypes.xml");
                        continue;
                    }
                    tempSubtypesArray = new ArrayList<InputMethodSubtype>();
                    allSubtypes.put(currentImiId, tempSubtypesArray);
                    continue;
                }
                if (!NODE_SUBTYPE.equals(nodeName)) continue;
                if (TextUtils.isEmpty(currentImiId) || tempSubtypesArray == null) {
                    Slog.w(TAG, "IME uninstalled or not valid.: " + currentImiId);
                    continue;
                }
                int icon = Integer.parseInt(parser.getAttributeValue(null, ATTR_ICON));
                int label = Integer.parseInt(parser.getAttributeValue(null, ATTR_LABEL));
                String imeSubtypeLocale = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_LOCALE);
                String languageTag = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_LANGUAGE_TAG);
                String imeSubtypeMode = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_MODE);
                String imeSubtypeExtraValue = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_EXTRA_VALUE);
                boolean isAuxiliary = "1".equals(String.valueOf(parser.getAttributeValue(null, ATTR_IS_AUXILIARY)));
                boolean isAsciiCapable = "1".equals(String.valueOf(parser.getAttributeValue(null, ATTR_IS_ASCII_CAPABLE)));
                InputMethodSubtype.InputMethodSubtypeBuilder builder = new InputMethodSubtype.InputMethodSubtypeBuilder().setSubtypeNameResId(label).setSubtypeIconResId(icon).setSubtypeLocale(imeSubtypeLocale).setLanguageTag(languageTag).setSubtypeMode(imeSubtypeMode).setSubtypeExtraValue(imeSubtypeExtraValue).setIsAuxiliary(isAuxiliary).setIsAsciiCapable(isAsciiCapable);
                String subtypeIdString = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_ID);
                if (subtypeIdString != null) {
                    builder.setSubtypeId(Integer.parseInt(subtypeIdString));
                }
                tempSubtypesArray.add(builder.build());
            }
        }
        catch (IOException | NumberFormatException | XmlPullParserException e) {
            Slog.w(TAG, "Error reading subtypes", e);
        }
    }
}

