/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.inputmethod;

import android.app.UriGrantsManager;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IInputContentUriToken;
import com.android.server.LocalServices;
import com.android.server.uri.UriGrantsManagerInternal;

final class InputContentUriTokenHandler
extends IInputContentUriToken.Stub {
    private final Uri mUri;
    private final int mSourceUid;
    private final String mTargetPackage;
    private final int mSourceUserId;
    private final int mTargetUserId;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private IBinder mPermissionOwnerToken = null;

    InputContentUriTokenHandler(Uri contentUri, int sourceUid, String targetPackage, int sourceUserId, int targetUserId) {
        this.mUri = contentUri;
        this.mSourceUid = sourceUid;
        this.mTargetPackage = targetPackage;
        this.mSourceUserId = sourceUserId;
        this.mTargetUserId = targetUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void take() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPermissionOwnerToken != null) {
                return;
            }
            this.mPermissionOwnerToken = LocalServices.getService(UriGrantsManagerInternal.class).newUriPermissionOwner("InputContentUriTokenHandler");
            this.doTakeLocked(this.mPermissionOwnerToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTakeLocked(IBinder permissionOwner) {
        long origId = Binder.clearCallingIdentity();
        try {
            try {
                UriGrantsManager.getService().grantUriPermissionFromOwner(permissionOwner, this.mSourceUid, this.mTargetPackage, this.mUri, 1, this.mSourceUserId, this.mTargetUserId);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPermissionOwnerToken == null) {
                return;
            }
            try {
                LocalServices.getService(UriGrantsManagerInternal.class).revokeUriPermissionFromOwner(this.mPermissionOwnerToken, this.mUri, 1, this.mSourceUserId);
            }
            finally {
                this.mPermissionOwnerToken = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }
}

