/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.inputmethod;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.app.AlertDialog;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManagerInternal;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.LocaleList;
import android.os.Message;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.style.SuggestionSpan;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.LruCache;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.view.ContextThemeWrapper;
import android.view.DisplayInfo;
import android.view.IWindowManager;
import android.view.InputChannel;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.view.inputmethod.InputMethodSystemProperty;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.Switch;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.inputmethod.IInputContentUriToken;
import com.android.internal.inputmethod.IInputMethodPrivilegedOperations;
import com.android.internal.inputmethod.InputMethodDebug;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;
import com.android.internal.view.InputBindResult;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.inputmethod.AdditionalSubtypeUtils;
import com.android.server.inputmethod.InputContentUriTokenHandler;
import com.android.server.inputmethod.InputMethodManagerInternal;
import com.android.server.inputmethod.InputMethodSubtypeSwitchingController;
import com.android.server.inputmethod.InputMethodUtils;
import com.android.server.statusbar.StatusBarManagerService;
import com.android.server.wm.WindowManagerInternal;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class InputMethodManagerService
extends IInputMethodManager.Stub
implements ServiceConnection,
Handler.Callback {
    static final boolean DEBUG = false;
    static final String TAG = "InputMethodManagerService";
    static final int MSG_SHOW_IM_SUBTYPE_PICKER = 1;
    static final int MSG_SHOW_IM_SUBTYPE_ENABLER = 2;
    static final int MSG_SHOW_IM_CONFIG = 3;
    static final int MSG_UNBIND_INPUT = 1000;
    static final int MSG_BIND_INPUT = 1010;
    static final int MSG_SHOW_SOFT_INPUT = 1020;
    static final int MSG_HIDE_SOFT_INPUT = 1030;
    static final int MSG_HIDE_CURRENT_INPUT_METHOD = 1035;
    static final int MSG_INITIALIZE_IME = 1040;
    static final int MSG_CREATE_SESSION = 1050;
    static final int MSG_START_INPUT = 2000;
    static final int MSG_UNBIND_CLIENT = 3000;
    static final int MSG_BIND_CLIENT = 3010;
    static final int MSG_SET_ACTIVE = 3020;
    static final int MSG_SET_INTERACTIVE = 3030;
    static final int MSG_REPORT_FULLSCREEN_MODE = 3045;
    static final int MSG_REPORT_PRE_RENDERED = 3060;
    static final int MSG_APPLY_IME_VISIBILITY = 3070;
    static final int MSG_HARD_KEYBOARD_SWITCH_CHANGED = 4000;
    static final int MSG_SYSTEM_UNLOCK_USER = 5000;
    static final long TIME_TO_RECONNECT = 3000L;
    static final int SECURE_SUGGESTION_SPANS_MAX_SIZE = 20;
    private static final int NOT_A_SUBTYPE_ID = -1;
    private static final String TAG_TRY_SUPPRESSING_IME_SWITCHER = "TrySuppressingImeSwitcher";
    private static final int IME_CONNECTION_BIND_FLAGS = 1082130437;
    private static final int IME_VISIBLE_BIND_FLAGS = 738725889;
    private static final String ACTION_SHOW_INPUT_METHOD_PICKER = "com.android.server.inputmethod.InputMethodManagerService.SHOW_INPUT_METHOD_PICKER";
    private int mLastSwitchUserId;
    final Context mContext;
    final Resources mRes;
    final Handler mHandler;
    final InputMethodUtils.InputMethodSettings mSettings;
    final SettingsObserver mSettingsObserver;
    final IWindowManager mIWindowManager;
    final WindowManagerInternal mWindowManagerInternal;
    private final DisplayManagerInternal mDisplayManagerInternal;
    final HandlerCaller mCaller;
    final boolean mHasFeature;
    private final ArrayMap<String, List<InputMethodSubtype>> mAdditionalSubtypeMap = new ArrayMap();
    private final boolean mIsLowRam;
    private final HardKeyboardListener mHardKeyboardListener;
    private final AppOpsManager mAppOpsManager;
    private final UserManager mUserManager;
    private final UserManagerInternal mUserManagerInternal;
    final ArrayList<InputMethodInfo> mMethodList = new ArrayList();
    final ArrayMap<String, InputMethodInfo> mMethodMap = new ArrayMap();
    private final LruCache<SuggestionSpan, InputMethodInfo> mSecureSuggestionSpans = new LruCache(20);
    private final InputMethodSubtypeSwitchingController mSwitchingController;
    @GuardedBy(value={"mMethodMap"})
    private int mMethodMapUpdateCount = 0;
    final ServiceConnection mVisibleConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBindingDied(ComponentName name) {
            ArrayMap<String, InputMethodInfo> arrayMap = InputMethodManagerService.this.mMethodMap;
            synchronized (arrayMap) {
                if (InputMethodManagerService.this.mVisibleBound) {
                    InputMethodManagerService.this.mContext.unbindService(InputMethodManagerService.this.mVisibleConnection);
                    InputMethodManagerService.this.mVisibleBound = false;
                }
            }
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    };
    boolean mVisibleBound = false;
    private NotificationManager mNotificationManager;
    private KeyguardManager mKeyguardManager;
    private StatusBarManagerService mStatusBar;
    private Notification.Builder mImeSwitcherNotification;
    private PendingIntent mImeSwitchPendingIntent;
    private boolean mShowOngoingImeSwitcherForPhones;
    private boolean mNotificationShown;
    final ArrayMap<IBinder, ClientState> mClients = new ArrayMap();
    private SparseArray<ActivityViewInfo> mActivityViewDisplayIdToParentMap = new SparseArray();
    boolean mSystemReady;
    String mCurMethodId;
    int mCurSeq;
    ClientState mCurClient;
    IBinder mCurFocusedWindow;
    IBinder mLastImeTargetWindow;
    int mCurFocusedWindowSoftInputMode;
    ClientState mCurFocusedWindowClient;
    IInputContext mCurInputContext;
    int mCurInputContextMissingMethods;
    EditorInfo mCurAttribute;
    private Matrix mCurActivityViewToScreenMatrix = null;
    String mCurId;
    private InputMethodSubtype mCurrentSubtype;
    private boolean mCurClientInKeyguard;
    boolean mHaveConnection;
    boolean mShowRequested;
    boolean mShowExplicitlyRequested;
    boolean mShowForced;
    boolean mInputShown;
    boolean mInFullscreenMode;
    Intent mCurIntent;
    IBinder mCurToken;
    int mCurTokenDisplayId = -1;
    private static final int FALLBACK_DISPLAY_ID = 0;
    final ImeDisplayValidator mImeDisplayValidator;
    IInputMethod mCurMethod;
    long mLastBindTime;
    boolean mBoundToMethod;
    SessionState mEnabledSession;
    boolean mIsInteractive = true;
    int mBackDisposition = 0;
    int mImeWindowVis;
    private AlertDialog.Builder mDialogBuilder;
    private AlertDialog mSwitchingDialog;
    private IBinder mSwitchingDialogToken = new Binder();
    private View mSwitchingDialogTitleView;
    private InputMethodInfo[] mIms;
    private int[] mSubtypeIds;
    private LocaleList mLastSystemLocales;
    private boolean mShowImeWithHardKeyboard;
    private boolean mAccessibilityRequestingNoSoftKeyboard;
    private final MyPackageMonitor mMyPackageMonitor = new MyPackageMonitor();
    private final IPackageManager mIPackageManager;
    private final String mSlotIme;
    private final int mHardKeyboardBehavior;
    @GuardedBy(value={"mMethodMap"})
    private final WeakHashMap<IBinder, IBinder> mImeTargetWindowMap = new WeakHashMap();
    @GuardedBy(value={"mMethodMap"})
    private final StartInputHistory mStartInputHistory = new StartInputHistory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onActionLocaleChanged() {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            LocaleList possibleNewLocale = this.mRes.getConfiguration().getLocales();
            if (possibleNewLocale != null && possibleNewLocale.equals(this.mLastSystemLocales)) {
                return;
            }
            this.buildInputMethodListLocked(true);
            this.resetDefaultImeLocked(this.mContext);
            this.updateFromSettingsLocked(true);
            this.mLastSystemLocales = possibleNewLocale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUnlockUser(int userId) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            int currentUserId = this.mSettings.getCurrentUserId();
            if (userId != currentUserId) {
                return;
            }
            this.mSettings.switchCurrentUser(currentUserId, !this.mSystemReady);
            if (this.mSystemReady) {
                this.buildInputMethodListLocked(false);
                this.updateInputMethodsFromSettingsLocked(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSwitchUser(int userId) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            this.switchUserLocked(userId);
        }
    }

    public InputMethodManagerService(Context context) {
        this.mIPackageManager = AppGlobals.getPackageManager();
        this.mContext = context;
        this.mRes = context.getResources();
        this.mHandler = new Handler(this);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
        this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
        this.mImeDisplayValidator = displayId -> this.mWindowManagerInternal.shouldShowIme(displayId);
        this.mCaller = new HandlerCaller(context, null, new HandlerCaller.Callback(){

            @Override
            public void executeMessage(Message msg) {
                InputMethodManagerService.this.handleMessage(msg);
            }
        }, true);
        this.mAppOpsManager = this.mContext.getSystemService(AppOpsManager.class);
        this.mUserManager = this.mContext.getSystemService(UserManager.class);
        this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
        this.mHardKeyboardListener = new HardKeyboardListener();
        this.mHasFeature = context.getPackageManager().hasSystemFeature("android.software.input_methods");
        this.mSlotIme = this.mContext.getString(17041075);
        this.mHardKeyboardBehavior = this.mContext.getResources().getInteger(17694807);
        this.mIsLowRam = ActivityManager.isLowRamDeviceStatic();
        Bundle extras = new Bundle();
        extras.putBoolean("android.allowDuringSetup", true);
        int accentColor = this.mContext.getColor(17170460);
        this.mImeSwitcherNotification = new Notification.Builder(this.mContext, SystemNotificationChannels.VIRTUAL_KEYBOARD).setSmallIcon(17302737).setWhen(0L).setOngoing(true).addExtras(extras).setCategory("sys").setColor(accentColor);
        Intent intent = new Intent(ACTION_SHOW_INPUT_METHOD_PICKER).setPackage(this.mContext.getPackageName());
        this.mImeSwitchPendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.mShowOngoingImeSwitcherForPhones = false;
        this.mNotificationShown = false;
        int userId = 0;
        try {
            userId = ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Couldn't get current user ID; guessing it's 0", e);
        }
        this.mLastSwitchUserId = userId;
        this.mSettings = new InputMethodUtils.InputMethodSettings(this.mRes, context.getContentResolver(), this.mMethodMap, userId, !this.mSystemReady);
        this.updateCurrentProfileIds();
        AdditionalSubtypeUtils.load(this.mAdditionalSubtypeMap, userId);
        this.mSwitchingController = InputMethodSubtypeSwitchingController.createInstanceLocked(this.mSettings, context);
    }

    private void resetDefaultImeLocked(Context context) {
        if (this.mCurMethodId != null && !this.mMethodMap.get(this.mCurMethodId).isSystem()) {
            return;
        }
        ArrayList<InputMethodInfo> suitableImes = InputMethodUtils.getDefaultEnabledImes(context, this.mSettings.getEnabledInputMethodListLocked());
        if (suitableImes.isEmpty()) {
            Slog.i(TAG, "No default found");
            return;
        }
        InputMethodInfo defIm = (InputMethodInfo)suitableImes.get(0);
        this.setSelectedInputMethodAndSubtypeLocked(defIm, -1, false);
    }

    @GuardedBy(value={"mMethodMap"})
    private void switchUserLocked(int newUserId) {
        this.mSettingsObserver.registerContentObserverLocked(newUserId);
        boolean useCopyOnWriteSettings = !this.mSystemReady || !this.mUserManagerInternal.isUserUnlockingOrUnlocked(newUserId);
        this.mSettings.switchCurrentUser(newUserId, useCopyOnWriteSettings);
        this.updateCurrentProfileIds();
        AdditionalSubtypeUtils.load(this.mAdditionalSubtypeMap, newUserId);
        String defaultImiId = this.mSettings.getSelectedInputMethod();
        boolean initialUserSwitch = TextUtils.isEmpty(defaultImiId);
        this.mLastSystemLocales = this.mRes.getConfiguration().getLocales();
        if (this.mSystemReady) {
            this.hideCurrentInputLocked(0, null);
            this.resetCurrentMethodAndClient(6);
            this.buildInputMethodListLocked(initialUserSwitch);
            if (TextUtils.isEmpty(this.mSettings.getSelectedInputMethod())) {
                this.resetDefaultImeLocked(this.mContext);
            }
            this.updateFromSettingsLocked(true);
        }
        if (initialUserSwitch) {
            InputMethodUtils.setNonSelectedSystemImesDisabledUntilUsed(this.mIPackageManager, this.mSettings.getEnabledInputMethodListLocked(), newUserId, this.mContext.getBasePackageName());
        }
        this.mLastSwitchUserId = newUserId;
    }

    void updateCurrentProfileIds() {
        this.mSettings.setCurrentProfileIds(this.mUserManager.getProfileIdsWithDisabled(this.mSettings.getCurrentUserId()));
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Input Method Manager Crash", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemRunning(StatusBarManagerService statusBar) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.mSystemReady) {
                int currentUserId;
                this.mSystemReady = true;
                this.mLastSystemLocales = this.mRes.getConfiguration().getLocales();
                this.mSettings.switchCurrentUser(currentUserId, !this.mUserManagerInternal.isUserUnlockingOrUnlocked(currentUserId = this.mSettings.getCurrentUserId()));
                this.mKeyguardManager = this.mContext.getSystemService(KeyguardManager.class);
                this.mNotificationManager = this.mContext.getSystemService(NotificationManager.class);
                this.mStatusBar = statusBar;
                if (this.mStatusBar != null) {
                    this.mStatusBar.setIconVisibility(this.mSlotIme, false);
                }
                this.updateSystemUiLocked(this.mImeWindowVis, this.mBackDisposition);
                this.mShowOngoingImeSwitcherForPhones = this.mRes.getBoolean(0x111011D);
                if (this.mShowOngoingImeSwitcherForPhones) {
                    this.mWindowManagerInternal.setOnHardKeyboardStatusChangeListener(this.mHardKeyboardListener);
                }
                this.mMyPackageMonitor.register(this.mContext, null, UserHandle.ALL, true);
                this.mSettingsObserver.registerContentObserverLocked(currentUserId);
                IntentFilter broadcastFilterForSystemUser = new IntentFilter();
                broadcastFilterForSystemUser.addAction("android.intent.action.USER_ADDED");
                broadcastFilterForSystemUser.addAction("android.intent.action.USER_REMOVED");
                broadcastFilterForSystemUser.addAction("android.intent.action.LOCALE_CHANGED");
                broadcastFilterForSystemUser.addAction(ACTION_SHOW_INPUT_METHOD_PICKER);
                this.mContext.registerReceiver(new ImmsBroadcastReceiverForSystemUser(), broadcastFilterForSystemUser);
                IntentFilter broadcastFilterForAllUsers = new IntentFilter();
                broadcastFilterForAllUsers.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
                this.mContext.registerReceiverAsUser(new ImmsBroadcastReceiverForAllUsers(), UserHandle.ALL, broadcastFilterForAllUsers, null, null);
                String defaultImiId = this.mSettings.getSelectedInputMethod();
                boolean imeSelectedOnBoot = !TextUtils.isEmpty(defaultImiId);
                this.buildInputMethodListLocked(!imeSelectedOnBoot);
                this.updateFromSettingsLocked(true);
                InputMethodUtils.setNonSelectedSystemImesDisabledUntilUsed(this.mIPackageManager, this.mSettings.getEnabledInputMethodListLocked(), currentUserId, this.mContext.getBasePackageName());
            }
        }
    }

    @GuardedBy(value={"mMethodMap"})
    private boolean calledFromValidUserLocked() {
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(uid);
        if (uid == 1000) {
            return true;
        }
        if (userId == this.mSettings.getCurrentUserId()) {
            return true;
        }
        if (!InputMethodSystemProperty.PER_PROFILE_IME_ENABLED && this.mSettings.isCurrentProfile(userId)) {
            return true;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0) {
            return true;
        }
        Slog.w(TAG, "--- IPC called from background users. Ignore. callers=" + Debug.getCallers(10));
        return false;
    }

    @GuardedBy(value={"mMethodMap"})
    private boolean calledWithValidTokenLocked(IBinder token) {
        if (token == null) {
            throw new InvalidParameterException("token must not be null.");
        }
        if (token != this.mCurToken) {
            Slog.e(TAG, "Ignoring " + Debug.getCaller() + " due to an invalid token. uid:" + Binder.getCallingUid() + " token:" + token);
            return false;
        }
        return true;
    }

    @GuardedBy(value={"mMethodMap"})
    private boolean bindCurrentInputMethodServiceLocked(Intent service, ServiceConnection conn, int flags) {
        if (service == null || conn == null) {
            Slog.e(TAG, "--- bind failed: service = " + service + ", conn = " + conn);
            return false;
        }
        return this.mContext.bindServiceAsUser(service, conn, flags, new UserHandle(this.mSettings.getCurrentUserId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodInfo> getInputMethodList(int userId) {
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            List<InputMethodInfo> list;
            int[] resolvedUserIds = InputMethodUtils.resolveUserId(userId, this.mSettings.getCurrentUserId(), null);
            if (resolvedUserIds.length != 1) {
                return Collections.emptyList();
            }
            long ident = Binder.clearCallingIdentity();
            try {
                list = this.getInputMethodListLocked(resolvedUserIds[0]);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodInfo> getEnabledInputMethodList(int userId) {
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            List<InputMethodInfo> list;
            int[] resolvedUserIds = InputMethodUtils.resolveUserId(userId, this.mSettings.getCurrentUserId(), null);
            if (resolvedUserIds.length != 1) {
                return Collections.emptyList();
            }
            long ident = Binder.clearCallingIdentity();
            try {
                list = this.getEnabledInputMethodListLocked(resolvedUserIds[0]);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return list;
        }
    }

    @GuardedBy(value={"mMethodMap"})
    private List<InputMethodInfo> getInputMethodListLocked(int userId) {
        ArrayList<InputMethodInfo> methodList;
        if (userId == this.mSettings.getCurrentUserId()) {
            methodList = new ArrayList<InputMethodInfo>(this.mMethodList);
        } else {
            ArrayMap<String, InputMethodInfo> methodMap = new ArrayMap<String, InputMethodInfo>();
            methodList = new ArrayList();
            ArrayMap<String, List<InputMethodSubtype>> additionalSubtypeMap = new ArrayMap<String, List<InputMethodSubtype>>();
            AdditionalSubtypeUtils.load(additionalSubtypeMap, userId);
            InputMethodManagerService.queryInputMethodServicesInternal(this.mContext, userId, additionalSubtypeMap, methodMap, methodList);
        }
        return methodList;
    }

    @GuardedBy(value={"mMethodMap"})
    private List<InputMethodInfo> getEnabledInputMethodListLocked(int userId) {
        if (userId == this.mSettings.getCurrentUserId()) {
            return this.mSettings.getEnabledInputMethodListLocked();
        }
        ArrayMap<String, InputMethodInfo> methodMap = new ArrayMap<String, InputMethodInfo>();
        ArrayList<InputMethodInfo> methodList = new ArrayList<InputMethodInfo>();
        ArrayMap<String, List<InputMethodSubtype>> additionalSubtypeMap = new ArrayMap<String, List<InputMethodSubtype>>();
        AdditionalSubtypeUtils.load(additionalSubtypeMap, userId);
        InputMethodManagerService.queryInputMethodServicesInternal(this.mContext, userId, additionalSubtypeMap, methodMap, methodList);
        InputMethodUtils.InputMethodSettings settings = new InputMethodUtils.InputMethodSettings(this.mContext.getResources(), this.mContext.getContentResolver(), methodMap, userId, true);
        return settings.getEnabledInputMethodListLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlySelectedSubtypes) {
        int callingUserId = UserHandle.getCallingUserId();
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            List<InputMethodSubtype> list;
            int[] resolvedUserIds = InputMethodUtils.resolveUserId(callingUserId, this.mSettings.getCurrentUserId(), null);
            if (resolvedUserIds.length != 1) {
                return Collections.emptyList();
            }
            long ident = Binder.clearCallingIdentity();
            try {
                list = this.getEnabledInputMethodSubtypeListLocked(imiId, allowsImplicitlySelectedSubtypes, resolvedUserIds[0]);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return list;
        }
    }

    @GuardedBy(value={"mMethodMap"})
    private List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(String imiId, boolean allowsImplicitlySelectedSubtypes, int userId) {
        if (userId == this.mSettings.getCurrentUserId()) {
            InputMethodInfo imi = imiId == null && this.mCurMethodId != null ? this.mMethodMap.get(this.mCurMethodId) : this.mMethodMap.get(imiId);
            if (imi == null) {
                return Collections.emptyList();
            }
            return this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, allowsImplicitlySelectedSubtypes);
        }
        ArrayMap<String, InputMethodInfo> methodMap = new ArrayMap<String, InputMethodInfo>();
        ArrayList<InputMethodInfo> methodList = new ArrayList<InputMethodInfo>();
        ArrayMap<String, List<InputMethodSubtype>> additionalSubtypeMap = new ArrayMap<String, List<InputMethodSubtype>>();
        AdditionalSubtypeUtils.load(additionalSubtypeMap, userId);
        InputMethodManagerService.queryInputMethodServicesInternal(this.mContext, userId, additionalSubtypeMap, methodMap, methodList);
        InputMethodInfo imi = methodMap.get(imiId);
        if (imi == null) {
            return Collections.emptyList();
        }
        InputMethodUtils.InputMethodSettings settings = new InputMethodUtils.InputMethodSettings(this.mContext.getResources(), this.mContext.getContentResolver(), methodMap, userId, true);
        return settings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, allowsImplicitlySelectedSubtypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClient(IInputMethodClient client, IInputContext inputContext, int selfReportedDisplayId) {
        int callerUid = Binder.getCallingUid();
        int callerPid = Binder.getCallingPid();
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            int numClients = this.mClients.size();
            for (int i = 0; i < numClients; ++i) {
                ClientState state = this.mClients.valueAt(i);
                if (state.uid != callerUid || state.pid != callerPid || state.selfReportedDisplayId != selfReportedDisplayId) continue;
                throw new SecurityException("uid=" + callerUid + "/pid=" + callerPid + "/displayId=" + selfReportedDisplayId + " is already registered.");
            }
            ClientDeathRecipient deathRecipient = new ClientDeathRecipient(this, client);
            try {
                client.asBinder().linkToDeath(deathRecipient, 0);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
            this.mClients.put(client.asBinder(), new ClientState(client, inputContext, callerUid, callerPid, selfReportedDisplayId, deathRecipient));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(IInputMethodClient client) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            ClientState cs = this.mClients.remove(client.asBinder());
            if (cs != null) {
                client.asBinder().unlinkToDeath(cs.clientDeathRecipient, 0);
                this.clearClientSessionLocked(cs);
                int numItems = this.mActivityViewDisplayIdToParentMap.size();
                for (int i = numItems - 1; i >= 0; --i) {
                    ActivityViewInfo info = this.mActivityViewDisplayIdToParentMap.valueAt(i);
                    if (info.mParentClient != cs) continue;
                    this.mActivityViewDisplayIdToParentMap.removeAt(i);
                }
                if (this.mCurClient == cs) {
                    if (this.mBoundToMethod) {
                        this.mBoundToMethod = false;
                        if (this.mCurMethod != null) {
                            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageO(1000, this.mCurMethod));
                        }
                    }
                    this.mCurClient = null;
                    this.mCurActivityViewToScreenMatrix = null;
                }
                if (this.mCurFocusedWindowClient == cs) {
                    this.mCurFocusedWindowClient = null;
                }
            }
        }
    }

    void executeOrSendMessage(IInterface target, Message msg) {
        if (target.asBinder() instanceof Binder) {
            this.mCaller.sendMessage(msg);
        } else {
            this.handleMessage(msg);
            msg.recycle();
        }
    }

    void unbindCurrentClientLocked(int unbindClientReason) {
        if (this.mCurClient != null) {
            if (this.mBoundToMethod) {
                this.mBoundToMethod = false;
                if (this.mCurMethod != null) {
                    this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageO(1000, this.mCurMethod));
                }
            }
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIIO(3020, 0, 0, this.mCurClient));
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIIO(3000, this.mCurSeq, unbindClientReason, this.mCurClient.client));
            this.mCurClient.sessionRequested = false;
            this.mCurClient = null;
            this.mCurActivityViewToScreenMatrix = null;
            this.hideInputMethodMenuLocked();
        }
    }

    private int getImeShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 3;
        } else if (this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    private int getAppShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 2;
        } else if (!this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    @GuardedBy(value={"mMethodMap"})
    InputBindResult attachNewInputLocked(int startInputReason, boolean initial) {
        if (!this.mBoundToMethod) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1010, this.mCurMethod, this.mCurClient.binding));
            this.mBoundToMethod = true;
        }
        Binder startInputToken = new Binder();
        StartInputInfo info = new StartInputInfo(this.mSettings.getCurrentUserId(), this.mCurToken, this.mCurTokenDisplayId, this.mCurId, startInputReason, !initial, UserHandle.getUserId(this.mCurClient.uid), this.mCurClient.selfReportedDisplayId, this.mCurFocusedWindow, this.mCurAttribute, this.mCurFocusedWindowSoftInputMode, this.mCurSeq);
        this.mImeTargetWindowMap.put(startInputToken, this.mCurFocusedWindow);
        this.mStartInputHistory.addEntry(info);
        SessionState session = this.mCurClient.curSession;
        this.executeOrSendMessage(session.method, this.mCaller.obtainMessageIIOOOO(2000, this.mCurInputContextMissingMethods, initial ? 0 : 1, startInputToken, session, this.mCurInputContext, this.mCurAttribute));
        if (this.mShowRequested) {
            this.showCurrentInputLocked(this.getAppShowFlags(), null);
        }
        return new InputBindResult(0, session.session, session.channel != null ? session.channel.dup() : null, this.mCurId, this.mCurSeq, this.mCurActivityViewToScreenMatrix);
    }

    private Matrix getActivityViewToScreenMatrixLocked(int clientDisplayId, int imeDisplayId) {
        if (clientDisplayId == imeDisplayId) {
            return null;
        }
        int displayId = clientDisplayId;
        Matrix matrix = null;
        ActivityViewInfo info;
        while ((info = this.mActivityViewDisplayIdToParentMap.get(displayId)) != null) {
            if (matrix == null) {
                matrix = new Matrix(info.mMatrix);
            } else {
                matrix.postConcat(info.mMatrix);
            }
            if (((ActivityViewInfo)info).mParentClient.selfReportedDisplayId == imeDisplayId) {
                return matrix;
            }
            displayId = ((ActivityViewInfo)info).mParentClient.selfReportedDisplayId;
        }
        return null;
    }

    @GuardedBy(value={"mMethodMap"})
    InputBindResult startInputUncheckedLocked(ClientState cs, IInputContext inputContext, int missingMethods, EditorInfo attribute, int startInputFlags, int startInputReason) {
        InputMethodInfo info;
        if (this.mCurMethodId == null) {
            return InputBindResult.NO_IME;
        }
        if (!this.mSystemReady) {
            return new InputBindResult(7, null, null, this.mCurMethodId, this.mCurSeq, null);
        }
        if (!InputMethodUtils.checkIfPackageBelongsToUid(this.mAppOpsManager, cs.uid, attribute.packageName)) {
            Slog.e(TAG, "Rejecting this client as it reported an invalid package name. uid=" + cs.uid + " package=" + attribute.packageName);
            return InputBindResult.INVALID_PACKAGE_NAME;
        }
        if (!this.mWindowManagerInternal.isUidAllowedOnDisplay(cs.selfReportedDisplayId, cs.uid)) {
            return InputBindResult.INVALID_DISPLAY_ID;
        }
        int displayIdToShowIme = InputMethodManagerService.computeImeDisplayIdForTarget(cs.selfReportedDisplayId, this.mImeDisplayValidator);
        if (this.mCurClient != cs) {
            this.mCurClientInKeyguard = this.isKeyguardLocked();
            this.unbindCurrentClientLocked(1);
            if (this.mIsInteractive) {
                this.executeOrSendMessage(cs.client, this.mCaller.obtainMessageIO(3020, 1, cs));
            }
        }
        ++this.mCurSeq;
        if (this.mCurSeq <= 0) {
            this.mCurSeq = 1;
        }
        this.mCurClient = cs;
        this.mCurInputContext = inputContext;
        this.mCurActivityViewToScreenMatrix = this.getActivityViewToScreenMatrixLocked(cs.selfReportedDisplayId, displayIdToShowIme);
        if (cs.selfReportedDisplayId != displayIdToShowIme && this.mCurActivityViewToScreenMatrix == null) {
            missingMethods |= 8;
        }
        this.mCurInputContextMissingMethods = missingMethods;
        this.mCurAttribute = attribute;
        if (this.mCurId != null && this.mCurId.equals(this.mCurMethodId) && displayIdToShowIme == this.mCurTokenDisplayId) {
            if (cs.curSession != null) {
                return this.attachNewInputLocked(startInputReason, (startInputFlags & 8) != 0);
            }
            if (this.mHaveConnection) {
                if (this.mCurMethod != null) {
                    this.requestClientSessionLocked(cs);
                    return new InputBindResult(1, null, null, this.mCurId, this.mCurSeq, null);
                }
                if (SystemClock.uptimeMillis() < this.mLastBindTime + 3000L) {
                    return new InputBindResult(2, null, null, this.mCurId, this.mCurSeq, null);
                }
                EventLog.writeEvent(32000, this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 0);
            }
        }
        if ((info = this.mMethodMap.get(this.mCurMethodId)) == null) {
            throw new IllegalArgumentException("Unknown id: " + this.mCurMethodId);
        }
        this.unbindCurrentMethodLocked();
        this.mCurIntent = new Intent("android.view.InputMethod");
        this.mCurIntent.setComponent(info.getComponent());
        this.mCurIntent.putExtra("android.intent.extra.client_label", 17040135);
        this.mCurIntent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(this.mContext, 0, new Intent("android.settings.INPUT_METHOD_SETTINGS"), 0));
        if (this.bindCurrentInputMethodServiceLocked(this.mCurIntent, this, 1082130437)) {
            this.mLastBindTime = SystemClock.uptimeMillis();
            this.mHaveConnection = true;
            this.mCurId = info.getId();
            this.mCurToken = new Binder();
            this.mCurTokenDisplayId = displayIdToShowIme;
            try {
                this.mIWindowManager.addWindowToken(this.mCurToken, 2011, this.mCurTokenDisplayId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return new InputBindResult(2, null, null, this.mCurId, this.mCurSeq, null);
        }
        this.mCurIntent = null;
        Slog.w(TAG, "Failure connecting to input method service: " + this.mCurIntent);
        return InputBindResult.IME_NOT_CONNECTED;
    }

    static int computeImeDisplayIdForTarget(int displayId, ImeDisplayValidator checker) {
        if (displayId == 0 || displayId == -1) {
            return 0;
        }
        return checker.displayCanShowIme(displayId) ? displayId : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (this.mCurIntent != null && name.equals(this.mCurIntent.getComponent())) {
                this.mCurMethod = IInputMethod.Stub.asInterface(service);
                if (this.mCurToken == null) {
                    Slog.w(TAG, "Service connected without a token!");
                    this.unbindCurrentMethodLocked();
                    return;
                }
                this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageIOO(1040, this.mCurTokenDisplayId, this.mCurMethod, this.mCurToken));
                if (this.mCurClient != null) {
                    this.clearClientSessionLocked(this.mCurClient);
                    this.requestClientSessionLocked(this.mCurClient);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionCreated(IInputMethod method, IInputMethodSession session, InputChannel channel) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (this.mCurMethod != null && method != null && this.mCurMethod.asBinder() == method.asBinder() && this.mCurClient != null) {
                this.clearClientSessionLocked(this.mCurClient);
                this.mCurClient.curSession = new SessionState(this.mCurClient, method, session, channel);
                InputBindResult res = this.attachNewInputLocked(9, true);
                if (res.method != null) {
                    this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageOO(3010, this.mCurClient.client, res));
                }
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
            channel.dispose();
            return;
        }
    }

    void unbindCurrentMethodLocked() {
        if (this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        if (this.mHaveConnection) {
            this.mContext.unbindService(this);
            this.mHaveConnection = false;
        }
        if (this.mCurToken != null) {
            try {
                this.mIWindowManager.removeWindowToken(this.mCurToken, this.mCurTokenDisplayId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mImeWindowVis = 0;
            this.mBackDisposition = 0;
            this.updateSystemUiLocked(this.mImeWindowVis, this.mBackDisposition);
            this.mCurToken = null;
            this.mCurTokenDisplayId = -1;
        }
        this.mCurId = null;
        this.clearCurMethodLocked();
    }

    void resetCurrentMethodAndClient(int unbindClientReason) {
        this.mCurMethodId = null;
        this.unbindCurrentMethodLocked();
        this.unbindCurrentClientLocked(unbindClientReason);
    }

    void requestClientSessionLocked(ClientState cs) {
        if (!cs.sessionRequested) {
            InputChannel[] channels = InputChannel.openInputChannelPair(cs.toString());
            cs.sessionRequested = true;
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOOO(1050, this.mCurMethod, channels[1], new MethodCallback(this, this.mCurMethod, channels[0])));
        }
    }

    void clearClientSessionLocked(ClientState cs) {
        this.finishSessionLocked(cs.curSession);
        cs.curSession = null;
        cs.sessionRequested = false;
    }

    private void finishSessionLocked(SessionState sessionState) {
        if (sessionState != null) {
            if (sessionState.session != null) {
                try {
                    sessionState.session.finishSession();
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Session failed to close due to remote exception", e);
                    this.updateSystemUiLocked(0, this.mBackDisposition);
                }
                sessionState.session = null;
            }
            if (sessionState.channel != null) {
                sessionState.channel.dispose();
                sessionState.channel = null;
            }
        }
    }

    void clearCurMethodLocked() {
        if (this.mCurMethod != null) {
            int numClients = this.mClients.size();
            for (int i = 0; i < numClients; ++i) {
                this.clearClientSessionLocked(this.mClients.valueAt(i));
            }
            this.finishSessionLocked(this.mEnabledSession);
            this.mEnabledSession = null;
            this.mCurMethod = null;
        }
        if (this.mStatusBar != null) {
            this.mStatusBar.setIconVisibility(this.mSlotIme, false);
        }
        this.mInFullscreenMode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName name) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (this.mCurMethod != null && this.mCurIntent != null && name.equals(this.mCurIntent.getComponent())) {
                this.clearCurMethodLocked();
                this.mLastBindTime = SystemClock.uptimeMillis();
                this.mShowRequested = this.mInputShown;
                this.mInputShown = false;
                this.unbindCurrentClientLocked(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatusIcon(IBinder token, String packageName, int iconId) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            block12: {
                if (!this.calledWithValidTokenLocked(token)) {
                    return;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    if (iconId == 0) {
                        if (this.mStatusBar != null) {
                            this.mStatusBar.setIconVisibility(this.mSlotIme, false);
                        }
                        break block12;
                    }
                    if (packageName == null) break block12;
                    CharSequence contentDescription = null;
                    try {
                        PackageManager packageManager = this.mContext.getPackageManager();
                        contentDescription = packageManager.getApplicationLabel(this.mIPackageManager.getApplicationInfo(packageName, 0, this.mSettings.getCurrentUserId()));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (this.mStatusBar != null) {
                        this.mStatusBar.setIcon(this.mSlotIme, packageName, iconId, 0, contentDescription != null ? contentDescription.toString() : null);
                        this.mStatusBar.setIconVisibility(this.mSlotIme, true);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    private boolean shouldShowImeSwitcherLocked(int visibility) {
        ArrayList<InputMethodInfo> imis;
        int N;
        if (!this.mShowOngoingImeSwitcherForPhones) {
            return false;
        }
        if (this.mSwitchingDialog != null) {
            return false;
        }
        if (this.mWindowManagerInternal.isKeyguardShowingAndNotOccluded() && this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardSecure()) {
            return false;
        }
        if ((visibility & 1) == 0 || (visibility & 4) != 0) {
            return false;
        }
        if (this.mWindowManagerInternal.isHardKeyboardAvailable()) {
            if (this.mHardKeyboardBehavior == 0) {
                return true;
            }
        } else if ((visibility & 2) == 0) {
            return false;
        }
        if ((N = (imis = this.mSettings.getEnabledInputMethodListLocked()).size()) > 2) {
            return true;
        }
        if (N < 1) {
            return false;
        }
        int nonAuxCount = 0;
        int auxCount = 0;
        InputMethodSubtype nonAuxSubtype = null;
        InputMethodSubtype auxSubtype = null;
        for (int i = 0; i < N; ++i) {
            InputMethodInfo imi = (InputMethodInfo)imis.get(i);
            List<InputMethodSubtype> subtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
            int subtypeCount = subtypes.size();
            if (subtypeCount == 0) {
                ++nonAuxCount;
                continue;
            }
            for (int j = 0; j < subtypeCount; ++j) {
                InputMethodSubtype subtype = subtypes.get(j);
                if (!subtype.isAuxiliary()) {
                    ++nonAuxCount;
                    nonAuxSubtype = subtype;
                    continue;
                }
                ++auxCount;
                auxSubtype = subtype;
            }
        }
        if (nonAuxCount > 1 || auxCount > 1) {
            return true;
        }
        if (nonAuxCount == 1 && auxCount == 1) {
            return nonAuxSubtype == null || auxSubtype == null || !nonAuxSubtype.getLocale().equals(auxSubtype.getLocale()) && !auxSubtype.overridesImplicitlyEnabledSubtype() && !nonAuxSubtype.overridesImplicitlyEnabledSubtype() || !nonAuxSubtype.containsExtraValueKey(TAG_TRY_SUPPRESSING_IME_SWITCHER);
        }
        return false;
    }

    private boolean isKeyguardLocked() {
        return this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImeWindowStatus(IBinder token, int vis, int backDisposition) {
        boolean dismissImeOnBackKeyPressed;
        int topFocusedDisplayId = this.mWindowManagerInternal.getTopFocusedDisplayId();
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            if (this.mCurTokenDisplayId != topFocusedDisplayId && this.mCurTokenDisplayId != 0) {
                return;
            }
            this.mImeWindowVis = vis;
            this.mBackDisposition = backDisposition;
            this.updateSystemUiLocked(vis, backDisposition);
        }
        switch (backDisposition) {
            case 2: {
                dismissImeOnBackKeyPressed = true;
                break;
            }
            case 1: {
                dismissImeOnBackKeyPressed = false;
                break;
            }
            default: {
                dismissImeOnBackKeyPressed = (vis & 2) != 0;
            }
        }
        this.mWindowManagerInternal.updateInputMethodWindowStatus(token, (vis & 2) != 0, dismissImeOnBackKeyPressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportStartInput(IBinder token, IBinder startInputToken) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            IBinder targetWindow = this.mImeTargetWindowMap.get(startInputToken);
            if (targetWindow != null && this.mLastImeTargetWindow != targetWindow) {
                this.mWindowManagerInternal.updateInputMethodTargetWindow(token, targetWindow);
            }
            this.mLastImeTargetWindow = targetWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemUiLocked(int vis, int backDisposition) {
        block11: {
            if (this.mCurToken == null) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                InputMethodInfo imi;
                if (vis != 0 && this.isKeyguardLocked() && !this.mCurClientInKeyguard) {
                    vis = 0;
                }
                boolean needsToShowImeSwitcher = this.shouldShowImeSwitcherLocked(vis);
                if (this.mStatusBar != null) {
                    this.mStatusBar.setImeWindowStatus(this.mCurTokenDisplayId, this.mCurToken, vis, backDisposition, needsToShowImeSwitcher);
                }
                if ((imi = this.mMethodMap.get(this.mCurMethodId)) != null && needsToShowImeSwitcher) {
                    CharSequence title = this.mRes.getText(17040981);
                    CharSequence summary = InputMethodUtils.getImeAndSubtypeDisplayName(this.mContext, imi, this.mCurrentSubtype);
                    this.mImeSwitcherNotification.setContentTitle(title).setContentText(summary).setContentIntent(this.mImeSwitchPendingIntent);
                    try {
                        if (this.mNotificationManager != null && !this.mIWindowManager.hasNavigationBar(0)) {
                            this.mNotificationManager.notifyAsUser(null, 8, this.mImeSwitcherNotification.build(), UserHandle.ALL);
                            this.mNotificationShown = true;
                        }
                        break block11;
                    }
                    catch (RemoteException remoteException) {}
                    break block11;
                }
                if (this.mNotificationShown && this.mNotificationManager != null) {
                    this.mNotificationManager.cancelAsUser(null, 8, UserHandle.ALL);
                    this.mNotificationShown = false;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    void updateFromSettingsLocked(boolean enabledMayChange) {
        this.updateInputMethodsFromSettingsLocked(enabledMayChange);
        this.updateKeyboardFromSettingsLocked();
    }

    void updateInputMethodsFromSettingsLocked(boolean enabledMayChange) {
        String id2;
        if (enabledMayChange) {
            ArrayList<InputMethodInfo> enabled = this.mSettings.getEnabledInputMethodListLocked();
            for (int i = 0; i < enabled.size(); ++i) {
                InputMethodInfo imm = (InputMethodInfo)enabled.get(i);
                try {
                    ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(imm.getPackageName(), 32768, this.mSettings.getCurrentUserId());
                    if (ai == null || ai.enabledSetting != 4) continue;
                    this.mIPackageManager.setApplicationEnabledSetting(imm.getPackageName(), 0, 1, this.mSettings.getCurrentUserId(), this.mContext.getBasePackageName());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (TextUtils.isEmpty(id2 = this.mSettings.getSelectedInputMethod()) && this.chooseNewDefaultIMELocked()) {
            id2 = this.mSettings.getSelectedInputMethod();
        }
        if (!TextUtils.isEmpty(id2)) {
            try {
                this.setInputMethodLocked(id2, this.mSettings.getSelectedInputMethodSubtypeId(id2));
            }
            catch (IllegalArgumentException e) {
                Slog.w(TAG, "Unknown input method from prefs: " + id2, e);
                this.resetCurrentMethodAndClient(5);
            }
        } else {
            this.resetCurrentMethodAndClient(4);
        }
        this.mSwitchingController.resetCircularListLocked(this.mContext);
    }

    public void updateKeyboardFromSettingsLocked() {
        this.mShowImeWithHardKeyboard = this.mSettings.isShowImeWithHardKeyboardEnabled();
        if (this.mSwitchingDialog != null && this.mSwitchingDialogTitleView != null && this.mSwitchingDialog.isShowing()) {
            Switch hardKeySwitch = (Switch)this.mSwitchingDialogTitleView.findViewById(16908973);
            hardKeySwitch.setChecked(this.mShowImeWithHardKeyboard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputMethodLocked(String id2, int subtypeId) {
        InputMethodInfo info = this.mMethodMap.get(id2);
        if (info == null) {
            throw new IllegalArgumentException("Unknown id: " + id2);
        }
        if (id2.equals(this.mCurMethodId)) {
            int subtypeCount = info.getSubtypeCount();
            if (subtypeCount <= 0) {
                return;
            }
            InputMethodSubtype oldSubtype = this.mCurrentSubtype;
            InputMethodSubtype newSubtype = subtypeId >= 0 && subtypeId < subtypeCount ? info.getSubtypeAt(subtypeId) : this.getCurrentInputMethodSubtypeLocked();
            if (newSubtype == null || oldSubtype == null) {
                Slog.w(TAG, "Illegal subtype state: old subtype = " + oldSubtype + ", new subtype = " + newSubtype);
                return;
            }
            if (newSubtype != oldSubtype) {
                this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, true);
                if (this.mCurMethod != null) {
                    try {
                        this.updateSystemUiLocked(this.mImeWindowVis, this.mBackDisposition);
                        this.mCurMethod.changeInputMethodSubtype(newSubtype);
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "Failed to call changeInputMethodSubtype");
                    }
                }
            }
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, false);
            this.mCurMethodId = id2;
            if (LocalServices.getService(ActivityManagerInternal.class).isSystemReady()) {
                Intent intent = new Intent("android.intent.action.INPUT_METHOD_CHANGED");
                intent.addFlags(0x20000000);
                intent.putExtra("input_method_id", id2);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.CURRENT);
            }
            this.unbindCurrentClientLocked(2);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean showSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        int uid = Binder.getCallingUid();
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledFromValidUserLocked()) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                    ClientState cs = this.mClients.get(client.asBinder());
                    if (cs == null) {
                        throw new IllegalArgumentException("unknown client " + client.asBinder());
                    }
                    if (!this.mWindowManagerInternal.isInputMethodClientFocus(cs.uid, cs.pid, cs.selfReportedDisplayId)) {
                        Slog.w(TAG, "Ignoring showSoftInput of uid " + uid + ": " + client);
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = this.showCurrentInputLocked(flags, resultReceiver);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    @GuardedBy(value={"mMethodMap"})
    boolean showCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        this.mShowRequested = true;
        if (this.mAccessibilityRequestingNoSoftKeyboard) {
            return false;
        }
        if ((flags & 2) != 0) {
            this.mShowExplicitlyRequested = true;
            this.mShowForced = true;
        } else if ((flags & 1) == 0) {
            this.mShowExplicitlyRequested = true;
        }
        if (!this.mSystemReady) {
            return false;
        }
        boolean res = false;
        if (this.mCurMethod != null) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageIOO(1020, this.getImeShowFlags(), this.mCurMethod, resultReceiver));
            this.mInputShown = true;
            if (this.mHaveConnection && !this.mVisibleBound) {
                this.bindCurrentInputMethodServiceLocked(this.mCurIntent, this.mVisibleConnection, 738725889);
                this.mVisibleBound = true;
            }
            res = true;
        } else if (this.mHaveConnection && SystemClock.uptimeMillis() >= this.mLastBindTime + 3000L) {
            EventLog.writeEvent(32000, this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 1);
            Slog.w(TAG, "Force disconnect/connect to the IME in showCurrentInputLocked()");
            this.mContext.unbindService(this);
            this.bindCurrentInputMethodServiceLocked(this.mCurIntent, this, 1082130437);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hideSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        int uid = Binder.getCallingUid();
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledFromValidUserLocked()) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                    ClientState cs = this.mClients.get(client.asBinder());
                    if (cs == null) {
                        throw new IllegalArgumentException("unknown client " + client.asBinder());
                    }
                    if (!this.mWindowManagerInternal.isInputMethodClientFocus(cs.uid, cs.pid, cs.selfReportedDisplayId)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = this.hideCurrentInputLocked(flags, resultReceiver);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    boolean hideCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        boolean res;
        boolean shouldHideSoftInput;
        if ((flags & 1) != 0 && (this.mShowExplicitlyRequested || this.mShowForced)) {
            return false;
        }
        if (this.mShowForced && (flags & 2) != 0) {
            return false;
        }
        boolean bl = shouldHideSoftInput = this.mCurMethod != null && (this.mInputShown || (this.mImeWindowVis & 1) != 0);
        if (shouldHideSoftInput) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1030, this.mCurMethod, resultReceiver));
            res = true;
        } else {
            res = false;
        }
        if (this.mHaveConnection && this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        this.mInputShown = false;
        this.mShowRequested = false;
        this.mShowExplicitlyRequested = false;
        this.mShowForced = false;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo attribute, IInputContext inputContext, int missingMethods, int unverifiedTargetSdkVersion) {
        InputBindResult result;
        int userId;
        if (windowToken == null) {
            Slog.e(TAG, "windowToken cannot be null.");
            return InputBindResult.NULL;
        }
        int callingUserId = UserHandle.getCallingUserId();
        if (attribute != null && attribute.targetInputMethodUser != null && attribute.targetInputMethodUser.getIdentifier() != callingUserId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "Using EditorInfo.targetInputMethodUser requires INTERACT_ACROSS_USERS_FULL.");
            userId = attribute.targetInputMethodUser.getIdentifier();
            if (!this.mUserManagerInternal.isUserRunning(userId)) {
                Slog.e(TAG, "User #" + userId + " is not running.");
                return InputBindResult.INVALID_USER;
            }
        } else {
            userId = callingUserId;
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            long ident = Binder.clearCallingIdentity();
            try {
                result = this.startInputOrWindowGainedFocusInternalLocked(startInputReason, client, windowToken, startInputFlags, softInputMode, windowFlags, attribute, inputContext, missingMethods, unverifiedTargetSdkVersion, userId);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        if (result == null) {
            Slog.wtf(TAG, "InputBindResult is @NonNull. startInputReason=" + InputMethodDebug.startInputReasonToString(startInputReason) + " windowFlags=#" + Integer.toHexString(windowFlags) + " editorInfo=" + attribute);
            return InputBindResult.NULL;
        }
        return result;
    }

    private InputBindResult startInputOrWindowGainedFocusInternalLocked(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo attribute, IInputContext inputContext, int missingMethods, int unverifiedTargetSdkVersion, int userId) {
        int windowDisplayId = this.mWindowManagerInternal.getDisplayIdForWindow(windowToken);
        ClientState cs = this.mClients.get(client.asBinder());
        if (cs == null) {
            throw new IllegalArgumentException("unknown client " + client.asBinder());
        }
        if (cs.selfReportedDisplayId != windowDisplayId) {
            Slog.e(TAG, "startInputOrWindowGainedFocusInternal: display ID mismatch. from client:" + cs.selfReportedDisplayId + " from window:" + windowDisplayId);
            return InputBindResult.DISPLAY_ID_MISMATCH;
        }
        if (!this.mWindowManagerInternal.isInputMethodClientFocus(cs.uid, cs.pid, cs.selfReportedDisplayId)) {
            return InputBindResult.NOT_IME_TARGET_WINDOW;
        }
        if (!this.mSettings.isCurrentProfile(userId)) {
            Slog.w(TAG, "A background user is requesting window. Hiding IME.");
            Slog.w(TAG, "If you need to impersonate a foreground user/profile from a background user, use EditorInfo.targetInputMethodUser with INTERACT_ACROSS_USERS_FULL permission.");
            this.hideCurrentInputLocked(0, null);
            return InputBindResult.INVALID_USER;
        }
        if (InputMethodSystemProperty.PER_PROFILE_IME_ENABLED && userId != this.mSettings.getCurrentUserId()) {
            this.switchUserLocked(userId);
        }
        boolean bl = cs.shouldPreRenderIme = DebugFlags.FLAG_PRE_RENDER_IME_VIEWS.value() && !this.mIsLowRam;
        if (this.mCurFocusedWindow == windowToken) {
            if (attribute != null) {
                return this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, startInputFlags, startInputReason);
            }
            return new InputBindResult(3, null, null, null, -1, null);
        }
        this.mCurFocusedWindow = windowToken;
        this.mCurFocusedWindowSoftInputMode = softInputMode;
        this.mCurFocusedWindowClient = cs;
        boolean doAutoShow = (softInputMode & 0xF0) == 16 || this.mRes.getConfiguration().isLayoutSizeAtLeast(3);
        boolean isTextEditor = (startInputFlags & 2) != 0;
        boolean didStart = false;
        InputBindResult res = null;
        switch (softInputMode & 0xF) {
            case 0: {
                if (!isTextEditor || !doAutoShow) {
                    if (!WindowManager.LayoutParams.mayUseInputMethod(windowFlags)) break;
                    this.hideCurrentInputLocked(2, null);
                    if (cs.selfReportedDisplayId == this.mCurTokenDisplayId) break;
                    this.unbindCurrentMethodLocked();
                    break;
                }
                if (!isTextEditor || !doAutoShow || (softInputMode & 0x100) == 0) break;
                if (attribute != null) {
                    res = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, startInputFlags, startInputReason);
                    didStart = true;
                }
                this.showCurrentInputLocked(1, null);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if ((softInputMode & 0x100) == 0) break;
                this.hideCurrentInputLocked(0, null);
                break;
            }
            case 3: {
                this.hideCurrentInputLocked(0, null);
                break;
            }
            case 4: {
                if ((softInputMode & 0x100) == 0) break;
                if (InputMethodUtils.isSoftInputModeStateVisibleAllowed(unverifiedTargetSdkVersion, startInputFlags)) {
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, startInputFlags, startInputReason);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
                Slog.e(TAG, "SOFT_INPUT_STATE_VISIBLE is ignored because there is no focused view that also returns true from View#onCheckIsTextEditor()");
                break;
            }
            case 5: {
                if (InputMethodUtils.isSoftInputModeStateVisibleAllowed(unverifiedTargetSdkVersion, startInputFlags)) {
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, startInputFlags, startInputReason);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
                Slog.e(TAG, "SOFT_INPUT_STATE_ALWAYS_VISIBLE is ignored because there is no focused view that also returns true from View#onCheckIsTextEditor()");
            }
        }
        if (!didStart) {
            res = attribute != null ? (!DebugFlags.FLAG_OPTIMIZE_START_INPUT.value() || (startInputFlags & 2) != 0 ? this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, startInputFlags, startInputReason) : InputBindResult.NO_EDITOR) : InputBindResult.NULL_EDITOR_INFO;
        }
        return res;
    }

    private boolean canShowInputMethodPickerLocked(IInputMethodClient client) {
        int uid = Binder.getCallingUid();
        if (this.mCurFocusedWindowClient != null && client != null && this.mCurFocusedWindowClient.client.asBinder() == client.asBinder()) {
            return true;
        }
        return this.mCurIntent != null && InputMethodUtils.checkIfPackageBelongsToUid(this.mAppOpsManager, uid, this.mCurIntent.getComponent().getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledFromValidUserLocked()) {
                return;
            }
            if (!this.canShowInputMethodPickerLocked(client)) {
                Slog.w(TAG, "Ignoring showInputMethodPickerFromClient of uid " + Binder.getCallingUid() + ": " + client);
                return;
            }
            this.mHandler.sendMessage(this.mCaller.obtainMessageII(1, auxiliarySubtypeMode, this.mCurClient != null ? this.mCurClient.selfReportedDisplayId : 0));
        }
    }

    @Override
    public void showInputMethodPickerFromSystem(IInputMethodClient client, int auxiliarySubtypeMode, int displayId) {
        if (this.mContext.checkCallingPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("showInputMethodPickerFromSystem requires WRITE_SECURE_SETTINGS permission");
        }
        this.mHandler.sendMessage(this.mCaller.obtainMessageII(1, auxiliarySubtypeMode, displayId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInputMethodPickerShownForTest() {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (this.mSwitchingDialog == null) {
                return false;
            }
            return this.mSwitchingDialog.isShowing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputMethod(IBinder token, String id2) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            this.setInputMethodWithSubtypeIdLocked(token, id2, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputMethodAndSubtype(IBinder token, String id2, InputMethodSubtype subtype) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            if (subtype != null) {
                this.setInputMethodWithSubtypeIdLocked(token, id2, InputMethodUtils.getSubtypeIdFromHashCode(this.mMethodMap.get(id2), subtype.hashCode()));
            } else {
                this.setInputMethod(token, id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient client, String inputMethodId) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledFromValidUserLocked()) {
                return;
            }
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageO(2, inputMethodId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToPreviousInputMethod(IBinder token) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            ArrayList<InputMethodInfo> enabled;
            if (!this.calledWithValidTokenLocked(token)) {
                return false;
            }
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            InputMethodInfo lastImi = lastIme != null ? this.mMethodMap.get(lastIme.first) : null;
            String targetLastImiId = null;
            int subtypeId = -1;
            if (lastIme != null && lastImi != null) {
                int currentSubtypeHash;
                boolean imiIdIsSame = lastImi.getId().equals(this.mCurMethodId);
                int lastSubtypeHash = Integer.parseInt((String)lastIme.second);
                int n = currentSubtypeHash = this.mCurrentSubtype == null ? -1 : this.mCurrentSubtype.hashCode();
                if (!imiIdIsSame || lastSubtypeHash != currentSubtypeHash) {
                    targetLastImiId = (String)lastIme.first;
                    subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                }
            }
            if (TextUtils.isEmpty(targetLastImiId) && !InputMethodUtils.canAddToLastInputMethod(this.mCurrentSubtype) && (enabled = this.mSettings.getEnabledInputMethodListLocked()) != null) {
                int N = enabled.size();
                String locale = this.mCurrentSubtype == null ? this.mRes.getConfiguration().locale.toString() : this.mCurrentSubtype.getLocale();
                for (int i = 0; i < N; ++i) {
                    InputMethodSubtype keyboardSubtype;
                    InputMethodInfo imi = (InputMethodInfo)enabled.get(i);
                    if (imi.getSubtypeCount() <= 0 || !imi.isSystem() || (keyboardSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, InputMethodUtils.getSubtypes(imi), "keyboard", locale, true)) == null) continue;
                    targetLastImiId = imi.getId();
                    subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi, keyboardSubtype.hashCode());
                    if (keyboardSubtype.getLocale().equals(locale)) break;
                }
            }
            if (!TextUtils.isEmpty(targetLastImiId)) {
                this.setInputMethodWithSubtypeIdLocked(token, targetLastImiId, subtypeId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToNextInputMethod(IBinder token, boolean onlyCurrentIme) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return false;
            }
            InputMethodSubtypeSwitchingController.ImeSubtypeListItem nextSubtype = this.mSwitchingController.getNextInputMethodLocked(onlyCurrentIme, this.mMethodMap.get(this.mCurMethodId), this.mCurrentSubtype);
            if (nextSubtype == null) {
                return false;
            }
            this.setInputMethodWithSubtypeIdLocked(token, nextSubtype.mImi.getId(), nextSubtype.mSubtypeId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldOfferSwitchingToNextInputMethod(IBinder token) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return false;
            }
            InputMethodSubtypeSwitchingController.ImeSubtypeListItem nextSubtype = this.mSwitchingController.getNextInputMethodLocked(false, this.mMethodMap.get(this.mCurMethodId), this.mCurrentSubtype);
            return nextSubtype != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputMethodSubtype getLastInputMethodSubtype() {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledFromValidUserLocked()) {
                return null;
            }
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            if (lastIme == null || TextUtils.isEmpty((CharSequence)lastIme.first) || TextUtils.isEmpty((CharSequence)lastIme.second)) {
                return null;
            }
            InputMethodInfo lastImi = this.mMethodMap.get(lastIme.first);
            if (lastImi == null) {
                return null;
            }
            try {
                int lastSubtypeHash = Integer.parseInt((String)lastIme.second);
                int lastSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                if (lastSubtypeId < 0 || lastSubtypeId >= lastImi.getSubtypeCount()) {
                    return null;
                }
                return lastImi.getSubtypeAt(lastSubtypeId);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
        if (TextUtils.isEmpty(imiId) || subtypes == null) {
            return;
        }
        ArrayList<InputMethodSubtype> toBeAdded = new ArrayList<InputMethodSubtype>();
        for (InputMethodSubtype subtype : subtypes) {
            if (!toBeAdded.contains(subtype)) {
                toBeAdded.add(subtype);
                continue;
            }
            Slog.w(TAG, "Duplicated subtype definition found: " + subtype.getLocale() + ", " + subtype.getMode());
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            String[] packageInfos;
            if (!this.calledFromValidUserLocked()) {
                return;
            }
            if (!this.mSystemReady) {
                return;
            }
            InputMethodInfo imi = this.mMethodMap.get(imiId);
            if (imi == null) {
                return;
            }
            try {
                packageInfos = this.mIPackageManager.getPackagesForUid(Binder.getCallingUid());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to get package infos");
                return;
            }
            if (packageInfos != null) {
                int packageNum = packageInfos.length;
                for (int i = 0; i < packageNum; ++i) {
                    if (!packageInfos[i].equals(imi.getPackageName())) continue;
                    if (subtypes.length > 0) {
                        this.mAdditionalSubtypeMap.put(imi.getId(), toBeAdded);
                    } else {
                        this.mAdditionalSubtypeMap.remove(imi.getId());
                    }
                    AdditionalSubtypeUtils.save(this.mAdditionalSubtypeMap, this.mMethodMap, this.mSettings.getCurrentUserId());
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.buildInputMethodListLocked(false);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public int getInputMethodWindowVisibleHeight() {
        return this.mWindowManagerInternal.getInputMethodWindowVisibleHeight(this.mCurTokenDisplayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportActivityView(IInputMethodClient parentClient, int childDisplayId, float[] matrixValues) {
        DisplayInfo displayInfo = this.mDisplayManagerInternal.getDisplayInfo(childDisplayId);
        if (displayInfo == null) {
            throw new IllegalArgumentException("Cannot find display for non-existent displayId: " + childDisplayId);
        }
        int callingUid = Binder.getCallingUid();
        if (callingUid != displayInfo.ownerUid) {
            throw new SecurityException("The caller doesn't own the display.");
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            ClientState cs = this.mClients.get(parentClient.asBinder());
            if (cs == null) {
                return;
            }
            if (matrixValues == null) {
                ActivityViewInfo info = this.mActivityViewDisplayIdToParentMap.get(childDisplayId);
                if (info == null) {
                    return;
                }
                if (info.mParentClient != cs) {
                    throw new SecurityException("Only the owner client can clear ActivityViewGeometry for display #" + childDisplayId);
                }
                this.mActivityViewDisplayIdToParentMap.remove(childDisplayId);
                return;
            }
            ActivityViewInfo info = this.mActivityViewDisplayIdToParentMap.get(childDisplayId);
            if (info != null && info.mParentClient != cs) {
                throw new InvalidParameterException("Display #" + childDisplayId + " is already registered by " + info.mParentClient);
            }
            if (info == null) {
                if (!this.mWindowManagerInternal.isUidAllowedOnDisplay(childDisplayId, cs.uid)) {
                    throw new SecurityException(cs + " cannot access to display #" + childDisplayId);
                }
                info = new ActivityViewInfo(cs, new Matrix());
                this.mActivityViewDisplayIdToParentMap.put(childDisplayId, info);
            }
            info.mMatrix.setValues(matrixValues);
            if (this.mCurClient == null || this.mCurClient.curSession == null) {
                return;
            }
            Matrix matrix = null;
            int displayId = this.mCurClient.selfReportedDisplayId;
            boolean needToNotify = false;
            while (true) {
                needToNotify |= displayId == childDisplayId;
                ActivityViewInfo next = this.mActivityViewDisplayIdToParentMap.get(displayId);
                if (next == null) break;
                if (matrix == null) {
                    matrix = new Matrix(next.mMatrix);
                } else {
                    matrix.postConcat(next.mMatrix);
                }
                if (((ActivityViewInfo)next).mParentClient.selfReportedDisplayId == this.mCurTokenDisplayId) {
                    if (!needToNotify) break;
                    float[] values = new float[9];
                    matrix.getValues(values);
                    try {
                        this.mCurClient.client.updateActivityViewToScreenMatrix(this.mCurSeq, values);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                displayId = ((ActivityViewInfo)info).mParentClient.selfReportedDisplayId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUserAction(IBinder token) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (this.mCurToken != token) {
                return;
            }
            InputMethodInfo imi = this.mMethodMap.get(this.mCurMethodId);
            if (imi != null) {
                this.mSwitchingController.onUserActionLocked(imi, this.mCurrentSubtype);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportPreRendered(IBinder token, EditorInfo info) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            if (this.mCurClient != null && this.mCurClient.client != null) {
                this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageOO(3060, info, this.mCurClient));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyImeVisibility(IBinder token, boolean setVisible) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            if (this.mCurClient != null && this.mCurClient.client != null) {
                this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3070, setVisible ? 1 : 0, this.mCurClient));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputMethodWithSubtypeIdLocked(IBinder token, String id2, int subtypeId) {
        if (token == null) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Using null token requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
        } else if (this.mCurToken != token) {
            Slog.w(TAG, "Ignoring setInputMethod of uid " + Binder.getCallingUid() + " token: " + token);
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.setInputMethodLocked(id2, subtypeId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideMySoftInput(IBinder token, int flags) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.hideCurrentInputLocked(flags, null);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMySoftInput(IBinder token, int flags) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.showCurrentInputLocked(flags, null);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    void setEnabledSessionInMainThread(SessionState session) {
        if (this.mEnabledSession != session) {
            if (this.mEnabledSession != null && this.mEnabledSession.session != null) {
                try {
                    this.mEnabledSession.method.setSessionEnabled(this.mEnabledSession.session, false);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mEnabledSession = session;
            if (this.mEnabledSession != null && this.mEnabledSession.session != null) {
                try {
                    this.mEnabledSession.method.setSessionEnabled(this.mEnabledSession.session, true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                boolean showAuxSubtypes;
                int displayId = msg.arg2;
                switch (msg.arg1) {
                    case 0: {
                        showAuxSubtypes = this.mInputShown;
                        break;
                    }
                    case 1: {
                        showAuxSubtypes = true;
                        break;
                    }
                    case 2: {
                        showAuxSubtypes = false;
                        break;
                    }
                    default: {
                        Slog.e(TAG, "Unknown subtype picker mode = " + msg.arg1);
                        return false;
                    }
                }
                this.showInputMethodMenu(showAuxSubtypes, displayId);
                return true;
            }
            case 2: {
                this.showInputMethodAndSubtypeEnabler((String)msg.obj);
                return true;
            }
            case 3: {
                this.showConfigureInputMethods();
                return true;
            }
            case 1000: {
                try {
                    ((IInputMethod)msg.obj).unbindInput();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return true;
            }
            case 1010: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).bindInput((InputBinding)args.arg2);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1020: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).showSoftInput(msg.arg1, (ResultReceiver)args.arg2);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1030: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).hideSoftInput(0, (ResultReceiver)args.arg2);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1035: {
                ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
                synchronized (arrayMap) {
                    this.hideCurrentInputLocked(0, null);
                }
                return true;
            }
            case 1040: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    IBinder token = (IBinder)args.arg2;
                    ((IInputMethod)args.arg1).initializeInternal(token, msg.arg1, new InputMethodPrivilegedOperationsImpl(this, token));
                }
                catch (RemoteException token) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1050: {
                SomeArgs args = (SomeArgs)msg.obj;
                IInputMethod method = (IInputMethod)args.arg1;
                InputChannel channel = (InputChannel)args.arg2;
                try {
                    method.createSession(channel, (IInputSessionCallback)args.arg3);
                }
                catch (RemoteException remoteException) {
                }
                finally {
                    if (channel != null && Binder.isProxy(method)) {
                        channel.dispose();
                    }
                }
                args.recycle();
                return true;
            }
            case 2000: {
                int missingMethods = msg.arg1;
                boolean restarting = msg.arg2 != 0;
                SomeArgs args = (SomeArgs)msg.obj;
                IBinder startInputToken = (IBinder)args.arg1;
                SessionState session = (SessionState)args.arg2;
                IInputContext inputContext = (IInputContext)args.arg3;
                EditorInfo editorInfo = (EditorInfo)args.arg4;
                try {
                    this.setEnabledSessionInMainThread(session);
                    session.method.startInput(startInputToken, inputContext, missingMethods, editorInfo, restarting, session.client.shouldPreRenderIme);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 3000: {
                try {
                    ((IInputMethodClient)msg.obj).onUnbindMethod(msg.arg1, msg.arg2);
                }
                catch (RemoteException missingMethods) {
                    // empty catch block
                }
                return true;
            }
            case 3010: {
                SomeArgs args = (SomeArgs)msg.obj;
                IInputMethodClient client = (IInputMethodClient)args.arg1;
                InputBindResult res = (InputBindResult)args.arg2;
                try {
                    client.onBindMethod(res);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Client died receiving input method " + args.arg2);
                }
                finally {
                    if (res.channel != null && Binder.isProxy(client)) {
                        res.channel.dispose();
                    }
                }
                args.recycle();
                return true;
            }
            case 3020: {
                try {
                    ((ClientState)msg.obj).client.setActive(msg.arg1 != 0, msg.arg2 != 0);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Got RemoteException sending setActive(false) notification to pid " + ((ClientState)msg.obj).pid + " uid " + ((ClientState)msg.obj).uid);
                }
                return true;
            }
            case 3030: {
                this.handleSetInteractive(msg.arg1 != 0);
                return true;
            }
            case 3045: {
                boolean fullscreen = msg.arg1 != 0;
                ClientState clientState = (ClientState)msg.obj;
                try {
                    clientState.client.reportFullscreenMode(fullscreen);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Got RemoteException sending reportFullscreen(" + fullscreen + ") notification to pid=" + clientState.pid + " uid=" + clientState.uid);
                }
                return true;
            }
            case 3060: {
                SomeArgs args = (SomeArgs)msg.obj;
                EditorInfo info = (EditorInfo)args.arg1;
                ClientState clientState = (ClientState)args.arg2;
                try {
                    clientState.client.reportPreRendered(info);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Got RemoteException sending reportPreRendered(" + info + ") notification to pid=" + clientState.pid + " uid=" + clientState.uid);
                }
                args.recycle();
                return true;
            }
            case 3070: {
                boolean setVisible = msg.arg1 != 0;
                ClientState clientState = (ClientState)msg.obj;
                try {
                    clientState.client.applyImeVisibility(setVisible);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Got RemoteException sending applyImeVisibility(" + setVisible + ") notification to pid=" + clientState.pid + " uid=" + clientState.uid);
                }
                return true;
            }
            case 4000: {
                this.mHardKeyboardListener.handleHardKeyboardStatusChange(msg.arg1 == 1);
                return true;
            }
            case 5000: {
                int userId = msg.arg1;
                this.onUnlockUser(userId);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetInteractive(boolean interactive) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            this.mIsInteractive = interactive;
            this.updateSystemUiLocked(interactive ? this.mImeWindowVis : 0, this.mBackDisposition);
            if (this.mCurClient != null && this.mCurClient.client != null) {
                this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIIO(3020, this.mIsInteractive ? 1 : 0, this.mInFullscreenMode ? 1 : 0, this.mCurClient));
            }
        }
    }

    private boolean chooseNewDefaultIMELocked() {
        InputMethodInfo imi = InputMethodUtils.getMostApplicableDefaultIME(this.mSettings.getEnabledInputMethodListLocked());
        if (imi != null) {
            this.resetSelectedInputMethodAndSubtypeLocked(imi.getId());
            return true;
        }
        return false;
    }

    static void queryInputMethodServicesInternal(Context context, int userId, ArrayMap<String, List<InputMethodSubtype>> additionalSubtypeMap, ArrayMap<String, InputMethodInfo> methodMap, ArrayList<InputMethodInfo> methodList) {
        methodList.clear();
        methodMap.clear();
        List<ResolveInfo> services = context.getPackageManager().queryIntentServicesAsUser(new Intent("android.view.InputMethod"), 32896, userId);
        methodList.ensureCapacity(services.size());
        methodMap.ensureCapacity(services.size());
        for (int i = 0; i < services.size(); ++i) {
            ResolveInfo ri = services.get(i);
            ServiceInfo si = ri.serviceInfo;
            String imeId = InputMethodInfo.computeId(ri);
            if (!"android.permission.BIND_INPUT_METHOD".equals(si.permission)) {
                Slog.w(TAG, "Skipping input method " + imeId + ": it does not require the permission " + "android.permission.BIND_INPUT_METHOD");
                continue;
            }
            try {
                InputMethodInfo imi = new InputMethodInfo(context, ri, additionalSubtypeMap.get(imeId));
                if (imi.isVrOnly()) continue;
                methodList.add(imi);
                methodMap.put(imi.getId(), imi);
                continue;
            }
            catch (Exception e) {
                Slog.wtf(TAG, "Unable to load input method " + imeId, e);
            }
        }
    }

    @GuardedBy(value={"mMethodMap"})
    void buildInputMethodListLocked(boolean resetDefaultEnabledIme) {
        String defaultImiId;
        if (!this.mSystemReady) {
            Slog.e(TAG, "buildInputMethodListLocked is not allowed until system is ready");
            return;
        }
        ++this.mMethodMapUpdateCount;
        this.mMyPackageMonitor.clearKnownImePackageNamesLocked();
        InputMethodManagerService.queryInputMethodServicesInternal(this.mContext, this.mSettings.getCurrentUserId(), this.mAdditionalSubtypeMap, this.mMethodMap, this.mMethodList);
        List<ResolveInfo> allInputMethodServices = this.mContext.getPackageManager().queryIntentServicesAsUser(new Intent("android.view.InputMethod"), 512, this.mSettings.getCurrentUserId());
        int N = allInputMethodServices.size();
        for (int i = 0; i < N; ++i) {
            ServiceInfo si = allInputMethodServices.get((int)i).serviceInfo;
            if (!"android.permission.BIND_INPUT_METHOD".equals(si.permission)) continue;
            this.mMyPackageMonitor.addKnownImePackageNameLocked(si.packageName);
        }
        boolean reenableMinimumNonAuxSystemImes = false;
        if (!resetDefaultEnabledIme) {
            boolean enabledImeFound = false;
            boolean enabledNonAuxImeFound = false;
            ArrayList<InputMethodInfo> enabledImes = this.mSettings.getEnabledInputMethodListLocked();
            int N2 = enabledImes.size();
            for (int i = 0; i < N2; ++i) {
                InputMethodInfo imi = (InputMethodInfo)enabledImes.get(i);
                if (!this.mMethodList.contains(imi)) continue;
                enabledImeFound = true;
                if (imi.isAuxiliaryIme()) continue;
                enabledNonAuxImeFound = true;
                break;
            }
            if (!enabledImeFound) {
                resetDefaultEnabledIme = true;
                this.resetSelectedInputMethodAndSubtypeLocked("");
            } else if (!enabledNonAuxImeFound) {
                reenableMinimumNonAuxSystemImes = true;
            }
        }
        if (resetDefaultEnabledIme || reenableMinimumNonAuxSystemImes) {
            ArrayList<InputMethodInfo> defaultEnabledIme = InputMethodUtils.getDefaultEnabledImes(this.mContext, this.mMethodList, reenableMinimumNonAuxSystemImes);
            int N3 = defaultEnabledIme.size();
            for (int i = 0; i < N3; ++i) {
                InputMethodInfo imi = defaultEnabledIme.get(i);
                this.setInputMethodEnabledLocked(imi.getId(), true);
            }
        }
        if (!TextUtils.isEmpty(defaultImiId = this.mSettings.getSelectedInputMethod())) {
            if (!this.mMethodMap.containsKey(defaultImiId)) {
                Slog.w(TAG, "Default IME is uninstalled. Choose new default IME.");
                if (this.chooseNewDefaultIMELocked()) {
                    this.updateInputMethodsFromSettingsLocked(true);
                }
            } else {
                this.setInputMethodEnabledLocked(defaultImiId, true);
            }
        }
        this.mSwitchingController.resetCircularListLocked(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputMethodAndSubtypeEnabler(String inputMethodId) {
        int userId;
        Intent intent = new Intent("android.settings.INPUT_METHOD_SUBTYPE_SETTINGS");
        intent.setFlags(337641472);
        if (!TextUtils.isEmpty(inputMethodId)) {
            intent.putExtra("input_method_id", inputMethodId);
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            userId = this.mSettings.getCurrentUserId();
        }
        this.mContext.startActivityAsUser(intent, null, UserHandle.of(userId));
    }

    private void showConfigureInputMethods() {
        Intent intent = new Intent("android.settings.INPUT_METHOD_SETTINGS");
        intent.setFlags(337641472);
        this.mContext.startActivityAsUser(intent, null, UserHandle.CURRENT);
    }

    private boolean isScreenLocked() {
        return this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked() && this.mKeyguardManager.isKeyguardSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputMethodMenu(boolean showAuxSubtypes, int displayId) {
        boolean isScreenLocked = this.isScreenLocked();
        String lastInputMethodId = this.mSettings.getSelectedInputMethod();
        int lastInputMethodSubtypeId = this.mSettings.getSelectedInputMethodSubtypeId(lastInputMethodId);
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            InputMethodSubtype currentSubtype;
            List<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> imList = this.mSwitchingController.getSortedInputMethodAndSubtypeListLocked(showAuxSubtypes, isScreenLocked);
            if (imList.isEmpty()) {
                return;
            }
            this.hideInputMethodMenuLocked();
            if (lastInputMethodSubtypeId == -1 && (currentSubtype = this.getCurrentInputMethodSubtypeLocked()) != null) {
                InputMethodInfo currentImi = this.mMethodMap.get(this.mCurMethodId);
                lastInputMethodSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(currentImi, currentSubtype.hashCode());
            }
            int N = imList.size();
            this.mIms = new InputMethodInfo[N];
            this.mSubtypeIds = new int[N];
            int checkedItem = 0;
            for (int i = 0; i < N; ++i) {
                int subtypeId;
                InputMethodSubtypeSwitchingController.ImeSubtypeListItem item = imList.get(i);
                this.mIms[i] = item.mImi;
                this.mSubtypeIds[i] = item.mSubtypeId;
                if (!this.mIms[i].getId().equals(lastInputMethodId) || (subtypeId = this.mSubtypeIds[i]) != -1 && (lastInputMethodSubtypeId != -1 || subtypeId != 0) && subtypeId != lastInputMethodSubtypeId) continue;
                checkedItem = i;
            }
            ActivityThread currentThread = ActivityThread.currentActivityThread();
            ContextThemeWrapper settingsContext = new ContextThemeWrapper((Context)(displayId == 0 ? currentThread.getSystemUiContext() : currentThread.createSystemUiContext(displayId)), 16974371);
            this.mDialogBuilder = new AlertDialog.Builder(settingsContext);
            this.mDialogBuilder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                @Override
                public void onCancel(DialogInterface dialog) {
                    InputMethodManagerService.this.hideInputMethodMenu();
                }
            });
            Context dialogContext = this.mDialogBuilder.getContext();
            TypedArray a = dialogContext.obtainStyledAttributes(null, R.styleable.DialogPreference, 16842845, 0);
            Drawable dialogIcon = a.getDrawable(2);
            a.recycle();
            this.mDialogBuilder.setIcon(dialogIcon);
            LayoutInflater inflater = dialogContext.getSystemService(LayoutInflater.class);
            View tv = inflater.inflate(17367168, null);
            this.mDialogBuilder.setCustomTitle(tv);
            this.mSwitchingDialogTitleView = tv;
            ((View)this.mSwitchingDialogTitleView.findViewById(16908972)).setVisibility(this.mWindowManagerInternal.isHardKeyboardAvailable() ? 0 : 8);
            Switch hardKeySwitch = (Switch)this.mSwitchingDialogTitleView.findViewById(16908973);
            hardKeySwitch.setChecked(this.mShowImeWithHardKeyboard);
            hardKeySwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    InputMethodManagerService.this.mSettings.setShowImeWithHardKeyboard(isChecked);
                    InputMethodManagerService.this.hideInputMethodMenu();
                }
            });
            final ImeSubtypeListAdapter adapter = new ImeSubtypeListAdapter(dialogContext, 17367169, imList, checkedItem);
            DialogInterface.OnClickListener choiceListener = new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    ArrayMap<String, InputMethodInfo> arrayMap = InputMethodManagerService.this.mMethodMap;
                    synchronized (arrayMap) {
                        if (InputMethodManagerService.this.mIms == null || InputMethodManagerService.this.mIms.length <= which || InputMethodManagerService.this.mSubtypeIds == null || InputMethodManagerService.this.mSubtypeIds.length <= which) {
                            return;
                        }
                        InputMethodInfo im = InputMethodManagerService.this.mIms[which];
                        int subtypeId = InputMethodManagerService.this.mSubtypeIds[which];
                        adapter.mCheckedItem = which;
                        adapter.notifyDataSetChanged();
                        InputMethodManagerService.this.hideInputMethodMenu();
                        if (im != null) {
                            if (subtypeId < 0 || subtypeId >= im.getSubtypeCount()) {
                                subtypeId = -1;
                            }
                            InputMethodManagerService.this.setInputMethodLocked(im.getId(), subtypeId);
                        }
                    }
                }
            };
            this.mDialogBuilder.setSingleChoiceItems(adapter, checkedItem, choiceListener);
            this.mSwitchingDialog = this.mDialogBuilder.create();
            this.mSwitchingDialog.setCanceledOnTouchOutside(true);
            Window w = this.mSwitchingDialog.getWindow();
            WindowManager.LayoutParams attrs = w.getAttributes();
            w.setType(2012);
            attrs.token = this.mSwitchingDialogToken;
            attrs.privateFlags |= 0x10;
            attrs.setTitle("Select input method");
            w.setAttributes(attrs);
            this.updateSystemUiLocked(this.mImeWindowVis, this.mBackDisposition);
            this.mSwitchingDialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideInputMethodMenu() {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            this.hideInputMethodMenuLocked();
        }
    }

    void hideInputMethodMenuLocked() {
        if (this.mSwitchingDialog != null) {
            this.mSwitchingDialog.dismiss();
            this.mSwitchingDialog = null;
            this.mSwitchingDialogTitleView = null;
        }
        this.updateSystemUiLocked(this.mImeWindowVis, this.mBackDisposition);
        this.mDialogBuilder = null;
        this.mIms = null;
    }

    private boolean setInputMethodEnabledLocked(String id2, boolean enabled) {
        List<Pair<String, ArrayList<String>>> enabledInputMethodsList = this.mSettings.getEnabledInputMethodsAndSubtypeListLocked();
        if (enabled) {
            for (Pair<String, ArrayList<String>> pair : enabledInputMethodsList) {
                if (!((String)pair.first).equals(id2)) continue;
                return true;
            }
            this.mSettings.appendAndPutEnabledInputMethodLocked(id2, false);
            return false;
        }
        StringBuilder builder = new StringBuilder();
        if (this.mSettings.buildAndPutEnabledInputMethodsStrRemovingIdLocked(builder, enabledInputMethodsList, id2)) {
            String selId = this.mSettings.getSelectedInputMethod();
            if (id2.equals(selId) && !this.chooseNewDefaultIMELocked()) {
                Slog.i(TAG, "Can't find new IME, unsetting the current input method.");
                this.resetSelectedInputMethodAndSubtypeLocked("");
            }
            return true;
        }
        return false;
    }

    private void setSelectedInputMethodAndSubtypeLocked(InputMethodInfo imi, int subtypeId, boolean setSubtypeOnly) {
        this.mSettings.saveCurrentInputMethodAndSubtypeToHistory(this.mCurMethodId, this.mCurrentSubtype);
        if (imi == null || subtypeId < 0) {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = null;
        } else if (subtypeId < imi.getSubtypeCount()) {
            InputMethodSubtype subtype = imi.getSubtypeAt(subtypeId);
            this.mSettings.putSelectedSubtype(subtype.hashCode());
            this.mCurrentSubtype = subtype;
        } else {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = this.getCurrentInputMethodSubtypeLocked();
        }
        if (!setSubtypeOnly) {
            this.mSettings.putSelectedInputMethod(imi != null ? imi.getId() : "");
        }
    }

    private void resetSelectedInputMethodAndSubtypeLocked(String newDefaultIme) {
        String subtypeHashCode;
        InputMethodInfo imi = this.mMethodMap.get(newDefaultIme);
        int lastSubtypeId = -1;
        if (imi != null && !TextUtils.isEmpty(newDefaultIme) && (subtypeHashCode = this.mSettings.getLastSubtypeForInputMethodLocked(newDefaultIme)) != null) {
            try {
                lastSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi, Integer.parseInt(subtypeHashCode));
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "HashCode for subtype looks broken: " + subtypeHashCode, e);
            }
        }
        this.setSelectedInputMethodAndSubtypeLocked(imi, lastSubtypeId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputMethodSubtype getCurrentInputMethodSubtype() {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledFromValidUserLocked()) {
                return null;
            }
            return this.getCurrentInputMethodSubtypeLocked();
        }
    }

    private InputMethodSubtype getCurrentInputMethodSubtypeLocked() {
        if (this.mCurMethodId == null) {
            return null;
        }
        boolean subtypeIsSelected = this.mSettings.isSubtypeSelected();
        InputMethodInfo imi = this.mMethodMap.get(this.mCurMethodId);
        if (imi == null || imi.getSubtypeCount() == 0) {
            return null;
        }
        if (!subtypeIsSelected || this.mCurrentSubtype == null || !InputMethodUtils.isValidSubtypeId(imi, this.mCurrentSubtype.hashCode())) {
            int subtypeId = this.mSettings.getSelectedInputMethodSubtypeId(this.mCurMethodId);
            if (subtypeId == -1) {
                List<InputMethodSubtype> explicitlyOrImplicitlyEnabledSubtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
                if (explicitlyOrImplicitlyEnabledSubtypes.size() == 1) {
                    this.mCurrentSubtype = explicitlyOrImplicitlyEnabledSubtypes.get(0);
                } else if (explicitlyOrImplicitlyEnabledSubtypes.size() > 1) {
                    this.mCurrentSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, "keyboard", null, true);
                    if (this.mCurrentSubtype == null) {
                        this.mCurrentSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, null, null, true);
                    }
                }
            } else {
                this.mCurrentSubtype = InputMethodUtils.getSubtypes(imi).get(subtypeId);
            }
        }
        return this.mCurrentSubtype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InputMethodInfo> getInputMethodListAsUser(int userId) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            return this.getInputMethodListLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InputMethodInfo> getEnabledInputMethodListAsUser(int userId) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            return this.getEnabledInputMethodListLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IInputContentUriToken createInputContentUriToken(IBinder token, Uri contentUri, String packageName) {
        if (token == null) {
            throw new NullPointerException("token");
        }
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        if (contentUri == null) {
            throw new NullPointerException("contentUri");
        }
        String contentUriScheme = contentUri.getScheme();
        if (!"content".equals(contentUriScheme)) {
            throw new InvalidParameterException("contentUri must have content scheme");
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            int uid = Binder.getCallingUid();
            if (this.mCurMethodId == null) {
                return null;
            }
            if (this.mCurToken != token) {
                Slog.e(TAG, "Ignoring createInputContentUriToken mCurToken=" + this.mCurToken + " token=" + token);
                return null;
            }
            if (!TextUtils.equals(this.mCurAttribute.packageName, packageName)) {
                Slog.e(TAG, "Ignoring createInputContentUriToken mCurAttribute.packageName=" + this.mCurAttribute.packageName + " packageName=" + packageName);
                return null;
            }
            int imeUserId = UserHandle.getUserId(uid);
            int appUserId = UserHandle.getUserId(this.mCurClient.uid);
            int contentUriOwnerUserId = ContentProvider.getUserIdFromUri(contentUri, imeUserId);
            Uri contentUriWithoutUserId = ContentProvider.getUriWithoutUserId(contentUri);
            return new InputContentUriTokenHandler(contentUriWithoutUserId, uid, packageName, contentUriOwnerUserId, appUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportFullscreenMode(IBinder token, boolean fullscreen) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            if (!this.calledWithValidTokenLocked(token)) {
                return;
            }
            if (this.mCurClient != null && this.mCurClient.client != null) {
                this.mInFullscreenMode = fullscreen;
                this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3045, fullscreen ? 1 : 0, this.mCurClient));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IInputMethod method;
        ClientState focusedWindowClient;
        ClientState client;
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            p.println("Current Input Method Manager state:");
            int N = this.mMethodList.size();
            p.println("  Input Methods: mMethodMapUpdateCount=" + this.mMethodMapUpdateCount);
            for (int i = 0; i < N; ++i) {
                InputMethodInfo info = this.mMethodList.get(i);
                p.println("  InputMethod #" + i + ":");
                info.dump(p, "    ");
            }
            p.println("  Clients:");
            int numClients = this.mClients.size();
            for (int i = 0; i < numClients; ++i) {
                ClientState ci = this.mClients.valueAt(i);
                p.println("  Client " + ci + ":");
                p.println("    client=" + ci.client);
                p.println("    inputContext=" + ci.inputContext);
                p.println("    sessionRequested=" + ci.sessionRequested);
                p.println("    curSession=" + ci.curSession);
            }
            p.println("  mCurMethodId=" + this.mCurMethodId);
            client = this.mCurClient;
            p.println("  mCurClient=" + client + " mCurSeq=" + this.mCurSeq);
            p.println("  mCurFocusedWindow=" + this.mCurFocusedWindow + " softInputMode=" + InputMethodDebug.softInputModeToString(this.mCurFocusedWindowSoftInputMode) + " client=" + this.mCurFocusedWindowClient);
            focusedWindowClient = this.mCurFocusedWindowClient;
            p.println("  mCurId=" + this.mCurId + " mHaveConnection=" + this.mHaveConnection + " mBoundToMethod=" + this.mBoundToMethod + " mVisibleBound=" + this.mVisibleBound);
            p.println("  mCurToken=" + this.mCurToken);
            p.println("  mCurTokenDisplayId=" + this.mCurTokenDisplayId);
            p.println("  mCurIntent=" + this.mCurIntent);
            method = this.mCurMethod;
            p.println("  mCurMethod=" + this.mCurMethod);
            p.println("  mEnabledSession=" + this.mEnabledSession);
            p.println("  mShowRequested=" + this.mShowRequested + " mShowExplicitlyRequested=" + this.mShowExplicitlyRequested + " mShowForced=" + this.mShowForced + " mInputShown=" + this.mInputShown);
            p.println("  mInFullscreenMode=" + this.mInFullscreenMode);
            p.println("  mSystemReady=" + this.mSystemReady + " mInteractive=" + this.mIsInteractive);
            p.println("  mSettingsObserver=" + this.mSettingsObserver);
            p.println("  mSwitchingController:");
            this.mSwitchingController.dump(p);
            p.println("  mSettings:");
            this.mSettings.dumpLocked(p, "    ");
            p.println("  mStartInputHistory:");
            this.mStartInputHistory.dump(pw, "   ");
        }
        p.println(" ");
        if (client != null) {
            pw.flush();
            try {
                TransferPipe.dumpAsync(client.client.asBinder(), fd, args);
            }
            catch (RemoteException | IOException e) {
                p.println("Failed to dump input method client: " + e);
            }
        } else {
            p.println("No input method client.");
        }
        if (focusedWindowClient != null && client != focusedWindowClient) {
            p.println(" ");
            p.println("Warning: Current input method client doesn't match the last focused. window.");
            p.println("Dumping input method client in the last focused window just in case.");
            p.println(" ");
            pw.flush();
            try {
                TransferPipe.dumpAsync(focusedWindowClient.client.asBinder(), fd, args);
            }
            catch (RemoteException | IOException e) {
                p.println("Failed to dump input method client in focused window: " + e);
            }
        }
        p.println(" ");
        if (method != null) {
            pw.flush();
            try {
                TransferPipe.dumpAsync(method.asBinder(), fd, args);
            }
            catch (RemoteException | IOException e) {
                p.println("Failed to dump input method service: " + e);
            }
        } else {
            p.println("No input method service.");
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 2000) {
            if (resultReceiver != null) {
                resultReceiver.send(-1, null);
            }
            String errorMsg = "InputMethodManagerService does not support shell commands from non-shell users. callingUid=" + callingUid + " args=" + Arrays.toString(args);
            if (Process.isCoreUid(callingUid)) {
                Slog.e(TAG, errorMsg);
                return;
            }
            throw new SecurityException(errorMsg);
        }
        new ShellCommandImpl(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastSwitchUserId(ShellCommand shellCommand) {
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            shellCommand.getOutPrintWriter().println(this.mLastSwitchUserId);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleShellCommandListInputMethods(ShellCommand shellCommand) {
        String nextOption;
        boolean all = false;
        boolean brief = false;
        int userIdToBeResolved = -2;
        while ((nextOption = shellCommand.getNextOption()) != null) {
            switch (nextOption) {
                case "-a": {
                    all = true;
                    break;
                }
                case "-s": {
                    brief = true;
                    break;
                }
                case "-u": 
                case "--user": {
                    userIdToBeResolved = UserHandle.parseUserArg(shellCommand.getNextArgRequired());
                }
            }
        }
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            int[] userIds;
            PrintWriter pr = shellCommand.getOutPrintWriter();
            for (int userId : userIds = InputMethodUtils.resolveUserId(userIdToBeResolved, this.mSettings.getCurrentUserId(), shellCommand.getErrPrintWriter())) {
                List<InputMethodInfo> methods;
                List<InputMethodInfo> list = methods = all ? this.getInputMethodListLocked(userId) : this.getEnabledInputMethodListLocked(userId);
                if (userIds.length > 1) {
                    pr.print("User #");
                    pr.print(userId);
                    pr.println(":");
                }
                for (InputMethodInfo info : methods) {
                    if (brief) {
                        pr.println(info.getId());
                        continue;
                    }
                    pr.print(info.getId());
                    pr.println(":");
                    info.dump(pr::println, "  ");
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleShellCommandEnableDisableInputMethod(ShellCommand shellCommand, boolean enabled) {
        int userIdToBeResolved = InputMethodManagerService.handleOptionsForCommandsThatOnlyHaveUserOption(shellCommand);
        String imeId = shellCommand.getNextArgRequired();
        PrintWriter out = shellCommand.getOutPrintWriter();
        PrintWriter error = shellCommand.getErrPrintWriter();
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            int[] userIds;
            for (int userId : userIds = InputMethodUtils.resolveUserId(userIdToBeResolved, this.mSettings.getCurrentUserId(), shellCommand.getErrPrintWriter())) {
                if (!this.userHasDebugPriv(userId, shellCommand)) continue;
                this.handleShellCommandEnableDisableInputMethodInternalLocked(userId, imeId, enabled, out, error);
            }
        }
        return 0;
    }

    private static int handleOptionsForCommandsThatOnlyHaveUserOption(ShellCommand shellCommand) {
        String nextOption;
        while ((nextOption = shellCommand.getNextOption()) != null) {
            switch (nextOption) {
                case "-u": 
                case "--user": {
                    return UserHandle.parseUserArg(shellCommand.getNextArgRequired());
                }
            }
        }
        return -2;
    }

    private void handleShellCommandEnableDisableInputMethodInternalLocked(int userId, String imeId, boolean enabled, PrintWriter out, PrintWriter error) {
        boolean failedToEnableUnknownIme = false;
        boolean previouslyEnabled = false;
        if (userId == this.mSettings.getCurrentUserId()) {
            if (enabled && !this.mMethodMap.containsKey(imeId)) {
                failedToEnableUnknownIme = true;
            } else {
                previouslyEnabled = this.setInputMethodEnabledLocked(imeId, enabled);
            }
        } else {
            ArrayMap<String, InputMethodInfo> methodMap = new ArrayMap<String, InputMethodInfo>();
            ArrayList<InputMethodInfo> methodList = new ArrayList<InputMethodInfo>();
            ArrayMap<String, List<InputMethodSubtype>> additionalSubtypeMap = new ArrayMap<String, List<InputMethodSubtype>>();
            AdditionalSubtypeUtils.load(additionalSubtypeMap, userId);
            InputMethodManagerService.queryInputMethodServicesInternal(this.mContext, userId, additionalSubtypeMap, methodMap, methodList);
            InputMethodUtils.InputMethodSettings settings = new InputMethodUtils.InputMethodSettings(this.mContext.getResources(), this.mContext.getContentResolver(), methodMap, userId, false);
            if (enabled) {
                if (!methodMap.containsKey(imeId)) {
                    failedToEnableUnknownIme = true;
                } else {
                    for (InputMethodInfo imi : settings.getEnabledInputMethodListLocked()) {
                        if (!TextUtils.equals(imi.getId(), imeId)) continue;
                        previouslyEnabled = true;
                        break;
                    }
                    if (!previouslyEnabled) {
                        settings.appendAndPutEnabledInputMethodLocked(imeId, false);
                    }
                }
            } else {
                previouslyEnabled = settings.buildAndPutEnabledInputMethodsStrRemovingIdLocked(new StringBuilder(), settings.getEnabledInputMethodsAndSubtypeListLocked(), imeId);
            }
        }
        if (failedToEnableUnknownIme) {
            error.print("Unknown input method ");
            error.print(imeId);
            error.println(" cannot be enabled for user #" + userId);
        } else {
            out.print("Input method ");
            out.print(imeId);
            out.print(": ");
            out.print(enabled == previouslyEnabled ? "already " : "now ");
            out.print(enabled ? "enabled" : "disabled");
            out.print(" for user #");
            out.println(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleShellCommandSetInputMethod(ShellCommand shellCommand) {
        int userIdToBeResolved = InputMethodManagerService.handleOptionsForCommandsThatOnlyHaveUserOption(shellCommand);
        String imeId = shellCommand.getNextArgRequired();
        PrintWriter out = shellCommand.getOutPrintWriter();
        PrintWriter error = shellCommand.getErrPrintWriter();
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            int[] userIds;
            for (int userId : userIds = InputMethodUtils.resolveUserId(userIdToBeResolved, this.mSettings.getCurrentUserId(), shellCommand.getErrPrintWriter())) {
                if (!this.userHasDebugPriv(userId, shellCommand)) continue;
                boolean failedToSelectUnknownIme = false;
                if (userId == this.mSettings.getCurrentUserId()) {
                    if (this.mMethodMap.containsKey(imeId)) {
                        this.setInputMethodLocked(imeId, -1);
                    } else {
                        failedToSelectUnknownIme = true;
                    }
                } else {
                    ArrayMap<String, InputMethodInfo> methodMap = new ArrayMap<String, InputMethodInfo>();
                    ArrayList<InputMethodInfo> methodList = new ArrayList<InputMethodInfo>();
                    ArrayMap<String, List<InputMethodSubtype>> additionalSubtypeMap = new ArrayMap<String, List<InputMethodSubtype>>();
                    AdditionalSubtypeUtils.load(additionalSubtypeMap, userId);
                    InputMethodManagerService.queryInputMethodServicesInternal(this.mContext, userId, additionalSubtypeMap, methodMap, methodList);
                    InputMethodUtils.InputMethodSettings settings = new InputMethodUtils.InputMethodSettings(this.mContext.getResources(), this.mContext.getContentResolver(), methodMap, userId, false);
                    if (methodMap.containsKey(imeId)) {
                        settings.putSelectedInputMethod(imeId);
                        settings.putSelectedSubtype(-1);
                    } else {
                        failedToSelectUnknownIme = true;
                    }
                }
                if (failedToSelectUnknownIme) {
                    error.print("Unknown input method ");
                    error.print(imeId);
                    error.print(" cannot be selected for user #");
                    error.println(userId);
                    continue;
                }
                out.print("Input method ");
                out.print(imeId);
                out.print(" selected for user #");
                out.println(userId);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleShellCommandResetInputMethod(ShellCommand shellCommand) {
        PrintWriter out = shellCommand.getOutPrintWriter();
        int userIdToBeResolved = InputMethodManagerService.handleOptionsForCommandsThatOnlyHaveUserOption(shellCommand);
        ArrayMap<String, InputMethodInfo> arrayMap = this.mMethodMap;
        synchronized (arrayMap) {
            int[] userIds;
            for (int userId : userIds = InputMethodUtils.resolveUserId(userIdToBeResolved, this.mSettings.getCurrentUserId(), shellCommand.getErrPrintWriter())) {
                ArrayList<InputMethodInfo> nextEnabledImes;
                String nextIme;
                if (!this.userHasDebugPriv(userId, shellCommand)) continue;
                if (userId == this.mSettings.getCurrentUserId()) {
                    this.hideCurrentInputLocked(0, null);
                    this.unbindCurrentMethodLocked();
                    this.resetSelectedInputMethodAndSubtypeLocked(null);
                    this.mSettings.putSelectedInputMethod(null);
                    this.mSettings.getEnabledInputMethodListLocked().forEach(imi -> this.setInputMethodEnabledLocked(imi.getId(), false));
                    InputMethodUtils.getDefaultEnabledImes(this.mContext, this.mMethodList).forEach(imi -> this.setInputMethodEnabledLocked(imi.getId(), true));
                    this.updateInputMethodsFromSettingsLocked(true);
                    InputMethodUtils.setNonSelectedSystemImesDisabledUntilUsed(this.mIPackageManager, this.mSettings.getEnabledInputMethodListLocked(), this.mSettings.getCurrentUserId(), this.mContext.getBasePackageName());
                    nextIme = this.mSettings.getSelectedInputMethod();
                    nextEnabledImes = this.mSettings.getEnabledInputMethodListLocked();
                } else {
                    ArrayMap<String, InputMethodInfo> methodMap = new ArrayMap<String, InputMethodInfo>();
                    ArrayList<InputMethodInfo> methodList = new ArrayList<InputMethodInfo>();
                    ArrayMap<String, List<InputMethodSubtype>> additionalSubtypeMap = new ArrayMap<String, List<InputMethodSubtype>>();
                    AdditionalSubtypeUtils.load(additionalSubtypeMap, userId);
                    InputMethodManagerService.queryInputMethodServicesInternal(this.mContext, userId, additionalSubtypeMap, methodMap, methodList);
                    InputMethodUtils.InputMethodSettings settings = new InputMethodUtils.InputMethodSettings(this.mContext.getResources(), this.mContext.getContentResolver(), methodMap, userId, false);
                    nextEnabledImes = InputMethodUtils.getDefaultEnabledImes(this.mContext, methodList);
                    nextIme = InputMethodUtils.getMostApplicableDefaultIME(nextEnabledImes).getId();
                    settings.putEnabledInputMethodsStr("");
                    nextEnabledImes.forEach(imi -> settings.appendAndPutEnabledInputMethodLocked(imi.getId(), false));
                    settings.putSelectedInputMethod(nextIme);
                    settings.putSelectedSubtype(-1);
                }
                out.println("Reset current and enabled IMEs for user #" + userId);
                out.println("  Selected: " + nextIme);
                nextEnabledImes.forEach(ime -> out.println("   Enabled: " + ime.getId()));
            }
        }
        return 0;
    }

    private boolean userHasDebugPriv(int userId, ShellCommand shellCommand) {
        if (this.mUserManager.hasUserRestriction("no_debugging_features", UserHandle.of(userId))) {
            shellCommand.getErrPrintWriter().println("User #" + userId + " is restricted with DISALLOW_DEBUGGING_FEATURES.");
            return false;
        }
        return true;
    }

    private static final class InputMethodPrivilegedOperationsImpl
    extends IInputMethodPrivilegedOperations.Stub {
        private final InputMethodManagerService mImms;
        private final IBinder mToken;

        InputMethodPrivilegedOperationsImpl(InputMethodManagerService imms, IBinder token) {
            this.mImms = imms;
            this.mToken = token;
        }

        @Override
        public void setImeWindowStatus(int vis, int backDisposition) {
            this.mImms.setImeWindowStatus(this.mToken, vis, backDisposition);
        }

        @Override
        public void reportStartInput(IBinder startInputToken) {
            this.mImms.reportStartInput(this.mToken, startInputToken);
        }

        @Override
        public IInputContentUriToken createInputContentUriToken(Uri contentUri, String packageName) {
            return this.mImms.createInputContentUriToken(this.mToken, contentUri, packageName);
        }

        @Override
        public void reportFullscreenMode(boolean fullscreen) {
            this.mImms.reportFullscreenMode(this.mToken, fullscreen);
        }

        @Override
        public void setInputMethod(String id2) {
            this.mImms.setInputMethod(this.mToken, id2);
        }

        @Override
        public void setInputMethodAndSubtype(String id2, InputMethodSubtype subtype) {
            this.mImms.setInputMethodAndSubtype(this.mToken, id2, subtype);
        }

        @Override
        public void hideMySoftInput(int flags) {
            this.mImms.hideMySoftInput(this.mToken, flags);
        }

        @Override
        public void showMySoftInput(int flags) {
            this.mImms.showMySoftInput(this.mToken, flags);
        }

        @Override
        public void updateStatusIcon(String packageName, int iconId) {
            this.mImms.updateStatusIcon(this.mToken, packageName, iconId);
        }

        @Override
        public boolean switchToPreviousInputMethod() {
            return this.mImms.switchToPreviousInputMethod(this.mToken);
        }

        @Override
        public boolean switchToNextInputMethod(boolean onlyCurrentIme) {
            return this.mImms.switchToNextInputMethod(this.mToken, onlyCurrentIme);
        }

        @Override
        public boolean shouldOfferSwitchingToNextInputMethod() {
            return this.mImms.shouldOfferSwitchingToNextInputMethod(this.mToken);
        }

        @Override
        public void notifyUserAction() {
            this.mImms.notifyUserAction(this.mToken);
        }

        @Override
        public void reportPreRendered(EditorInfo info) {
            this.mImms.reportPreRendered(this.mToken, info);
        }

        @Override
        public void applyImeVisibility(boolean setVisible) {
            this.mImms.applyImeVisibility(this.mToken, setVisible);
        }
    }

    private static final class ShellCommandImpl
    extends ShellCommand {
        final InputMethodManagerService mService;

        ShellCommandImpl(InputMethodManagerService service) {
            this.mService = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int onCommand(String cmd) {
            Arrays.asList("android.permission.DUMP", "android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.WRITE_SECURE_SETTINGS").forEach(permission2 -> this.mService.mContext.enforceCallingPermission((String)permission2, null));
            long identity = Binder.clearCallingIdentity();
            try {
                int n = this.onCommandWithSystemIdentity(cmd);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private int onCommandWithSystemIdentity(String cmd) {
            if ("refresh_debug_properties".equals(cmd)) {
                return this.refreshDebugProperties();
            }
            if ("get-last-switch-user-id".equals(cmd)) {
                return this.mService.getLastSwitchUserId(this);
            }
            if ("ime".equals(cmd)) {
                String imeCommand = this.getNextArg();
                if (imeCommand == null || "help".equals(imeCommand) || "-h".equals(imeCommand)) {
                    this.onImeCommandHelp();
                    return 0;
                }
                switch (imeCommand) {
                    case "list": {
                        return this.mService.handleShellCommandListInputMethods(this);
                    }
                    case "enable": {
                        return this.mService.handleShellCommandEnableDisableInputMethod(this, true);
                    }
                    case "disable": {
                        return this.mService.handleShellCommandEnableDisableInputMethod(this, false);
                    }
                    case "set": {
                        return this.mService.handleShellCommandSetInputMethod(this);
                    }
                    case "reset": {
                        return this.mService.handleShellCommandResetInputMethod(this);
                    }
                }
                this.getOutPrintWriter().println("Unknown command: " + imeCommand);
                return -1;
            }
            return this.handleDefaultCommands(cmd);
        }

        private int refreshDebugProperties() {
            DebugFlags.FLAG_OPTIMIZE_START_INPUT.refresh();
            DebugFlags.FLAG_PRE_RENDER_IME_VIEWS.refresh();
            return 0;
        }

        @Override
        public void onHelp() {
            try (PrintWriter pw = this.getOutPrintWriter();){
                pw.println("InputMethodManagerService commands:");
                pw.println("  help");
                pw.println("    Prints this help text.");
                pw.println("  dump [options]");
                pw.println("    Synonym of dumpsys.");
                pw.println("  ime <command> [options]");
                pw.println("    Manipulate IMEs.  Run \"ime help\" for details.");
            }
        }

        private void onImeCommandHelp() {
            try (IndentingPrintWriter pw = new IndentingPrintWriter(this.getOutPrintWriter(), "  ", 100);){
                pw.println("ime <command>:");
                pw.increaseIndent();
                pw.println("list [-a] [-s]");
                pw.increaseIndent();
                pw.println("prints all enabled input methods.");
                pw.increaseIndent();
                pw.println("-a: see all input methods");
                pw.println("-s: only a single summary line of each");
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.println("enable [--user <USER_ID>] <ID>");
                pw.increaseIndent();
                pw.println("allows the given input method ID to be used.");
                pw.increaseIndent();
                pw.print("--user <USER_ID>: Specify which user to enable.");
                pw.println(" Assumes the current user if not specified.");
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.println("disable [--user <USER_ID>] <ID>");
                pw.increaseIndent();
                pw.println("disallows the given input method ID to be used.");
                pw.increaseIndent();
                pw.print("--user <USER_ID>: Specify which user to disable.");
                pw.println(" Assumes the current user if not specified.");
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.println("set [--user <USER_ID>] <ID>");
                pw.increaseIndent();
                pw.println("switches to the given input method ID.");
                pw.increaseIndent();
                pw.print("--user <USER_ID>: Specify which user to enable.");
                pw.println(" Assumes the current user if not specified.");
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.println("reset [--user <USER_ID>]");
                pw.increaseIndent();
                pw.println("reset currently selected/enabled IMEs to the default ones as if the device is initially booted with the current locale.");
                pw.increaseIndent();
                pw.print("--user <USER_ID>: Specify which user to reset.");
                pw.println(" Assumes the current user if not specified.");
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.decreaseIndent();
            }
        }
    }

    private static final class LocalServiceImpl
    extends InputMethodManagerInternal {
        private final InputMethodManagerService mService;

        LocalServiceImpl(InputMethodManagerService service) {
            this.mService = service;
        }

        @Override
        public void setInteractive(boolean interactive) {
            this.mService.mHandler.obtainMessage(3030, interactive ? 1 : 0, 0).sendToTarget();
        }

        @Override
        public void hideCurrentInputMethod() {
            this.mService.mHandler.removeMessages(1035);
            this.mService.mHandler.sendEmptyMessage(1035);
        }

        @Override
        public List<InputMethodInfo> getInputMethodListAsUser(int userId) {
            return this.mService.getInputMethodListAsUser(userId);
        }

        @Override
        public List<InputMethodInfo> getEnabledInputMethodListAsUser(int userId) {
            return this.mService.getEnabledInputMethodListAsUser(userId);
        }
    }

    private static class ImeSubtypeListAdapter
    extends ArrayAdapter<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> {
        private final LayoutInflater mInflater;
        private final int mTextViewResourceId;
        private final List<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> mItemsList;
        public int mCheckedItem;

        public ImeSubtypeListAdapter(Context context, int textViewResourceId, List<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> itemsList, int checkedItem) {
            super(context, textViewResourceId, itemsList);
            this.mTextViewResourceId = textViewResourceId;
            this.mItemsList = itemsList;
            this.mCheckedItem = checkedItem;
            this.mInflater = context.getSystemService(LayoutInflater.class);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            View view2 = view = convertView != null ? convertView : this.mInflater.inflate(this.mTextViewResourceId, null);
            if (position < 0 || position >= this.mItemsList.size()) {
                return view;
            }
            InputMethodSubtypeSwitchingController.ImeSubtypeListItem item = this.mItemsList.get(position);
            CharSequence imeName = item.mImeName;
            CharSequence subtypeName = item.mSubtypeName;
            TextView firstTextView = (TextView)view.findViewById(16908308);
            TextView secondTextView = (TextView)view.findViewById(16908309);
            if (TextUtils.isEmpty(subtypeName)) {
                firstTextView.setText(imeName);
                secondTextView.setVisibility(8);
            } else {
                firstTextView.setText(subtypeName);
                secondTextView.setText(imeName);
                secondTextView.setVisibility(0);
            }
            RadioButton radioButton = (RadioButton)view.findViewById(16909269);
            radioButton.setChecked(position == this.mCheckedItem);
            return view;
        }
    }

    @FunctionalInterface
    static interface ImeDisplayValidator {
        public boolean displayCanShowIme(int var1);
    }

    public static final class Lifecycle
    extends SystemService {
        private InputMethodManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new InputMethodManagerService(context);
        }

        @Override
        public void onStart() {
            LocalServices.addService(InputMethodManagerInternal.class, new LocalServiceImpl(this.mService));
            this.publishBinderService("input_method", this.mService);
        }

        @Override
        public void onSwitchUser(int userHandle) {
            this.mService.onSwitchUser(userHandle);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                StatusBarManagerService statusBarService = (StatusBarManagerService)ServiceManager.getService("statusbar");
                this.mService.systemRunning(statusBarService);
            }
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.mHandler.sendMessage(this.mService.mHandler.obtainMessage(5000, userHandle, 0));
        }
    }

    private class HardKeyboardListener
    implements WindowManagerInternal.OnHardKeyboardStatusChangeListener {
        private HardKeyboardListener() {
        }

        @Override
        public void onHardKeyboardStatusChange(boolean available) {
            InputMethodManagerService.this.mHandler.sendMessage(InputMethodManagerService.this.mHandler.obtainMessage(4000, available ? 1 : 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleHardKeyboardStatusChange(boolean available) {
            ArrayMap<String, InputMethodInfo> arrayMap = InputMethodManagerService.this.mMethodMap;
            synchronized (arrayMap) {
                if (InputMethodManagerService.this.mSwitchingDialog != null && InputMethodManagerService.this.mSwitchingDialogTitleView != null && InputMethodManagerService.this.mSwitchingDialog.isShowing()) {
                    ((View)InputMethodManagerService.this.mSwitchingDialogTitleView.findViewById(16908972)).setVisibility(available ? 0 : 8);
                }
            }
        }
    }

    private static final class MethodCallback
    extends IInputSessionCallback.Stub {
        private final InputMethodManagerService mParentIMMS;
        private final IInputMethod mMethod;
        private final InputChannel mChannel;

        MethodCallback(InputMethodManagerService imms, IInputMethod method, InputChannel channel) {
            this.mParentIMMS = imms;
            this.mMethod = method;
            this.mChannel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionCreated(IInputMethodSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mParentIMMS.onSessionCreated(this.mMethod, session, this.mChannel);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    final class MyPackageMonitor
    extends PackageMonitor {
        @GuardedBy(value={"mMethodMap"})
        private final ArraySet<String> mKnownImePackageNames = new ArraySet();
        private final ArrayList<String> mChangedPackages = new ArrayList();
        private boolean mImePackageAppeared = false;

        MyPackageMonitor() {
        }

        @GuardedBy(value={"mMethodMap"})
        void clearKnownImePackageNamesLocked() {
            this.mKnownImePackageNames.clear();
        }

        @GuardedBy(value={"mMethodMap"})
        final void addKnownImePackageNameLocked(String packageName) {
            this.mKnownImePackageNames.add(packageName);
        }

        @GuardedBy(value={"mMethodMap"})
        private boolean isChangingPackagesOfCurrentUserLocked() {
            int userId = this.getChangingUserId();
            boolean retval = userId == InputMethodManagerService.this.mSettings.getCurrentUserId();
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            ArrayMap<String, InputMethodInfo> arrayMap = InputMethodManagerService.this.mMethodMap;
            synchronized (arrayMap) {
                if (!this.isChangingPackagesOfCurrentUserLocked()) {
                    return false;
                }
                String curInputMethodId = InputMethodManagerService.this.mSettings.getSelectedInputMethod();
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        if (!imi.getId().equals(curInputMethodId)) continue;
                        for (String pkg : packages) {
                            if (!imi.getPackageName().equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                            InputMethodManagerService.this.chooseNewDefaultIMELocked();
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void onBeginPackageChanges() {
            this.clearPackageChangeState();
        }

        @Override
        public void onPackageAppeared(String packageName, int reason) {
            PackageManager pm;
            List<ResolveInfo> services;
            if (!this.mImePackageAppeared && !(services = (pm = InputMethodManagerService.this.mContext.getPackageManager()).queryIntentServicesAsUser(new Intent("android.view.InputMethod").setPackage(packageName), 512, this.getChangingUserId())).isEmpty()) {
                this.mImePackageAppeared = true;
            }
            this.mChangedPackages.add(packageName);
        }

        @Override
        public void onPackageDisappeared(String packageName, int reason) {
            this.mChangedPackages.add(packageName);
        }

        @Override
        public void onPackageModified(String packageName) {
            this.mChangedPackages.add(packageName);
        }

        @Override
        public void onPackagesSuspended(String[] packages) {
            for (String packageName : packages) {
                this.mChangedPackages.add(packageName);
            }
        }

        @Override
        public void onPackagesUnsuspended(String[] packages) {
            for (String packageName : packages) {
                this.mChangedPackages.add(packageName);
            }
        }

        @Override
        public void onFinishPackageChanges() {
            this.onFinishPackageChangesInternal();
            this.clearPackageChangeState();
        }

        private void clearPackageChangeState() {
            this.mChangedPackages.clear();
            this.mImePackageAppeared = false;
        }

        @GuardedBy(value={"mMethodMap"})
        private boolean shouldRebuildInputMethodListLocked() {
            if (this.mImePackageAppeared) {
                return true;
            }
            int N = this.mChangedPackages.size();
            for (int i = 0; i < N; ++i) {
                String packageName = this.mChangedPackages.get(i);
                if (!this.mKnownImePackageNames.contains(packageName)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFinishPackageChangesInternal() {
            ArrayMap<String, InputMethodInfo> arrayMap = InputMethodManagerService.this.mMethodMap;
            synchronized (arrayMap) {
                int change;
                if (!this.isChangingPackagesOfCurrentUserLocked()) {
                    return;
                }
                if (!this.shouldRebuildInputMethodListLocked()) {
                    return;
                }
                InputMethodInfo curIm = null;
                String curInputMethodId = InputMethodManagerService.this.mSettings.getSelectedInputMethod();
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        String imiId = imi.getId();
                        if (imiId.equals(curInputMethodId)) {
                            curIm = imi;
                        }
                        int change2 = this.isPackageDisappearing(imi.getPackageName());
                        if (this.isPackageModified(imi.getPackageName())) {
                            InputMethodManagerService.this.mAdditionalSubtypeMap.remove(imi.getId());
                            AdditionalSubtypeUtils.save(InputMethodManagerService.this.mAdditionalSubtypeMap, InputMethodManagerService.this.mMethodMap, InputMethodManagerService.this.mSettings.getCurrentUserId());
                        }
                        if (change2 != 2 && change2 != 3) continue;
                        Slog.i(InputMethodManagerService.TAG, "Input method uninstalled, disabling: " + imi.getComponent());
                        InputMethodManagerService.this.setInputMethodEnabledLocked(imi.getId(), false);
                    }
                }
                InputMethodManagerService.this.buildInputMethodListLocked(false);
                boolean changed = false;
                if (curIm != null && ((change = this.isPackageDisappearing(curIm.getPackageName())) == 2 || change == 3)) {
                    ServiceInfo si = null;
                    try {
                        si = InputMethodManagerService.this.mIPackageManager.getServiceInfo(curIm.getComponent(), 0, InputMethodManagerService.this.mSettings.getCurrentUserId());
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (si == null) {
                        Slog.i(InputMethodManagerService.TAG, "Current input method removed: " + curInputMethodId);
                        InputMethodManagerService.this.updateSystemUiLocked(0, InputMethodManagerService.this.mBackDisposition);
                        if (!InputMethodManagerService.this.chooseNewDefaultIMELocked()) {
                            changed = true;
                            curIm = null;
                            Slog.i(InputMethodManagerService.TAG, "Unsetting current input method");
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                        }
                    }
                }
                if (curIm == null) {
                    changed = InputMethodManagerService.this.chooseNewDefaultIMELocked();
                } else if (!changed && this.isPackageModified(curIm.getPackageName())) {
                    changed = true;
                }
                if (changed) {
                    InputMethodManagerService.this.updateFromSettingsLocked(false);
                }
            }
        }
    }

    private final class ImmsBroadcastReceiverForAllUsers
    extends BroadcastReceiver {
        private ImmsBroadcastReceiverForAllUsers() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action)) {
                BroadcastReceiver.PendingResult pendingResult = this.getPendingResult();
                if (pendingResult == null) {
                    return;
                }
                int senderUserId = pendingResult.getSendingUserId();
                if (senderUserId != -1) {
                    int resolvedUserId;
                    int n = resolvedUserId = InputMethodSystemProperty.PER_PROFILE_IME_ENABLED ? senderUserId : InputMethodManagerService.this.mUserManagerInternal.getProfileParentId(senderUserId);
                    if (resolvedUserId != InputMethodManagerService.this.mSettings.getCurrentUserId()) {
                        return;
                    }
                }
                InputMethodManagerService.this.hideInputMethodMenu();
            } else {
                Slog.w(InputMethodManagerService.TAG, "Unexpected intent " + intent);
            }
        }
    }

    private final class ImmsBroadcastReceiverForSystemUser
    extends BroadcastReceiver {
        private ImmsBroadcastReceiverForSystemUser() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.USER_ADDED".equals(action) || "android.intent.action.USER_REMOVED".equals(action)) {
                InputMethodManagerService.this.updateCurrentProfileIds();
                return;
            }
            if ("android.intent.action.LOCALE_CHANGED".equals(action)) {
                InputMethodManagerService.this.onActionLocaleChanged();
            } else if (InputMethodManagerService.ACTION_SHOW_INPUT_METHOD_PICKER.equals(action)) {
                InputMethodManagerService.this.mHandler.obtainMessage(1, 1, 0).sendToTarget();
            } else {
                Slog.w(InputMethodManagerService.TAG, "Unexpected intent " + intent);
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        int mUserId;
        boolean mRegistered;
        String mLastEnabled;

        SettingsObserver(Handler handler) {
            super(handler);
            this.mRegistered = false;
            this.mLastEnabled = "";
        }

        public void registerContentObserverLocked(int userId) {
            if (this.mRegistered && this.mUserId == userId) {
                return;
            }
            ContentResolver resolver = InputMethodManagerService.this.mContext.getContentResolver();
            if (this.mRegistered) {
                InputMethodManagerService.this.mContext.getContentResolver().unregisterContentObserver(this);
                this.mRegistered = false;
            }
            if (this.mUserId != userId) {
                this.mLastEnabled = "";
                this.mUserId = userId;
            }
            resolver.registerContentObserver(Settings.Secure.getUriFor("default_input_method"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("enabled_input_methods"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("selected_input_method_subtype"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("show_ime_with_hard_keyboard"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("accessibility_soft_keyboard_mode"), false, this, userId);
            this.mRegistered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Uri showImeUri = Settings.Secure.getUriFor("show_ime_with_hard_keyboard");
            Uri accessibilityRequestingNoImeUri = Settings.Secure.getUriFor("accessibility_soft_keyboard_mode");
            ArrayMap<String, InputMethodInfo> arrayMap = InputMethodManagerService.this.mMethodMap;
            synchronized (arrayMap) {
                if (showImeUri.equals(uri)) {
                    InputMethodManagerService.this.updateKeyboardFromSettingsLocked();
                } else if (accessibilityRequestingNoImeUri.equals(uri)) {
                    int accessibilitySoftKeyboardSetting = Settings.Secure.getIntForUser(InputMethodManagerService.this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", 0, this.mUserId);
                    InputMethodManagerService.this.mAccessibilityRequestingNoSoftKeyboard = (accessibilitySoftKeyboardSetting & 3) == 1;
                    if (InputMethodManagerService.this.mAccessibilityRequestingNoSoftKeyboard) {
                        boolean showRequested = InputMethodManagerService.this.mShowRequested;
                        InputMethodManagerService.this.hideCurrentInputLocked(0, null);
                        InputMethodManagerService.this.mShowRequested = showRequested;
                    } else if (InputMethodManagerService.this.mShowRequested) {
                        InputMethodManagerService.this.showCurrentInputLocked(1, null);
                    }
                } else {
                    boolean enabledChanged = false;
                    String newEnabled = InputMethodManagerService.this.mSettings.getEnabledInputMethodsStr();
                    if (!this.mLastEnabled.equals(newEnabled)) {
                        this.mLastEnabled = newEnabled;
                        enabledChanged = true;
                    }
                    InputMethodManagerService.this.updateInputMethodsFromSettingsLocked(enabledChanged);
                }
            }
        }

        public String toString() {
            return "SettingsObserver{mUserId=" + this.mUserId + " mRegistered=" + this.mRegistered + " mLastEnabled=" + this.mLastEnabled + "}";
        }
    }

    private static final class StartInputHistory {
        private static final int ENTRY_SIZE_FOR_HIGH_RAM_DEVICE = 16;
        private static final int ENTRY_SIZE_FOR_LOW_RAM_DEVICE = 5;
        private final Entry[] mEntries = new Entry[StartInputHistory.getEntrySize()];
        private int mNextIndex = 0;

        private StartInputHistory() {
        }

        private static int getEntrySize() {
            if (ActivityManager.isLowRamDeviceStatic()) {
                return 5;
            }
            return 16;
        }

        void addEntry(StartInputInfo info) {
            int index = this.mNextIndex;
            if (this.mEntries[index] == null) {
                this.mEntries[index] = new Entry(info);
            } else {
                this.mEntries[index].set(info);
            }
            this.mNextIndex = (this.mNextIndex + 1) % this.mEntries.length;
        }

        void dump(PrintWriter pw, String prefix) {
            SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
            for (int i = 0; i < this.mEntries.length; ++i) {
                Entry entry = this.mEntries[(i + this.mNextIndex) % this.mEntries.length];
                if (entry == null) continue;
                pw.print(prefix);
                pw.println("StartInput #" + entry.mSequenceNumber + ":");
                pw.print(prefix);
                pw.println(" time=" + dataFormat.format(new Date(entry.mWallTime)) + " (timestamp=" + entry.mTimestamp + ") reason=" + InputMethodDebug.startInputReasonToString(entry.mStartInputReason) + " restarting=" + entry.mRestarting);
                pw.print(prefix);
                pw.print(" imeToken=" + entry.mImeTokenString + " [" + entry.mImeId + "]");
                pw.print(" imeUserId=" + entry.mImeUserId);
                pw.println(" imeDisplayId=" + entry.mImeDisplayId);
                pw.print(prefix);
                pw.println(" targetWin=" + entry.mTargetWindowString + " [" + entry.mEditorInfo.packageName + "] targetUserId=" + entry.mTargetUserId + " targetDisplayId=" + entry.mTargetDisplayId + " clientBindSeq=" + entry.mClientBindSequenceNumber);
                pw.print(prefix);
                pw.println(" softInputMode=" + InputMethodDebug.softInputModeToString(entry.mTargetWindowSoftInputMode));
                pw.print(prefix);
                pw.println(" inputType=0x" + Integer.toHexString(entry.mEditorInfo.inputType) + " imeOptions=0x" + Integer.toHexString(entry.mEditorInfo.imeOptions) + " fieldId=0x" + Integer.toHexString(entry.mEditorInfo.fieldId) + " fieldName=" + entry.mEditorInfo.fieldName + " actionId=" + entry.mEditorInfo.actionId + " actionLabel=" + entry.mEditorInfo.actionLabel);
            }
        }

        private static final class Entry {
            int mSequenceNumber;
            long mTimestamp;
            long mWallTime;
            int mImeUserId;
            String mImeTokenString;
            int mImeDisplayId;
            String mImeId;
            int mStartInputReason;
            boolean mRestarting;
            int mTargetUserId;
            int mTargetDisplayId;
            String mTargetWindowString;
            EditorInfo mEditorInfo;
            int mTargetWindowSoftInputMode;
            int mClientBindSequenceNumber;

            Entry(StartInputInfo original) {
                this.set(original);
            }

            void set(StartInputInfo original) {
                this.mSequenceNumber = original.mSequenceNumber;
                this.mTimestamp = original.mTimestamp;
                this.mWallTime = original.mWallTime;
                this.mImeUserId = original.mImeUserId;
                this.mImeTokenString = String.valueOf(original.mImeToken);
                this.mImeDisplayId = original.mImeDisplayId;
                this.mImeId = original.mImeId;
                this.mStartInputReason = original.mStartInputReason;
                this.mRestarting = original.mRestarting;
                this.mTargetUserId = original.mTargetUserId;
                this.mTargetDisplayId = original.mTargetDisplayId;
                this.mTargetWindowString = String.valueOf(original.mTargetWindow);
                this.mEditorInfo = original.mEditorInfo;
                this.mTargetWindowSoftInputMode = original.mTargetWindowSoftInputMode;
                this.mClientBindSequenceNumber = original.mClientBindSequenceNumber;
            }
        }
    }

    private static class StartInputInfo {
        private static final AtomicInteger sSequenceNumber = new AtomicInteger(0);
        final int mSequenceNumber = sSequenceNumber.getAndIncrement();
        final long mTimestamp = SystemClock.uptimeMillis();
        final long mWallTime = System.currentTimeMillis();
        final int mImeUserId;
        final IBinder mImeToken;
        final int mImeDisplayId;
        final String mImeId;
        final int mStartInputReason;
        final boolean mRestarting;
        final int mTargetUserId;
        final int mTargetDisplayId;
        final IBinder mTargetWindow;
        final EditorInfo mEditorInfo;
        final int mTargetWindowSoftInputMode;
        final int mClientBindSequenceNumber;

        StartInputInfo(int imeUserId, IBinder imeToken, int imeDisplayId, String imeId, int startInputReason, boolean restarting, int targetUserId, int targetDisplayId, IBinder targetWindow, EditorInfo editorInfo, int targetWindowSoftInputMode, int clientBindSequenceNumber) {
            this.mImeUserId = imeUserId;
            this.mImeToken = imeToken;
            this.mImeDisplayId = imeDisplayId;
            this.mImeId = imeId;
            this.mStartInputReason = startInputReason;
            this.mRestarting = restarting;
            this.mTargetUserId = targetUserId;
            this.mTargetDisplayId = targetDisplayId;
            this.mTargetWindow = targetWindow;
            this.mEditorInfo = editorInfo;
            this.mTargetWindowSoftInputMode = targetWindowSoftInputMode;
            this.mClientBindSequenceNumber = clientBindSequenceNumber;
        }
    }

    private static final class ActivityViewInfo {
        private final ClientState mParentClient;
        private final Matrix mMatrix;

        ActivityViewInfo(ClientState parentClient, Matrix matrix) {
            this.mParentClient = parentClient;
            this.mMatrix = matrix;
        }
    }

    static final class ClientState {
        final IInputMethodClient client;
        final IInputContext inputContext;
        final int uid;
        final int pid;
        final int selfReportedDisplayId;
        final InputBinding binding;
        final ClientDeathRecipient clientDeathRecipient;
        boolean sessionRequested;
        boolean shouldPreRenderIme;
        SessionState curSession;

        public String toString() {
            return "ClientState{" + Integer.toHexString(System.identityHashCode(this)) + " uid=" + this.uid + " pid=" + this.pid + " displayId=" + this.selfReportedDisplayId + "}";
        }

        ClientState(IInputMethodClient _client, IInputContext _inputContext, int _uid, int _pid, int _selfReportedDisplayId, ClientDeathRecipient _clientDeathRecipient) {
            this.client = _client;
            this.inputContext = _inputContext;
            this.uid = _uid;
            this.pid = _pid;
            this.selfReportedDisplayId = _selfReportedDisplayId;
            this.binding = new InputBinding(null, this.inputContext.asBinder(), this.uid, this.pid);
            this.clientDeathRecipient = _clientDeathRecipient;
        }
    }

    private static final class ClientDeathRecipient
    implements IBinder.DeathRecipient {
        private final InputMethodManagerService mImms;
        private final IInputMethodClient mClient;

        ClientDeathRecipient(InputMethodManagerService imms, IInputMethodClient client) {
            this.mImms = imms;
            this.mClient = client;
        }

        @Override
        public void binderDied() {
            this.mImms.removeClient(this.mClient);
        }
    }

    static class SessionState {
        final ClientState client;
        final IInputMethod method;
        IInputMethodSession session;
        InputChannel channel;

        public String toString() {
            return "SessionState{uid " + this.client.uid + " pid " + this.client.pid + " method " + Integer.toHexString(System.identityHashCode(this.method)) + " session " + Integer.toHexString(System.identityHashCode(this.session)) + " channel " + this.channel + "}";
        }

        SessionState(ClientState _client, IInputMethod _method, IInputMethodSession _session, InputChannel _channel) {
            this.client = _client;
            this.method = _method;
            this.session = _session;
            this.channel = _channel;
        }
    }

    private static final class DebugFlags {
        static final DebugFlag FLAG_OPTIMIZE_START_INPUT = new DebugFlag("debug.optimize_startinput", false);
        static final DebugFlag FLAG_PRE_RENDER_IME_VIEWS = new DebugFlag("persist.pre_render_ime_views", false);

        private DebugFlags() {
        }
    }

    private static final class DebugFlag {
        private static final Object LOCK = new Object();
        private final String mKey;
        private final boolean mDefaultValue;
        @GuardedBy(value={"LOCK"})
        private boolean mValue;

        public DebugFlag(String key, boolean defaultValue) {
            this.mKey = key;
            this.mDefaultValue = defaultValue;
            this.mValue = SystemProperties.getBoolean(key, defaultValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refresh() {
            Object object = LOCK;
            synchronized (object) {
                this.mValue = SystemProperties.getBoolean(this.mKey, this.mDefaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean value() {
            Object object = LOCK;
            synchronized (object) {
                return this.mValue;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface HardKeyboardBehavior {
        public static final int WIRELESS_AFFORDANCE = 0;
        public static final int WIRED_AFFORDANCE = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ShellCommandResult {
        public static final int SUCCESS = 0;
        public static final int FAILURE = -1;
    }
}

