/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.inputmethod;

import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.view.inputmethod.InputMethodSystemProperty;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IMultiClientInputMethod;
import com.android.internal.inputmethod.IMultiClientInputMethodPrivilegedOperations;
import com.android.internal.inputmethod.IMultiClientInputMethodSession;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputBindResult;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.inputmethod.InputMethodManagerInternal;
import com.android.server.inputmethod.InputMethodUtils;
import com.android.server.wm.WindowManagerInternal;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;

public final class MultiClientInputMethodManagerService {
    private static final String TAG = "MultiClientInputMethodManagerService";
    private static final boolean DEBUG = false;
    private static final String PER_DISPLAY_FOCUS_DISABLED_WARNING_TITLE = "config_perDisplayFocusEnabled is not true.";
    private static final String PER_DISPLAY_FOCUS_DISABLED_WARNING_MSG = "Consider rebuilding the system image after enabling config_perDisplayFocusEnabled to make IME focus compatible with multi-client IME mode.";
    private static final long RECONNECT_DELAY_MSEC = 1000L;
    private static final int IME_CONNECTION_UNIFIED_BIND_FLAGS = 0x44000005;
    private static final ComponentName sImeComponentName = InputMethodSystemProperty.sMultiClientImeComponentName;

    private static void reportNotSupported() {
    }

    private MultiClientInputMethodManagerService() {
    }

    private static InputMethodInfo queryInputMethod(Context context, int userId, ComponentName componentName) {
        if (componentName == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        List<ResolveInfo> services = pm.queryIntentServicesAsUser(new Intent("android.inputmethodservice.MultiClientInputMethodService").setComponent(componentName), 128, userId);
        if (services.isEmpty()) {
            Slog.e(TAG, "No IME found");
            return null;
        }
        if (services.size() > 1) {
            Slog.e(TAG, "Only one IME service is supported.");
            return null;
        }
        ResolveInfo ri = services.get(0);
        ServiceInfo si = ri.serviceInfo;
        String imeId = InputMethodInfo.computeId(ri);
        if (!"android.permission.BIND_INPUT_METHOD".equals(si.permission)) {
            Slog.e(TAG, imeId + " must have required" + "android.permission.BIND_INPUT_METHOD");
            return null;
        }
        if (!Build.IS_DEBUGGABLE && (si.applicationInfo.flags & 1) == 0) {
            Slog.e(TAG, imeId + " must be pre-installed when Build.IS_DEBUGGABLE is false");
            return null;
        }
        try {
            return new InputMethodInfo(context, ri);
        }
        catch (Exception e) {
            Slog.wtf(TAG, "Unable to load input method " + imeId, e);
            return null;
        }
    }

    private static final class ApiCallbacks
    extends IInputMethodManager.Stub {
        private final Context mContext;
        private final UserDataMap mUserDataMap;
        private final UserToInputMethodInfoMap mInputMethodInfoMap;
        private final AppOpsManager mAppOpsManager;
        private final WindowManagerInternal mWindowManagerInternal;

        ApiCallbacks(Context context, UserDataMap userDataMap, UserToInputMethodInfoMap inputMethodInfoMap) {
            this.mContext = context;
            this.mUserDataMap = userDataMap;
            this.mInputMethodInfoMap = inputMethodInfoMap;
            this.mAppOpsManager = context.getSystemService(AppOpsManager.class);
            this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
        }

        private boolean checkFocus(int uid, int pid, int displayId) {
            return this.mWindowManagerInternal.isInputMethodClientFocus(uid, pid, displayId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addClient(IInputMethodClient client, IInputContext inputContext, int selfReportedDisplayId) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            int userId = UserHandle.getUserId(callingUid);
            PerUserData data = this.mUserDataMap.get(userId);
            if (data == null) {
                Slog.e(MultiClientInputMethodManagerService.TAG, "addClient() from unknown userId=" + userId + " uid=" + callingUid + " pid=" + callingPid);
                return;
            }
            Object object = data.mLock;
            synchronized (object) {
                data.addClientLocked(callingUid, callingPid, client, selfReportedDisplayId);
            }
        }

        @Override
        public List<InputMethodInfo> getInputMethodList(int userId) {
            if (UserHandle.getCallingUserId() != userId) {
                this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
            }
            return this.mInputMethodInfoMap.getAsList(userId);
        }

        @Override
        public List<InputMethodInfo> getEnabledInputMethodList(int userId) {
            if (UserHandle.getCallingUserId() != userId) {
                this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
            }
            return this.mInputMethodInfoMap.getAsList(userId);
        }

        @Override
        public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlySelectedSubtypes) {
            MultiClientInputMethodManagerService.reportNotSupported();
            return Collections.emptyList();
        }

        @Override
        public InputMethodSubtype getLastInputMethodSubtype() {
            MultiClientInputMethodManagerService.reportNotSupported();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean showSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            int userId = UserHandle.getUserId(callingUid);
            PerUserData data = this.mUserDataMap.get(userId);
            if (data == null) {
                Slog.e(MultiClientInputMethodManagerService.TAG, "showSoftInput() from unknown userId=" + userId + " uid=" + callingUid + " pid=" + callingPid);
                return false;
            }
            Object object = data.mLock;
            synchronized (object) {
                InputMethodClientInfo clientInfo = data.getClientLocked(client);
                if (clientInfo == null) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "showSoftInput. client not found. ignoring.");
                    return false;
                }
                if (clientInfo.mUid != callingUid) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "Expected calling UID=" + clientInfo.mUid + " actual=" + callingUid);
                    return false;
                }
                switch (clientInfo.mState) {
                    case 3: 
                    case 4: {
                        try {
                            clientInfo.mMSInputMethodSession.showSoftInput(flags, resultReceiver);
                        }
                        catch (RemoteException remoteException) {}
                        break;
                    }
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hideSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            int userId = UserHandle.getUserId(callingUid);
            PerUserData data = this.mUserDataMap.get(userId);
            if (data == null) {
                Slog.e(MultiClientInputMethodManagerService.TAG, "hideSoftInput() from unknown userId=" + userId + " uid=" + callingUid + " pid=" + callingPid);
                return false;
            }
            Object object = data.mLock;
            synchronized (object) {
                InputMethodClientInfo clientInfo = data.getClientLocked(client);
                if (clientInfo == null) {
                    return false;
                }
                if (clientInfo.mUid != callingUid) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "Expected calling UID=" + clientInfo.mUid + " actual=" + callingUid);
                    return false;
                }
                switch (clientInfo.mState) {
                    case 3: 
                    case 4: {
                        try {
                            clientInfo.mMSInputMethodSession.hideSoftInput(flags, resultReceiver);
                        }
                        catch (RemoteException remoteException) {}
                        break;
                    }
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo editorInfo, IInputContext inputContext, int missingMethods, int unverifiedTargetSdkVersion) {
            boolean packageNameVerified;
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            int userId = UserHandle.getUserId(callingUid);
            if (client == null) {
                return InputBindResult.INVALID_CLIENT;
            }
            boolean bl = packageNameVerified = editorInfo != null && InputMethodUtils.checkIfPackageBelongsToUid(this.mAppOpsManager, callingUid, editorInfo.packageName);
            if (editorInfo != null && !packageNameVerified) {
                Slog.e(MultiClientInputMethodManagerService.TAG, "Rejecting this client as it reported an invalid package name. uid=" + callingUid + " package=" + editorInfo.packageName);
                return InputBindResult.INVALID_PACKAGE_NAME;
            }
            PerUserData data = this.mUserDataMap.get(userId);
            if (data == null) {
                Slog.e(MultiClientInputMethodManagerService.TAG, "startInputOrWindowGainedFocus() from unknown userId=" + userId + " uid=" + callingUid + " pid=" + callingPid);
                return InputBindResult.INVALID_USER;
            }
            Object object = data.mLock;
            synchronized (object) {
                InputMethodClientInfo clientInfo = data.getClientLocked(client);
                if (clientInfo == null) {
                    return InputBindResult.INVALID_CLIENT;
                }
                if (clientInfo.mUid != callingUid) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "Expected calling UID=" + clientInfo.mUid + " actual=" + callingUid);
                    return InputBindResult.INVALID_CLIENT;
                }
                switch (data.mState) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        return InputBindResult.IME_NOT_CONNECTED;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        Slog.wtf(MultiClientInputMethodManagerService.TAG, "Unexpected state=" + data.mState);
                        return InputBindResult.IME_NOT_CONNECTED;
                    }
                }
                WindowInfo windowInfo = null;
                if (windowToken != null && (windowInfo = clientInfo.mWindowMap.get(windowToken)) == null) {
                    windowInfo = new WindowInfo(windowToken, WindowHandleSource.getNext());
                    clientInfo.mWindowMap.put(windowToken, windowInfo);
                }
                if (!this.checkFocus(clientInfo.mUid, clientInfo.mPid, clientInfo.mSelfReportedDisplayId)) {
                    return InputBindResult.NOT_IME_TARGET_WINDOW;
                }
                if (editorInfo == null) {
                    switch (clientInfo.mState) {
                        case 3: 
                        case 4: {
                            int windowHandle = windowInfo != null ? windowInfo.mWindowHandle : -1;
                            try {
                                clientInfo.mMSInputMethodSession.startInputOrWindowGainedFocus(inputContext, missingMethods, editorInfo, startInputFlags, softInputMode, windowHandle);
                                break;
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                    return InputBindResult.NULL_EDITOR_INFO;
                }
                switch (clientInfo.mState) {
                    case 1: 
                    case 2: {
                        ++clientInfo.mBindingSequence;
                        if (clientInfo.mBindingSequence < 0) {
                            clientInfo.mBindingSequence = 0;
                        }
                        return new InputBindResult(1, null, null, data.mCurrentInputMethodInfo.getId(), clientInfo.mBindingSequence, null);
                    }
                    case 3: 
                    case 4: {
                        ++clientInfo.mBindingSequence;
                        if (clientInfo.mBindingSequence < 0) {
                            clientInfo.mBindingSequence = 0;
                        }
                        int windowHandle = windowInfo != null ? windowInfo.mWindowHandle : -1;
                        try {
                            clientInfo.mMSInputMethodSession.startInputOrWindowGainedFocus(inputContext, missingMethods, editorInfo, startInputFlags, softInputMode, windowHandle);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        clientInfo.mState = 4;
                        return new InputBindResult(0, clientInfo.mInputMethodSession, clientInfo.mWriteChannel.dup(), data.mCurrentInputMethodInfo.getId(), clientInfo.mBindingSequence, null);
                    }
                    case 5: {
                        Slog.e(MultiClientInputMethodManagerService.TAG, "The client is already unregistered.");
                        return InputBindResult.INVALID_CLIENT;
                    }
                }
                return null;
            }
        }

        @Override
        public void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) {
            MultiClientInputMethodManagerService.reportNotSupported();
        }

        @Override
        public void showInputMethodPickerFromSystem(IInputMethodClient client, int auxiliarySubtypeMode, int displayId) {
            MultiClientInputMethodManagerService.reportNotSupported();
        }

        @Override
        public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient client, String inputMethodId) {
            MultiClientInputMethodManagerService.reportNotSupported();
        }

        @Override
        public boolean isInputMethodPickerShownForTest() {
            MultiClientInputMethodManagerService.reportNotSupported();
            return false;
        }

        @Override
        public InputMethodSubtype getCurrentInputMethodSubtype() {
            MultiClientInputMethodManagerService.reportNotSupported();
            return null;
        }

        @Override
        public void setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
            MultiClientInputMethodManagerService.reportNotSupported();
        }

        @Override
        public int getInputMethodWindowVisibleHeight() {
            MultiClientInputMethodManagerService.reportNotSupported();
            return 0;
        }

        @Override
        public void reportActivityView(IInputMethodClient parentClient, int childDisplayId, float[] matrixValues) {
            MultiClientInputMethodManagerService.reportNotSupported();
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(this.mContext, MultiClientInputMethodManagerService.TAG, pw)) {
                return;
            }
            String prefixChild = "  ";
            pw.println("Current Multi Client Input Method Manager state:");
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, " ");
            ipw.println("mUserDataMap=");
            if (this.mUserDataMap != null) {
                ipw.increaseIndent();
                this.mUserDataMap.dump(fd, ipw, args);
            }
        }
    }

    private static final class ImeCallbacks
    extends IMultiClientInputMethodPrivilegedOperations.Stub {
        private final PerUserData mPerUserData;
        private final WindowManagerInternal mIWindowManagerInternal;

        ImeCallbacks(PerUserData perUserData) {
            this.mPerUserData = perUserData;
            this.mIWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IBinder createInputMethodWindowToken(int displayId) {
            Object object = this.mPerUserData.mLock;
            synchronized (object) {
                int numTokens = this.mPerUserData.mDisplayIdToImeWindowTokenMap.size();
                for (int i = 0; i < numTokens; ++i) {
                    TokenInfo tokenInfo = this.mPerUserData.mDisplayIdToImeWindowTokenMap.valueAt(i);
                    if (tokenInfo.mDisplayId != displayId) continue;
                    return tokenInfo.mToken;
                }
                Binder token = new Binder();
                Binder.withCleanCallingIdentity(PooledLambda.obtainRunnable(WindowManagerInternal::addWindowToken, this.mIWindowManagerInternal, token, 2011, displayId));
                this.mPerUserData.mDisplayIdToImeWindowTokenMap.add(new TokenInfo(token, displayId));
                return token;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteInputMethodWindowToken(IBinder token) {
            Object object = this.mPerUserData.mLock;
            synchronized (object) {
                int numTokens = this.mPerUserData.mDisplayIdToImeWindowTokenMap.size();
                for (int i = 0; i < numTokens; ++i) {
                    TokenInfo tokenInfo = this.mPerUserData.mDisplayIdToImeWindowTokenMap.valueAt(i);
                    if (tokenInfo.mToken != token) continue;
                    this.mPerUserData.mDisplayIdToImeWindowTokenMap.remove(tokenInfo);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptClient(int clientId, IInputMethodSession inputMethodSession, IMultiClientInputMethodSession multiSessionInputMethodSession, InputChannel writeChannel) {
            Object object = this.mPerUserData.mLock;
            synchronized (object) {
                InputMethodClientInfo clientInfo = this.mPerUserData.getClientFromIdLocked(clientId);
                if (clientInfo == null) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "Unknown clientId=" + clientId);
                    return;
                }
                switch (clientInfo.mState) {
                    case 2: {
                        try {
                            clientInfo.mClient.setActive(true, false);
                        }
                        catch (RemoteException e) {
                            return;
                        }
                        clientInfo.mState = 3;
                        clientInfo.mWriteChannel = writeChannel;
                        clientInfo.mInputMethodSession = inputMethodSession;
                        clientInfo.mMSInputMethodSession = multiSessionInputMethodSession;
                        break;
                    }
                    default: {
                        Slog.e(MultiClientInputMethodManagerService.TAG, "Unexpected state=" + clientInfo.mState);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reportImeWindowTarget(int clientId, int targetWindowHandle, IBinder imeWindowToken) {
            Object object = this.mPerUserData.mLock;
            synchronized (object) {
                InputMethodClientInfo clientInfo = this.mPerUserData.getClientFromIdLocked(clientId);
                if (clientInfo == null) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "Unknown clientId=" + clientId);
                    return;
                }
                for (WindowInfo windowInfo : clientInfo.mWindowMap.values()) {
                    if (windowInfo.mWindowHandle != targetWindowHandle) continue;
                    IBinder iBinder = windowInfo.mWindowToken;
                }
            }
        }

        @Override
        public boolean isUidAllowedOnDisplay(int displayId, int uid) {
            return this.mIWindowManagerInternal.isUidAllowedOnDisplay(displayId, uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setActive(int clientId, boolean active) {
            Object object = this.mPerUserData.mLock;
            synchronized (object) {
                InputMethodClientInfo clientInfo = this.mPerUserData.getClientFromIdLocked(clientId);
                if (clientInfo == null) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "Unknown clientId=" + clientId);
                    return;
                }
                try {
                    clientInfo.mClient.setActive(active, false);
                }
                catch (RemoteException e) {
                    return;
                }
                return;
            }
        }
    }

    private static final class UserToInputMethodInfoMap {
        @GuardedBy(value={"mArray"})
        private final SparseArray<InputMethodInfo> mArray = new SparseArray();

        private UserToInputMethodInfoMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(int userId, InputMethodInfo imi) {
            SparseArray<InputMethodInfo> sparseArray = this.mArray;
            synchronized (sparseArray) {
                this.mArray.put(userId, imi);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(int userId) {
            SparseArray<InputMethodInfo> sparseArray = this.mArray;
            synchronized (sparseArray) {
                this.mArray.remove(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InputMethodInfo get(int userId) {
            SparseArray<InputMethodInfo> sparseArray = this.mArray;
            synchronized (sparseArray) {
                return this.mArray.get(userId);
            }
        }

        List<InputMethodInfo> getAsList(int userId) {
            InputMethodInfo info = this.get(userId);
            if (info == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dump(FileDescriptor fd, IndentingPrintWriter ipw, String[] args) {
            SparseArray<InputMethodInfo> sparseArray = this.mArray;
            synchronized (sparseArray) {
                for (int i = 0; i < this.mArray.size(); ++i) {
                    ipw.println("userId=" + this.mArray.keyAt(i));
                    ipw.println(" InputMethodInfo=" + this.mArray.valueAt(i));
                }
            }
        }
    }

    private static final class PerUserData {
        final Object mLock = new Object();
        private final int mUserId;
        @GuardedBy(value={"mLock"})
        IMultiClientInputMethod mCurrentInputMethod;
        @GuardedBy(value={"mLock"})
        InputMethodInfo mCurrentInputMethodInfo;
        @GuardedBy(value={"mLock"})
        int mState;
        @GuardedBy(value={"mLock"})
        final ArraySet<TokenInfo> mDisplayIdToImeWindowTokenMap = new ArraySet();
        @GuardedBy(value={"mLock"})
        private final ArrayMap<IBinder, InputMethodClientInfo> mClientMap = new ArrayMap();
        @GuardedBy(value={"mLock"})
        private SparseArray<InputMethodClientInfo> mClientIdToClientMap = new SparseArray();
        private final OnWorkerThreadServiceConnection mOnWorkerThreadServiceConnection;

        PerUserData(int userId, InputMethodInfo inputMethodInfo, int initialState, OnWorkerThreadCallback callback) {
            this.mUserId = userId;
            this.mCurrentInputMethodInfo = inputMethodInfo;
            this.mState = initialState;
            this.mOnWorkerThreadServiceConnection = new OnWorkerThreadServiceConnection(this, callback);
        }

        @GuardedBy(value={"mLock"})
        boolean bindServiceLocked(Context context, int userId) {
            Intent intent = new Intent("android.inputmethodservice.MultiClientInputMethodService").setComponent(this.mCurrentInputMethodInfo.getComponent()).putExtra("android.intent.extra.client_label", 17040135).putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(context, 0, new Intent("android.settings.INPUT_METHOD_SETTINGS"), 0));
            return context.bindServiceAsUser(intent, this.mOnWorkerThreadServiceConnection, 0x44000005, this.mOnWorkerThreadServiceConnection.getHandler(), UserHandle.of(userId));
        }

        @GuardedBy(value={"mLock"})
        void unbindServiceLocked(Context context) {
            context.unbindService(this.mOnWorkerThreadServiceConnection);
        }

        @GuardedBy(value={"mLock"})
        InputMethodClientInfo getClientLocked(IInputMethodClient client) {
            return this.mClientMap.get(client.asBinder());
        }

        @GuardedBy(value={"mLock"})
        InputMethodClientInfo getClientFromIdLocked(int clientId) {
            return this.mClientIdToClientMap.get(clientId);
        }

        @GuardedBy(value={"mLock"})
        InputMethodClientInfo removeClientLocked(IInputMethodClient client) {
            InputMethodClientInfo info = this.mClientMap.remove(client.asBinder());
            if (info != null) {
                this.mClientIdToClientMap.remove(info.mClientId);
            }
            return info;
        }

        @GuardedBy(value={"mLock"})
        void addClientLocked(int uid, int pid, IInputMethodClient client, int selfReportedDisplayId) {
            if (this.getClientLocked(client) != null) {
                Slog.wtf(MultiClientInputMethodManagerService.TAG, "The same client is added multiple times");
                return;
            }
            ClientDeathRecipient deathRecipient = new ClientDeathRecipient(this, client);
            try {
                client.asBinder().linkToDeath(deathRecipient, 0);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
            InputMethodClientInfo clientInfo = new InputMethodClientInfo(client, uid, pid, selfReportedDisplayId);
            clientInfo.mState = 1;
            this.mClientMap.put(client.asBinder(), clientInfo);
            this.mClientIdToClientMap.put(clientInfo.mClientId, clientInfo);
            switch (this.mState) {
                case 5: {
                    try {
                        this.mCurrentInputMethod.addClient(clientInfo.mClientId, clientInfo.mPid, clientInfo.mUid, clientInfo.mSelfReportedDisplayId);
                        clientInfo.mState = 2;
                        break;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }

        @GuardedBy(value={"mLock"})
        void onInputMethodConnectedLocked() {
            int numClients = this.mClientMap.size();
            for (int i = 0; i < numClients; ++i) {
                InputMethodClientInfo clientInfo = this.mClientMap.valueAt(i);
                switch (clientInfo.mState) {
                    case 1: {
                        break;
                    }
                    default: {
                        Slog.e(MultiClientInputMethodManagerService.TAG, "Unexpected state=" + clientInfo.mState);
                        return;
                    }
                }
                try {
                    this.mCurrentInputMethod.addClient(clientInfo.mClientId, clientInfo.mUid, clientInfo.mPid, clientInfo.mSelfReportedDisplayId);
                    clientInfo.mState = 2;
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @GuardedBy(value={"mLock"})
        void onInputMethodDisconnectedLocked() {
            int numClients = this.mClientMap.size();
            block8: for (int i = 0; i < numClients; ++i) {
                InputMethodClientInfo clientInfo = this.mClientMap.valueAt(i);
                switch (clientInfo.mState) {
                    case 1: {
                        continue block8;
                    }
                    case 2: {
                        clientInfo.mState = 1;
                        continue block8;
                    }
                    case 3: {
                        clientInfo.mState = 1;
                        clientInfo.mInputMethodSession = null;
                        clientInfo.mMSInputMethodSession = null;
                        if (clientInfo.mWriteChannel == null) continue block8;
                        clientInfo.mWriteChannel.dispose();
                        clientInfo.mWriteChannel = null;
                        continue block8;
                    }
                    case 4: {
                        try {
                            clientInfo.mClient.onUnbindMethod(clientInfo.mBindingSequence, 3);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        clientInfo.mState = 1;
                        clientInfo.mInputMethodSession = null;
                        clientInfo.mMSInputMethodSession = null;
                        if (clientInfo.mWriteChannel == null) continue block8;
                        clientInfo.mWriteChannel.dispose();
                        clientInfo.mWriteChannel = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dump(FileDescriptor fd, IndentingPrintWriter ipw, String[] args) {
            Object object = this.mLock;
            synchronized (object) {
                int i;
                ipw.println("mState=" + this.mState + ",mCurrentInputMethod=" + this.mCurrentInputMethod + ",mCurrentInputMethodInfo=" + this.mCurrentInputMethodInfo);
                if (this.mCurrentInputMethod != null) {
                    ipw.println(">>Dump CurrentInputMethod>>");
                    ipw.flush();
                    try {
                        TransferPipe.dumpAsync(this.mCurrentInputMethod.asBinder(), fd, args);
                    }
                    catch (RemoteException | IOException e) {
                        ipw.println("Failed to dump input method service: " + e);
                    }
                    ipw.println("<<Dump CurrentInputMethod<<");
                }
                ipw.println("mDisplayIdToImeWindowTokenMap=");
                for (TokenInfo tokenInfo : this.mDisplayIdToImeWindowTokenMap) {
                    ipw.println(" display=" + tokenInfo.mDisplayId + ",token=" + tokenInfo.mToken);
                }
                ipw.println("mClientMap=");
                ipw.increaseIndent();
                for (i = 0; i < this.mClientMap.size(); ++i) {
                    ipw.println("binder=" + this.mClientMap.keyAt(i));
                    ipw.println(" InputMethodClientInfo=");
                    InputMethodClientInfo inputMethodClientInfo = this.mClientMap.valueAt(i);
                    if (inputMethodClientInfo == null) continue;
                    ipw.increaseIndent();
                    inputMethodClientInfo.dumpLocked(fd, ipw, args);
                    ipw.decreaseIndent();
                }
                ipw.decreaseIndent();
                ipw.println("mClientIdToClientMap=");
                ipw.increaseIndent();
                for (i = 0; i < this.mClientIdToClientMap.size(); ++i) {
                    ipw.println("clientId=" + this.mClientIdToClientMap.keyAt(i));
                    ipw.println(" InputMethodClientInfo=");
                    InputMethodClientInfo inputMethodClientInfo = this.mClientIdToClientMap.valueAt(i);
                    if (inputMethodClientInfo != null) {
                        ipw.increaseIndent();
                        inputMethodClientInfo.dumpLocked(fd, ipw, args);
                        ipw.decreaseIndent();
                    }
                    if (inputMethodClientInfo.mClient == null) continue;
                    ipw.println(">>DumpClientStart>>");
                    ipw.flush();
                    try {
                        TransferPipe.dumpAsync(inputMethodClientInfo.mClient.asBinder(), fd, args);
                    }
                    catch (RemoteException | IOException e) {
                        ipw.println(" Failed to dump client:" + e);
                    }
                    ipw.println("<<DumpClientEnd<<");
                }
                ipw.decreaseIndent();
            }
        }

        private static final class ClientDeathRecipient
        implements IBinder.DeathRecipient {
            private final PerUserData mPerUserData;
            private final IInputMethodClient mClient;

            ClientDeathRecipient(PerUserData perUserData, IInputMethodClient client) {
                this.mPerUserData = perUserData;
                this.mClient = client;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                Object object = this.mPerUserData.mLock;
                synchronized (object) {
                    this.mClient.asBinder().unlinkToDeath(this, 0);
                    InputMethodClientInfo clientInfo = this.mPerUserData.removeClientLocked(this.mClient);
                    if (clientInfo == null) {
                        return;
                    }
                    if (clientInfo.mWriteChannel != null) {
                        clientInfo.mWriteChannel.dispose();
                        clientInfo.mWriteChannel = null;
                    }
                    if (clientInfo.mInputMethodSession != null) {
                        try {
                            clientInfo.mInputMethodSession.finishSession();
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        clientInfo.mInputMethodSession = null;
                    }
                    clientInfo.mMSInputMethodSession = null;
                    clientInfo.mState = 5;
                    switch (this.mPerUserData.mState) {
                        case 5: {
                            try {
                                this.mPerUserData.mCurrentInputMethod.removeClient(clientInfo.mClientId);
                                break;
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }

        private static final class OnWorkerThreadServiceConnection
        implements ServiceConnection {
            private final PerUserData mData;
            private final OnWorkerThreadCallback mCallback;

            OnWorkerThreadServiceConnection(PerUserData data, OnWorkerThreadCallback callback) {
                this.mData = data;
                this.mCallback = callback;
            }

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                this.mCallback.onServiceConnected(this.mData, IMultiClientInputMethod.Stub.asInterface(service));
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                this.mCallback.onServiceDisconnected(this.mData);
            }

            @Override
            public void onBindingDied(ComponentName name) {
                this.mCallback.onBindingDied(this.mData);
            }

            Handler getHandler() {
                return this.mCallback.getHandler();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface PerUserState {
        public static final int USER_LOCKED = 1;
        public static final int SERVICE_NOT_QUERIED = 2;
        public static final int SERVICE_RECOGNIZED = 3;
        public static final int WAITING_SERVICE_CONNECTED = 4;
        public static final int SERVICE_CONNECTED = 5;
        public static final int UNBIND_CALLED = 6;
    }

    private static final class TokenInfo {
        final Binder mToken;
        final int mDisplayId;

        TokenInfo(Binder token, int displayId) {
            this.mToken = token;
            this.mDisplayId = displayId;
        }
    }

    private static final class UserDataMap {
        @GuardedBy(value={"mMap"})
        private final SparseArray<PerUserData> mMap = new SparseArray();

        private UserDataMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PerUserData get(int userId) {
            SparseArray<PerUserData> sparseArray = this.mMap;
            synchronized (sparseArray) {
                return this.mMap.get(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(int userId, PerUserData data) {
            SparseArray<PerUserData> sparseArray = this.mMap;
            synchronized (sparseArray) {
                this.mMap.put(userId, data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PerUserData removeReturnOld(int userId) {
            SparseArray<PerUserData> sparseArray = this.mMap;
            synchronized (sparseArray) {
                return this.mMap.removeReturnOld(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dump(FileDescriptor fd, IndentingPrintWriter ipw, String[] args) {
            SparseArray<PerUserData> sparseArray = this.mMap;
            synchronized (sparseArray) {
                for (int i = 0; i < this.mMap.size(); ++i) {
                    int userId = this.mMap.keyAt(i);
                    PerUserData data = this.mMap.valueAt(i);
                    ipw.println("userId=" + userId + ", data=");
                    if (data == null) continue;
                    ipw.increaseIndent();
                    data.dump(fd, ipw, args);
                    ipw.decreaseIndent();
                }
            }
        }
    }

    private static final class InputMethodClientInfo {
        final IInputMethodClient mClient;
        final int mUid;
        final int mPid;
        final int mSelfReportedDisplayId;
        final int mClientId;
        @GuardedBy(value={"PerUserData.mLock"})
        int mState;
        @GuardedBy(value={"PerUserData.mLock"})
        int mBindingSequence;
        @GuardedBy(value={"PerUserData.mLock"})
        InputChannel mWriteChannel;
        @GuardedBy(value={"PerUserData.mLock"})
        IInputMethodSession mInputMethodSession;
        @GuardedBy(value={"PerUserData.mLock"})
        IMultiClientInputMethodSession mMSInputMethodSession;
        @GuardedBy(value={"PerUserData.mLock"})
        final WeakHashMap<IBinder, WindowInfo> mWindowMap = new WeakHashMap();

        InputMethodClientInfo(IInputMethodClient client, int uid, int pid, int selfReportedDisplayId) {
            this.mClient = client;
            this.mUid = uid;
            this.mPid = pid;
            this.mSelfReportedDisplayId = selfReportedDisplayId;
            this.mClientId = InputMethodClientIdSource.getNext();
        }

        @GuardedBy(value={"PerUserData.mLock"})
        void dumpLocked(FileDescriptor fd, IndentingPrintWriter ipw, String[] args) {
            ipw.println("mState=" + this.mState + ",mBindingSequence=" + this.mBindingSequence + ",mWriteChannel=" + this.mWriteChannel + ",mInputMethodSession=" + this.mInputMethodSession + ",mMSInputMethodSession=" + this.mMSInputMethodSession);
        }
    }

    private static final class WindowHandleSource {
        @GuardedBy(value={"WindowHandleSource.class"})
        private static int sNextValue = 0;

        private WindowHandleSource() {
        }

        static synchronized int getNext() {
            int result = sNextValue++;
            if (sNextValue < 0) {
                sNextValue = 0;
            }
            return result;
        }
    }

    private static final class InputMethodClientIdSource {
        @GuardedBy(value={"InputMethodClientIdSource.class"})
        private static int sNextValue = 0;

        private InputMethodClientIdSource() {
        }

        static synchronized int getNext() {
            int result = sNextValue++;
            if (sNextValue < 0) {
                sNextValue = 0;
            }
            return result;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface InputMethodClientState {
        public static final int REGISTERED = 1;
        public static final int WAITING_FOR_IME_SESSION = 2;
        public static final int READY_TO_SEND_FIRST_BIND_RESULT = 3;
        public static final int ALREADY_SENT_BIND_RESULT = 4;
        public static final int UNREGISTERED = 5;
    }

    private static final class WindowInfo {
        final IBinder mWindowToken;
        final int mWindowHandle;

        WindowInfo(IBinder windowToken, int windowCookie) {
            this.mWindowToken = windowToken;
            this.mWindowHandle = windowCookie;
        }
    }

    private static final class OnWorkerThreadCallback {
        private final Context mContext;
        private final UserDataMap mUserDataMap;
        private final UserToInputMethodInfoMap mInputMethodInfoMap;
        private final Handler mHandler;

        OnWorkerThreadCallback(Context context, UserDataMap userDataMap, UserToInputMethodInfoMap inputMethodInfoMap, Handler handler) {
            this.mContext = context;
            this.mUserDataMap = userDataMap;
            this.mInputMethodInfoMap = inputMethodInfoMap;
            this.mHandler = handler;
        }

        Handler getHandler() {
            return this.mHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryBindInputMethodService(int userId) {
            PerUserData data = this.mUserDataMap.get(userId);
            if (data == null) {
                Slog.i(MultiClientInputMethodManagerService.TAG, "tryBindInputMethodService is called for an unknown user=" + userId);
                return;
            }
            InputMethodInfo imi = MultiClientInputMethodManagerService.queryInputMethod(this.mContext, userId, sImeComponentName);
            if (imi == null) {
                Slog.w(MultiClientInputMethodManagerService.TAG, "Multi-client InputMethod is not found. component=" + sImeComponentName);
                Object object = data.mLock;
                synchronized (object) {
                    switch (data.mState) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 6: {
                            this.mInputMethodInfoMap.remove(userId);
                        }
                    }
                }
                return;
            }
            Object object = data.mLock;
            synchronized (object) {
                switch (data.mState) {
                    case 1: {
                        return;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        return;
                    }
                    default: {
                        Slog.wtf(MultiClientInputMethodManagerService.TAG, "Unknown state=" + data.mState);
                        return;
                    }
                }
                data.mState = 3;
                data.mCurrentInputMethodInfo = imi;
                this.mInputMethodInfoMap.put(userId, imi);
                boolean bindResult = data.bindServiceLocked(this.mContext, userId);
                if (!bindResult) {
                    Slog.e(MultiClientInputMethodManagerService.TAG, "Failed to bind Multi-client InputMethod.");
                    return;
                }
                data.mState = 4;
            }
        }

        void onStartUser(int userId) {
            PerUserData data = new PerUserData(userId, null, 1, this);
            this.mUserDataMap.put(userId, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onUnlockUser(int userId) {
            PerUserData data = this.mUserDataMap.get(userId);
            if (data == null) {
                Slog.i(MultiClientInputMethodManagerService.TAG, "onUnlockUser is called for an unknown user=" + userId);
                return;
            }
            Object object = data.mLock;
            synchronized (object) {
                switch (data.mState) {
                    case 1: {
                        data.mState = 2;
                        this.tryBindInputMethodService(userId);
                        break;
                    }
                    default: {
                        Slog.wtf(MultiClientInputMethodManagerService.TAG, "Unknown state=" + data.mState);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onStopUser(int userId) {
            this.mInputMethodInfoMap.remove(userId);
            PerUserData data = this.mUserDataMap.removeReturnOld(userId);
            if (data == null) {
                Slog.i(MultiClientInputMethodManagerService.TAG, "onStopUser is called for an unknown user=" + userId);
                return;
            }
            Object object = data.mLock;
            synchronized (object) {
                switch (data.mState) {
                    case 1: 
                    case 3: 
                    case 6: {
                        return;
                    }
                    case 4: 
                    case 5: {
                        break;
                    }
                    default: {
                        Slog.wtf(MultiClientInputMethodManagerService.TAG, "Unknown state=" + data.mState);
                    }
                }
                data.unbindServiceLocked(this.mContext);
                data.mState = 6;
                data.mCurrentInputMethod = null;
                data.onInputMethodDisconnectedLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onServiceConnected(PerUserData data, IMultiClientInputMethod service) {
            Object object = data.mLock;
            synchronized (object) {
                switch (data.mState) {
                    case 6: {
                        return;
                    }
                    case 4: {
                        data.mState = 5;
                        data.mCurrentInputMethod = service;
                        try {
                            data.mCurrentInputMethod.initialize(new ImeCallbacks(data));
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        data.onInputMethodConnectedLocked();
                        break;
                    }
                    default: {
                        Slog.wtf(MultiClientInputMethodManagerService.TAG, "Unknown state=" + data.mState);
                        return;
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onServiceDisconnected(PerUserData data) {
            WindowManagerInternal windowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
            Object object = data.mLock;
            synchronized (object) {
                int numTokens = data.mDisplayIdToImeWindowTokenMap.size();
                for (int i = 0; i < numTokens; ++i) {
                    TokenInfo info = data.mDisplayIdToImeWindowTokenMap.valueAt(i);
                    windowManagerInternal.removeWindowToken(info.mToken, false, info.mDisplayId);
                }
                data.mDisplayIdToImeWindowTokenMap.clear();
                switch (data.mState) {
                    case 6: {
                        return;
                    }
                    case 4: 
                    case 5: {
                        data.mState = 4;
                        data.mCurrentInputMethod = null;
                        data.onInputMethodDisconnectedLocked();
                        break;
                    }
                    default: {
                        Slog.wtf(MultiClientInputMethodManagerService.TAG, "Unknown state=" + data.mState);
                        return;
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onBindingDied(PerUserData data) {
            WindowManagerInternal windowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
            Object object = data.mLock;
            synchronized (object) {
                int numTokens = data.mDisplayIdToImeWindowTokenMap.size();
                for (int i = 0; i < numTokens; ++i) {
                    TokenInfo info = data.mDisplayIdToImeWindowTokenMap.valueAt(i);
                    windowManagerInternal.removeWindowToken(info.mToken, false, info.mDisplayId);
                }
                data.mDisplayIdToImeWindowTokenMap.clear();
                switch (data.mState) {
                    case 6: {
                        return;
                    }
                    case 4: 
                    case 5: {
                        data.mState = 6;
                        data.mCurrentInputMethod = null;
                        data.onInputMethodDisconnectedLocked();
                        this.mHandler.sendMessageDelayed(PooledLambda.obtainMessage(OnWorkerThreadCallback::tryBindInputMethodService, this, data.mUserId), 1000L);
                        break;
                    }
                    default: {
                        Slog.wtf(MultiClientInputMethodManagerService.TAG, "Unknown state=" + data.mState);
                        return;
                    }
                }
                return;
            }
        }

        void onBootPhase(int phase) {
            switch (phase) {
                case 550: {
                    IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
                    filter.addDataScheme("package");
                    this.mContext.registerReceiver(new BroadcastReceiver(){

                        @Override
                        public void onReceive(Context context, Intent intent) {
                            this.onPackageAdded(intent);
                        }
                    }, filter, null, this.mHandler);
                    break;
                }
                case 1000: {
                    boolean perDisplayFocusEnabled = this.mContext.getResources().getBoolean(0x1110004);
                    if (perDisplayFocusEnabled) break;
                    Bundle extras = new Bundle();
                    extras.putBoolean("android.allowDuringSetup", true);
                    this.mContext.getSystemService(NotificationManager.class).notifyAsUser(MultiClientInputMethodManagerService.TAG, 8, new Notification.Builder(this.mContext, SystemNotificationChannels.VIRTUAL_KEYBOARD).setContentTitle(MultiClientInputMethodManagerService.PER_DISPLAY_FOCUS_DISABLED_WARNING_TITLE).setStyle(new Notification.BigTextStyle().bigText(MultiClientInputMethodManagerService.PER_DISPLAY_FOCUS_DISABLED_WARNING_MSG)).setSmallIcon(17302737).setWhen(0L).setOngoing(true).setLocalOnly(true).addExtras(extras).setCategory("sys").setColor(this.mContext.getColor(17170460)).build(), UserHandle.ALL);
                    break;
                }
            }
        }

        void onPackageAdded(Intent intent) {
            Uri uri = intent.getData();
            if (uri == null) {
                return;
            }
            if (!intent.hasExtra("android.intent.extra.UID")) {
                return;
            }
            String packageName = uri.getSchemeSpecificPart();
            if (sImeComponentName == null || packageName == null || !TextUtils.equals(sImeComponentName.getPackageName(), packageName)) {
                return;
            }
            int userId = UserHandle.getUserId(intent.getIntExtra("android.intent.extra.UID", 0));
            this.tryBindInputMethodService(userId);
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final ApiCallbacks mApiCallbacks;
        private final OnWorkerThreadCallback mOnWorkerThreadCallback;

        public Lifecycle(Context context) {
            super(context);
            final UserToInputMethodInfoMap userIdToInputMethodInfoMapper = new UserToInputMethodInfoMap();
            UserDataMap userDataMap = new UserDataMap();
            HandlerThread workerThread = new HandlerThread(MultiClientInputMethodManagerService.TAG);
            workerThread.start();
            this.mApiCallbacks = new ApiCallbacks(context, userDataMap, userIdToInputMethodInfoMapper);
            this.mOnWorkerThreadCallback = new OnWorkerThreadCallback(context, userDataMap, userIdToInputMethodInfoMapper, new Handler(workerThread.getLooper(), msg -> false, true));
            LocalServices.addService(InputMethodManagerInternal.class, new InputMethodManagerInternal(){

                @Override
                public void setInteractive(boolean interactive) {
                    MultiClientInputMethodManagerService.reportNotSupported();
                }

                @Override
                public void hideCurrentInputMethod() {
                    MultiClientInputMethodManagerService.reportNotSupported();
                }

                @Override
                public List<InputMethodInfo> getInputMethodListAsUser(int userId) {
                    return userIdToInputMethodInfoMapper.getAsList(userId);
                }

                @Override
                public List<InputMethodInfo> getEnabledInputMethodListAsUser(int userId) {
                    return userIdToInputMethodInfoMapper.getAsList(userId);
                }
            });
        }

        @Override
        public void onBootPhase(int phase) {
            this.mOnWorkerThreadCallback.getHandler().sendMessage(PooledLambda.obtainMessage(OnWorkerThreadCallback::onBootPhase, this.mOnWorkerThreadCallback, phase));
        }

        @Override
        public void onStart() {
            this.publishBinderService("input_method", this.mApiCallbacks);
        }

        @Override
        public void onStartUser(int userId) {
            this.mOnWorkerThreadCallback.getHandler().sendMessage(PooledLambda.obtainMessage(OnWorkerThreadCallback::onStartUser, this.mOnWorkerThreadCallback, userId));
        }

        @Override
        public void onUnlockUser(int userId) {
            this.mOnWorkerThreadCallback.getHandler().sendMessage(PooledLambda.obtainMessage(OnWorkerThreadCallback::onUnlockUser, this.mOnWorkerThreadCallback, userId));
        }

        @Override
        public void onStopUser(int userId) {
            this.mOnWorkerThreadCallback.getHandler().sendMessage(PooledLambda.obtainMessage(OnWorkerThreadCallback::onStopUser, this.mOnWorkerThreadCallback, userId));
        }
    }
}

