/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.IActivityManager;
import android.app.UriGrantsManager;
import android.content.ClipData;
import android.content.ContentProvider;
import android.content.Intent;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.server.LocalServices;
import com.android.server.uri.UriGrantsManagerInternal;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class GrantedUriPermissions {
    private final int mGrantFlags;
    private final int mSourceUserId;
    private final String mTag;
    private final IBinder mPermissionOwner;
    private final ArrayList<Uri> mUris = new ArrayList();

    private GrantedUriPermissions(IActivityManager am, int grantFlags, int uid, String tag) throws RemoteException {
        this.mGrantFlags = grantFlags;
        this.mSourceUserId = UserHandle.getUserId(uid);
        this.mTag = tag;
        this.mPermissionOwner = LocalServices.getService(UriGrantsManagerInternal.class).newUriPermissionOwner("job: " + tag);
    }

    public void revoke(IActivityManager am) {
        for (int i = this.mUris.size() - 1; i >= 0; --i) {
            LocalServices.getService(UriGrantsManagerInternal.class).revokeUriPermissionFromOwner(this.mPermissionOwner, this.mUris.get(i), this.mGrantFlags, this.mSourceUserId);
        }
        this.mUris.clear();
    }

    public static boolean checkGrantFlags(int grantFlags) {
        return (grantFlags & 3) != 0;
    }

    public static GrantedUriPermissions createFromIntent(IActivityManager am, Intent intent, int sourceUid, String targetPackage, int targetUserId, String tag) {
        ClipData clip;
        int grantFlags = intent.getFlags();
        if (!GrantedUriPermissions.checkGrantFlags(grantFlags)) {
            return null;
        }
        GrantedUriPermissions perms = null;
        Uri data = intent.getData();
        if (data != null) {
            perms = GrantedUriPermissions.grantUri(am, data, sourceUid, targetPackage, targetUserId, grantFlags, tag, perms);
        }
        if ((clip = intent.getClipData()) != null) {
            perms = GrantedUriPermissions.grantClip(am, clip, sourceUid, targetPackage, targetUserId, grantFlags, tag, perms);
        }
        return perms;
    }

    public static GrantedUriPermissions createFromClip(IActivityManager am, ClipData clip, int sourceUid, String targetPackage, int targetUserId, int grantFlags, String tag) {
        if (!GrantedUriPermissions.checkGrantFlags(grantFlags)) {
            return null;
        }
        GrantedUriPermissions perms = null;
        if (clip != null) {
            perms = GrantedUriPermissions.grantClip(am, clip, sourceUid, targetPackage, targetUserId, grantFlags, tag, perms);
        }
        return perms;
    }

    private static GrantedUriPermissions grantClip(IActivityManager am, ClipData clip, int sourceUid, String targetPackage, int targetUserId, int grantFlags, String tag, GrantedUriPermissions curPerms) {
        int N = clip.getItemCount();
        for (int i = 0; i < N; ++i) {
            curPerms = GrantedUriPermissions.grantItem(am, clip.getItemAt(i), sourceUid, targetPackage, targetUserId, grantFlags, tag, curPerms);
        }
        return curPerms;
    }

    private static GrantedUriPermissions grantUri(IActivityManager am, Uri uri, int sourceUid, String targetPackage, int targetUserId, int grantFlags, String tag, GrantedUriPermissions curPerms) {
        try {
            int sourceUserId = ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid));
            uri = ContentProvider.getUriWithoutUserId(uri);
            if (curPerms == null) {
                curPerms = new GrantedUriPermissions(am, grantFlags, sourceUid, tag);
            }
            UriGrantsManager.getService().grantUriPermissionFromOwner(curPerms.mPermissionOwner, sourceUid, targetPackage, uri, grantFlags, sourceUserId, targetUserId);
            curPerms.mUris.add(uri);
        }
        catch (RemoteException e) {
            Slog.e("JobScheduler", "AM dead");
        }
        return curPerms;
    }

    private static GrantedUriPermissions grantItem(IActivityManager am, ClipData.Item item, int sourceUid, String targetPackage, int targetUserId, int grantFlags, String tag, GrantedUriPermissions curPerms) {
        Intent intent;
        if (item.getUri() != null) {
            curPerms = GrantedUriPermissions.grantUri(am, item.getUri(), sourceUid, targetPackage, targetUserId, grantFlags, tag, curPerms);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            curPerms = GrantedUriPermissions.grantUri(am, intent.getData(), sourceUid, targetPackage, targetUserId, grantFlags, tag, curPerms);
        }
        return curPerms;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mGrantFlags=0x");
        pw.print(Integer.toHexString(this.mGrantFlags));
        pw.print(" mSourceUserId=");
        pw.println(this.mSourceUserId);
        pw.print(prefix);
        pw.print("mTag=");
        pw.println(this.mTag);
        pw.print(prefix);
        pw.print("mPermissionOwner=");
        pw.println(this.mPermissionOwner);
        for (int i = 0; i < this.mUris.size(); ++i) {
            pw.print(prefix);
            pw.print("#");
            pw.print(i);
            pw.print(": ");
            pw.println(this.mUris.get(i));
        }
    }

    public void dump(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, this.mGrantFlags);
        proto.write(1120986464258L, this.mSourceUserId);
        proto.write(1138166333443L, this.mTag);
        proto.write(1138166333444L, this.mPermissionOwner.toString());
        for (int i = 0; i < this.mUris.size(); ++i) {
            Uri u = this.mUris.get(i);
            if (u == null) continue;
            proto.write(2237677961221L, u.toString());
        }
        proto.end(token);
    }
}

