/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.StatLogger;
import com.android.server.job.JobPackageTracker;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.JobServiceContext;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.util.ArrayList;
import java.util.List;

class JobConcurrencyManager {
    private static final String TAG = "JobScheduler";
    private static final boolean DEBUG = JobSchedulerService.DEBUG;
    private final Object mLock;
    private final JobSchedulerService mService;
    private final JobSchedulerService.Constants mConstants;
    private final Context mContext;
    private final Handler mHandler;
    private PowerManager mPowerManager;
    private boolean mCurrentInteractiveState;
    private boolean mEffectiveInteractiveState;
    private long mLastScreenOnRealtime;
    private long mLastScreenOffRealtime;
    private static final int MAX_JOB_CONTEXTS_COUNT = 16;
    JobStatus[] mRecycledAssignContextIdToJobMap = new JobStatus[16];
    boolean[] mRecycledSlotChanged = new boolean[16];
    int[] mRecycledPreferredUidForContext = new int[16];
    private JobSchedulerService.MaxJobCounts mMaxJobCounts;
    private final JobCountTracker mJobCountTracker = new JobCountTracker();
    private int mLastMemoryTrimLevel;
    private long mNextSystemStateRefreshTime;
    private static final int SYSTEM_STATE_REFRESH_MIN_INTERVAL = 1000;
    private final StatLogger mStatLogger = new StatLogger(new String[]{"assignJobsToContexts", "refreshSystemState"});
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.intent.action.SCREEN_ON": {
                    JobConcurrencyManager.this.onInteractiveStateChanged(true);
                    break;
                }
                case "android.intent.action.SCREEN_OFF": {
                    JobConcurrencyManager.this.onInteractiveStateChanged(false);
                }
            }
        }
    };
    private final Runnable mRampUpForScreenOff = this::rampUpForScreenOff;

    JobConcurrencyManager(JobSchedulerService service) {
        this.mService = service;
        this.mLock = this.mService.mLock;
        this.mConstants = service.mConstants;
        this.mContext = service.getContext();
        this.mHandler = BackgroundThread.getHandler();
    }

    public void onSystemReady() {
        this.mPowerManager = this.mContext.getSystemService(PowerManager.class);
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.onInteractiveStateChanged(this.mPowerManager.isInteractive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInteractiveStateChanged(boolean interactive) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentInteractiveState == interactive) {
                return;
            }
            this.mCurrentInteractiveState = interactive;
            if (DEBUG) {
                Slog.d(TAG, "Interactive: " + interactive);
            }
            long nowRealtime = JobSchedulerService.sElapsedRealtimeClock.millis();
            if (interactive) {
                this.mLastScreenOnRealtime = nowRealtime;
                this.mEffectiveInteractiveState = true;
                this.mHandler.removeCallbacks(this.mRampUpForScreenOff);
            } else {
                this.mLastScreenOffRealtime = nowRealtime;
                this.mHandler.postDelayed(this.mRampUpForScreenOff, this.mConstants.SCREEN_OFF_JOB_CONCURRENCY_INCREASE_DELAY_MS.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rampUpForScreenOff() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEffectiveInteractiveState) {
                return;
            }
            if (this.mLastScreenOnRealtime > this.mLastScreenOffRealtime) {
                return;
            }
            long now = JobSchedulerService.sElapsedRealtimeClock.millis();
            if (this.mLastScreenOffRealtime + (long)this.mConstants.SCREEN_OFF_JOB_CONCURRENCY_INCREASE_DELAY_MS.getValue() > now) {
                return;
            }
            this.mEffectiveInteractiveState = false;
            if (DEBUG) {
                Slog.d(TAG, "Ramping up concurrency");
            }
            this.mService.maybeRunPendingJobsLocked();
        }
    }

    private boolean isFgJob(JobStatus job) {
        return job.lastEvaluatedPriority >= 40;
    }

    @GuardedBy(value={"mLock"})
    private void refreshSystemStateLocked() {
        long nowUptime = JobSchedulerService.sUptimeMillisClock.millis();
        if (nowUptime < this.mNextSystemStateRefreshTime) {
            return;
        }
        long start = this.mStatLogger.getTime();
        this.mNextSystemStateRefreshTime = nowUptime + 1000L;
        this.mLastMemoryTrimLevel = 0;
        try {
            this.mLastMemoryTrimLevel = ActivityManager.getService().getMemoryTrimLevel();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mStatLogger.logDurationStat(1, start);
    }

    @GuardedBy(value={"mLock"})
    private void updateMaxCountsLocked() {
        this.refreshSystemStateLocked();
        JobSchedulerService.MaxJobCountsPerMemoryTrimLevel jobCounts = this.mEffectiveInteractiveState ? this.mConstants.MAX_JOB_COUNTS_SCREEN_ON : this.mConstants.MAX_JOB_COUNTS_SCREEN_OFF;
        switch (this.mLastMemoryTrimLevel) {
            case 1: {
                this.mMaxJobCounts = jobCounts.moderate;
                break;
            }
            case 2: {
                this.mMaxJobCounts = jobCounts.low;
                break;
            }
            case 3: {
                this.mMaxJobCounts = jobCounts.critical;
                break;
            }
            default: {
                this.mMaxJobCounts = jobCounts.normal;
            }
        }
    }

    @GuardedBy(value={"mLock"})
    void assignJobsToContextsLocked() {
        long start = this.mStatLogger.getTime();
        this.assignJobsToContextsInternalLocked();
        this.mStatLogger.logDurationStat(0, start);
    }

    @GuardedBy(value={"mLock"})
    private void assignJobsToContextsInternalLocked() {
        int i;
        if (DEBUG) {
            Slog.d(TAG, this.printPendingQueueLocked());
        }
        JobPackageTracker tracker = this.mService.mJobPackageTracker;
        ArrayList<JobStatus> pendingJobs = this.mService.mPendingJobs;
        List<JobServiceContext> activeServices = this.mService.mActiveServices;
        List<StateController> controllers = this.mService.mControllers;
        this.updateMaxCountsLocked();
        JobStatus[] contextIdToJobMap = this.mRecycledAssignContextIdToJobMap;
        boolean[] slotChanged = this.mRecycledSlotChanged;
        int[] preferredUidForContext = this.mRecycledPreferredUidForContext;
        this.mJobCountTracker.reset(this.mMaxJobCounts.getMaxTotal(), this.mMaxJobCounts.getMaxBg(), this.mMaxJobCounts.getMinBg());
        for (i = 0; i < 16; ++i) {
            JobServiceContext js = this.mService.mActiveServices.get(i);
            JobStatus status = js.getRunningJobLocked();
            contextIdToJobMap[i] = status;
            if (contextIdToJobMap[i] != null) {
                this.mJobCountTracker.incrementRunningJobCount(this.isFgJob(status));
            }
            slotChanged[i] = false;
            preferredUidForContext[i] = js.getPreferredUid();
        }
        if (DEBUG) {
            Slog.d(TAG, JobConcurrencyManager.printContextIdToJobMap(contextIdToJobMap, "running jobs initial"));
        }
        for (i = 0; i < pendingJobs.size(); ++i) {
            int priority;
            JobStatus pending = (JobStatus)pendingJobs.get(i);
            int jobRunningContext = JobConcurrencyManager.findJobContextIdFromMap(pending, contextIdToJobMap);
            if (jobRunningContext != -1) continue;
            pending.lastEvaluatedPriority = priority = this.mService.evaluateJobPriorityLocked(pending);
            this.mJobCountTracker.incrementPendingJobCount(this.isFgJob(pending));
        }
        this.mJobCountTracker.onCountDone();
        for (i = 0; i < pendingJobs.size(); ++i) {
            JobStatus nextPending = (JobStatus)pendingJobs.get(i);
            int jobRunningContext = JobConcurrencyManager.findJobContextIdFromMap(nextPending, contextIdToJobMap);
            if (jobRunningContext != -1) continue;
            boolean isPendingFg = this.isFgJob(nextPending);
            int minPriorityForPreemption = Integer.MAX_VALUE;
            int selectedContextId = -1;
            boolean startingJob = false;
            for (int j = 0; j < 16; ++j) {
                int jobPriority;
                JobStatus job = contextIdToJobMap[j];
                int preferredUid = preferredUidForContext[j];
                if (job == null) {
                    boolean preferredUidOkay;
                    boolean bl = preferredUidOkay = preferredUid == nextPending.getUid() || preferredUid == -1;
                    if (!preferredUidOkay || !this.mJobCountTracker.canJobStart(isPendingFg)) continue;
                    selectedContextId = j;
                    startingJob = true;
                    break;
                }
                if (job.getUid() != nextPending.getUid() || (jobPriority = this.mService.evaluateJobPriorityLocked(job)) >= nextPending.lastEvaluatedPriority || minPriorityForPreemption <= nextPending.lastEvaluatedPriority) continue;
                minPriorityForPreemption = nextPending.lastEvaluatedPriority;
                selectedContextId = j;
            }
            if (selectedContextId != -1) {
                contextIdToJobMap[selectedContextId] = nextPending;
                slotChanged[selectedContextId] = true;
            }
            if (!startingJob) continue;
            this.mJobCountTracker.onStartingNewJob(isPendingFg);
        }
        if (DEBUG) {
            Slog.d(TAG, JobConcurrencyManager.printContextIdToJobMap(contextIdToJobMap, "running jobs final"));
        }
        this.mJobCountTracker.logStatus();
        tracker.noteConcurrency(this.mJobCountTracker.getTotalRunningJobCountToNote(), this.mJobCountTracker.getFgRunningJobCountToNote());
        for (i = 0; i < 16; ++i) {
            boolean preservePreferredUid = false;
            if (slotChanged[i]) {
                JobStatus js = activeServices.get(i).getRunningJobLocked();
                if (js != null) {
                    if (DEBUG) {
                        Slog.d(TAG, "preempting job: " + activeServices.get(i).getRunningJobLocked());
                    }
                    activeServices.get(i).preemptExecutingJobLocked();
                    preservePreferredUid = true;
                } else {
                    JobStatus pendingJob = contextIdToJobMap[i];
                    if (DEBUG) {
                        Slog.d(TAG, "About to run job on context " + i + ", job: " + pendingJob);
                    }
                    for (int ic = 0; ic < controllers.size(); ++ic) {
                        controllers.get(ic).prepareForExecutionLocked(pendingJob);
                    }
                    if (!activeServices.get(i).executeRunnableJob(pendingJob)) {
                        Slog.d(TAG, "Error executing " + pendingJob);
                    }
                    if (pendingJobs.remove(pendingJob)) {
                        tracker.noteNonpending(pendingJob);
                    }
                }
            }
            if (preservePreferredUid) continue;
            activeServices.get(i).clearPreferredUid();
        }
    }

    private static int findJobContextIdFromMap(JobStatus jobStatus, JobStatus[] map) {
        for (int i = 0; i < map.length; ++i) {
            if (map[i] == null || !map[i].matches(jobStatus.getUid(), jobStatus.getJobId())) continue;
            return i;
        }
        return -1;
    }

    @GuardedBy(value={"mLock"})
    private String printPendingQueueLocked() {
        StringBuilder s = new StringBuilder("Pending queue: ");
        for (JobStatus js : this.mService.mPendingJobs) {
            s.append("(").append(js.getJob().getId()).append(", ").append(js.getUid()).append(") ");
        }
        return s.toString();
    }

    private static String printContextIdToJobMap(JobStatus[] map, String initial) {
        StringBuilder s = new StringBuilder(initial + ": ");
        for (int i = 0; i < map.length; ++i) {
            s.append("(").append(map[i] == null ? -1 : map[i].getJobId()).append(map[i] == null ? -1 : map[i].getUid()).append(")");
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLocked(IndentingPrintWriter pw, long now, long nowRealtime) {
        pw.println("Concurrency:");
        pw.increaseIndent();
        try {
            pw.print("Screen state: current ");
            pw.print(this.mCurrentInteractiveState ? "ON" : "OFF");
            pw.print("  effective ");
            pw.print(this.mEffectiveInteractiveState ? "ON" : "OFF");
            pw.println();
            pw.print("Last screen ON : ");
            TimeUtils.dumpTimeWithDelta(pw, now - nowRealtime + this.mLastScreenOnRealtime, now);
            pw.println();
            pw.print("Last screen OFF: ");
            TimeUtils.dumpTimeWithDelta(pw, now - nowRealtime + this.mLastScreenOffRealtime, now);
            pw.println();
            pw.println();
            pw.println("Current max jobs:");
            pw.println("  ");
            pw.println(this.mJobCountTracker);
            pw.println();
            pw.print("mLastMemoryTrimLevel: ");
            pw.print(this.mLastMemoryTrimLevel);
            pw.println();
            this.mStatLogger.dump(pw);
        }
        finally {
            pw.decreaseIndent();
        }
    }

    public void dumpProtoLocked(ProtoOutputStream proto, long tag, long now, long nowRealtime) {
        long token = proto.start(tag);
        proto.write(0x10800000001L, this.mCurrentInteractiveState);
        proto.write(1133871366146L, this.mEffectiveInteractiveState);
        proto.write(0x10300000003L, nowRealtime - this.mLastScreenOnRealtime);
        proto.write(1112396529668L, nowRealtime - this.mLastScreenOffRealtime);
        this.mJobCountTracker.dumpProto(proto, 1146756268037L);
        proto.write(1120986464262L, this.mLastMemoryTrimLevel);
        proto.end(token);
    }

    @VisibleForTesting
    static class JobCountTracker {
        private int mConfigNumMaxTotalJobs;
        private int mConfigNumMaxBgJobs;
        private int mConfigNumMinBgJobs;
        private int mNumRunningFgJobs;
        private int mNumRunningBgJobs;
        private int mNumPendingFgJobs;
        private int mNumPendingBgJobs;
        private int mNumStartingFgJobs;
        private int mNumStartingBgJobs;
        private int mNumReservedForBg;
        private int mNumActualMaxFgJobs;
        private int mNumActualMaxBgJobs;

        JobCountTracker() {
        }

        void reset(int numTotalMaxJobs, int numMaxBgJobs, int numMinBgJobs) {
            this.mConfigNumMaxTotalJobs = numTotalMaxJobs;
            this.mConfigNumMaxBgJobs = numMaxBgJobs;
            this.mConfigNumMinBgJobs = numMinBgJobs;
            this.mNumRunningFgJobs = 0;
            this.mNumRunningBgJobs = 0;
            this.mNumPendingFgJobs = 0;
            this.mNumPendingBgJobs = 0;
            this.mNumStartingFgJobs = 0;
            this.mNumStartingBgJobs = 0;
            this.mNumReservedForBg = 0;
            this.mNumActualMaxFgJobs = 0;
            this.mNumActualMaxBgJobs = 0;
        }

        void incrementRunningJobCount(boolean isFg) {
            if (isFg) {
                ++this.mNumRunningFgJobs;
            } else {
                ++this.mNumRunningBgJobs;
            }
        }

        void incrementPendingJobCount(boolean isFg) {
            if (isFg) {
                ++this.mNumPendingFgJobs;
            } else {
                ++this.mNumPendingBgJobs;
            }
        }

        void onStartingNewJob(boolean isFg) {
            if (isFg) {
                ++this.mNumStartingFgJobs;
            } else {
                ++this.mNumStartingBgJobs;
            }
        }

        void onCountDone() {
            int reservedForBg = Math.min(this.mConfigNumMinBgJobs, this.mNumRunningBgJobs + this.mNumPendingBgJobs);
            this.mNumReservedForBg = Math.min(reservedForBg, this.mConfigNumMaxTotalJobs - this.mNumRunningFgJobs);
            int maxFg = this.mConfigNumMaxTotalJobs - Math.max(this.mNumRunningBgJobs, this.mNumReservedForBg);
            this.mNumActualMaxFgJobs = Math.min(maxFg, this.mNumRunningFgJobs + this.mNumPendingFgJobs);
            int maxBg = Math.min(this.mConfigNumMaxBgJobs, this.mConfigNumMaxTotalJobs - this.mNumActualMaxFgJobs);
            this.mNumActualMaxBgJobs = Math.min(maxBg, this.mNumRunningBgJobs + this.mNumPendingBgJobs);
        }

        boolean canJobStart(boolean isFg) {
            if (isFg) {
                return this.mNumRunningFgJobs + this.mNumStartingFgJobs < this.mNumActualMaxFgJobs;
            }
            return this.mNumRunningBgJobs + this.mNumStartingBgJobs < this.mNumActualMaxBgJobs;
        }

        public int getNumStartingFgJobs() {
            return this.mNumStartingFgJobs;
        }

        public int getNumStartingBgJobs() {
            return this.mNumStartingBgJobs;
        }

        int getTotalRunningJobCountToNote() {
            return this.mNumRunningFgJobs + this.mNumRunningBgJobs + this.mNumStartingFgJobs + this.mNumStartingBgJobs;
        }

        int getFgRunningJobCountToNote() {
            return this.mNumRunningFgJobs + this.mNumStartingFgJobs;
        }

        void logStatus() {
            if (DEBUG) {
                Slog.d(JobConcurrencyManager.TAG, "assignJobsToContexts: " + this);
            }
        }

        public String toString() {
            int totalFg = this.mNumRunningFgJobs + this.mNumStartingFgJobs;
            int totalBg = this.mNumRunningBgJobs + this.mNumStartingBgJobs;
            return String.format("Config={tot=%d bg min/max=%d/%d} Running[FG/BG (total)]: %d / %d (%d) Pending: %d / %d (%d) Actual max: %d%s / %d%s (%d%s) Res BG: %d Starting: %d / %d (%d) Total: %d%s / %d%s (%d%s)", this.mConfigNumMaxTotalJobs, this.mConfigNumMinBgJobs, this.mConfigNumMaxBgJobs, this.mNumRunningFgJobs, this.mNumRunningBgJobs, this.mNumRunningFgJobs + this.mNumRunningBgJobs, this.mNumPendingFgJobs, this.mNumPendingBgJobs, this.mNumPendingFgJobs + this.mNumPendingBgJobs, this.mNumActualMaxFgJobs, totalFg <= this.mConfigNumMaxTotalJobs ? "" : "*", this.mNumActualMaxBgJobs, totalBg <= this.mConfigNumMaxBgJobs ? "" : "*", this.mNumActualMaxFgJobs + this.mNumActualMaxBgJobs, this.mNumActualMaxFgJobs + this.mNumActualMaxBgJobs <= this.mConfigNumMaxTotalJobs ? "" : "*", this.mNumReservedForBg, this.mNumStartingFgJobs, this.mNumStartingBgJobs, this.mNumStartingFgJobs + this.mNumStartingBgJobs, totalFg, totalFg <= this.mNumActualMaxFgJobs ? "" : "*", totalBg, totalBg <= this.mNumActualMaxBgJobs ? "" : "*", totalFg + totalBg, totalFg + totalBg <= this.mConfigNumMaxTotalJobs ? "" : "*");
        }

        public void dumpProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.mConfigNumMaxTotalJobs);
            proto.write(1120986464258L, this.mConfigNumMaxBgJobs);
            proto.write(1120986464259L, this.mConfigNumMinBgJobs);
            proto.write(1120986464260L, this.mNumRunningFgJobs);
            proto.write(0x10500000005L, this.mNumRunningBgJobs);
            proto.write(1120986464262L, this.mNumPendingFgJobs);
            proto.write(1120986464263L, this.mNumPendingBgJobs);
            proto.end(token);
        }
    }

    static interface Stats {
        public static final int ASSIGN_JOBS_TO_CONTEXTS = 0;
        public static final int REFRESH_SYSTEM_STATE = 1;
        public static final int COUNT = 2;
    }
}

