/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.ActivityManager;
import android.app.job.IJobCallback;
import android.app.job.IJobService;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobWorkItem;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.EventLog;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.server.LocalServices;
import com.android.server.job.JobCompletedListener;
import com.android.server.job.JobPackageTracker;
import com.android.server.job.JobSchedulerInternal;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;

public final class JobServiceContext
implements ServiceConnection {
    private static final boolean DEBUG = JobSchedulerService.DEBUG;
    private static final boolean DEBUG_STANDBY = JobSchedulerService.DEBUG_STANDBY;
    private static final String TAG = "JobServiceContext";
    public static final long EXECUTING_TIMESLICE_MILLIS = 600000L;
    private static final long OP_BIND_TIMEOUT_MILLIS = 18000L;
    private static final long OP_TIMEOUT_MILLIS = 8000L;
    private static final String[] VERB_STRINGS = new String[]{"VERB_BINDING", "VERB_STARTING", "VERB_EXECUTING", "VERB_STOPPING", "VERB_FINISHED"};
    static final int VERB_BINDING = 0;
    static final int VERB_STARTING = 1;
    static final int VERB_EXECUTING = 2;
    static final int VERB_STOPPING = 3;
    static final int VERB_FINISHED = 4;
    private static final int MSG_TIMEOUT = 0;
    public static final int NO_PREFERRED_UID = -1;
    private final Handler mCallbackHandler;
    private final JobCompletedListener mCompletedListener;
    private final Context mContext;
    private final Object mLock;
    private final IBatteryStats mBatteryStats;
    private final JobPackageTracker mJobPackageTracker;
    private PowerManager.WakeLock mWakeLock;
    private JobParameters mParams;
    @VisibleForTesting
    int mVerb;
    private boolean mCancelled;
    private JobStatus mRunningJob;
    private JobCallback mRunningCallback;
    private int mPreferredUid;
    IJobService service;
    @GuardedBy(value={"mLock"})
    private boolean mAvailable;
    private long mExecutionStartTimeElapsed;
    private long mTimeoutElapsed;
    public String mStoppedReason;
    public long mStoppedTime;

    JobServiceContext(JobSchedulerService service, IBatteryStats batteryStats, JobPackageTracker tracker, Looper looper) {
        this(service.getContext(), service.getLock(), batteryStats, tracker, service, looper);
    }

    @VisibleForTesting
    JobServiceContext(Context context, Object lock, IBatteryStats batteryStats, JobPackageTracker tracker, JobCompletedListener completedListener, Looper looper) {
        this.mContext = context;
        this.mLock = lock;
        this.mBatteryStats = batteryStats;
        this.mJobPackageTracker = tracker;
        this.mCallbackHandler = new JobServiceHandler(looper);
        this.mCompletedListener = completedListener;
        this.mAvailable = true;
        this.mVerb = 4;
        this.mPreferredUid = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeRunnableJob(JobStatus job) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAvailable) {
                Slog.e(TAG, "Starting new runnable but context is unavailable > Error.");
                return false;
            }
            this.mPreferredUid = -1;
            this.mRunningJob = job;
            this.mRunningCallback = new JobCallback();
            boolean isDeadlineExpired = job.hasDeadlineConstraint() && job.getLatestRunTimeElapsed() < JobSchedulerService.sElapsedRealtimeClock.millis();
            Uri[] triggeredUris = null;
            if (job.changedUris != null) {
                triggeredUris = new Uri[job.changedUris.size()];
                job.changedUris.toArray(triggeredUris);
            }
            String[] triggeredAuthorities = null;
            if (job.changedAuthorities != null) {
                triggeredAuthorities = new String[job.changedAuthorities.size()];
                job.changedAuthorities.toArray(triggeredAuthorities);
            }
            JobInfo ji = job.getJob();
            this.mParams = new JobParameters(this.mRunningCallback, job.getJobId(), ji.getExtras(), ji.getTransientExtras(), ji.getClipData(), ji.getClipGrantFlags(), isDeadlineExpired, triggeredUris, triggeredAuthorities, job.network);
            this.mExecutionStartTimeElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
            long whenDeferred = job.getWhenStandbyDeferred();
            if (whenDeferred > 0L) {
                long deferral = this.mExecutionStartTimeElapsed - whenDeferred;
                EventLog.writeEvent(8000, deferral);
                if (DEBUG_STANDBY) {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("Starting job deferred for standby by ");
                    TimeUtils.formatDuration(deferral, sb);
                    sb.append(" ms : ");
                    sb.append(job.toShortString());
                    Slog.v(TAG, sb.toString());
                }
            }
            job.clearPersistedUtcTimes();
            this.mVerb = 0;
            this.scheduleOpTimeOutLocked();
            Intent intent = new Intent().setComponent(job.getServiceComponent());
            boolean binding = false;
            try {
                binding = this.mContext.bindServiceAsUser(intent, this, 261, new UserHandle(job.getUserId()));
            }
            catch (SecurityException e) {
                Slog.w(TAG, "Job service " + job.getServiceComponent().getShortClassName() + " cannot be executed: " + e.getMessage());
                binding = false;
            }
            if (!binding) {
                if (DEBUG) {
                    Slog.d(TAG, job.getServiceComponent().getShortClassName() + " unavailable.");
                }
                this.mRunningJob = null;
                this.mRunningCallback = null;
                this.mParams = null;
                this.mExecutionStartTimeElapsed = 0L;
                this.mVerb = 4;
                this.removeOpTimeOutLocked();
                return false;
            }
            this.mJobPackageTracker.noteActive(job);
            try {
                this.mBatteryStats.noteJobStart(job.getBatteryName(), job.getSourceUid(), job.getStandbyBucket(), job.getJobId());
            }
            catch (RemoteException e) {
                // empty catch block
            }
            String jobPackage = job.getSourcePackageName();
            int jobUserId = job.getSourceUserId();
            UsageStatsManagerInternal usageStats = LocalServices.getService(UsageStatsManagerInternal.class);
            usageStats.setLastJobRunTime(jobPackage, jobUserId, this.mExecutionStartTimeElapsed);
            JobSchedulerInternal jobScheduler = LocalServices.getService(JobSchedulerInternal.class);
            jobScheduler.noteJobStart(jobPackage, jobUserId);
            this.mAvailable = false;
            this.mStoppedReason = null;
            this.mStoppedTime = 0L;
            return true;
        }
    }

    JobStatus getRunningJobLocked() {
        return this.mRunningJob;
    }

    private String getRunningJobNameLocked() {
        return this.mRunningJob != null ? this.mRunningJob.toShortString() : "<null>";
    }

    @GuardedBy(value={"mLock"})
    void cancelExecutingJobLocked(int reason, String debugReason) {
        this.doCancelLocked(reason, debugReason);
    }

    @GuardedBy(value={"mLock"})
    void preemptExecutingJobLocked() {
        this.doCancelLocked(2, "cancelled due to preemption");
    }

    int getPreferredUid() {
        return this.mPreferredUid;
    }

    void clearPreferredUid() {
        this.mPreferredUid = -1;
    }

    long getExecutionStartTimeElapsed() {
        return this.mExecutionStartTimeElapsed;
    }

    long getTimeoutElapsed() {
        return this.mTimeoutElapsed;
    }

    @GuardedBy(value={"mLock"})
    boolean timeoutIfExecutingLocked(String pkgName, int userId, boolean matchJobId, int jobId, String reason) {
        JobStatus executing = this.getRunningJobLocked();
        if (!(executing == null || userId != -1 && userId != executing.getUserId() || pkgName != null && !pkgName.equals(executing.getSourcePackageName()) || matchJobId && jobId != executing.getJobId() || this.mVerb != 2)) {
            this.mParams.setStopReason(3, reason);
            this.sendStopMessageLocked("force timeout from shell");
            return true;
        }
        return false;
    }

    void doJobFinished(JobCallback cb, int jobId, boolean reschedule) {
        this.doCallback(cb, reschedule, "app called jobFinished");
    }

    void doAcknowledgeStopMessage(JobCallback cb, int jobId, boolean reschedule) {
        this.doCallback(cb, reschedule, null);
    }

    void doAcknowledgeStartMessage(JobCallback cb, int jobId, boolean ongoing) {
        this.doCallback(cb, ongoing, "finished start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    JobWorkItem doDequeueWork(JobCallback cb, int jobId) {
        long ident;
        block7: {
            JobWorkItem jobWorkItem;
            ident = Binder.clearCallingIdentity();
            try {
                Object object = this.mLock;
                // MONITORENTER : object
                this.assertCallerLocked(cb);
                if (this.mVerb != 3 && this.mVerb != 4) break block7;
                jobWorkItem = null;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return jobWorkItem;
        }
        JobWorkItem work = this.mRunningJob.dequeueWorkLocked();
        if (work == null && !this.mRunningJob.hasExecutingWorkLocked()) {
            this.doCallbackLocked(false, "last work dequeued");
        }
        JobWorkItem jobWorkItem = work;
        // MONITOREXIT : object
        Binder.restoreCallingIdentity(ident);
        return jobWorkItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCompleteWork(JobCallback cb, int jobId, int workId) {
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.assertCallerLocked(cb);
                boolean bl = this.mRunningJob.completeWorkLocked(ActivityManager.getService(), workId);
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.mLock;
        synchronized (object) {
            JobStatus runningJob = this.mRunningJob;
            if (runningJob == null || !name.equals(runningJob.getServiceComponent())) {
                this.closeAndCleanupJobLocked(true, "connected for different component");
                return;
            }
            this.service = IJobService.Stub.asInterface(service);
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, runningJob.getTag());
            wl.setWorkSource(this.deriveWorkSource(runningJob));
            wl.setReferenceCounted(false);
            wl.acquire();
            if (this.mWakeLock != null) {
                Slog.w(TAG, "Bound new job " + runningJob + " but live wakelock " + this.mWakeLock + " tag=" + this.mWakeLock.getTag());
                this.mWakeLock.release();
            }
            this.mWakeLock = wl;
            this.doServiceBoundLocked();
        }
    }

    private WorkSource deriveWorkSource(JobStatus runningJob) {
        int jobUid = runningJob.getSourceUid();
        if (WorkSource.isChainedBatteryAttributionEnabled(this.mContext)) {
            WorkSource workSource = new WorkSource();
            workSource.createWorkChain().addNode(jobUid, null).addNode(1000, "JobScheduler");
            return workSource;
        }
        return new WorkSource(jobUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName name) {
        Object object = this.mLock;
        synchronized (object) {
            this.closeAndCleanupJobLocked(true, "unexpectedly disconnected");
        }
    }

    private boolean verifyCallerLocked(JobCallback cb) {
        if (this.mRunningCallback != cb) {
            if (DEBUG) {
                Slog.d(TAG, "Stale callback received, ignoring.");
            }
            return false;
        }
        return true;
    }

    private void assertCallerLocked(JobCallback cb) {
        if (!this.verifyCallerLocked(cb)) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Caller no longer running");
            if (cb.mStoppedReason != null) {
                sb.append(", last stopped ");
                TimeUtils.formatDuration(JobSchedulerService.sElapsedRealtimeClock.millis() - cb.mStoppedTime, sb);
                sb.append(" because: ");
                sb.append(cb.mStoppedReason);
            }
            throw new SecurityException(sb.toString());
        }
    }

    @GuardedBy(value={"mLock"})
    void doServiceBoundLocked() {
        this.removeOpTimeOutLocked();
        this.handleServiceBoundLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCallback(JobCallback cb, boolean reschedule, String reason) {
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                block8: {
                    if (this.verifyCallerLocked(cb)) break block8;
                    return;
                }
                this.doCallbackLocked(reschedule, reason);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @GuardedBy(value={"mLock"})
    void doCallbackLocked(boolean reschedule, String reason) {
        if (DEBUG) {
            Slog.d(TAG, "doCallback of : " + this.mRunningJob + " v:" + VERB_STRINGS[this.mVerb]);
        }
        this.removeOpTimeOutLocked();
        if (this.mVerb == 1) {
            this.handleStartedLocked(reschedule);
        } else if (this.mVerb == 2 || this.mVerb == 3) {
            this.handleFinishedLocked(reschedule, reason);
        } else if (DEBUG) {
            Slog.d(TAG, "Unrecognised callback: " + this.mRunningJob);
        }
    }

    @GuardedBy(value={"mLock"})
    void doCancelLocked(int arg1, String debugReason) {
        if (this.mVerb == 4) {
            if (DEBUG) {
                Slog.d(TAG, "Trying to process cancel for torn-down context, ignoring.");
            }
            return;
        }
        this.mParams.setStopReason(arg1, debugReason);
        if (arg1 == 2) {
            this.mPreferredUid = this.mRunningJob != null ? this.mRunningJob.getUid() : -1;
        }
        this.handleCancelLocked(debugReason);
    }

    @GuardedBy(value={"mLock"})
    private void handleServiceBoundLocked() {
        if (DEBUG) {
            Slog.d(TAG, "handleServiceBound for " + this.getRunningJobNameLocked());
        }
        if (this.mVerb != 0) {
            Slog.e(TAG, "Sending onStartJob for a job that isn't pending. " + VERB_STRINGS[this.mVerb]);
            this.closeAndCleanupJobLocked(false, "started job not pending");
            return;
        }
        if (this.mCancelled) {
            if (DEBUG) {
                Slog.d(TAG, "Job cancelled while waiting for bind to complete. " + this.mRunningJob);
            }
            this.closeAndCleanupJobLocked(true, "cancelled while waiting for bind");
            return;
        }
        try {
            this.mVerb = 1;
            this.scheduleOpTimeOutLocked();
            this.service.startJob(this.mParams);
        }
        catch (Exception e) {
            Slog.e(TAG, "Error sending onStart message to '" + this.mRunningJob.getServiceComponent().getShortClassName() + "' ", e);
        }
    }

    @GuardedBy(value={"mLock"})
    private void handleStartedLocked(boolean workOngoing) {
        switch (this.mVerb) {
            case 1: {
                this.mVerb = 2;
                if (!workOngoing) {
                    this.handleFinishedLocked(false, "onStartJob returned false");
                    return;
                }
                if (this.mCancelled) {
                    if (DEBUG) {
                        Slog.d(TAG, "Job cancelled while waiting for onStartJob to complete.");
                    }
                    this.handleCancelLocked(null);
                    return;
                }
                this.scheduleOpTimeOutLocked();
                break;
            }
            default: {
                Slog.e(TAG, "Handling started job but job wasn't starting! Was " + VERB_STRINGS[this.mVerb] + ".");
                return;
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void handleFinishedLocked(boolean reschedule, String reason) {
        switch (this.mVerb) {
            case 2: 
            case 3: {
                this.closeAndCleanupJobLocked(reschedule, reason);
                break;
            }
            default: {
                Slog.e(TAG, "Got an execution complete message for a job that wasn't beingexecuted. Was " + VERB_STRINGS[this.mVerb] + ".");
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void handleCancelLocked(String reason) {
        if (JobSchedulerService.DEBUG) {
            Slog.d(TAG, "Handling cancel for: " + this.mRunningJob.getJobId() + " " + VERB_STRINGS[this.mVerb]);
        }
        switch (this.mVerb) {
            case 0: 
            case 1: {
                this.mCancelled = true;
                this.applyStoppedReasonLocked(reason);
                break;
            }
            case 2: {
                this.sendStopMessageLocked(reason);
                break;
            }
            case 3: {
                break;
            }
            default: {
                Slog.e(TAG, "Cancelling a job without a valid verb: " + this.mVerb);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void handleOpTimeoutLocked() {
        switch (this.mVerb) {
            case 0: {
                Slog.w(TAG, "Time-out while trying to bind " + this.getRunningJobNameLocked() + ", dropping.");
                this.closeAndCleanupJobLocked(false, "timed out while binding");
                break;
            }
            case 1: {
                Slog.w(TAG, "No response from client for onStartJob " + this.getRunningJobNameLocked());
                this.closeAndCleanupJobLocked(false, "timed out while starting");
                break;
            }
            case 3: {
                Slog.w(TAG, "No response from client for onStopJob " + this.getRunningJobNameLocked());
                this.closeAndCleanupJobLocked(true, "timed out while stopping");
                break;
            }
            case 2: {
                Slog.i(TAG, "Client timed out while executing (no jobFinished received), sending onStop: " + this.getRunningJobNameLocked());
                this.mParams.setStopReason(3, "client timed out");
                this.sendStopMessageLocked("timeout while executing");
                break;
            }
            default: {
                Slog.e(TAG, "Handling timeout for an invalid job state: " + this.getRunningJobNameLocked() + ", dropping.");
                this.closeAndCleanupJobLocked(false, "invalid timeout");
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void sendStopMessageLocked(String reason) {
        this.removeOpTimeOutLocked();
        if (this.mVerb != 2) {
            Slog.e(TAG, "Sending onStopJob for a job that isn't started. " + this.mRunningJob);
            this.closeAndCleanupJobLocked(false, reason);
            return;
        }
        try {
            this.applyStoppedReasonLocked(reason);
            this.mVerb = 3;
            this.scheduleOpTimeOutLocked();
            this.service.stopJob(this.mParams);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error sending onStopJob to client.", e);
            this.closeAndCleanupJobLocked(true, "host crashed when trying to stop");
        }
    }

    @GuardedBy(value={"mLock"})
    private void closeAndCleanupJobLocked(boolean reschedule, String reason) {
        if (this.mVerb == 4) {
            return;
        }
        this.applyStoppedReasonLocked(reason);
        JobStatus completedJob = this.mRunningJob;
        this.mJobPackageTracker.noteInactive(completedJob, this.mParams.getStopReason(), reason);
        try {
            this.mBatteryStats.noteJobFinish(this.mRunningJob.getBatteryName(), this.mRunningJob.getSourceUid(), this.mParams.getStopReason(), this.mRunningJob.getStandbyBucket(), this.mRunningJob.getJobId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
        }
        this.mContext.unbindService(this);
        this.mWakeLock = null;
        this.mRunningJob = null;
        this.mRunningCallback = null;
        this.mParams = null;
        this.mVerb = 4;
        this.mCancelled = false;
        this.service = null;
        this.mAvailable = true;
        this.removeOpTimeOutLocked();
        this.mCompletedListener.onJobCompletedLocked(completedJob, reschedule);
    }

    private void applyStoppedReasonLocked(String reason) {
        if (reason != null && this.mStoppedReason == null) {
            this.mStoppedReason = reason;
            this.mStoppedTime = JobSchedulerService.sElapsedRealtimeClock.millis();
            if (this.mRunningCallback != null) {
                this.mRunningCallback.mStoppedReason = this.mStoppedReason;
                this.mRunningCallback.mStoppedTime = this.mStoppedTime;
            }
        }
    }

    private void scheduleOpTimeOutLocked() {
        long timeoutMillis;
        this.removeOpTimeOutLocked();
        switch (this.mVerb) {
            case 2: {
                timeoutMillis = 600000L;
                break;
            }
            case 0: {
                timeoutMillis = 18000L;
                break;
            }
            default: {
                timeoutMillis = 8000L;
            }
        }
        if (DEBUG) {
            Slog.d(TAG, "Scheduling time out for '" + this.mRunningJob.getServiceComponent().getShortClassName() + "' jId: " + this.mParams.getJobId() + ", in " + timeoutMillis / 1000L + " s");
        }
        Message m = this.mCallbackHandler.obtainMessage(0, this.mRunningCallback);
        this.mCallbackHandler.sendMessageDelayed(m, timeoutMillis);
        this.mTimeoutElapsed = JobSchedulerService.sElapsedRealtimeClock.millis() + timeoutMillis;
    }

    private void removeOpTimeOutLocked() {
        this.mCallbackHandler.removeMessages(0);
    }

    private class JobServiceHandler
    extends Handler {
        JobServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    Object object = JobServiceContext.this.mLock;
                    synchronized (object) {
                        if (message.obj == JobServiceContext.this.mRunningCallback) {
                            JobServiceContext.this.handleOpTimeoutLocked();
                        } else {
                            JobCallback jc = (JobCallback)message.obj;
                            StringBuilder sb = new StringBuilder(128);
                            sb.append("Ignoring timeout of no longer active job");
                            if (jc.mStoppedReason != null) {
                                sb.append(", stopped ");
                                TimeUtils.formatDuration(JobSchedulerService.sElapsedRealtimeClock.millis() - jc.mStoppedTime, sb);
                                sb.append(" because: ");
                                sb.append(jc.mStoppedReason);
                            }
                            Slog.w(JobServiceContext.TAG, sb.toString());
                        }
                        break;
                    }
                }
                default: {
                    Slog.e(JobServiceContext.TAG, "Unrecognised message: " + message);
                }
            }
        }
    }

    final class JobCallback
    extends IJobCallback.Stub {
        public String mStoppedReason;
        public long mStoppedTime;

        JobCallback() {
        }

        @Override
        public void acknowledgeStartMessage(int jobId, boolean ongoing) {
            JobServiceContext.this.doAcknowledgeStartMessage(this, jobId, ongoing);
        }

        @Override
        public void acknowledgeStopMessage(int jobId, boolean reschedule) {
            JobServiceContext.this.doAcknowledgeStopMessage(this, jobId, reschedule);
        }

        @Override
        public JobWorkItem dequeueWork(int jobId) {
            return JobServiceContext.this.doDequeueWork(this, jobId);
        }

        @Override
        public boolean completeWork(int jobId, int workId) {
            return JobServiceContext.this.doCompleteWork(this, jobId, workId);
        }

        @Override
        public void jobFinished(int jobId, boolean reschedule) {
            JobServiceContext.this.doJobFinished(this, jobId, reschedule);
        }
    }
}

