/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.AppStateTracker;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.JobStore;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class BackgroundJobsController
extends StateController {
    private static final String TAG = "JobScheduler.Background";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.Background", 3);
    static final int UNKNOWN = 0;
    static final int KNOWN_ACTIVE = 1;
    static final int KNOWN_INACTIVE = 2;
    private final AppStateTracker mAppStateTracker;
    private final AppStateTracker.Listener mForceAppStandbyListener = new AppStateTracker.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateAllJobs() {
            Object object = BackgroundJobsController.this.mLock;
            synchronized (object) {
                BackgroundJobsController.this.updateAllJobRestrictionsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateJobsForUid(int uid, boolean isActive) {
            Object object = BackgroundJobsController.this.mLock;
            synchronized (object) {
                BackgroundJobsController.this.updateJobRestrictionsForUidLocked(uid, isActive);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateJobsForUidPackage(int uid, String packageName, boolean isActive) {
            Object object = BackgroundJobsController.this.mLock;
            synchronized (object) {
                BackgroundJobsController.this.updateJobRestrictionsForUidLocked(uid, isActive);
            }
        }
    };

    public BackgroundJobsController(JobSchedulerService service) {
        super(service);
        this.mAppStateTracker = Preconditions.checkNotNull(LocalServices.getService(AppStateTracker.class));
        this.mAppStateTracker.addListener(this.mForceAppStandbyListener);
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        this.updateSingleJobRestrictionLocked(jobStatus, 0);
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
    }

    @Override
    public void dumpControllerStateLocked(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
        this.mAppStateTracker.dump(pw);
        pw.println();
        this.mService.getJobStore().forEachJob(predicate, jobStatus -> {
            int uid = jobStatus.getSourceUid();
            String sourcePkg = jobStatus.getSourcePackageName();
            pw.print("#");
            jobStatus.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, uid);
            pw.print(this.mAppStateTracker.isUidActive(uid) ? " active" : " idle");
            if (this.mAppStateTracker.isUidPowerSaveWhitelisted(uid) || this.mAppStateTracker.isUidTempPowerSaveWhitelisted(uid)) {
                pw.print(", whitelisted");
            }
            pw.print(": ");
            pw.print(sourcePkg);
            pw.print(" [RUN_ANY_IN_BACKGROUND ");
            pw.print(this.mAppStateTracker.isRunAnyInBackgroundAppOpsAllowed(uid, sourcePkg) ? "allowed]" : "disallowed]");
            if ((jobStatus.satisfiedConstraints & 0x400000) != 0) {
                pw.println(" RUNNABLE");
            } else {
                pw.println(" WAITING");
            }
        });
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
        long token = proto.start(fieldId);
        long mToken = proto.start(0x10B00000001L);
        this.mAppStateTracker.dumpProto(proto, 0x10B00000001L);
        this.mService.getJobStore().forEachJob(predicate, jobStatus -> {
            long jsToken = proto.start(0x20B00000002L);
            jobStatus.writeToShortProto(proto, 0x10B00000001L);
            int sourceUid = jobStatus.getSourceUid();
            proto.write(1120986464258L, sourceUid);
            String sourcePkg = jobStatus.getSourcePackageName();
            proto.write(1138166333443L, sourcePkg);
            proto.write(1133871366148L, this.mAppStateTracker.isUidActive(sourceUid));
            proto.write(1133871366149L, this.mAppStateTracker.isUidPowerSaveWhitelisted(sourceUid) || this.mAppStateTracker.isUidTempPowerSaveWhitelisted(sourceUid));
            proto.write(1133871366150L, this.mAppStateTracker.isRunAnyInBackgroundAppOpsAllowed(sourceUid, sourcePkg));
            proto.write(1133871366151L, (jobStatus.satisfiedConstraints & 0x400000) != 0);
            proto.end(jsToken);
        });
        proto.end(mToken);
        proto.end(token);
    }

    private void updateAllJobRestrictionsLocked() {
        this.updateJobRestrictionsLocked(-1, 0);
    }

    private void updateJobRestrictionsForUidLocked(int uid, boolean isActive) {
        this.updateJobRestrictionsLocked(uid, isActive ? 1 : 2);
    }

    private void updateJobRestrictionsLocked(int filterUid, int newActiveState) {
        long time;
        UpdateJobFunctor updateTrackedJobs = new UpdateJobFunctor(newActiveState);
        long start = DEBUG ? SystemClock.elapsedRealtimeNanos() : 0L;
        JobStore store = this.mService.getJobStore();
        if (filterUid > 0) {
            store.forEachJobForSourceUid(filterUid, updateTrackedJobs);
        } else {
            store.forEachJob(updateTrackedJobs);
        }
        long l = time = DEBUG ? SystemClock.elapsedRealtimeNanos() - start : 0L;
        if (DEBUG) {
            Slog.d(TAG, String.format("Job status updated: %d/%d checked/total jobs, %d us", updateTrackedJobs.mCheckedCount, updateTrackedJobs.mTotalCount, time / 1000L));
        }
        if (updateTrackedJobs.mChanged) {
            this.mStateChangedListener.onControllerStateChanged();
        }
    }

    boolean updateSingleJobRestrictionLocked(JobStatus jobStatus, int activeState) {
        boolean canRun;
        int uid = jobStatus.getSourceUid();
        String packageName = jobStatus.getSourcePackageName();
        boolean bl = canRun = !this.mAppStateTracker.areJobsRestricted(uid, packageName, (jobStatus.getInternalFlags() & 1) != 0);
        boolean isActive = activeState == 0 ? this.mAppStateTracker.isUidActive(uid) : activeState == 1;
        boolean didChange = jobStatus.setBackgroundNotRestrictedConstraintSatisfied(canRun);
        return didChange |= jobStatus.setUidActive(isActive);
    }

    private final class UpdateJobFunctor
    implements Consumer<JobStatus> {
        final int activeState;
        boolean mChanged = false;
        int mTotalCount = 0;
        int mCheckedCount = 0;

        public UpdateJobFunctor(int newActiveState) {
            this.activeState = newActiveState;
        }

        @Override
        public void accept(JobStatus jobStatus) {
            ++this.mTotalCount;
            ++this.mCheckedCount;
            if (BackgroundJobsController.this.updateSingleJobRestrictionLocked(jobStatus, this.activeState)) {
                this.mChanged = true;
            }
        }
    }
}

