/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.net.ConnectivityManager;
import android.net.INetworkPolicyListener;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkPolicyManager;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import com.android.server.net.NetworkPolicyManagerInternal;
import java.util.Objects;
import java.util.function.Predicate;

public final class ConnectivityController
extends StateController
implements ConnectivityManager.OnNetworkActiveListener {
    private static final String TAG = "JobScheduler.Connectivity";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.Connectivity", 3);
    private final ConnectivityManager mConnManager;
    private final NetworkPolicyManager mNetPolicyManager;
    private final NetworkPolicyManagerInternal mNetPolicyManagerInternal;
    @GuardedBy(value={"mLock"})
    private final SparseArray<ArraySet<JobStatus>> mTrackedJobs = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final SparseArray<ArraySet<JobStatus>> mRequestedWhitelistJobs = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArraySet<Network> mAvailableNetworks = new ArraySet();
    private static final int MSG_DATA_SAVER_TOGGLED = 0;
    private static final int MSG_UID_RULES_CHANGES = 1;
    private final Handler mHandler;
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAvailable(Network network) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onAvailable: " + network);
            }
            Object object = ConnectivityController.this.mLock;
            synchronized (object) {
                ConnectivityController.this.mAvailableNetworks.add(network);
            }
        }

        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities capabilities) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onCapabilitiesChanged: " + network);
            }
            ConnectivityController.this.updateTrackedJobs(-1, network);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLost(Network network) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onLost: " + network);
            }
            Object object = ConnectivityController.this.mLock;
            synchronized (object) {
                ConnectivityController.this.mAvailableNetworks.remove(network);
            }
            ConnectivityController.this.updateTrackedJobs(-1, network);
        }
    };
    private final INetworkPolicyListener mNetPolicyListener = new NetworkPolicyManager.Listener(){

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onRestrictBackgroundChanged: " + restrictBackground);
            }
            ConnectivityController.this.mHandler.obtainMessage(0).sendToTarget();
        }

        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            if (DEBUG) {
                Slog.v(ConnectivityController.TAG, "onUidRulesChanged: " + uid);
            }
            ConnectivityController.this.mHandler.obtainMessage(1, uid, 0).sendToTarget();
        }
    };

    public ConnectivityController(JobSchedulerService service) {
        super(service);
        this.mHandler = new CcHandler(this.mContext.getMainLooper());
        this.mConnManager = this.mContext.getSystemService(ConnectivityManager.class);
        this.mNetPolicyManager = this.mContext.getSystemService(NetworkPolicyManager.class);
        this.mNetPolicyManagerInternal = LocalServices.getService(NetworkPolicyManagerInternal.class);
        NetworkRequest request = new NetworkRequest.Builder().clearCapabilities().build();
        this.mConnManager.registerNetworkCallback(request, this.mNetworkCallback);
        this.mNetPolicyManager.registerListener(this.mNetPolicyListener);
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        if (jobStatus.hasConnectivityConstraint()) {
            this.updateConstraintsSatisfied(jobStatus);
            ArraySet<JobStatus> jobs = this.mTrackedJobs.get(jobStatus.getSourceUid());
            if (jobs == null) {
                jobs = new ArraySet();
                this.mTrackedJobs.put(jobStatus.getSourceUid(), jobs);
            }
            jobs.add(jobStatus);
            jobStatus.setTrackingController(2);
        }
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
        if (jobStatus.clearTrackingController(2)) {
            ArraySet<JobStatus> jobs = this.mTrackedJobs.get(jobStatus.getSourceUid());
            if (jobs != null) {
                jobs.remove(jobStatus);
            }
            this.maybeRevokeStandbyExceptionLocked(jobStatus);
        }
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void onConstantsUpdatedLocked() {
        if (this.mConstants.USE_HEARTBEATS) {
            if (DEBUG) {
                Slog.i(TAG, "Revoking all standby exceptions");
            }
            for (int i = 0; i < this.mRequestedWhitelistJobs.size(); ++i) {
                int uid = this.mRequestedWhitelistJobs.keyAt(i);
                this.mNetPolicyManagerInternal.setAppIdleWhitelist(uid, false);
            }
            this.mRequestedWhitelistJobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNetworkAvailable(JobStatus job) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mAvailableNetworks.size(); ++i) {
                Network network = this.mAvailableNetworks.valueAt(i);
                NetworkCapabilities capabilities = this.mConnManager.getNetworkCapabilities(network);
                boolean satisfied = ConnectivityController.isSatisfied(job, network, capabilities, this.mConstants);
                if (DEBUG) {
                    Slog.v(TAG, "isNetworkAvailable(" + job + ") with network " + network + " and capabilities " + capabilities + ". Satisfied=" + satisfied);
                }
                if (!satisfied) continue;
                return true;
            }
            return false;
        }
    }

    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    void requestStandbyExceptionLocked(JobStatus job) {
        int uid = job.getSourceUid();
        boolean isExceptionRequested = this.isStandbyExceptionRequestedLocked(uid);
        ArraySet<JobStatus> jobs = this.mRequestedWhitelistJobs.get(uid);
        if (jobs == null) {
            jobs = new ArraySet();
            this.mRequestedWhitelistJobs.put(uid, jobs);
        }
        if (!jobs.add(job) || isExceptionRequested) {
            if (DEBUG) {
                Slog.i(TAG, "requestStandbyExceptionLocked found exception already requested.");
            }
            return;
        }
        if (DEBUG) {
            Slog.i(TAG, "Requesting standby exception for UID: " + uid);
        }
        this.mNetPolicyManagerInternal.setAppIdleWhitelist(uid, true);
    }

    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    boolean isStandbyExceptionRequestedLocked(int uid) {
        ArraySet<JobStatus> jobs = this.mRequestedWhitelistJobs.get(uid);
        return jobs != null && jobs.size() > 0;
    }

    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    boolean wouldBeReadyWithConnectivityLocked(JobStatus jobStatus) {
        boolean networkAvailable = this.isNetworkAvailable(jobStatus);
        if (DEBUG) {
            Slog.v(TAG, "wouldBeReadyWithConnectivityLocked: " + jobStatus.toShortString() + " networkAvailable=" + networkAvailable);
        }
        return networkAvailable && this.wouldBeReadyWithConstraintLocked(jobStatus, 0x10000000);
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void evaluateStateLocked(JobStatus jobStatus) {
        if (this.mConstants.USE_HEARTBEATS) {
            return;
        }
        if (!jobStatus.hasConnectivityConstraint()) {
            return;
        }
        if (this.wouldBeReadyWithConnectivityLocked(jobStatus)) {
            if (DEBUG) {
                Slog.i(TAG, "evaluateStateLocked finds job " + jobStatus + " would be ready.");
            }
            this.requestStandbyExceptionLocked(jobStatus);
        } else {
            if (DEBUG) {
                Slog.i(TAG, "evaluateStateLocked finds job " + jobStatus + " would not be ready.");
            }
            this.maybeRevokeStandbyExceptionLocked(jobStatus);
        }
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void reevaluateStateLocked(int uid) {
        if (this.mConstants.USE_HEARTBEATS) {
            return;
        }
        ArraySet<JobStatus> jobs = this.mTrackedJobs.get(uid);
        if (jobs == null) {
            return;
        }
        for (int i = jobs.size() - 1; i >= 0; --i) {
            this.evaluateStateLocked(jobs.valueAt(i));
        }
    }

    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    void maybeRevokeStandbyExceptionLocked(JobStatus job) {
        int uid = job.getSourceUid();
        if (!this.isStandbyExceptionRequestedLocked(uid)) {
            return;
        }
        ArraySet<JobStatus> jobs = this.mRequestedWhitelistJobs.get(uid);
        if (jobs == null) {
            Slog.wtf(TAG, "maybeRevokeStandbyExceptionLocked found null jobs array even though a standby exception has been requested.");
            return;
        }
        if (!jobs.remove(job) || jobs.size() > 0) {
            if (DEBUG) {
                Slog.i(TAG, "maybeRevokeStandbyExceptionLocked not revoking because there are still " + jobs.size() + " jobs left.");
            }
            return;
        }
        this.revokeStandbyExceptionLocked(uid);
    }

    @GuardedBy(value={"mLock"})
    private void revokeStandbyExceptionLocked(int uid) {
        if (DEBUG) {
            Slog.i(TAG, "Revoking standby exception for UID: " + uid);
        }
        this.mNetPolicyManagerInternal.setAppIdleWhitelist(uid, false);
        this.mRequestedWhitelistJobs.remove(uid);
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void onAppRemovedLocked(String pkgName, int uid) {
        this.mTrackedJobs.delete(uid);
    }

    private static boolean isInsane(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        long estimatedBytes = jobStatus.getEstimatedNetworkBytes();
        if (estimatedBytes == -1L) {
            return false;
        }
        long slowest = NetworkCapabilities.minBandwidth(capabilities.getLinkDownstreamBandwidthKbps(), capabilities.getLinkUpstreamBandwidthKbps());
        if (slowest == 0L) {
            return false;
        }
        long estimatedMillis = estimatedBytes * 1000L / (slowest * 1024L / 8L);
        if (estimatedMillis > 600000L) {
            Slog.w(TAG, "Estimated " + estimatedBytes + " bytes over " + slowest + " kbps network would take " + estimatedMillis + "ms; that's insane!");
            return true;
        }
        return false;
    }

    private static boolean isCongestionDelayed(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        if (!capabilities.hasCapability(20)) {
            return jobStatus.getFractionRunTime() < constants.CONN_CONGESTION_DELAY_FRAC;
        }
        return false;
    }

    private static boolean isStrictSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        return jobStatus.getJob().getRequiredNetwork().networkCapabilities.satisfiedByNetworkCapabilities(capabilities);
    }

    private static boolean isRelaxedSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        if (!jobStatus.getJob().isPrefetch()) {
            return false;
        }
        NetworkCapabilities relaxed = new NetworkCapabilities(jobStatus.getJob().getRequiredNetwork().networkCapabilities).removeCapability(11);
        if (relaxed.satisfiedByNetworkCapabilities(capabilities)) {
            return jobStatus.getFractionRunTime() > constants.CONN_PREFETCH_RELAX_FRAC;
        }
        return false;
    }

    @VisibleForTesting
    static boolean isSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities, JobSchedulerService.Constants constants) {
        if (network == null || capabilities == null) {
            return false;
        }
        if (ConnectivityController.isInsane(jobStatus, network, capabilities, constants)) {
            return false;
        }
        if (ConnectivityController.isCongestionDelayed(jobStatus, network, capabilities, constants)) {
            return false;
        }
        if (ConnectivityController.isStrictSatisfied(jobStatus, network, capabilities, constants)) {
            return true;
        }
        return ConnectivityController.isRelaxedSatisfied(jobStatus, network, capabilities, constants);
    }

    private boolean updateConstraintsSatisfied(JobStatus jobStatus) {
        Network network = this.mConnManager.getActiveNetworkForUid(jobStatus.getSourceUid());
        NetworkCapabilities capabilities = this.mConnManager.getNetworkCapabilities(network);
        return this.updateConstraintsSatisfied(jobStatus, network, capabilities);
    }

    private boolean updateConstraintsSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities) {
        boolean ignoreBlocked = (jobStatus.getFlags() & 1) != 0;
        NetworkInfo info = this.mConnManager.getNetworkInfoForUid(network, jobStatus.getSourceUid(), ignoreBlocked);
        boolean connected = info != null && info.isConnected();
        boolean satisfied = ConnectivityController.isSatisfied(jobStatus, network, capabilities, this.mConstants);
        boolean changed = jobStatus.setConnectivityConstraintSatisfied(connected && satisfied);
        jobStatus.network = network;
        if (DEBUG) {
            Slog.i(TAG, "Connectivity " + (changed ? "CHANGED" : "unchanged") + " for " + jobStatus + ": connected=" + connected + " satisfied=" + satisfied);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTrackedJobs(int filterUid, Network filterNetwork) {
        Object object = this.mLock;
        synchronized (object) {
            SparseArray<NetworkCapabilities> networkToCapabilities = new SparseArray<NetworkCapabilities>();
            boolean changed = false;
            if (filterUid == -1) {
                for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                    changed |= this.updateTrackedJobsLocked(this.mTrackedJobs.valueAt(i), filterNetwork, networkToCapabilities);
                }
            } else {
                changed = this.updateTrackedJobsLocked(this.mTrackedJobs.get(filterUid), filterNetwork, networkToCapabilities);
            }
            if (changed) {
                this.mStateChangedListener.onControllerStateChanged();
            }
        }
    }

    private boolean updateTrackedJobsLocked(ArraySet<JobStatus> jobs, Network filterNetwork, SparseArray<NetworkCapabilities> networkToCapabilities) {
        if (jobs == null || jobs.size() == 0) {
            return false;
        }
        Network network = this.mConnManager.getActiveNetworkForUid(jobs.valueAt(0).getSourceUid());
        int netId = network != null ? network.netId : -1;
        NetworkCapabilities capabilities = networkToCapabilities.get(netId);
        if (capabilities == null) {
            capabilities = this.mConnManager.getNetworkCapabilities(network);
            networkToCapabilities.put(netId, capabilities);
        }
        boolean networkMatch = filterNetwork == null || Objects.equals(filterNetwork, network);
        boolean changed = false;
        for (int i = jobs.size() - 1; i >= 0; --i) {
            JobStatus js = jobs.valueAt(i);
            if (!networkMatch && Objects.equals(js.network, network)) continue;
            changed |= this.updateConstraintsSatisfied(js, network, capabilities);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNetworkActive() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                ArraySet<JobStatus> jobs = this.mTrackedJobs.valueAt(i);
                for (int j = jobs.size() - 1; j >= 0; --j) {
                    JobStatus js = jobs.valueAt(j);
                    if (!js.isReady()) continue;
                    if (DEBUG) {
                        Slog.d(TAG, "Running " + js + " due to network activity.");
                    }
                    this.mStateChangedListener.onRunJobNow(js);
                }
            }
        }
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void dumpControllerStateLocked(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
        int i;
        if (this.mRequestedWhitelistJobs.size() > 0) {
            pw.print("Requested standby exceptions:");
            for (i = 0; i < this.mRequestedWhitelistJobs.size(); ++i) {
                pw.print(" ");
                pw.print(this.mRequestedWhitelistJobs.keyAt(i));
                pw.print(" (");
                pw.print(this.mRequestedWhitelistJobs.valueAt(i).size());
                pw.print(" jobs)");
            }
            pw.println();
        }
        if (this.mAvailableNetworks.size() > 0) {
            pw.println("Available networks:");
            pw.increaseIndent();
            for (i = 0; i < this.mAvailableNetworks.size(); ++i) {
                pw.println(this.mAvailableNetworks.valueAt(i));
            }
            pw.decreaseIndent();
        } else {
            pw.println("No available networks");
        }
        for (i = 0; i < this.mTrackedJobs.size(); ++i) {
            ArraySet<JobStatus> jobs = this.mTrackedJobs.valueAt(i);
            for (int j = 0; j < jobs.size(); ++j) {
                JobStatus js = jobs.valueAt(j);
                if (!predicate.test(js)) continue;
                pw.print("#");
                js.printUniqueId(pw);
                pw.print(" from ");
                UserHandle.formatUid(pw, js.getSourceUid());
                pw.print(": ");
                pw.print(js.getJob().getRequiredNetwork());
                pw.println();
            }
        }
    }

    @Override
    @GuardedBy(value={"mLock"})
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268035L);
        for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
            ArraySet<JobStatus> jobs = this.mTrackedJobs.valueAt(i);
            for (int j = 0; j < jobs.size(); ++j) {
                JobStatus js = jobs.valueAt(j);
                if (!predicate.test(js)) continue;
                long jsToken = proto.start(0x20B00000002L);
                js.writeToShortProto(proto, 0x10B00000001L);
                proto.write(1120986464258L, js.getSourceUid());
                NetworkRequest rn = js.getJob().getRequiredNetwork();
                if (rn != null) {
                    rn.writeToProto(proto, 1146756268035L);
                }
                proto.end(jsToken);
            }
        }
        proto.end(mToken);
        proto.end(token);
    }

    private class CcHandler
    extends Handler {
        CcHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            Object object = ConnectivityController.this.mLock;
            synchronized (object) {
                switch (msg.what) {
                    case 0: {
                        ConnectivityController.this.updateTrackedJobs(-1, null);
                        break;
                    }
                    case 1: {
                        ConnectivityController.this.updateTrackedJobs(msg.arg1, null);
                    }
                }
            }
        }
    }
}

