/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.job.JobInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.util.ArrayList;
import java.util.function.Predicate;

public final class ContentObserverController
extends StateController {
    private static final String TAG = "JobScheduler.ContentObserver";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.ContentObserver", 3);
    private static final int MAX_URIS_REPORTED = 50;
    private static final int URIS_URGENT_THRESHOLD = 40;
    private final ArraySet<JobStatus> mTrackedTasks = new ArraySet();
    final SparseArray<ArrayMap<JobInfo.TriggerContentUri, ObserverInstance>> mObservers = new SparseArray();
    final Handler mHandler = new Handler(this.mContext.getMainLooper());

    public ContentObserverController(JobSchedulerService service) {
        super(service);
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus taskStatus, JobStatus lastJob) {
        if (taskStatus.hasContentTriggerConstraint()) {
            if (taskStatus.contentObserverJobInstance == null) {
                taskStatus.contentObserverJobInstance = new JobInstance(taskStatus);
            }
            if (DEBUG) {
                Slog.i(TAG, "Tracking content-trigger job " + taskStatus);
            }
            this.mTrackedTasks.add(taskStatus);
            taskStatus.setTrackingController(4);
            boolean havePendingUris = false;
            if (taskStatus.contentObserverJobInstance.mChangedAuthorities != null) {
                havePendingUris = true;
            }
            if (taskStatus.changedAuthorities != null) {
                havePendingUris = true;
                if (taskStatus.contentObserverJobInstance.mChangedAuthorities == null) {
                    taskStatus.contentObserverJobInstance.mChangedAuthorities = new ArraySet();
                }
                for (String auth : taskStatus.changedAuthorities) {
                    taskStatus.contentObserverJobInstance.mChangedAuthorities.add(auth);
                }
                if (taskStatus.changedUris != null) {
                    if (taskStatus.contentObserverJobInstance.mChangedUris == null) {
                        taskStatus.contentObserverJobInstance.mChangedUris = new ArraySet();
                    }
                    for (Uri uri : taskStatus.changedUris) {
                        taskStatus.contentObserverJobInstance.mChangedUris.add(uri);
                    }
                }
                taskStatus.changedAuthorities = null;
                taskStatus.changedUris = null;
            }
            taskStatus.changedAuthorities = null;
            taskStatus.changedUris = null;
            taskStatus.setContentTriggerConstraintSatisfied(havePendingUris);
        }
        if (lastJob != null && lastJob.contentObserverJobInstance != null) {
            lastJob.contentObserverJobInstance.detachLocked();
            lastJob.contentObserverJobInstance = null;
        }
    }

    @Override
    public void prepareForExecutionLocked(JobStatus taskStatus) {
        if (taskStatus.hasContentTriggerConstraint() && taskStatus.contentObserverJobInstance != null) {
            taskStatus.changedUris = taskStatus.contentObserverJobInstance.mChangedUris;
            taskStatus.changedAuthorities = taskStatus.contentObserverJobInstance.mChangedAuthorities;
            taskStatus.contentObserverJobInstance.mChangedUris = null;
            taskStatus.contentObserverJobInstance.mChangedAuthorities = null;
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus taskStatus, JobStatus incomingJob, boolean forUpdate) {
        if (taskStatus.clearTrackingController(4)) {
            this.mTrackedTasks.remove(taskStatus);
            if (taskStatus.contentObserverJobInstance != null) {
                taskStatus.contentObserverJobInstance.unscheduleLocked();
                if (incomingJob != null) {
                    if (taskStatus.contentObserverJobInstance != null && taskStatus.contentObserverJobInstance.mChangedAuthorities != null) {
                        if (incomingJob.contentObserverJobInstance == null) {
                            incomingJob.contentObserverJobInstance = new JobInstance(incomingJob);
                        }
                        incomingJob.contentObserverJobInstance.mChangedAuthorities = taskStatus.contentObserverJobInstance.mChangedAuthorities;
                        incomingJob.contentObserverJobInstance.mChangedUris = taskStatus.contentObserverJobInstance.mChangedUris;
                        taskStatus.contentObserverJobInstance.mChangedAuthorities = null;
                        taskStatus.contentObserverJobInstance.mChangedUris = null;
                    }
                } else {
                    taskStatus.contentObserverJobInstance.detachLocked();
                    taskStatus.contentObserverJobInstance = null;
                }
            }
            if (DEBUG) {
                Slog.i(TAG, "No longer tracking job " + taskStatus);
            }
        }
    }

    @Override
    public void rescheduleForFailureLocked(JobStatus newJob, JobStatus failureToReschedule) {
        if (failureToReschedule.hasContentTriggerConstraint() && newJob.hasContentTriggerConstraint()) {
            newJob.changedAuthorities = failureToReschedule.changedAuthorities;
            newJob.changedUris = failureToReschedule.changedUris;
        }
    }

    @Override
    public void dumpControllerStateLocked(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
        for (int i = 0; i < this.mTrackedTasks.size(); ++i) {
            JobStatus js = this.mTrackedTasks.valueAt(i);
            if (!predicate.test(js)) continue;
            pw.print("#");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.println();
        }
        pw.println();
        int N = this.mObservers.size();
        if (N > 0) {
            pw.println("Observers:");
            pw.increaseIndent();
            for (int userIdx = 0; userIdx < N; ++userIdx) {
                int userId = this.mObservers.keyAt(userIdx);
                ArrayMap<JobInfo.TriggerContentUri, ObserverInstance> observersOfUser = this.mObservers.get(userId);
                int numbOfObserversPerUser = observersOfUser.size();
                for (int observerIdx = 0; observerIdx < numbOfObserversPerUser; ++observerIdx) {
                    ObserverInstance obs = observersOfUser.valueAt(observerIdx);
                    int M = obs.mJobs.size();
                    boolean shouldDump = false;
                    for (int j = 0; j < M; ++j) {
                        JobInstance inst = obs.mJobs.valueAt(j);
                        if (!predicate.test(inst.mJobStatus)) continue;
                        shouldDump = true;
                        break;
                    }
                    if (!shouldDump) continue;
                    JobInfo.TriggerContentUri trigger = observersOfUser.keyAt(observerIdx);
                    pw.print(trigger.getUri());
                    pw.print(" 0x");
                    pw.print(Integer.toHexString(trigger.getFlags()));
                    pw.print(" (");
                    pw.print(System.identityHashCode(obs));
                    pw.println("):");
                    pw.increaseIndent();
                    pw.println("Jobs:");
                    pw.increaseIndent();
                    for (int j = 0; j < M; ++j) {
                        JobInstance inst = obs.mJobs.valueAt(j);
                        pw.print("#");
                        inst.mJobStatus.printUniqueId(pw);
                        pw.print(" from ");
                        UserHandle.formatUid(pw, inst.mJobStatus.getSourceUid());
                        if (inst.mChangedAuthorities != null) {
                            int k;
                            pw.println(":");
                            pw.increaseIndent();
                            if (inst.mTriggerPending) {
                                pw.print("Trigger pending: update=");
                                TimeUtils.formatDuration(inst.mJobStatus.getTriggerContentUpdateDelay(), pw);
                                pw.print(", max=");
                                TimeUtils.formatDuration(inst.mJobStatus.getTriggerContentMaxDelay(), pw);
                                pw.println();
                            }
                            pw.println("Changed Authorities:");
                            for (k = 0; k < inst.mChangedAuthorities.size(); ++k) {
                                pw.println(inst.mChangedAuthorities.valueAt(k));
                            }
                            if (inst.mChangedUris != null) {
                                pw.println("          Changed URIs:");
                                for (k = 0; k < inst.mChangedUris.size(); ++k) {
                                    pw.println(inst.mChangedUris.valueAt(k));
                                }
                            }
                            pw.decreaseIndent();
                            continue;
                        }
                        pw.println();
                    }
                    pw.decreaseIndent();
                    pw.decreaseIndent();
                }
            }
            pw.decreaseIndent();
        }
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268036L);
        for (int i = 0; i < this.mTrackedTasks.size(); ++i) {
            JobStatus js = this.mTrackedTasks.valueAt(i);
            if (!predicate.test(js)) continue;
            long jsToken = proto.start(2246267895809L);
            js.writeToShortProto(proto, 0x10B00000001L);
            proto.write(1120986464258L, js.getSourceUid());
            proto.end(jsToken);
        }
        int n = this.mObservers.size();
        for (int userIdx = 0; userIdx < n; ++userIdx) {
            long oToken = proto.start(0x20B00000002L);
            int userId = this.mObservers.keyAt(userIdx);
            proto.write(0x10500000001L, userId);
            ArrayMap<JobInfo.TriggerContentUri, ObserverInstance> observersOfUser = this.mObservers.get(userId);
            int numbOfObserversPerUser = observersOfUser.size();
            for (int observerIdx = 0; observerIdx < numbOfObserversPerUser; ++observerIdx) {
                ObserverInstance obs = observersOfUser.valueAt(observerIdx);
                int m = obs.mJobs.size();
                boolean shouldDump = false;
                for (int j = 0; j < m; ++j) {
                    JobInstance inst = obs.mJobs.valueAt(j);
                    if (!predicate.test(inst.mJobStatus)) continue;
                    shouldDump = true;
                    break;
                }
                if (!shouldDump) continue;
                long tToken = proto.start(0x20B00000002L);
                JobInfo.TriggerContentUri trigger = observersOfUser.keyAt(observerIdx);
                Uri u = trigger.getUri();
                if (u != null) {
                    proto.write(0x10900000001L, u.toString());
                }
                proto.write(1120986464258L, trigger.getFlags());
                for (int j = 0; j < m; ++j) {
                    int k;
                    long jToken = proto.start(2246267895811L);
                    JobInstance inst = obs.mJobs.valueAt(j);
                    inst.mJobStatus.writeToShortProto(proto, 0x10B00000001L);
                    proto.write(1120986464258L, inst.mJobStatus.getSourceUid());
                    if (inst.mChangedAuthorities == null) {
                        proto.end(jToken);
                        continue;
                    }
                    if (inst.mTriggerPending) {
                        proto.write(0x10300000003L, inst.mJobStatus.getTriggerContentUpdateDelay());
                        proto.write(1112396529668L, inst.mJobStatus.getTriggerContentMaxDelay());
                    }
                    for (k = 0; k < inst.mChangedAuthorities.size(); ++k) {
                        proto.write(2237677961221L, inst.mChangedAuthorities.valueAt(k));
                    }
                    if (inst.mChangedUris != null) {
                        for (k = 0; k < inst.mChangedUris.size(); ++k) {
                            u = inst.mChangedUris.valueAt(k);
                            if (u == null) continue;
                            proto.write(2237677961222L, u.toString());
                        }
                    }
                    proto.end(jToken);
                }
                proto.end(tToken);
            }
            proto.end(oToken);
        }
        proto.end(mToken);
        proto.end(token);
    }

    final class JobInstance {
        final ArrayList<ObserverInstance> mMyObservers = new ArrayList();
        final JobStatus mJobStatus;
        final Runnable mExecuteRunner;
        final Runnable mTimeoutRunner;
        ArraySet<Uri> mChangedUris;
        ArraySet<String> mChangedAuthorities;
        boolean mTriggerPending;

        JobInstance(JobStatus jobStatus) {
            this.mJobStatus = jobStatus;
            this.mExecuteRunner = new TriggerRunnable(this);
            this.mTimeoutRunner = new TriggerRunnable(this);
            JobInfo.TriggerContentUri[] uris = jobStatus.getJob().getTriggerContentUris();
            int sourceUserId = jobStatus.getSourceUserId();
            ArrayMap<JobInfo.TriggerContentUri, ObserverInstance> observersOfUser = ContentObserverController.this.mObservers.get(sourceUserId);
            if (observersOfUser == null) {
                observersOfUser = new ArrayMap();
                ContentObserverController.this.mObservers.put(sourceUserId, observersOfUser);
            }
            if (uris != null) {
                for (JobInfo.TriggerContentUri uri : uris) {
                    boolean andDescendants;
                    ObserverInstance obs = observersOfUser.get(uri);
                    if (obs == null) {
                        obs = new ObserverInstance(ContentObserverController.this.mHandler, uri, jobStatus.getSourceUserId());
                        observersOfUser.put(uri, obs);
                        boolean bl = andDescendants = (uri.getFlags() & 1) != 0;
                        if (DEBUG) {
                            Slog.v(ContentObserverController.TAG, "New observer " + obs + " for " + uri.getUri() + " andDescendants=" + andDescendants + " sourceUserId=" + sourceUserId);
                        }
                        ContentObserverController.this.mContext.getContentResolver().registerContentObserver(uri.getUri(), andDescendants, obs, sourceUserId);
                    } else if (DEBUG) {
                        andDescendants = (uri.getFlags() & 1) != 0;
                        Slog.v(ContentObserverController.TAG, "Reusing existing observer " + obs + " for " + uri.getUri() + " andDescendants=" + andDescendants);
                    }
                    obs.mJobs.add(this);
                    this.mMyObservers.add(obs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trigger() {
            boolean reportChange = false;
            Object object = ContentObserverController.this.mLock;
            synchronized (object) {
                if (this.mTriggerPending) {
                    if (this.mJobStatus.setContentTriggerConstraintSatisfied(true)) {
                        reportChange = true;
                    }
                    this.unscheduleLocked();
                }
            }
            if (reportChange) {
                ContentObserverController.this.mStateChangedListener.onControllerStateChanged();
            }
        }

        void scheduleLocked() {
            if (!this.mTriggerPending) {
                this.mTriggerPending = true;
                ContentObserverController.this.mHandler.postDelayed(this.mTimeoutRunner, this.mJobStatus.getTriggerContentMaxDelay());
            }
            ContentObserverController.this.mHandler.removeCallbacks(this.mExecuteRunner);
            if (this.mChangedUris.size() >= 40) {
                ContentObserverController.this.mHandler.post(this.mExecuteRunner);
            } else {
                ContentObserverController.this.mHandler.postDelayed(this.mExecuteRunner, this.mJobStatus.getTriggerContentUpdateDelay());
            }
        }

        void unscheduleLocked() {
            if (this.mTriggerPending) {
                ContentObserverController.this.mHandler.removeCallbacks(this.mExecuteRunner);
                ContentObserverController.this.mHandler.removeCallbacks(this.mTimeoutRunner);
                this.mTriggerPending = false;
            }
        }

        void detachLocked() {
            int N = this.mMyObservers.size();
            for (int i = 0; i < N; ++i) {
                ObserverInstance obs = this.mMyObservers.get(i);
                obs.mJobs.remove(this);
                if (obs.mJobs.size() != 0) continue;
                if (DEBUG) {
                    Slog.i(ContentObserverController.TAG, "Unregistering observer " + obs + " for " + obs.mUri.getUri());
                }
                ContentObserverController.this.mContext.getContentResolver().unregisterContentObserver(obs);
                ArrayMap<JobInfo.TriggerContentUri, ObserverInstance> observerOfUser = ContentObserverController.this.mObservers.get(obs.mUserId);
                if (observerOfUser == null) continue;
                observerOfUser.remove(obs.mUri);
            }
        }
    }

    static final class TriggerRunnable
    implements Runnable {
        final JobInstance mInstance;

        TriggerRunnable(JobInstance instance) {
            this.mInstance = instance;
        }

        @Override
        public void run() {
            this.mInstance.trigger();
        }
    }

    final class ObserverInstance
    extends ContentObserver {
        final JobInfo.TriggerContentUri mUri;
        final int mUserId;
        final ArraySet<JobInstance> mJobs;

        public ObserverInstance(Handler handler, JobInfo.TriggerContentUri uri, int userId) {
            super(handler);
            this.mJobs = new ArraySet();
            this.mUri = uri;
            this.mUserId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (DEBUG) {
                Slog.i(ContentObserverController.TAG, "onChange(self=" + selfChange + ") for " + uri + " when mUri=" + this.mUri + " mUserId=" + this.mUserId);
            }
            Object object = ContentObserverController.this.mLock;
            synchronized (object) {
                int N = this.mJobs.size();
                for (int i = 0; i < N; ++i) {
                    JobInstance inst = this.mJobs.valueAt(i);
                    if (inst.mChangedUris == null) {
                        inst.mChangedUris = new ArraySet();
                    }
                    if (inst.mChangedUris.size() < 50) {
                        inst.mChangedUris.add(uri);
                    }
                    if (inst.mChangedAuthorities == null) {
                        inst.mChangedAuthorities = new ArraySet();
                    }
                    inst.mChangedAuthorities.add(uri.getAuthority());
                    inst.scheduleLocked();
                }
            }
        }
    }
}

