/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IUidObserver;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.BatteryManagerInternal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseSetArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class QuotaController
extends StateController {
    private static final String TAG = "JobScheduler.Quota";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.Quota", 3);
    private static final String ALARM_TAG_CLEANUP = "*job.cleanup*";
    private static final String ALARM_TAG_QUOTA_CHECK = "*job.quota_check*";
    private final UserPackageMap<ArraySet<JobStatus>> mTrackedJobs = new UserPackageMap();
    private final UserPackageMap<Timer> mPkgTimers = new UserPackageMap();
    private final UserPackageMap<List<TimingSession>> mTimingSessions = new UserPackageMap();
    private final UserPackageMap<QcAlarmListener> mInQuotaAlarmListeners = new UserPackageMap();
    private final UserPackageMap<ExecutionStats[]> mExecutionStatsCache = new UserPackageMap();
    private final SparseBooleanArray mForegroundUids = new SparseBooleanArray();
    private final SparseSetArray<String> mUidToPackageCache = new SparseSetArray();
    private final ArraySet<JobStatus> mTopStartedJobs = new ArraySet();
    private final ActivityManagerInternal mActivityManagerInternal;
    private final AlarmManager mAlarmManager;
    private final ChargingTracker mChargeTracker;
    private final Handler mHandler;
    private final QcConstants mQcConstants;
    private volatile boolean mInParole;
    private boolean mShouldThrottle;
    private long mAllowedTimePerPeriodMs = 600000L;
    private long mMaxExecutionTimeMs = 14400000L;
    private long mQuotaBufferMs = 30000L;
    private long mAllowedTimeIntoQuotaMs = this.mAllowedTimePerPeriodMs - this.mQuotaBufferMs;
    private long mMaxExecutionTimeIntoQuotaMs = this.mMaxExecutionTimeMs - this.mQuotaBufferMs;
    private long mRateLimitingWindowMs = 600000L;
    private int mMaxJobCountPerRateLimitingWindow = 20;
    private int mMaxSessionCountPerRateLimitingWindow = 20;
    private long mNextCleanupTimeElapsed = 0L;
    private final AlarmManager.OnAlarmListener mSessionCleanupAlarmListener = new AlarmManager.OnAlarmListener(){

        @Override
        public void onAlarm() {
            QuotaController.this.mHandler.obtainMessage(1).sendToTarget();
        }
    };
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
            QuotaController.this.mHandler.obtainMessage(3, uid, procState).sendToTarget();
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
        }

        @Override
        public void onUidActive(int uid) {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    };
    private final BroadcastReceiver mPackageAddedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                return;
            }
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                QuotaController.this.mUidToPackageCache.remove(uid);
            }
        }
    };
    private final long[] mBucketPeriodsMs = new long[]{600000L, 0x6DDD00L, 28800000L, 86400000L};
    private static final long MAX_PERIOD_MS = 86400000L;
    private final int[] mMaxBucketJobCounts = new int[]{20, 120, 200, 48};
    private final int[] mMaxBucketSessionCounts = new int[]{20, 10, 8, 3};
    private long mTimingSessionCoalescingDurationMs = 5000L;
    private static final int MSG_REACHED_QUOTA = 0;
    private static final int MSG_CLEAN_UP_SESSIONS = 1;
    private static final int MSG_CHECK_PACKAGE = 2;
    private static final int MSG_UID_PROCESS_STATE_CHANGED = 3;
    private final EarliestEndTimeFunctor mEarliestEndTimeFunctor = new EarliestEndTimeFunctor();
    private final UidConstraintUpdater mUpdateUidConstraints = new UidConstraintUpdater();
    private final DeleteTimingSessionsFunctor mDeleteOldSessionsFunctor = new DeleteTimingSessionsFunctor();

    private static String string(int userId, String packageName) {
        return "<" + userId + ">" + packageName;
    }

    private static int hashLong(long val) {
        return (int)(val ^ val >>> 32);
    }

    public QuotaController(JobSchedulerService service) {
        super(service);
        this.mHandler = new QcHandler(this.mContext.getMainLooper());
        this.mChargeTracker = new ChargingTracker();
        this.mChargeTracker.startTracking();
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mQcConstants = new QcConstants(this.mHandler);
        IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        this.mContext.registerReceiverAsUser(this.mPackageAddedReceiver, UserHandle.ALL, filter, null, null);
        UsageStatsManagerInternal usageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        usageStats.addAppIdleStateChangeListener(new StandbyTracker());
        try {
            ActivityManager.getService().registerUidObserver(this.mUidObserver, 1, 5, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mShouldThrottle = !this.mConstants.USE_HEARTBEATS;
    }

    @Override
    public void onSystemServicesReady() {
        this.mQcConstants.start(this.mContext.getContentResolver());
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        String pkgName;
        int userId = jobStatus.getSourceUserId();
        ArraySet<JobStatus> jobs = this.mTrackedJobs.get(userId, pkgName = jobStatus.getSourcePackageName());
        if (jobs == null) {
            jobs = new ArraySet();
            this.mTrackedJobs.add(userId, pkgName, jobs);
        }
        jobs.add(jobStatus);
        jobStatus.setTrackingController(64);
        if (this.mShouldThrottle) {
            boolean isWithinQuota = this.isWithinQuotaLocked(jobStatus);
            this.setConstraintSatisfied(jobStatus, isWithinQuota);
            if (!isWithinQuota) {
                this.maybeScheduleStartAlarmLocked(userId, pkgName, this.getEffectiveStandbyBucket(jobStatus));
            }
        } else {
            jobStatus.setQuotaConstraintSatisfied(true);
        }
    }

    @Override
    public void prepareForExecutionLocked(JobStatus jobStatus) {
        String packageName;
        int uid;
        if (DEBUG) {
            Slog.d(TAG, "Prepping for " + jobStatus.toShortString());
        }
        if (this.mActivityManagerInternal.getUidProcessState(uid = jobStatus.getSourceUid()) <= 2) {
            if (DEBUG) {
                Slog.d(TAG, jobStatus.toShortString() + " is top started job");
            }
            this.mTopStartedJobs.add(jobStatus);
            return;
        }
        int userId = jobStatus.getSourceUserId();
        Timer timer = this.mPkgTimers.get(userId, packageName = jobStatus.getSourcePackageName());
        if (timer == null) {
            timer = new Timer(uid, userId, packageName);
            this.mPkgTimers.add(userId, packageName, timer);
        }
        timer.startTrackingJobLocked(jobStatus);
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
        if (jobStatus.clearTrackingController(64)) {
            ArraySet<JobStatus> jobs;
            Timer timer = this.mPkgTimers.get(jobStatus.getSourceUserId(), jobStatus.getSourcePackageName());
            if (timer != null) {
                timer.stopTrackingJob(jobStatus);
            }
            if ((jobs = this.mTrackedJobs.get(jobStatus.getSourceUserId(), jobStatus.getSourcePackageName())) != null) {
                jobs.remove(jobStatus);
            }
            this.mTopStartedJobs.remove(jobStatus);
        }
    }

    @Override
    public void onConstantsUpdatedLocked() {
        if (this.mShouldThrottle == this.mConstants.USE_HEARTBEATS) {
            this.mShouldThrottle = !this.mConstants.USE_HEARTBEATS;
            BackgroundThread.getHandler().post(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    this.maybeUpdateAllConstraintsLocked();
                }
            });
        }
    }

    @Override
    public void onAppRemovedLocked(String packageName, int uid) {
        if (packageName == null) {
            Slog.wtf(TAG, "Told app removed but given null package name.");
            return;
        }
        int userId = UserHandle.getUserId(uid);
        this.mTrackedJobs.delete(userId, packageName);
        Timer timer = this.mPkgTimers.get(userId, packageName);
        if (timer != null) {
            if (timer.isActive()) {
                Slog.wtf(TAG, "onAppRemovedLocked called before Timer turned off.");
                timer.dropEverythingLocked();
            }
            this.mPkgTimers.delete(userId, packageName);
        }
        this.mTimingSessions.delete(userId, packageName);
        QcAlarmListener alarmListener = this.mInQuotaAlarmListeners.get(userId, packageName);
        if (alarmListener != null) {
            this.mAlarmManager.cancel(alarmListener);
            this.mInQuotaAlarmListeners.delete(userId, packageName);
        }
        this.mExecutionStatsCache.delete(userId, packageName);
        this.mForegroundUids.delete(uid);
        this.mUidToPackageCache.remove(uid);
    }

    @Override
    public void onUserRemovedLocked(int userId) {
        this.mTrackedJobs.delete(userId);
        this.mPkgTimers.delete(userId);
        this.mTimingSessions.delete(userId);
        this.mInQuotaAlarmListeners.delete(userId);
        this.mExecutionStatsCache.delete(userId);
        this.mUidToPackageCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUidInForeground(int uid) {
        if (UserHandle.isCore(uid)) {
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.mForegroundUids.get(uid);
        }
    }

    private boolean isTopStartedJobLocked(JobStatus jobStatus) {
        return this.mTopStartedJobs.contains(jobStatus);
    }

    private int getEffectiveStandbyBucket(JobStatus jobStatus) {
        if (jobStatus.uidActive || jobStatus.getJob().isExemptedFromAppStandby()) {
            return 0;
        }
        return jobStatus.getStandbyBucket();
    }

    @VisibleForTesting
    boolean isWithinQuotaLocked(JobStatus jobStatus) {
        int standbyBucket = this.getEffectiveStandbyBucket(jobStatus);
        return this.isTopStartedJobLocked(jobStatus) || this.isUidInForeground(jobStatus.getSourceUid()) || this.isWithinQuotaLocked(jobStatus.getSourceUserId(), jobStatus.getSourcePackageName(), standbyBucket);
    }

    @VisibleForTesting
    boolean isWithinQuotaLocked(int userId, String packageName, int standbyBucket) {
        if (standbyBucket == 4) {
            return false;
        }
        if (!this.mShouldThrottle) {
            return true;
        }
        if (this.mChargeTracker.isCharging() || this.mInParole) {
            return true;
        }
        ExecutionStats stats = this.getExecutionStatsLocked(userId, packageName, standbyBucket);
        return this.getRemainingExecutionTimeLocked(stats) > 0L && this.isUnderJobCountQuotaLocked(stats, standbyBucket) && this.isUnderSessionCountQuotaLocked(stats, standbyBucket);
    }

    private boolean isUnderJobCountQuotaLocked(ExecutionStats stats, int standbyBucket) {
        long now = JobSchedulerService.sElapsedRealtimeClock.millis();
        boolean isUnderAllowedTimeQuota = stats.jobRateLimitExpirationTimeElapsed <= now || stats.jobCountInRateLimitingWindow < this.mMaxJobCountPerRateLimitingWindow;
        return isUnderAllowedTimeQuota && stats.bgJobCountInWindow < this.mMaxBucketJobCounts[standbyBucket];
    }

    private boolean isUnderSessionCountQuotaLocked(ExecutionStats stats, int standbyBucket) {
        long now = JobSchedulerService.sElapsedRealtimeClock.millis();
        boolean isUnderAllowedTimeQuota = stats.sessionRateLimitExpirationTimeElapsed <= now || stats.sessionCountInRateLimitingWindow < this.mMaxSessionCountPerRateLimitingWindow;
        return isUnderAllowedTimeQuota && stats.sessionCountInWindow < this.mMaxBucketSessionCounts[standbyBucket];
    }

    @VisibleForTesting
    long getRemainingExecutionTimeLocked(JobStatus jobStatus) {
        return this.getRemainingExecutionTimeLocked(jobStatus.getSourceUserId(), jobStatus.getSourcePackageName(), this.getEffectiveStandbyBucket(jobStatus));
    }

    @VisibleForTesting
    long getRemainingExecutionTimeLocked(int userId, String packageName) {
        int standbyBucket = JobSchedulerService.standbyBucketForPackage(packageName, userId, JobSchedulerService.sElapsedRealtimeClock.millis());
        return this.getRemainingExecutionTimeLocked(userId, packageName, standbyBucket);
    }

    private long getRemainingExecutionTimeLocked(int userId, String packageName, int standbyBucket) {
        if (standbyBucket == 4) {
            return 0L;
        }
        return this.getRemainingExecutionTimeLocked(this.getExecutionStatsLocked(userId, packageName, standbyBucket));
    }

    private long getRemainingExecutionTimeLocked(ExecutionStats stats) {
        return Math.min(this.mAllowedTimePerPeriodMs - stats.executionTimeInWindowMs, this.mMaxExecutionTimeMs - stats.executionTimeInMaxPeriodMs);
    }

    @VisibleForTesting
    long getTimeUntilQuotaConsumedLocked(int userId, String packageName) {
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        int standbyBucket = JobSchedulerService.standbyBucketForPackage(packageName, userId, nowElapsed);
        if (standbyBucket == 4) {
            return 0L;
        }
        List<TimingSession> sessions = this.mTimingSessions.get(userId, packageName);
        if (sessions == null || sessions.size() == 0) {
            return this.mAllowedTimePerPeriodMs;
        }
        ExecutionStats stats = this.getExecutionStatsLocked(userId, packageName, standbyBucket);
        long startWindowElapsed = nowElapsed - stats.windowSizeMs;
        long startMaxElapsed = nowElapsed - 86400000L;
        long allowedTimeRemainingMs = this.mAllowedTimePerPeriodMs - stats.executionTimeInWindowMs;
        long maxExecutionTimeRemainingMs = this.mMaxExecutionTimeMs - stats.executionTimeInMaxPeriodMs;
        if (stats.windowSizeMs == this.mAllowedTimePerPeriodMs) {
            return this.calculateTimeUntilQuotaConsumedLocked(sessions, startMaxElapsed, maxExecutionTimeRemainingMs);
        }
        return Math.min(this.calculateTimeUntilQuotaConsumedLocked(sessions, startMaxElapsed, maxExecutionTimeRemainingMs), this.calculateTimeUntilQuotaConsumedLocked(sessions, startWindowElapsed, allowedTimeRemainingMs));
    }

    private long calculateTimeUntilQuotaConsumedLocked(List<TimingSession> sessions, long windowStartElapsed, long deadSpaceMs) {
        long timeUntilQuotaConsumedMs = 0L;
        long start = windowStartElapsed;
        for (int i = 0; i < sessions.size(); ++i) {
            TimingSession session = sessions.get(i);
            if (session.endTimeElapsed < windowStartElapsed) continue;
            if (session.startTimeElapsed <= windowStartElapsed) {
                timeUntilQuotaConsumedMs += session.endTimeElapsed - windowStartElapsed;
                start = session.endTimeElapsed;
                continue;
            }
            long diff = session.startTimeElapsed - start;
            if (diff > deadSpaceMs) break;
            timeUntilQuotaConsumedMs += diff + (session.endTimeElapsed - session.startTimeElapsed);
            deadSpaceMs -= diff;
            start = session.endTimeElapsed;
        }
        if ((timeUntilQuotaConsumedMs += deadSpaceMs) > this.mMaxExecutionTimeMs) {
            Slog.wtf(TAG, "Calculated quota consumed time too high: " + timeUntilQuotaConsumedMs);
        }
        return timeUntilQuotaConsumedMs;
    }

    @VisibleForTesting
    ExecutionStats getExecutionStatsLocked(int userId, String packageName, int standbyBucket) {
        return this.getExecutionStatsLocked(userId, packageName, standbyBucket, true);
    }

    private ExecutionStats getExecutionStatsLocked(int userId, String packageName, int standbyBucket, boolean refreshStatsIfOld) {
        ExecutionStats stats;
        if (standbyBucket == 4) {
            Slog.wtf(TAG, "getExecutionStatsLocked called for a NEVER app.");
            return new ExecutionStats();
        }
        ExecutionStats[] appStats = this.mExecutionStatsCache.get(userId, packageName);
        if (appStats == null) {
            appStats = new ExecutionStats[this.mBucketPeriodsMs.length];
            this.mExecutionStatsCache.add(userId, packageName, appStats);
        }
        if ((stats = appStats[standbyBucket]) == null) {
            appStats[standbyBucket] = stats = new ExecutionStats();
        }
        if (refreshStatsIfOld) {
            long bucketWindowSizeMs = this.mBucketPeriodsMs[standbyBucket];
            int jobCountLimit = this.mMaxBucketJobCounts[standbyBucket];
            int sessionCountLimit = this.mMaxBucketSessionCounts[standbyBucket];
            Timer timer = this.mPkgTimers.get(userId, packageName);
            if (timer != null && timer.isActive() || stats.expirationTimeElapsed <= JobSchedulerService.sElapsedRealtimeClock.millis() || stats.windowSizeMs != bucketWindowSizeMs || stats.jobCountLimit != jobCountLimit || stats.sessionCountLimit != sessionCountLimit) {
                stats.windowSizeMs = bucketWindowSizeMs;
                stats.jobCountLimit = jobCountLimit;
                stats.sessionCountLimit = sessionCountLimit;
                this.updateExecutionStatsLocked(userId, packageName, stats);
            }
        }
        return stats;
    }

    @VisibleForTesting
    void updateExecutionStatsLocked(int userId, String packageName, ExecutionStats stats) {
        int loopStart;
        List<TimingSession> sessions;
        stats.executionTimeInWindowMs = 0L;
        stats.bgJobCountInWindow = 0;
        stats.executionTimeInMaxPeriodMs = 0L;
        stats.bgJobCountInMaxPeriod = 0;
        stats.sessionCountInWindow = 0;
        stats.inQuotaTimeElapsed = 0L;
        Timer timer = this.mPkgTimers.get(userId, packageName);
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        stats.expirationTimeElapsed = nowElapsed + 86400000L;
        if (timer != null && timer.isActive()) {
            stats.executionTimeInWindowMs = stats.executionTimeInMaxPeriodMs = timer.getCurrentDuration(nowElapsed);
            stats.bgJobCountInWindow = stats.bgJobCountInMaxPeriod = timer.getBgJobCount();
            stats.expirationTimeElapsed = nowElapsed;
            if (stats.executionTimeInWindowMs >= this.mAllowedTimeIntoQuotaMs) {
                stats.inQuotaTimeElapsed = Math.max(stats.inQuotaTimeElapsed, nowElapsed - this.mAllowedTimeIntoQuotaMs + stats.windowSizeMs);
            }
            if (stats.executionTimeInMaxPeriodMs >= this.mMaxExecutionTimeIntoQuotaMs) {
                stats.inQuotaTimeElapsed = Math.max(stats.inQuotaTimeElapsed, nowElapsed - this.mMaxExecutionTimeIntoQuotaMs + 86400000L);
            }
        }
        if ((sessions = this.mTimingSessions.get(userId, packageName)) == null || sessions.size() == 0) {
            return;
        }
        long startWindowElapsed = nowElapsed - stats.windowSizeMs;
        long startMaxElapsed = nowElapsed - 86400000L;
        int sessionCountInWindow = 0;
        long emptyTimeMs = Long.MAX_VALUE;
        for (int i = loopStart = sessions.size() - 1; i >= 0; --i) {
            TimingSession session = sessions.get(i);
            if (startWindowElapsed < session.endTimeElapsed) {
                long start;
                if (startWindowElapsed < session.startTimeElapsed) {
                    start = session.startTimeElapsed;
                    emptyTimeMs = Math.min(emptyTimeMs, session.startTimeElapsed - startWindowElapsed);
                } else {
                    start = startWindowElapsed;
                    emptyTimeMs = 0L;
                }
                stats.executionTimeInWindowMs += session.endTimeElapsed - start;
                stats.bgJobCountInWindow += session.bgJobCount;
                if (stats.executionTimeInWindowMs >= this.mAllowedTimeIntoQuotaMs) {
                    stats.inQuotaTimeElapsed = Math.max(stats.inQuotaTimeElapsed, start + stats.executionTimeInWindowMs - this.mAllowedTimeIntoQuotaMs + stats.windowSizeMs);
                }
                if (stats.bgJobCountInWindow >= stats.jobCountLimit) {
                    stats.inQuotaTimeElapsed = Math.max(stats.inQuotaTimeElapsed, session.endTimeElapsed + stats.windowSizeMs);
                }
                if ((i == loopStart || sessions.get((int)(i + 1)).startTimeElapsed - session.endTimeElapsed > this.mTimingSessionCoalescingDurationMs) && ++sessionCountInWindow >= stats.sessionCountLimit) {
                    stats.inQuotaTimeElapsed = Math.max(stats.inQuotaTimeElapsed, session.endTimeElapsed + stats.windowSizeMs);
                }
            }
            if (startMaxElapsed < session.startTimeElapsed) {
                stats.executionTimeInMaxPeriodMs += session.endTimeElapsed - session.startTimeElapsed;
                stats.bgJobCountInMaxPeriod += session.bgJobCount;
                emptyTimeMs = Math.min(emptyTimeMs, session.startTimeElapsed - startMaxElapsed);
                if (stats.executionTimeInMaxPeriodMs < this.mMaxExecutionTimeIntoQuotaMs) continue;
                stats.inQuotaTimeElapsed = Math.max(stats.inQuotaTimeElapsed, session.startTimeElapsed + stats.executionTimeInMaxPeriodMs - this.mMaxExecutionTimeIntoQuotaMs + 86400000L);
                continue;
            }
            if (startMaxElapsed >= session.endTimeElapsed) break;
            stats.executionTimeInMaxPeriodMs += session.endTimeElapsed - startMaxElapsed;
            stats.bgJobCountInMaxPeriod += session.bgJobCount;
            emptyTimeMs = 0L;
            if (stats.executionTimeInMaxPeriodMs < this.mMaxExecutionTimeIntoQuotaMs) continue;
            stats.inQuotaTimeElapsed = Math.max(stats.inQuotaTimeElapsed, startMaxElapsed + stats.executionTimeInMaxPeriodMs - this.mMaxExecutionTimeIntoQuotaMs + 86400000L);
        }
        stats.expirationTimeElapsed = nowElapsed + emptyTimeMs;
        stats.sessionCountInWindow = sessionCountInWindow;
    }

    @VisibleForTesting
    void invalidateAllExecutionStatsLocked() {
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        this.mExecutionStatsCache.forEach(appStats -> {
            if (appStats != null) {
                for (int i = 0; i < ((ExecutionStats[])appStats).length; ++i) {
                    ExecutionStats stats = appStats[i];
                    if (stats == null) continue;
                    stats.expirationTimeElapsed = nowElapsed;
                }
            }
        });
    }

    @VisibleForTesting
    void invalidateAllExecutionStatsLocked(int userId, String packageName) {
        ExecutionStats[] appStats = this.mExecutionStatsCache.get(userId, packageName);
        if (appStats != null) {
            long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
            for (int i = 0; i < appStats.length; ++i) {
                ExecutionStats stats = appStats[i];
                if (stats == null) continue;
                stats.expirationTimeElapsed = nowElapsed;
            }
        }
    }

    @VisibleForTesting
    void incrementJobCount(int userId, String packageName, int count) {
        long now = JobSchedulerService.sElapsedRealtimeClock.millis();
        ExecutionStats[] appStats = this.mExecutionStatsCache.get(userId, packageName);
        if (appStats == null) {
            appStats = new ExecutionStats[this.mBucketPeriodsMs.length];
            this.mExecutionStatsCache.add(userId, packageName, appStats);
        }
        for (int i = 0; i < appStats.length; ++i) {
            ExecutionStats stats = appStats[i];
            if (stats == null) {
                appStats[i] = stats = new ExecutionStats();
            }
            if (stats.jobRateLimitExpirationTimeElapsed <= now) {
                stats.jobRateLimitExpirationTimeElapsed = now + this.mRateLimitingWindowMs;
                stats.jobCountInRateLimitingWindow = 0;
            }
            stats.jobCountInRateLimitingWindow += count;
        }
    }

    private void incrementTimingSessionCount(int userId, String packageName) {
        long now = JobSchedulerService.sElapsedRealtimeClock.millis();
        ExecutionStats[] appStats = this.mExecutionStatsCache.get(userId, packageName);
        if (appStats == null) {
            appStats = new ExecutionStats[this.mBucketPeriodsMs.length];
            this.mExecutionStatsCache.add(userId, packageName, appStats);
        }
        for (int i = 0; i < appStats.length; ++i) {
            ExecutionStats stats = appStats[i];
            if (stats == null) {
                appStats[i] = stats = new ExecutionStats();
            }
            if (stats.sessionRateLimitExpirationTimeElapsed <= now) {
                stats.sessionRateLimitExpirationTimeElapsed = now + this.mRateLimitingWindowMs;
                stats.sessionCountInRateLimitingWindow = 0;
            }
            ++stats.sessionCountInRateLimitingWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void saveTimingSession(int userId, String packageName, TimingSession session) {
        Object object = this.mLock;
        synchronized (object) {
            List<TimingSession> sessions = this.mTimingSessions.get(userId, packageName);
            if (sessions == null) {
                sessions = new ArrayList<TimingSession>();
                this.mTimingSessions.add(userId, packageName, sessions);
            }
            sessions.add(session);
            this.invalidateAllExecutionStatsLocked(userId, packageName);
            this.maybeScheduleCleanupAlarmLocked();
        }
    }

    @VisibleForTesting
    void maybeScheduleCleanupAlarmLocked() {
        if (this.mNextCleanupTimeElapsed > JobSchedulerService.sElapsedRealtimeClock.millis()) {
            if (DEBUG) {
                Slog.v(TAG, "Not scheduling cleanup since there's already one at " + this.mNextCleanupTimeElapsed + " (in " + (this.mNextCleanupTimeElapsed - JobSchedulerService.sElapsedRealtimeClock.millis()) + "ms)");
            }
            return;
        }
        this.mEarliestEndTimeFunctor.reset();
        this.mTimingSessions.forEach(this.mEarliestEndTimeFunctor);
        long earliestEndElapsed = this.mEarliestEndTimeFunctor.earliestEndElapsed;
        if (earliestEndElapsed == Long.MAX_VALUE) {
            if (DEBUG) {
                Slog.d(TAG, "Didn't find a time to schedule cleanup");
            }
            return;
        }
        long nextCleanupElapsed = earliestEndElapsed + 86400000L;
        if (nextCleanupElapsed - this.mNextCleanupTimeElapsed <= 600000L) {
            nextCleanupElapsed += 600000L;
        }
        this.mNextCleanupTimeElapsed = nextCleanupElapsed;
        this.mAlarmManager.set(3, nextCleanupElapsed, ALARM_TAG_CLEANUP, this.mSessionCleanupAlarmListener, this.mHandler);
        if (DEBUG) {
            Slog.d(TAG, "Scheduled next cleanup for " + this.mNextCleanupTimeElapsed);
        }
    }

    private void handleNewChargingStateLocked() {
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        boolean isCharging = this.mChargeTracker.isCharging();
        if (DEBUG) {
            Slog.d(TAG, "handleNewChargingStateLocked: " + isCharging);
        }
        this.mPkgTimers.forEach(t -> t.onStateChangedLocked(nowElapsed, isCharging));
        this.maybeUpdateAllConstraintsLocked();
    }

    private void maybeUpdateAllConstraintsLocked() {
        boolean changed = false;
        for (int u = 0; u < this.mTrackedJobs.numUsers(); ++u) {
            int userId = this.mTrackedJobs.keyAt(u);
            for (int p = 0; p < this.mTrackedJobs.numPackagesForUser(userId); ++p) {
                String packageName = this.mTrackedJobs.keyAt(u, p);
                changed |= this.maybeUpdateConstraintForPkgLocked(userId, packageName);
            }
        }
        if (changed) {
            this.mStateChangedListener.onControllerStateChanged();
        }
    }

    private boolean maybeUpdateConstraintForPkgLocked(int userId, String packageName) {
        ArraySet<JobStatus> jobs = this.mTrackedJobs.get(userId, packageName);
        if (jobs == null || jobs.size() == 0) {
            return false;
        }
        int realStandbyBucket = jobs.valueAt(0).getStandbyBucket();
        boolean realInQuota = this.isWithinQuotaLocked(userId, packageName, realStandbyBucket);
        boolean changed = false;
        for (int i = jobs.size() - 1; i >= 0; --i) {
            JobStatus js = jobs.valueAt(i);
            if (this.isTopStartedJobLocked(js)) {
                changed |= js.setQuotaConstraintSatisfied(true);
                continue;
            }
            if (realStandbyBucket != 0 && realStandbyBucket == this.getEffectiveStandbyBucket(js)) {
                changed |= this.setConstraintSatisfied(js, realInQuota);
                continue;
            }
            changed |= this.setConstraintSatisfied(js, this.isWithinQuotaLocked(js));
        }
        if (!realInQuota) {
            this.maybeScheduleStartAlarmLocked(userId, packageName, realStandbyBucket);
        } else {
            QcAlarmListener alarmListener = this.mInQuotaAlarmListeners.get(userId, packageName);
            if (alarmListener != null && alarmListener.isWaiting()) {
                this.mAlarmManager.cancel(alarmListener);
                alarmListener.setTriggerTime(0L);
            }
        }
        return changed;
    }

    private boolean maybeUpdateConstraintForUidLocked(int uid) {
        this.mService.getJobStore().forEachJobForSourceUid(uid, this.mUpdateUidConstraints);
        this.mUpdateUidConstraints.postProcess();
        boolean changed = this.mUpdateUidConstraints.wasJobChanged;
        this.mUpdateUidConstraints.reset();
        return changed;
    }

    @VisibleForTesting
    void maybeScheduleStartAlarmLocked(int userId, String packageName, int standbyBucket) {
        if (standbyBucket == 4) {
            return;
        }
        String pkgString = QuotaController.string(userId, packageName);
        ExecutionStats stats = this.getExecutionStatsLocked(userId, packageName, standbyBucket);
        boolean isUnderJobCountQuota = this.isUnderJobCountQuotaLocked(stats, standbyBucket);
        boolean isUnderTimingSessionCountQuota = this.isUnderSessionCountQuotaLocked(stats, standbyBucket);
        QcAlarmListener alarmListener = this.mInQuotaAlarmListeners.get(userId, packageName);
        if (stats.executionTimeInWindowMs < this.mAllowedTimePerPeriodMs && stats.executionTimeInMaxPeriodMs < this.mMaxExecutionTimeMs && isUnderJobCountQuota && isUnderTimingSessionCountQuota) {
            if (DEBUG) {
                Slog.e(TAG, "maybeScheduleStartAlarmLocked called for " + pkgString + " even though it already has " + this.getRemainingExecutionTimeLocked(userId, packageName, standbyBucket) + "ms in its quota.");
            }
            if (alarmListener != null) {
                this.mAlarmManager.cancel(alarmListener);
                alarmListener.setTriggerTime(0L);
            }
            this.mHandler.obtainMessage(2, userId, 0, packageName).sendToTarget();
            return;
        }
        if (alarmListener == null) {
            alarmListener = new QcAlarmListener(userId, packageName);
            this.mInQuotaAlarmListeners.add(userId, packageName, alarmListener);
        }
        long inQuotaTimeElapsed = stats.inQuotaTimeElapsed;
        if (!isUnderJobCountQuota && stats.bgJobCountInWindow < stats.jobCountLimit) {
            inQuotaTimeElapsed = Math.max(inQuotaTimeElapsed, stats.jobRateLimitExpirationTimeElapsed);
        }
        if (!isUnderTimingSessionCountQuota && stats.sessionCountInWindow < stats.sessionCountLimit) {
            inQuotaTimeElapsed = Math.max(inQuotaTimeElapsed, stats.sessionRateLimitExpirationTimeElapsed);
        }
        if (!alarmListener.isWaiting() || inQuotaTimeElapsed < alarmListener.getTriggerTimeElapsed() - 180000L || alarmListener.getTriggerTimeElapsed() < inQuotaTimeElapsed) {
            if (DEBUG) {
                Slog.d(TAG, "Scheduling start alarm for " + pkgString);
            }
            this.mAlarmManager.set(3, inQuotaTimeElapsed, ALARM_TAG_QUOTA_CHECK, alarmListener, this.mHandler);
            alarmListener.setTriggerTime(inQuotaTimeElapsed);
        } else if (DEBUG) {
            Slog.d(TAG, "No need to schedule start alarm for " + pkgString);
        }
    }

    private boolean setConstraintSatisfied(JobStatus jobStatus, boolean isWithinQuota) {
        if (!isWithinQuota && jobStatus.getWhenStandbyDeferred() == 0L) {
            jobStatus.setWhenStandbyDeferred(JobSchedulerService.sElapsedRealtimeClock.millis());
        }
        return jobStatus.setQuotaConstraintSatisfied(isWithinQuota);
    }

    @VisibleForTesting
    void deleteObsoleteSessionsLocked() {
        this.mTimingSessions.forEach(this.mDeleteOldSessionsFunctor);
    }

    @VisibleForTesting
    long getAllowedTimePerPeriodMs() {
        return this.mAllowedTimePerPeriodMs;
    }

    @VisibleForTesting
    int[] getBucketMaxJobCounts() {
        return this.mMaxBucketJobCounts;
    }

    @VisibleForTesting
    int[] getBucketMaxSessionCounts() {
        return this.mMaxBucketSessionCounts;
    }

    @VisibleForTesting
    long[] getBucketWindowSizes() {
        return this.mBucketPeriodsMs;
    }

    @VisibleForTesting
    SparseBooleanArray getForegroundUids() {
        return this.mForegroundUids;
    }

    @VisibleForTesting
    Handler getHandler() {
        return this.mHandler;
    }

    @VisibleForTesting
    long getInQuotaBufferMs() {
        return this.mQuotaBufferMs;
    }

    @VisibleForTesting
    long getMaxExecutionTimeMs() {
        return this.mMaxExecutionTimeMs;
    }

    @VisibleForTesting
    int getMaxJobCountPerRateLimitingWindow() {
        return this.mMaxJobCountPerRateLimitingWindow;
    }

    @VisibleForTesting
    int getMaxSessionCountPerRateLimitingWindow() {
        return this.mMaxSessionCountPerRateLimitingWindow;
    }

    @VisibleForTesting
    long getRateLimitingWindowMs() {
        return this.mRateLimitingWindowMs;
    }

    @VisibleForTesting
    long getTimingSessionCoalescingDurationMs() {
        return this.mTimingSessionCoalescingDurationMs;
    }

    @VisibleForTesting
    List<TimingSession> getTimingSessions(int userId, String packageName) {
        return this.mTimingSessions.get(userId, packageName);
    }

    @VisibleForTesting
    QcConstants getQcConstants() {
        return this.mQcConstants;
    }

    @Override
    public void dumpControllerStateLocked(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
        String pkgName;
        int p;
        int userId;
        int u;
        pw.println("Is throttling: " + this.mShouldThrottle);
        pw.println("Is charging: " + this.mChargeTracker.isCharging());
        pw.println("In parole: " + this.mInParole);
        pw.println("Current elapsed time: " + JobSchedulerService.sElapsedRealtimeClock.millis());
        pw.println();
        pw.print("Foreground UIDs: ");
        pw.println(this.mForegroundUids.toString());
        pw.println();
        pw.println("Cached UID->package map:");
        pw.increaseIndent();
        for (int i = 0; i < this.mUidToPackageCache.size(); ++i) {
            int uid = this.mUidToPackageCache.keyAt(i);
            pw.print(uid);
            pw.print(": ");
            pw.println(this.mUidToPackageCache.get(uid));
        }
        pw.decreaseIndent();
        pw.println();
        this.mTrackedJobs.forEach(jobs -> {
            for (int j = 0; j < jobs.size(); ++j) {
                JobStatus js = (JobStatus)jobs.valueAt(j);
                if (!predicate.test(js)) continue;
                pw.print("#");
                js.printUniqueId(pw);
                pw.print(" from ");
                UserHandle.formatUid(pw, js.getSourceUid());
                if (this.mTopStartedJobs.contains(js)) {
                    pw.print(" (TOP)");
                }
                pw.println();
                pw.increaseIndent();
                pw.print(JobStatus.bucketName(this.getEffectiveStandbyBucket(js)));
                pw.print(", ");
                if (js.isConstraintSatisfied(0x1000000)) {
                    pw.print("within quota");
                } else {
                    pw.print("not within quota");
                }
                pw.print(", ");
                pw.print(this.getRemainingExecutionTimeLocked(js));
                pw.print("ms remaining in quota");
                pw.decreaseIndent();
                pw.println();
            }
        });
        pw.println();
        for (u = 0; u < this.mPkgTimers.numUsers(); ++u) {
            userId = this.mPkgTimers.keyAt(u);
            for (p = 0; p < this.mPkgTimers.numPackagesForUser(userId); ++p) {
                pkgName = this.mPkgTimers.keyAt(u, p);
                this.mPkgTimers.valueAt(u, p).dump(pw, predicate);
                pw.println();
                List<TimingSession> sessions = this.mTimingSessions.get(userId, pkgName);
                if (sessions == null) continue;
                pw.increaseIndent();
                pw.println("Saved sessions:");
                pw.increaseIndent();
                for (int j = sessions.size() - 1; j >= 0; --j) {
                    TimingSession session = sessions.get(j);
                    session.dump(pw);
                }
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.println();
            }
        }
        pw.println("Cached execution stats:");
        pw.increaseIndent();
        for (u = 0; u < this.mExecutionStatsCache.numUsers(); ++u) {
            userId = this.mExecutionStatsCache.keyAt(u);
            for (p = 0; p < this.mExecutionStatsCache.numPackagesForUser(userId); ++p) {
                pkgName = this.mExecutionStatsCache.keyAt(u, p);
                ExecutionStats[] stats = this.mExecutionStatsCache.valueAt(u, p);
                pw.println(QuotaController.string(userId, pkgName));
                pw.increaseIndent();
                for (int i = 0; i < stats.length; ++i) {
                    ExecutionStats executionStats = stats[i];
                    if (executionStats == null) continue;
                    pw.print(JobStatus.bucketName(i));
                    pw.print(": ");
                    pw.println(executionStats);
                }
                pw.decreaseIndent();
            }
        }
        pw.decreaseIndent();
        pw.println();
        pw.println("In quota alarms:");
        pw.increaseIndent();
        for (u = 0; u < this.mInQuotaAlarmListeners.numUsers(); ++u) {
            userId = this.mInQuotaAlarmListeners.keyAt(u);
            for (p = 0; p < this.mInQuotaAlarmListeners.numPackagesForUser(userId); ++p) {
                pkgName = this.mInQuotaAlarmListeners.keyAt(u, p);
                QcAlarmListener alarmListener = this.mInQuotaAlarmListeners.valueAt(u, p);
                pw.print(QuotaController.string(userId, pkgName));
                pw.print(": ");
                if (alarmListener.isWaiting()) {
                    pw.println(alarmListener.getTriggerTimeElapsed());
                    continue;
                }
                pw.println("NOT WAITING");
            }
        }
        pw.decreaseIndent();
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268041L);
        proto.write(0x10800000001L, this.mChargeTracker.isCharging());
        proto.write(1133871366146L, this.mInParole);
        proto.write(1112396529670L, JobSchedulerService.sElapsedRealtimeClock.millis());
        for (int i = 0; i < this.mForegroundUids.size(); ++i) {
            proto.write(2220498092035L, this.mForegroundUids.keyAt(i));
        }
        this.mTrackedJobs.forEach(jobs -> {
            for (int j = 0; j < jobs.size(); ++j) {
                JobStatus js = (JobStatus)jobs.valueAt(j);
                if (!predicate.test(js)) continue;
                long jsToken = proto.start(2246267895812L);
                js.writeToShortProto(proto, 0x10B00000001L);
                proto.write(1120986464258L, js.getSourceUid());
                proto.write(1159641169923L, this.getEffectiveStandbyBucket(js));
                proto.write(1133871366148L, this.mTopStartedJobs.contains(js));
                proto.write(1133871366149L, js.isConstraintSatisfied(0x1000000));
                proto.write(1112396529670L, this.getRemainingExecutionTimeLocked(js));
                proto.end(jsToken);
            }
        });
        for (int u = 0; u < this.mPkgTimers.numUsers(); ++u) {
            int userId = this.mPkgTimers.keyAt(u);
            for (int p = 0; p < this.mPkgTimers.numPackagesForUser(userId); ++p) {
                QcAlarmListener alarmListener;
                ExecutionStats[] stats;
                String pkgName = this.mPkgTimers.keyAt(u, p);
                long psToken = proto.start(2246267895813L);
                this.mPkgTimers.valueAt(u, p).dump(proto, 1146756268034L, predicate);
                List<TimingSession> sessions = this.mTimingSessions.get(userId, pkgName);
                if (sessions != null) {
                    for (int j = sessions.size() - 1; j >= 0; --j) {
                        TimingSession session = sessions.get(j);
                        session.dump(proto, 2246267895811L);
                    }
                }
                if ((stats = this.mExecutionStatsCache.get(userId, pkgName)) != null) {
                    for (int bucketIndex = 0; bucketIndex < stats.length; ++bucketIndex) {
                        ExecutionStats es = stats[bucketIndex];
                        if (es == null) continue;
                        long esToken = proto.start(2246267895812L);
                        proto.write(0x10E00000001L, bucketIndex);
                        proto.write(1112396529666L, es.expirationTimeElapsed);
                        proto.write(0x10300000003L, es.windowSizeMs);
                        proto.write(1120986464270L, es.jobCountLimit);
                        proto.write(1120986464271L, es.sessionCountLimit);
                        proto.write(1112396529668L, es.executionTimeInWindowMs);
                        proto.write(0x10500000005L, es.bgJobCountInWindow);
                        proto.write(1112396529670L, es.executionTimeInMaxPeriodMs);
                        proto.write(1120986464263L, es.bgJobCountInMaxPeriod);
                        proto.write(1120986464267L, es.sessionCountInWindow);
                        proto.write(1112396529672L, es.inQuotaTimeElapsed);
                        proto.write(1112396529673L, es.jobRateLimitExpirationTimeElapsed);
                        proto.write(1120986464266L, es.jobCountInRateLimitingWindow);
                        proto.write(1112396529676L, es.sessionRateLimitExpirationTimeElapsed);
                        proto.write(1120986464269L, es.sessionCountInRateLimitingWindow);
                        proto.end(esToken);
                    }
                }
                if ((alarmListener = this.mInQuotaAlarmListeners.get(userId, pkgName)) != null) {
                    long alToken = proto.start(1146756268037L);
                    proto.write(0x10800000001L, alarmListener.isWaiting());
                    proto.write(1112396529666L, alarmListener.getTriggerTimeElapsed());
                    proto.end(alToken);
                }
                proto.end(psToken);
            }
        }
        proto.end(mToken);
        proto.end(token);
    }

    @Override
    public void dumpConstants(IndentingPrintWriter pw) {
        this.mQcConstants.dump(pw);
    }

    @Override
    public void dumpConstants(ProtoOutputStream proto) {
        this.mQcConstants.dump(proto);
    }

    @VisibleForTesting
    class QcConstants
    extends ContentObserver {
        private ContentResolver mResolver;
        private final KeyValueListParser mParser;
        private static final String KEY_ALLOWED_TIME_PER_PERIOD_MS = "allowed_time_per_period_ms";
        private static final String KEY_IN_QUOTA_BUFFER_MS = "in_quota_buffer_ms";
        private static final String KEY_WINDOW_SIZE_ACTIVE_MS = "window_size_active_ms";
        private static final String KEY_WINDOW_SIZE_WORKING_MS = "window_size_working_ms";
        private static final String KEY_WINDOW_SIZE_FREQUENT_MS = "window_size_frequent_ms";
        private static final String KEY_WINDOW_SIZE_RARE_MS = "window_size_rare_ms";
        private static final String KEY_MAX_EXECUTION_TIME_MS = "max_execution_time_ms";
        private static final String KEY_MAX_JOB_COUNT_ACTIVE = "max_job_count_active";
        private static final String KEY_MAX_JOB_COUNT_WORKING = "max_job_count_working";
        private static final String KEY_MAX_JOB_COUNT_FREQUENT = "max_job_count_frequent";
        private static final String KEY_MAX_JOB_COUNT_RARE = "max_job_count_rare";
        private static final String KEY_RATE_LIMITING_WINDOW_MS = "rate_limiting_window_ms";
        private static final String KEY_MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW = "max_job_count_per_rate_limiting_window";
        private static final String KEY_MAX_SESSION_COUNT_ACTIVE = "max_session_count_active";
        private static final String KEY_MAX_SESSION_COUNT_WORKING = "max_session_count_working";
        private static final String KEY_MAX_SESSION_COUNT_FREQUENT = "max_session_count_frequent";
        private static final String KEY_MAX_SESSION_COUNT_RARE = "max_session_count_rare";
        private static final String KEY_MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW = "max_session_count_per_rate_limiting_window";
        private static final String KEY_TIMING_SESSION_COALESCING_DURATION_MS = "timing_session_coalescing_duration_ms";
        private static final long DEFAULT_ALLOWED_TIME_PER_PERIOD_MS = 600000L;
        private static final long DEFAULT_IN_QUOTA_BUFFER_MS = 30000L;
        private static final long DEFAULT_WINDOW_SIZE_ACTIVE_MS = 600000L;
        private static final long DEFAULT_WINDOW_SIZE_WORKING_MS = 0x6DDD00L;
        private static final long DEFAULT_WINDOW_SIZE_FREQUENT_MS = 28800000L;
        private static final long DEFAULT_WINDOW_SIZE_RARE_MS = 86400000L;
        private static final long DEFAULT_MAX_EXECUTION_TIME_MS = 14400000L;
        private static final long DEFAULT_RATE_LIMITING_WINDOW_MS = 600000L;
        private static final int DEFAULT_MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW = 20;
        private static final int DEFAULT_MAX_JOB_COUNT_ACTIVE = 20;
        private static final int DEFAULT_MAX_JOB_COUNT_WORKING = 120;
        private static final int DEFAULT_MAX_JOB_COUNT_FREQUENT = 200;
        private static final int DEFAULT_MAX_JOB_COUNT_RARE = 48;
        private static final int DEFAULT_MAX_SESSION_COUNT_ACTIVE = 20;
        private static final int DEFAULT_MAX_SESSION_COUNT_WORKING = 10;
        private static final int DEFAULT_MAX_SESSION_COUNT_FREQUENT = 8;
        private static final int DEFAULT_MAX_SESSION_COUNT_RARE = 3;
        private static final int DEFAULT_MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW = 20;
        private static final long DEFAULT_TIMING_SESSION_COALESCING_DURATION_MS = 5000L;
        public long ALLOWED_TIME_PER_PERIOD_MS;
        public long IN_QUOTA_BUFFER_MS;
        public long WINDOW_SIZE_ACTIVE_MS;
        public long WINDOW_SIZE_WORKING_MS;
        public long WINDOW_SIZE_FREQUENT_MS;
        public long WINDOW_SIZE_RARE_MS;
        public long MAX_EXECUTION_TIME_MS;
        public int MAX_JOB_COUNT_ACTIVE;
        public int MAX_JOB_COUNT_WORKING;
        public int MAX_JOB_COUNT_FREQUENT;
        public int MAX_JOB_COUNT_RARE;
        public long RATE_LIMITING_WINDOW_MS;
        public int MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW;
        public int MAX_SESSION_COUNT_ACTIVE;
        public int MAX_SESSION_COUNT_WORKING;
        public int MAX_SESSION_COUNT_FREQUENT;
        public int MAX_SESSION_COUNT_RARE;
        public int MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW;
        public long TIMING_SESSION_COALESCING_DURATION_MS;
        private static final int MIN_BUCKET_JOB_COUNT = 10;
        private static final int MIN_BUCKET_SESSION_COUNT = 1;
        private static final long MIN_MAX_EXECUTION_TIME_MS = 3600000L;
        private static final int MIN_MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW = 10;
        private static final int MIN_MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW = 10;
        private static final long MIN_RATE_LIMITING_WINDOW_MS = 30000L;

        QcConstants(Handler handler) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
            this.ALLOWED_TIME_PER_PERIOD_MS = 600000L;
            this.IN_QUOTA_BUFFER_MS = 30000L;
            this.WINDOW_SIZE_ACTIVE_MS = 600000L;
            this.WINDOW_SIZE_WORKING_MS = 0x6DDD00L;
            this.WINDOW_SIZE_FREQUENT_MS = 28800000L;
            this.WINDOW_SIZE_RARE_MS = 86400000L;
            this.MAX_EXECUTION_TIME_MS = 14400000L;
            this.MAX_JOB_COUNT_ACTIVE = 20;
            this.MAX_JOB_COUNT_WORKING = 120;
            this.MAX_JOB_COUNT_FREQUENT = 200;
            this.MAX_JOB_COUNT_RARE = 48;
            this.RATE_LIMITING_WINDOW_MS = 600000L;
            this.MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW = 20;
            this.MAX_SESSION_COUNT_ACTIVE = 20;
            this.MAX_SESSION_COUNT_WORKING = 10;
            this.MAX_SESSION_COUNT_FREQUENT = 8;
            this.MAX_SESSION_COUNT_RARE = 3;
            this.MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW = 20;
            this.TIMING_SESSION_COALESCING_DURATION_MS = 5000L;
        }

        private void start(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("job_scheduler_quota_controller_constants"), false, this);
            this.updateConstants();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            String constants = Settings.Global.getString(this.mResolver, "job_scheduler_quota_controller_constants");
            try {
                this.mParser.setString(constants);
            }
            catch (Exception e) {
                Slog.e(QuotaController.TAG, "Bad jobscheduler quota controller settings", e);
            }
            this.ALLOWED_TIME_PER_PERIOD_MS = this.mParser.getDurationMillis(KEY_ALLOWED_TIME_PER_PERIOD_MS, 600000L);
            this.IN_QUOTA_BUFFER_MS = this.mParser.getDurationMillis(KEY_IN_QUOTA_BUFFER_MS, 30000L);
            this.WINDOW_SIZE_ACTIVE_MS = this.mParser.getDurationMillis(KEY_WINDOW_SIZE_ACTIVE_MS, 600000L);
            this.WINDOW_SIZE_WORKING_MS = this.mParser.getDurationMillis(KEY_WINDOW_SIZE_WORKING_MS, 0x6DDD00L);
            this.WINDOW_SIZE_FREQUENT_MS = this.mParser.getDurationMillis(KEY_WINDOW_SIZE_FREQUENT_MS, 28800000L);
            this.WINDOW_SIZE_RARE_MS = this.mParser.getDurationMillis(KEY_WINDOW_SIZE_RARE_MS, 86400000L);
            this.MAX_EXECUTION_TIME_MS = this.mParser.getDurationMillis(KEY_MAX_EXECUTION_TIME_MS, 14400000L);
            this.MAX_JOB_COUNT_ACTIVE = this.mParser.getInt(KEY_MAX_JOB_COUNT_ACTIVE, 20);
            this.MAX_JOB_COUNT_WORKING = this.mParser.getInt(KEY_MAX_JOB_COUNT_WORKING, 120);
            this.MAX_JOB_COUNT_FREQUENT = this.mParser.getInt(KEY_MAX_JOB_COUNT_FREQUENT, 200);
            this.MAX_JOB_COUNT_RARE = this.mParser.getInt(KEY_MAX_JOB_COUNT_RARE, 48);
            this.RATE_LIMITING_WINDOW_MS = this.mParser.getLong(KEY_RATE_LIMITING_WINDOW_MS, 600000L);
            this.MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW = this.mParser.getInt(KEY_MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW, 20);
            this.MAX_SESSION_COUNT_ACTIVE = this.mParser.getInt(KEY_MAX_SESSION_COUNT_ACTIVE, 20);
            this.MAX_SESSION_COUNT_WORKING = this.mParser.getInt(KEY_MAX_SESSION_COUNT_WORKING, 10);
            this.MAX_SESSION_COUNT_FREQUENT = this.mParser.getInt(KEY_MAX_SESSION_COUNT_FREQUENT, 8);
            this.MAX_SESSION_COUNT_RARE = this.mParser.getInt(KEY_MAX_SESSION_COUNT_RARE, 3);
            this.MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW = this.mParser.getInt(KEY_MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW, 20);
            this.TIMING_SESSION_COALESCING_DURATION_MS = this.mParser.getLong(KEY_TIMING_SESSION_COALESCING_DURATION_MS, 5000L);
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        void updateConstants() {
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                boolean changed = false;
                long newMaxExecutionTimeMs = Math.max(3600000L, Math.min(86400000L, this.MAX_EXECUTION_TIME_MS));
                if (QuotaController.this.mMaxExecutionTimeMs != newMaxExecutionTimeMs) {
                    QuotaController.this.mMaxExecutionTimeMs = newMaxExecutionTimeMs;
                    QuotaController.this.mMaxExecutionTimeIntoQuotaMs = QuotaController.this.mMaxExecutionTimeMs - QuotaController.this.mQuotaBufferMs;
                    changed = true;
                }
                long newAllowedTimeMs = Math.min(QuotaController.this.mMaxExecutionTimeMs, Math.max(60000L, this.ALLOWED_TIME_PER_PERIOD_MS));
                if (QuotaController.this.mAllowedTimePerPeriodMs != newAllowedTimeMs) {
                    QuotaController.this.mAllowedTimePerPeriodMs = newAllowedTimeMs;
                    QuotaController.this.mAllowedTimeIntoQuotaMs = QuotaController.this.mAllowedTimePerPeriodMs - QuotaController.this.mQuotaBufferMs;
                    changed = true;
                }
                long newQuotaBufferMs = Math.max(0L, Math.min(300000L, this.IN_QUOTA_BUFFER_MS));
                if (QuotaController.this.mQuotaBufferMs != newQuotaBufferMs) {
                    QuotaController.this.mQuotaBufferMs = newQuotaBufferMs;
                    QuotaController.this.mAllowedTimeIntoQuotaMs = QuotaController.this.mAllowedTimePerPeriodMs - QuotaController.this.mQuotaBufferMs;
                    QuotaController.this.mMaxExecutionTimeIntoQuotaMs = QuotaController.this.mMaxExecutionTimeMs - QuotaController.this.mQuotaBufferMs;
                    changed = true;
                }
                long newActivePeriodMs = Math.max(QuotaController.this.mAllowedTimePerPeriodMs, Math.min(86400000L, this.WINDOW_SIZE_ACTIVE_MS));
                if (QuotaController.this.mBucketPeriodsMs[0] != newActivePeriodMs) {
                    ((QuotaController)QuotaController.this).mBucketPeriodsMs[0] = newActivePeriodMs;
                    changed = true;
                }
                long newWorkingPeriodMs = Math.max(QuotaController.this.mAllowedTimePerPeriodMs, Math.min(86400000L, this.WINDOW_SIZE_WORKING_MS));
                if (QuotaController.this.mBucketPeriodsMs[1] != newWorkingPeriodMs) {
                    ((QuotaController)QuotaController.this).mBucketPeriodsMs[1] = newWorkingPeriodMs;
                    changed = true;
                }
                long newFrequentPeriodMs = Math.max(QuotaController.this.mAllowedTimePerPeriodMs, Math.min(86400000L, this.WINDOW_SIZE_FREQUENT_MS));
                if (QuotaController.this.mBucketPeriodsMs[2] != newFrequentPeriodMs) {
                    ((QuotaController)QuotaController.this).mBucketPeriodsMs[2] = newFrequentPeriodMs;
                    changed = true;
                }
                long newRarePeriodMs = Math.max(QuotaController.this.mAllowedTimePerPeriodMs, Math.min(86400000L, this.WINDOW_SIZE_RARE_MS));
                if (QuotaController.this.mBucketPeriodsMs[3] != newRarePeriodMs) {
                    ((QuotaController)QuotaController.this).mBucketPeriodsMs[3] = newRarePeriodMs;
                    changed = true;
                }
                long newRateLimitingWindowMs = Math.min(86400000L, Math.max(30000L, this.RATE_LIMITING_WINDOW_MS));
                if (QuotaController.this.mRateLimitingWindowMs != newRateLimitingWindowMs) {
                    QuotaController.this.mRateLimitingWindowMs = newRateLimitingWindowMs;
                    changed = true;
                }
                int newMaxJobCountPerRateLimitingWindow = Math.max(10, this.MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW);
                if (QuotaController.this.mMaxJobCountPerRateLimitingWindow != newMaxJobCountPerRateLimitingWindow) {
                    QuotaController.this.mMaxJobCountPerRateLimitingWindow = newMaxJobCountPerRateLimitingWindow;
                    changed = true;
                }
                int newActiveMaxJobCount = Math.max(10, this.MAX_JOB_COUNT_ACTIVE);
                if (QuotaController.this.mMaxBucketJobCounts[0] != newActiveMaxJobCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketJobCounts[0] = newActiveMaxJobCount;
                    changed = true;
                }
                int newWorkingMaxJobCount = Math.max(10, this.MAX_JOB_COUNT_WORKING);
                if (QuotaController.this.mMaxBucketJobCounts[1] != newWorkingMaxJobCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketJobCounts[1] = newWorkingMaxJobCount;
                    changed = true;
                }
                int newFrequentMaxJobCount = Math.max(10, this.MAX_JOB_COUNT_FREQUENT);
                if (QuotaController.this.mMaxBucketJobCounts[2] != newFrequentMaxJobCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketJobCounts[2] = newFrequentMaxJobCount;
                    changed = true;
                }
                int newRareMaxJobCount = Math.max(10, this.MAX_JOB_COUNT_RARE);
                if (QuotaController.this.mMaxBucketJobCounts[3] != newRareMaxJobCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketJobCounts[3] = newRareMaxJobCount;
                    changed = true;
                }
                int newMaxSessionCountPerRateLimitPeriod = Math.max(10, this.MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW);
                if (QuotaController.this.mMaxSessionCountPerRateLimitingWindow != newMaxSessionCountPerRateLimitPeriod) {
                    QuotaController.this.mMaxSessionCountPerRateLimitingWindow = newMaxSessionCountPerRateLimitPeriod;
                    changed = true;
                }
                int newActiveMaxSessionCount = Math.max(1, this.MAX_SESSION_COUNT_ACTIVE);
                if (QuotaController.this.mMaxBucketSessionCounts[0] != newActiveMaxSessionCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketSessionCounts[0] = newActiveMaxSessionCount;
                    changed = true;
                }
                int newWorkingMaxSessionCount = Math.max(1, this.MAX_SESSION_COUNT_WORKING);
                if (QuotaController.this.mMaxBucketSessionCounts[1] != newWorkingMaxSessionCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketSessionCounts[1] = newWorkingMaxSessionCount;
                    changed = true;
                }
                int newFrequentMaxSessionCount = Math.max(1, this.MAX_SESSION_COUNT_FREQUENT);
                if (QuotaController.this.mMaxBucketSessionCounts[2] != newFrequentMaxSessionCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketSessionCounts[2] = newFrequentMaxSessionCount;
                    changed = true;
                }
                int newRareMaxSessionCount = Math.max(1, this.MAX_SESSION_COUNT_RARE);
                if (QuotaController.this.mMaxBucketSessionCounts[3] != newRareMaxSessionCount) {
                    ((QuotaController)QuotaController.this).mMaxBucketSessionCounts[3] = newRareMaxSessionCount;
                    changed = true;
                }
                long newSessionCoalescingDurationMs = Math.min(900000L, Math.max(0L, this.TIMING_SESSION_COALESCING_DURATION_MS));
                if (QuotaController.this.mTimingSessionCoalescingDurationMs != newSessionCoalescingDurationMs) {
                    QuotaController.this.mTimingSessionCoalescingDurationMs = newSessionCoalescingDurationMs;
                    changed = true;
                }
                if (changed && QuotaController.this.mShouldThrottle) {
                    BackgroundThread.getHandler().post(() -> {
                        Object object = QuotaController.this.mLock;
                        synchronized (object) {
                            QuotaController.this.invalidateAllExecutionStatsLocked();
                            QuotaController.this.maybeUpdateAllConstraintsLocked();
                        }
                    });
                }
            }
        }

        private void dump(IndentingPrintWriter pw) {
            pw.println();
            pw.println("QuotaController:");
            pw.increaseIndent();
            pw.printPair(KEY_ALLOWED_TIME_PER_PERIOD_MS, this.ALLOWED_TIME_PER_PERIOD_MS).println();
            pw.printPair(KEY_IN_QUOTA_BUFFER_MS, this.IN_QUOTA_BUFFER_MS).println();
            pw.printPair(KEY_WINDOW_SIZE_ACTIVE_MS, this.WINDOW_SIZE_ACTIVE_MS).println();
            pw.printPair(KEY_WINDOW_SIZE_WORKING_MS, this.WINDOW_SIZE_WORKING_MS).println();
            pw.printPair(KEY_WINDOW_SIZE_FREQUENT_MS, this.WINDOW_SIZE_FREQUENT_MS).println();
            pw.printPair(KEY_WINDOW_SIZE_RARE_MS, this.WINDOW_SIZE_RARE_MS).println();
            pw.printPair(KEY_MAX_EXECUTION_TIME_MS, this.MAX_EXECUTION_TIME_MS).println();
            pw.printPair(KEY_MAX_JOB_COUNT_ACTIVE, this.MAX_JOB_COUNT_ACTIVE).println();
            pw.printPair(KEY_MAX_JOB_COUNT_WORKING, this.MAX_JOB_COUNT_WORKING).println();
            pw.printPair(KEY_MAX_JOB_COUNT_FREQUENT, this.MAX_JOB_COUNT_FREQUENT).println();
            pw.printPair(KEY_MAX_JOB_COUNT_RARE, this.MAX_JOB_COUNT_RARE).println();
            pw.printPair(KEY_RATE_LIMITING_WINDOW_MS, this.RATE_LIMITING_WINDOW_MS).println();
            pw.printPair(KEY_MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW, this.MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW).println();
            pw.printPair(KEY_MAX_SESSION_COUNT_ACTIVE, this.MAX_SESSION_COUNT_ACTIVE).println();
            pw.printPair(KEY_MAX_SESSION_COUNT_WORKING, this.MAX_SESSION_COUNT_WORKING).println();
            pw.printPair(KEY_MAX_SESSION_COUNT_FREQUENT, this.MAX_SESSION_COUNT_FREQUENT).println();
            pw.printPair(KEY_MAX_SESSION_COUNT_RARE, this.MAX_SESSION_COUNT_RARE).println();
            pw.printPair(KEY_MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW, this.MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW).println();
            pw.printPair(KEY_TIMING_SESSION_COALESCING_DURATION_MS, this.TIMING_SESSION_COALESCING_DURATION_MS).println();
            pw.decreaseIndent();
        }

        private void dump(ProtoOutputStream proto) {
            long qcToken = proto.start(1146756268056L);
            proto.write(0x10300000001L, this.ALLOWED_TIME_PER_PERIOD_MS);
            proto.write(1112396529666L, this.IN_QUOTA_BUFFER_MS);
            proto.write(0x10300000003L, this.WINDOW_SIZE_ACTIVE_MS);
            proto.write(1112396529668L, this.WINDOW_SIZE_WORKING_MS);
            proto.write(1112396529669L, this.WINDOW_SIZE_FREQUENT_MS);
            proto.write(1112396529670L, this.WINDOW_SIZE_RARE_MS);
            proto.write(1112396529671L, this.MAX_EXECUTION_TIME_MS);
            proto.write(1120986464264L, this.MAX_JOB_COUNT_ACTIVE);
            proto.write(1120986464265L, this.MAX_JOB_COUNT_WORKING);
            proto.write(1120986464266L, this.MAX_JOB_COUNT_FREQUENT);
            proto.write(1120986464267L, this.MAX_JOB_COUNT_RARE);
            proto.write(1120986464275L, this.RATE_LIMITING_WINDOW_MS);
            proto.write(1120986464268L, this.MAX_JOB_COUNT_PER_RATE_LIMITING_WINDOW);
            proto.write(1120986464269L, this.MAX_SESSION_COUNT_ACTIVE);
            proto.write(1120986464270L, this.MAX_SESSION_COUNT_WORKING);
            proto.write(1120986464271L, this.MAX_SESSION_COUNT_FREQUENT);
            proto.write(0x10500000010L, this.MAX_SESSION_COUNT_RARE);
            proto.write(0x10500000011L, this.MAX_SESSION_COUNT_PER_RATE_LIMITING_WINDOW);
            proto.write(1112396529682L, this.TIMING_SESSION_COALESCING_DURATION_MS);
            proto.end(qcToken);
        }
    }

    private class QcAlarmListener
    implements AlarmManager.OnAlarmListener {
        private final int mUserId;
        private final String mPackageName;
        private volatile long mTriggerTimeElapsed;

        QcAlarmListener(int userId, String packageName) {
            this.mUserId = userId;
            this.mPackageName = packageName;
        }

        boolean isWaiting() {
            return this.mTriggerTimeElapsed > 0L;
        }

        void setTriggerTime(long timeElapsed) {
            this.mTriggerTimeElapsed = timeElapsed;
        }

        long getTriggerTimeElapsed() {
            return this.mTriggerTimeElapsed;
        }

        @Override
        public void onAlarm() {
            QuotaController.this.mHandler.obtainMessage(2, this.mUserId, 0, this.mPackageName).sendToTarget();
            this.mTriggerTimeElapsed = 0L;
        }
    }

    private class QcHandler
    extends Handler {
        QcHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                switch (msg.what) {
                    case 0: {
                        long timeRemainingMs;
                        Package pkg = (Package)msg.obj;
                        if (DEBUG) {
                            Slog.d(QuotaController.TAG, "Checking if " + pkg + " has reached its quota.");
                        }
                        if ((timeRemainingMs = QuotaController.this.getRemainingExecutionTimeLocked(pkg.userId, pkg.packageName)) <= 50L) {
                            if (DEBUG) {
                                Slog.d(QuotaController.TAG, pkg + " has reached its quota.");
                            }
                            if (!QuotaController.this.maybeUpdateConstraintForPkgLocked(pkg.userId, pkg.packageName)) break;
                            QuotaController.this.mStateChangedListener.onControllerStateChanged();
                            break;
                        }
                        Message rescheduleMsg = this.obtainMessage(0, pkg);
                        timeRemainingMs = QuotaController.this.getTimeUntilQuotaConsumedLocked(pkg.userId, pkg.packageName);
                        if (DEBUG) {
                            Slog.d(QuotaController.TAG, pkg + " has " + timeRemainingMs + "ms left.");
                        }
                        this.sendMessageDelayed(rescheduleMsg, timeRemainingMs);
                        break;
                    }
                    case 1: {
                        if (DEBUG) {
                            Slog.d(QuotaController.TAG, "Cleaning up timing sessions.");
                        }
                        QuotaController.this.deleteObsoleteSessionsLocked();
                        QuotaController.this.maybeScheduleCleanupAlarmLocked();
                        break;
                    }
                    case 2: {
                        String packageName = (String)msg.obj;
                        int userId = msg.arg1;
                        if (DEBUG) {
                            Slog.d(QuotaController.TAG, "Checking pkg " + QuotaController.string(userId, packageName));
                        }
                        if (!QuotaController.this.maybeUpdateConstraintForPkgLocked(userId, packageName)) break;
                        QuotaController.this.mStateChangedListener.onControllerStateChanged();
                        break;
                    }
                    case 3: {
                        int uid = msg.arg1;
                        int procState = msg.arg2;
                        int userId = UserHandle.getUserId(uid);
                        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
                        Object object2 = QuotaController.this.mLock;
                        synchronized (object2) {
                            boolean isQuotaFree;
                            if (procState <= 5) {
                                QuotaController.this.mForegroundUids.put(uid, true);
                                isQuotaFree = true;
                            } else {
                                QuotaController.this.mForegroundUids.delete(uid);
                                isQuotaFree = false;
                            }
                            if (QuotaController.this.mPkgTimers.indexOfKey(userId) >= 0) {
                                ArraySet packages = QuotaController.this.mUidToPackageCache.get(uid);
                                if (packages == null) {
                                    try {
                                        String[] pkgs = AppGlobals.getPackageManager().getPackagesForUid(uid);
                                        if (pkgs != null) {
                                            for (String pkg : pkgs) {
                                                QuotaController.this.mUidToPackageCache.add(uid, pkg);
                                            }
                                            packages = QuotaController.this.mUidToPackageCache.get(uid);
                                        }
                                    }
                                    catch (RemoteException e) {
                                        Slog.wtf(QuotaController.TAG, "Failed to get package list", e);
                                    }
                                }
                                if (packages != null) {
                                    for (int i = packages.size() - 1; i >= 0; --i) {
                                        Timer t = (Timer)QuotaController.this.mPkgTimers.get(userId, (String)packages.valueAt(i));
                                        if (t == null) continue;
                                        t.onStateChangedLocked(nowElapsed, isQuotaFree);
                                    }
                                }
                            }
                            if (QuotaController.this.maybeUpdateConstraintForUidLocked(uid)) {
                                QuotaController.this.mStateChangedListener.onControllerStateChanged();
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    private final class DeleteTimingSessionsFunctor
    implements Consumer<List<TimingSession>> {
        private final Predicate<TimingSession> mTooOld = new Predicate<TimingSession>(){

            @Override
            public boolean test(TimingSession ts) {
                return ts.endTimeElapsed <= JobSchedulerService.sElapsedRealtimeClock.millis() - 86400000L;
            }
        };

        private DeleteTimingSessionsFunctor() {
        }

        @Override
        public void accept(List<TimingSession> sessions) {
            if (sessions != null) {
                sessions.removeIf(this.mTooOld);
            }
        }
    }

    final class StandbyTracker
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        StandbyTracker() {
        }

        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle, int bucket, int reason) {
            BackgroundThread.getHandler().post(() -> {
                int bucketIndex = JobSchedulerService.standbyBucketToBucketIndex(bucket);
                if (DEBUG) {
                    Slog.i(QuotaController.TAG, "Moving pkg " + QuotaController.string(userId, packageName) + " to bucketIndex " + bucketIndex);
                }
                Object object = QuotaController.this.mLock;
                synchronized (object) {
                    ArraySet jobs = (ArraySet)QuotaController.this.mTrackedJobs.get(userId, packageName);
                    if (jobs == null || jobs.size() == 0) {
                        return;
                    }
                    for (int i = jobs.size() - 1; i >= 0; --i) {
                        JobStatus js = (JobStatus)jobs.valueAt(i);
                        js.setStandbyBucket(bucketIndex);
                    }
                    Timer timer = (Timer)QuotaController.this.mPkgTimers.get(userId, packageName);
                    if (timer != null && timer.isActive()) {
                        timer.rescheduleCutoff();
                    }
                    if (!QuotaController.this.mShouldThrottle || QuotaController.this.maybeUpdateConstraintForPkgLocked(userId, packageName)) {
                        QuotaController.this.mStateChangedListener.onControllerStateChanged();
                    }
                }
            });
        }

        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
            QuotaController.this.mInParole = isParoleOn;
            if (DEBUG) {
                Slog.i(QuotaController.TAG, "Global parole state now " + (isParoleOn ? "ON" : "OFF"));
            }
            BackgroundThread.getHandler().post(() -> {
                Object object = QuotaController.this.mLock;
                synchronized (object) {
                    QuotaController.this.maybeUpdateAllConstraintsLocked();
                }
            });
        }
    }

    private final class Timer {
        private final Package mPkg;
        private final int mUid;
        private final ArraySet<JobStatus> mRunningBgJobs = new ArraySet();
        private long mStartTimeElapsed;
        private int mBgJobCount;

        Timer(int uid, int userId, String packageName) {
            this.mPkg = new Package(userId, packageName);
            this.mUid = uid;
        }

        void startTrackingJobLocked(JobStatus jobStatus) {
            if (QuotaController.this.isTopStartedJobLocked(jobStatus)) {
                if (DEBUG) {
                    Slog.v(QuotaController.TAG, "Timer ignoring " + jobStatus.toShortString() + " because isTop");
                }
                return;
            }
            if (DEBUG) {
                Slog.v(QuotaController.TAG, "Starting to track " + jobStatus.toShortString());
            }
            this.mRunningBgJobs.add(jobStatus);
            if (this.shouldTrackLocked()) {
                ++this.mBgJobCount;
                QuotaController.this.incrementJobCount(this.mPkg.userId, this.mPkg.packageName, 1);
                if (this.mRunningBgJobs.size() == 1) {
                    this.mStartTimeElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
                    QuotaController.this.invalidateAllExecutionStatsLocked(this.mPkg.userId, this.mPkg.packageName);
                    this.scheduleCutoff();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopTrackingJob(JobStatus jobStatus) {
            if (DEBUG) {
                Slog.v(QuotaController.TAG, "Stopping tracking of " + jobStatus.toShortString());
            }
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                if (this.mRunningBgJobs.size() == 0) {
                    if (DEBUG) {
                        Slog.d(QuotaController.TAG, "Timer isn't tracking any jobs but still told to stop");
                    }
                    return;
                }
                if (this.mRunningBgJobs.remove(jobStatus) && !QuotaController.this.mChargeTracker.isCharging() && this.mRunningBgJobs.size() == 0) {
                    this.emitSessionLocked(JobSchedulerService.sElapsedRealtimeClock.millis());
                    this.cancelCutoff();
                }
            }
        }

        void dropEverythingLocked() {
            this.mRunningBgJobs.clear();
            this.cancelCutoff();
        }

        private void emitSessionLocked(long nowElapsed) {
            if (this.mBgJobCount <= 0) {
                return;
            }
            TimingSession ts = new TimingSession(this.mStartTimeElapsed, nowElapsed, this.mBgJobCount);
            QuotaController.this.saveTimingSession(this.mPkg.userId, this.mPkg.packageName, ts);
            this.mBgJobCount = 0;
            this.cancelCutoff();
            QuotaController.this.incrementTimingSessionCount(this.mPkg.userId, this.mPkg.packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                return this.mBgJobCount > 0;
            }
        }

        boolean isRunning(JobStatus jobStatus) {
            return this.mRunningBgJobs.contains(jobStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getCurrentDuration(long nowElapsed) {
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                return !this.isActive() ? 0L : nowElapsed - this.mStartTimeElapsed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getBgJobCount() {
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                return this.mBgJobCount;
            }
        }

        private boolean shouldTrackLocked() {
            return !QuotaController.this.mChargeTracker.isCharging() && !QuotaController.this.mForegroundUids.get(this.mUid);
        }

        void onStateChangedLocked(long nowElapsed, boolean isQuotaFree) {
            if (isQuotaFree) {
                this.emitSessionLocked(nowElapsed);
            } else if (!this.isActive() && this.shouldTrackLocked() && this.mRunningBgJobs.size() > 0) {
                this.mStartTimeElapsed = nowElapsed;
                this.mBgJobCount = this.mRunningBgJobs.size();
                QuotaController.this.incrementJobCount(this.mPkg.userId, this.mPkg.packageName, this.mBgJobCount);
                QuotaController.this.invalidateAllExecutionStatsLocked(this.mPkg.userId, this.mPkg.packageName);
                this.scheduleCutoff();
            }
        }

        void rescheduleCutoff() {
            this.cancelCutoff();
            this.scheduleCutoff();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleCutoff() {
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                if (!this.isActive()) {
                    return;
                }
                Message msg = QuotaController.this.mHandler.obtainMessage(0, this.mPkg);
                long timeRemainingMs = QuotaController.this.getTimeUntilQuotaConsumedLocked(this.mPkg.userId, this.mPkg.packageName);
                if (DEBUG) {
                    Slog.i(QuotaController.TAG, "Job for " + this.mPkg + " has " + timeRemainingMs + "ms left.");
                }
                QuotaController.this.mHandler.sendMessageDelayed(msg, timeRemainingMs);
            }
        }

        private void cancelCutoff() {
            QuotaController.this.mHandler.removeMessages(0, this.mPkg);
        }

        public void dump(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
            pw.print("Timer{");
            pw.print(this.mPkg);
            pw.print("} ");
            if (this.isActive()) {
                pw.print("started at ");
                pw.print(this.mStartTimeElapsed);
                pw.print(" (");
                pw.print(JobSchedulerService.sElapsedRealtimeClock.millis() - this.mStartTimeElapsed);
                pw.print("ms ago)");
            } else {
                pw.print("NOT active");
            }
            pw.print(", ");
            pw.print(this.mBgJobCount);
            pw.print(" running bg jobs");
            pw.println();
            pw.increaseIndent();
            for (int i = 0; i < this.mRunningBgJobs.size(); ++i) {
                JobStatus js = this.mRunningBgJobs.valueAt(i);
                if (!predicate.test(js)) continue;
                pw.println(js.toShortString());
            }
            pw.decreaseIndent();
        }

        public void dump(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
            long token = proto.start(fieldId);
            this.mPkg.writeToProto(proto, 0x10B00000001L);
            proto.write(1133871366146L, this.isActive());
            proto.write(0x10300000003L, this.mStartTimeElapsed);
            proto.write(1120986464260L, this.mBgJobCount);
            for (int i = 0; i < this.mRunningBgJobs.size(); ++i) {
                JobStatus js = this.mRunningBgJobs.valueAt(i);
                if (!predicate.test(js)) continue;
                js.writeToShortProto(proto, 2246267895813L);
            }
            proto.end(token);
        }
    }

    @VisibleForTesting
    static final class TimingSession {
        public final long startTimeElapsed;
        public final long endTimeElapsed;
        public final int bgJobCount;
        private final int mHashCode;

        TimingSession(long startElapsed, long endElapsed, int bgJobCount) {
            this.startTimeElapsed = startElapsed;
            this.endTimeElapsed = endElapsed;
            this.bgJobCount = bgJobCount;
            int hashCode = 0;
            hashCode = 31 * hashCode + QuotaController.hashLong(this.startTimeElapsed);
            hashCode = 31 * hashCode + QuotaController.hashLong(this.endTimeElapsed);
            this.mHashCode = hashCode = 31 * hashCode + bgJobCount;
        }

        public String toString() {
            return "TimingSession{" + this.startTimeElapsed + "->" + this.endTimeElapsed + ", " + this.bgJobCount + "}";
        }

        public boolean equals(Object obj) {
            if (obj instanceof TimingSession) {
                TimingSession other = (TimingSession)obj;
                return this.startTimeElapsed == other.startTimeElapsed && this.endTimeElapsed == other.endTimeElapsed && this.bgJobCount == other.bgJobCount;
            }
            return false;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public void dump(IndentingPrintWriter pw) {
            pw.print(this.startTimeElapsed);
            pw.print(" -> ");
            pw.print(this.endTimeElapsed);
            pw.print(" (");
            pw.print(this.endTimeElapsed - this.startTimeElapsed);
            pw.print("), ");
            pw.print(this.bgJobCount);
            pw.print(" bg jobs.");
            pw.println();
        }

        public void dump(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10300000001L, this.startTimeElapsed);
            proto.write(1112396529666L, this.endTimeElapsed);
            proto.write(1120986464259L, this.bgJobCount);
            proto.end(token);
        }
    }

    private final class ChargingTracker
    extends BroadcastReceiver {
        private boolean mCharging;

        ChargingTracker() {
        }

        public void startTracking() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.os.action.CHARGING");
            filter.addAction("android.os.action.DISCHARGING");
            QuotaController.this.mContext.registerReceiver(this, filter);
            BatteryManagerInternal batteryManagerInternal = LocalServices.getService(BatteryManagerInternal.class);
            this.mCharging = batteryManagerInternal.isPowered(7);
        }

        public boolean isCharging() {
            return this.mCharging;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = QuotaController.this.mLock;
            synchronized (object) {
                String action = intent.getAction();
                if ("android.os.action.CHARGING".equals(action)) {
                    if (DEBUG) {
                        Slog.d(QuotaController.TAG, "Received charging intent, fired @ " + JobSchedulerService.sElapsedRealtimeClock.millis());
                    }
                    this.mCharging = true;
                    QuotaController.this.handleNewChargingStateLocked();
                } else if ("android.os.action.DISCHARGING".equals(action)) {
                    if (DEBUG) {
                        Slog.d(QuotaController.TAG, "Disconnected from power.");
                    }
                    this.mCharging = false;
                    QuotaController.this.handleNewChargingStateLocked();
                }
            }
        }
    }

    private class UidConstraintUpdater
    implements Consumer<JobStatus> {
        private final UserPackageMap<Integer> mToScheduleStartAlarms = new UserPackageMap();
        public boolean wasJobChanged;

        private UidConstraintUpdater() {
        }

        @Override
        public void accept(JobStatus jobStatus) {
            int realStandbyBucket;
            String packageName;
            this.wasJobChanged |= QuotaController.this.setConstraintSatisfied(jobStatus, QuotaController.this.isWithinQuotaLocked(jobStatus));
            int userId = jobStatus.getSourceUserId();
            if (QuotaController.this.isWithinQuotaLocked(userId, packageName = jobStatus.getSourcePackageName(), realStandbyBucket = jobStatus.getStandbyBucket())) {
                QcAlarmListener alarmListener = (QcAlarmListener)QuotaController.this.mInQuotaAlarmListeners.get(userId, packageName);
                if (alarmListener != null && alarmListener.isWaiting()) {
                    QuotaController.this.mAlarmManager.cancel(alarmListener);
                    alarmListener.setTriggerTime(0L);
                }
            } else {
                this.mToScheduleStartAlarms.add(userId, packageName, realStandbyBucket);
            }
        }

        void postProcess() {
            for (int u = 0; u < this.mToScheduleStartAlarms.numUsers(); ++u) {
                int userId = this.mToScheduleStartAlarms.keyAt(u);
                for (int p = 0; p < this.mToScheduleStartAlarms.numPackagesForUser(userId); ++p) {
                    String packageName = this.mToScheduleStartAlarms.keyAt(u, p);
                    int standbyBucket = this.mToScheduleStartAlarms.get(userId, packageName);
                    QuotaController.this.maybeScheduleStartAlarmLocked(userId, packageName, standbyBucket);
                }
            }
        }

        void reset() {
            this.wasJobChanged = false;
            this.mToScheduleStartAlarms.clear();
        }
    }

    private final class EarliestEndTimeFunctor
    implements Consumer<List<TimingSession>> {
        public long earliestEndElapsed = Long.MAX_VALUE;

        private EarliestEndTimeFunctor() {
        }

        @Override
        public void accept(List<TimingSession> sessions) {
            if (sessions != null && sessions.size() > 0) {
                this.earliestEndElapsed = Math.min(this.earliestEndElapsed, sessions.get((int)0).endTimeElapsed);
            }
        }

        void reset() {
            this.earliestEndElapsed = Long.MAX_VALUE;
        }
    }

    @VisibleForTesting
    static class ExecutionStats {
        public long expirationTimeElapsed;
        public long windowSizeMs;
        public int jobCountLimit;
        public int sessionCountLimit;
        public long executionTimeInWindowMs;
        public int bgJobCountInWindow;
        public long executionTimeInMaxPeriodMs;
        public int bgJobCountInMaxPeriod;
        public int sessionCountInWindow;
        public long inQuotaTimeElapsed;
        public long jobRateLimitExpirationTimeElapsed;
        public int jobCountInRateLimitingWindow;
        public long sessionRateLimitExpirationTimeElapsed;
        public int sessionCountInRateLimitingWindow;

        ExecutionStats() {
        }

        public String toString() {
            return "expirationTime=" + this.expirationTimeElapsed + ", windowSizeMs=" + this.windowSizeMs + ", jobCountLimit=" + this.jobCountLimit + ", sessionCountLimit=" + this.sessionCountLimit + ", executionTimeInWindow=" + this.executionTimeInWindowMs + ", bgJobCountInWindow=" + this.bgJobCountInWindow + ", executionTimeInMaxPeriod=" + this.executionTimeInMaxPeriodMs + ", bgJobCountInMaxPeriod=" + this.bgJobCountInMaxPeriod + ", sessionCountInWindow=" + this.sessionCountInWindow + ", inQuotaTime=" + this.inQuotaTimeElapsed + ", jobCountExpirationTime=" + this.jobRateLimitExpirationTimeElapsed + ", jobCountInRateLimitingWindow=" + this.jobCountInRateLimitingWindow + ", sessionCountExpirationTime=" + this.sessionRateLimitExpirationTimeElapsed + ", sessionCountInRateLimitingWindow=" + this.sessionCountInRateLimitingWindow;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExecutionStats) {
                ExecutionStats other = (ExecutionStats)obj;
                return this.expirationTimeElapsed == other.expirationTimeElapsed && this.windowSizeMs == other.windowSizeMs && this.jobCountLimit == other.jobCountLimit && this.sessionCountLimit == other.sessionCountLimit && this.executionTimeInWindowMs == other.executionTimeInWindowMs && this.bgJobCountInWindow == other.bgJobCountInWindow && this.executionTimeInMaxPeriodMs == other.executionTimeInMaxPeriodMs && this.sessionCountInWindow == other.sessionCountInWindow && this.bgJobCountInMaxPeriod == other.bgJobCountInMaxPeriod && this.inQuotaTimeElapsed == other.inQuotaTimeElapsed && this.jobRateLimitExpirationTimeElapsed == other.jobRateLimitExpirationTimeElapsed && this.jobCountInRateLimitingWindow == other.jobCountInRateLimitingWindow && this.sessionRateLimitExpirationTimeElapsed == other.sessionRateLimitExpirationTimeElapsed && this.sessionCountInRateLimitingWindow == other.sessionCountInRateLimitingWindow;
            }
            return false;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + QuotaController.hashLong(this.expirationTimeElapsed);
            result = 31 * result + QuotaController.hashLong(this.windowSizeMs);
            result = 31 * result + QuotaController.hashLong(this.jobCountLimit);
            result = 31 * result + QuotaController.hashLong(this.sessionCountLimit);
            result = 31 * result + QuotaController.hashLong(this.executionTimeInWindowMs);
            result = 31 * result + this.bgJobCountInWindow;
            result = 31 * result + QuotaController.hashLong(this.executionTimeInMaxPeriodMs);
            result = 31 * result + this.bgJobCountInMaxPeriod;
            result = 31 * result + this.sessionCountInWindow;
            result = 31 * result + QuotaController.hashLong(this.inQuotaTimeElapsed);
            result = 31 * result + QuotaController.hashLong(this.jobRateLimitExpirationTimeElapsed);
            result = 31 * result + this.jobCountInRateLimitingWindow;
            result = 31 * result + QuotaController.hashLong(this.sessionRateLimitExpirationTimeElapsed);
            result = 31 * result + this.sessionCountInRateLimitingWindow;
            return result;
        }
    }

    private static final class Package {
        public final String packageName;
        public final int userId;

        Package(int userId, String packageName) {
            this.userId = userId;
            this.packageName = packageName;
        }

        public String toString() {
            return QuotaController.string(this.userId, this.packageName);
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.userId);
            proto.write(1138166333442L, this.packageName);
            proto.end(token);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Package) {
                Package other = (Package)obj;
                return this.userId == other.userId && Objects.equals(this.packageName, other.packageName);
            }
            return false;
        }

        public int hashCode() {
            return this.packageName.hashCode() + this.userId;
        }
    }

    private static class UserPackageMap<T> {
        private final SparseArray<ArrayMap<String, T>> mData = new SparseArray();

        private UserPackageMap() {
        }

        public void add(int userId, String packageName, T obj) {
            ArrayMap<String, Object> data = this.mData.get(userId);
            if (data == null) {
                data = new ArrayMap();
                this.mData.put(userId, data);
            }
            data.put(packageName, obj);
        }

        public void clear() {
            for (int i = 0; i < this.mData.size(); ++i) {
                this.mData.valueAt(i).clear();
            }
        }

        public void delete(int userId) {
            this.mData.delete(userId);
        }

        public void delete(int userId, String packageName) {
            ArrayMap<String, T> data = this.mData.get(userId);
            if (data != null) {
                data.remove(packageName);
            }
        }

        public T get(int userId, String packageName) {
            ArrayMap<String, T> data = this.mData.get(userId);
            if (data != null) {
                return data.get(packageName);
            }
            return null;
        }

        public int indexOfKey(int userId) {
            return this.mData.indexOfKey(userId);
        }

        public int keyAt(int index) {
            return this.mData.keyAt(index);
        }

        public String keyAt(int userIndex, int packageIndex) {
            return this.mData.valueAt(userIndex).keyAt(packageIndex);
        }

        public int numUsers() {
            return this.mData.size();
        }

        public int numPackagesForUser(int userId) {
            ArrayMap<String, T> data = this.mData.get(userId);
            return data == null ? 0 : data.size();
        }

        public T valueAt(int userIndex, int packageIndex) {
            return this.mData.valueAt(userIndex).valueAt(packageIndex);
        }

        public void forEach(Consumer<T> consumer) {
            for (int i = this.numUsers() - 1; i >= 0; --i) {
                ArrayMap<String, T> data = this.mData.valueAt(i);
                for (int j = data.size() - 1; j >= 0; --j) {
                    consumer.accept(data.valueAt(j));
                }
            }
        }
    }
}

