/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.AlarmManager;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Log;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public final class TimeController
extends StateController {
    private static final String TAG = "JobScheduler.Time";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.Time", 3);
    private final String DEADLINE_TAG = "*job.deadline*";
    private final String DELAY_TAG = "*job.delay*";
    private final Handler mHandler;
    private final TcConstants mTcConstants;
    private long mNextJobExpiredElapsedMillis;
    private long mNextDelayExpiredElapsedMillis;
    private final boolean mChainedAttributionEnabled;
    private AlarmManager mAlarmService = null;
    private final List<JobStatus> mTrackedJobs = new LinkedList<JobStatus>();
    private final AlarmManager.OnAlarmListener mDeadlineExpiredListener = new AlarmManager.OnAlarmListener(){

        @Override
        public void onAlarm() {
            if (DEBUG) {
                Slog.d(TimeController.TAG, "Deadline-expired alarm fired");
            }
            TimeController.this.checkExpiredDeadlinesAndResetAlarm();
        }
    };
    private final AlarmManager.OnAlarmListener mNextDelayExpiredListener = new AlarmManager.OnAlarmListener(){

        @Override
        public void onAlarm() {
            if (DEBUG) {
                Slog.d(TimeController.TAG, "Delay-expired alarm fired");
            }
            TimeController.this.checkExpiredDelaysAndResetAlarm();
        }
    };

    public TimeController(JobSchedulerService service) {
        super(service);
        this.mNextJobExpiredElapsedMillis = Long.MAX_VALUE;
        this.mNextDelayExpiredElapsedMillis = Long.MAX_VALUE;
        this.mChainedAttributionEnabled = this.mService.isChainedAttributionEnabled();
        this.mHandler = new Handler(this.mContext.getMainLooper());
        this.mTcConstants = new TcConstants(this.mHandler);
    }

    @Override
    public void onSystemServicesReady() {
        this.mTcConstants.start(this.mContext.getContentResolver());
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus job, JobStatus lastJob) {
        if (job.hasTimingDelayConstraint() || job.hasDeadlineConstraint()) {
            long delayExpiredElapsed;
            this.maybeStopTrackingJobLocked(job, null, false);
            long nowElapsedMillis = JobSchedulerService.sElapsedRealtimeClock.millis();
            if (job.hasDeadlineConstraint() && this.evaluateDeadlineConstraint(job, nowElapsedMillis)) {
                return;
            }
            if (job.hasTimingDelayConstraint() && this.evaluateTimingDelayConstraint(job, nowElapsedMillis) && !job.hasDeadlineConstraint()) {
                return;
            }
            boolean isInsert = false;
            ListIterator<JobStatus> it = this.mTrackedJobs.listIterator(this.mTrackedJobs.size());
            while (it.hasPrevious()) {
                JobStatus ts = it.previous();
                if (ts.getLatestRunTimeElapsed() >= job.getLatestRunTimeElapsed()) continue;
                isInsert = true;
                break;
            }
            if (isInsert) {
                it.next();
            }
            it.add(job);
            job.setTrackingController(32);
            WorkSource ws = this.deriveWorkSource(job.getSourceUid(), job.getSourcePackageName());
            long deadlineExpiredElapsed = job.hasDeadlineConstraint() ? job.getLatestRunTimeElapsed() : Long.MAX_VALUE;
            long l = delayExpiredElapsed = job.hasTimingDelayConstraint() ? job.getEarliestRunTime() : Long.MAX_VALUE;
            if (this.mTcConstants.SKIP_NOT_READY_JOBS) {
                if (this.wouldBeReadyWithConstraintLocked(job, Integer.MIN_VALUE)) {
                    this.maybeUpdateDelayAlarmLocked(delayExpiredElapsed, ws);
                }
                if (this.wouldBeReadyWithConstraintLocked(job, 0x40000000)) {
                    this.maybeUpdateDeadlineAlarmLocked(deadlineExpiredElapsed, ws);
                }
            } else {
                this.maybeUpdateDelayAlarmLocked(delayExpiredElapsed, ws);
                this.maybeUpdateDeadlineAlarmLocked(deadlineExpiredElapsed, ws);
            }
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus job, JobStatus incomingJob, boolean forUpdate) {
        if (job.clearTrackingController(32) && this.mTrackedJobs.remove(job)) {
            this.checkExpiredDelaysAndResetAlarm();
            this.checkExpiredDeadlinesAndResetAlarm();
        }
    }

    @Override
    public void evaluateStateLocked(JobStatus job) {
        boolean wouldBeReady;
        boolean isAlarmForJob;
        if (!this.mTcConstants.SKIP_NOT_READY_JOBS) {
            return;
        }
        long nowElapsedMillis = JobSchedulerService.sElapsedRealtimeClock.millis();
        if (job.hasDeadlineConstraint() && !job.isConstraintSatisfied(0x40000000) && job.getLatestRunTimeElapsed() <= this.mNextJobExpiredElapsedMillis) {
            if (this.evaluateDeadlineConstraint(job, nowElapsedMillis)) {
                this.checkExpiredDeadlinesAndResetAlarm();
                this.checkExpiredDelaysAndResetAlarm();
            } else {
                isAlarmForJob = job.getLatestRunTimeElapsed() == this.mNextJobExpiredElapsedMillis;
                wouldBeReady = this.wouldBeReadyWithConstraintLocked(job, 0x40000000);
                if (isAlarmForJob && !wouldBeReady || !isAlarmForJob && wouldBeReady) {
                    this.checkExpiredDeadlinesAndResetAlarm();
                }
            }
        }
        if (job.hasTimingDelayConstraint() && !job.isConstraintSatisfied(Integer.MIN_VALUE) && job.getEarliestRunTime() <= this.mNextDelayExpiredElapsedMillis) {
            if (this.evaluateTimingDelayConstraint(job, nowElapsedMillis)) {
                this.checkExpiredDelaysAndResetAlarm();
            } else {
                isAlarmForJob = job.getEarliestRunTime() == this.mNextDelayExpiredElapsedMillis;
                wouldBeReady = this.wouldBeReadyWithConstraintLocked(job, Integer.MIN_VALUE);
                if (isAlarmForJob && !wouldBeReady || !isAlarmForJob && wouldBeReady) {
                    this.checkExpiredDelaysAndResetAlarm();
                }
            }
        }
    }

    @Override
    public void reevaluateStateLocked(int uid) {
        this.checkExpiredDeadlinesAndResetAlarm();
        this.checkExpiredDelaysAndResetAlarm();
    }

    private boolean canStopTrackingJobLocked(JobStatus job) {
        return !(job.hasTimingDelayConstraint() && !job.isConstraintSatisfied(Integer.MIN_VALUE) || job.hasDeadlineConstraint() && !job.isConstraintSatisfied(0x40000000));
    }

    private void ensureAlarmServiceLocked() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void checkExpiredDeadlinesAndResetAlarm() {
        Object object = this.mLock;
        synchronized (object) {
            long nextExpiryTime = Long.MAX_VALUE;
            int nextExpiryUid = 0;
            String nextExpiryPackageName = null;
            long nowElapsedMillis = JobSchedulerService.sElapsedRealtimeClock.millis();
            ListIterator<JobStatus> it = this.mTrackedJobs.listIterator();
            while (it.hasNext()) {
                JobStatus job = it.next();
                if (!job.hasDeadlineConstraint()) continue;
                if (this.evaluateDeadlineConstraint(job, nowElapsedMillis)) {
                    if (job.isReady()) {
                        this.mStateChangedListener.onRunJobNow(job);
                    }
                    it.remove();
                    continue;
                }
                if (this.mTcConstants.SKIP_NOT_READY_JOBS && !this.wouldBeReadyWithConstraintLocked(job, 0x40000000)) {
                    if (!DEBUG) continue;
                    Slog.i(TAG, "Skipping " + job + " because deadline won't make it ready.");
                    continue;
                }
                nextExpiryTime = job.getLatestRunTimeElapsed();
                nextExpiryUid = job.getSourceUid();
                nextExpiryPackageName = job.getSourcePackageName();
                break;
            }
            this.setDeadlineExpiredAlarmLocked(nextExpiryTime, this.deriveWorkSource(nextExpiryUid, nextExpiryPackageName));
        }
    }

    private boolean evaluateDeadlineConstraint(JobStatus job, long nowElapsedMillis) {
        long jobDeadline = job.getLatestRunTimeElapsed();
        if (jobDeadline <= nowElapsedMillis) {
            if (job.hasTimingDelayConstraint()) {
                job.setTimingDelayConstraintSatisfied(true);
            }
            job.setDeadlineConstraintSatisfied(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void checkExpiredDelaysAndResetAlarm() {
        Object object = this.mLock;
        synchronized (object) {
            long nowElapsedMillis = JobSchedulerService.sElapsedRealtimeClock.millis();
            long nextDelayTime = Long.MAX_VALUE;
            int nextDelayUid = 0;
            String nextDelayPackageName = null;
            boolean ready = false;
            Iterator<JobStatus> it = this.mTrackedJobs.iterator();
            while (it.hasNext()) {
                JobStatus job = it.next();
                if (!job.hasTimingDelayConstraint()) continue;
                if (this.evaluateTimingDelayConstraint(job, nowElapsedMillis)) {
                    if (this.canStopTrackingJobLocked(job)) {
                        it.remove();
                    }
                    if (!job.isReady()) continue;
                    ready = true;
                    continue;
                }
                if (this.mTcConstants.SKIP_NOT_READY_JOBS && !this.wouldBeReadyWithConstraintLocked(job, Integer.MIN_VALUE)) {
                    if (!DEBUG) continue;
                    Slog.i(TAG, "Skipping " + job + " because delay won't make it ready.");
                    continue;
                }
                long jobDelayTime = job.getEarliestRunTime();
                if (nextDelayTime <= jobDelayTime) continue;
                nextDelayTime = jobDelayTime;
                nextDelayUid = job.getSourceUid();
                nextDelayPackageName = job.getSourcePackageName();
            }
            if (ready) {
                this.mStateChangedListener.onControllerStateChanged();
            }
            this.setDelayExpiredAlarmLocked(nextDelayTime, this.deriveWorkSource(nextDelayUid, nextDelayPackageName));
        }
    }

    private WorkSource deriveWorkSource(int uid, String packageName) {
        if (this.mChainedAttributionEnabled) {
            WorkSource ws = new WorkSource();
            ws.createWorkChain().addNode(uid, packageName).addNode(1000, "JobScheduler");
            return ws;
        }
        return packageName == null ? new WorkSource(uid) : new WorkSource(uid, packageName);
    }

    private boolean evaluateTimingDelayConstraint(JobStatus job, long nowElapsedMillis) {
        long jobDelayTime = job.getEarliestRunTime();
        if (jobDelayTime <= nowElapsedMillis) {
            job.setTimingDelayConstraintSatisfied(true);
            return true;
        }
        return false;
    }

    private void maybeUpdateDelayAlarmLocked(long delayExpiredElapsed, WorkSource ws) {
        if (delayExpiredElapsed < this.mNextDelayExpiredElapsedMillis) {
            this.setDelayExpiredAlarmLocked(delayExpiredElapsed, ws);
        }
    }

    private void maybeUpdateDeadlineAlarmLocked(long deadlineExpiredElapsed, WorkSource ws) {
        if (deadlineExpiredElapsed < this.mNextJobExpiredElapsedMillis) {
            this.setDeadlineExpiredAlarmLocked(deadlineExpiredElapsed, ws);
        }
    }

    private void setDelayExpiredAlarmLocked(long alarmTimeElapsedMillis, WorkSource ws) {
        if (this.mNextDelayExpiredElapsedMillis == (alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis))) {
            return;
        }
        this.mNextDelayExpiredElapsedMillis = alarmTimeElapsedMillis;
        this.updateAlarmWithListenerLocked("*job.delay*", this.mNextDelayExpiredListener, this.mNextDelayExpiredElapsedMillis, ws);
    }

    private void setDeadlineExpiredAlarmLocked(long alarmTimeElapsedMillis, WorkSource ws) {
        if (this.mNextJobExpiredElapsedMillis == (alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis))) {
            return;
        }
        this.mNextJobExpiredElapsedMillis = alarmTimeElapsedMillis;
        this.updateAlarmWithListenerLocked("*job.deadline*", this.mDeadlineExpiredListener, this.mNextJobExpiredElapsedMillis, ws);
    }

    private long maybeAdjustAlarmTime(long proposedAlarmTimeElapsedMillis) {
        return Math.max(proposedAlarmTimeElapsedMillis, JobSchedulerService.sElapsedRealtimeClock.millis());
    }

    private void updateAlarmWithListenerLocked(String tag, AlarmManager.OnAlarmListener listener, long alarmTimeElapsed, WorkSource ws) {
        this.ensureAlarmServiceLocked();
        if (alarmTimeElapsed == Long.MAX_VALUE) {
            this.mAlarmService.cancel(listener);
        } else {
            if (DEBUG) {
                Slog.d(TAG, "Setting " + tag + " for: " + alarmTimeElapsed);
            }
            this.mAlarmService.set(2, alarmTimeElapsed, -1L, 0L, tag, listener, null, ws);
        }
    }

    @VisibleForTesting
    void recheckAlarmsLocked() {
        this.checkExpiredDeadlinesAndResetAlarm();
        this.checkExpiredDelaysAndResetAlarm();
    }

    @VisibleForTesting
    TcConstants getTcConstants() {
        return this.mTcConstants;
    }

    @Override
    public void dumpControllerStateLocked(IndentingPrintWriter pw, Predicate<JobStatus> predicate) {
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        pw.println("Elapsed clock: " + nowElapsed);
        pw.print("Next delay alarm in ");
        TimeUtils.formatDuration(this.mNextDelayExpiredElapsedMillis, nowElapsed, pw);
        pw.println();
        pw.print("Next deadline alarm in ");
        TimeUtils.formatDuration(this.mNextJobExpiredElapsedMillis, nowElapsed, pw);
        pw.println();
        pw.println();
        for (JobStatus ts : this.mTrackedJobs) {
            if (!predicate.test(ts)) continue;
            pw.print("#");
            ts.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, ts.getSourceUid());
            pw.print(": Delay=");
            if (ts.hasTimingDelayConstraint()) {
                TimeUtils.formatDuration(ts.getEarliestRunTime(), nowElapsed, pw);
            } else {
                pw.print("N/A");
            }
            pw.print(", Deadline=");
            if (ts.hasDeadlineConstraint()) {
                TimeUtils.formatDuration(ts.getLatestRunTimeElapsed(), nowElapsed, pw);
            } else {
                pw.print("N/A");
            }
            pw.println();
        }
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, Predicate<JobStatus> predicate) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268040L);
        long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
        proto.write(0x10300000001L, nowElapsed);
        proto.write(1112396529666L, this.mNextDelayExpiredElapsedMillis - nowElapsed);
        proto.write(0x10300000003L, this.mNextJobExpiredElapsedMillis - nowElapsed);
        for (JobStatus ts : this.mTrackedJobs) {
            if (!predicate.test(ts)) continue;
            long tsToken = proto.start(2246267895812L);
            ts.writeToShortProto(proto, 0x10B00000001L);
            proto.write(1133871366147L, ts.hasTimingDelayConstraint());
            proto.write(1112396529668L, ts.getEarliestRunTime() - nowElapsed);
            proto.write(1133871366149L, ts.hasDeadlineConstraint());
            proto.write(1112396529670L, ts.getLatestRunTimeElapsed() - nowElapsed);
            proto.end(tsToken);
        }
        proto.end(mToken);
        proto.end(token);
    }

    @Override
    public void dumpConstants(IndentingPrintWriter pw) {
        this.mTcConstants.dump(pw);
    }

    @Override
    public void dumpConstants(ProtoOutputStream proto) {
        this.mTcConstants.dump(proto);
    }

    @VisibleForTesting
    class TcConstants
    extends ContentObserver {
        private ContentResolver mResolver;
        private final KeyValueListParser mParser;
        private static final String KEY_SKIP_NOT_READY_JOBS = "skip_not_ready_jobs";
        private static final boolean DEFAULT_SKIP_NOT_READY_JOBS = true;
        public boolean SKIP_NOT_READY_JOBS;

        TcConstants(Handler handler) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
            this.SKIP_NOT_READY_JOBS = true;
        }

        private void start(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("job_scheduler_time_controller_constants"), false, this);
            this.onChange(true, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            String constants = Settings.Global.getString(this.mResolver, "job_scheduler_time_controller_constants");
            try {
                this.mParser.setString(constants);
            }
            catch (Exception e) {
                Slog.e(TimeController.TAG, "Bad jobscheduler time controller settings", e);
            }
            boolean oldVal = this.SKIP_NOT_READY_JOBS;
            this.SKIP_NOT_READY_JOBS = this.mParser.getBoolean(KEY_SKIP_NOT_READY_JOBS, true);
            if (oldVal != this.SKIP_NOT_READY_JOBS) {
                Object object = TimeController.this.mLock;
                synchronized (object) {
                    TimeController.this.recheckAlarmsLocked();
                }
            }
        }

        private void dump(IndentingPrintWriter pw) {
            pw.println();
            pw.println("TimeController:");
            pw.increaseIndent();
            pw.printPair(KEY_SKIP_NOT_READY_JOBS, this.SKIP_NOT_READY_JOBS).println();
            pw.decreaseIndent();
        }

        private void dump(ProtoOutputStream proto) {
            long tcToken = proto.start(1146756268057L);
            proto.write(0x10800000001L, this.SKIP_NOT_READY_JOBS);
            proto.end(tcToken);
        }
    }
}

