/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers.idle;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import android.util.Slog;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.idle.IdlenessListener;
import com.android.server.job.controllers.idle.IdlenessTracker;
import java.io.PrintWriter;

public final class CarIdlenessTracker
extends BroadcastReceiver
implements IdlenessTracker {
    private static final String TAG = "JobScheduler.CarIdlenessTracker";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.CarIdlenessTracker", 3);
    public static final String ACTION_GARAGE_MODE_ON = "com.android.server.jobscheduler.GARAGE_MODE_ON";
    public static final String ACTION_GARAGE_MODE_OFF = "com.android.server.jobscheduler.GARAGE_MODE_OFF";
    public static final String ACTION_FORCE_IDLE = "com.android.server.jobscheduler.FORCE_IDLE";
    public static final String ACTION_UNFORCE_IDLE = "com.android.server.jobscheduler.UNFORCE_IDLE";
    private boolean mIdle = false;
    private boolean mGarageModeOn = false;
    private boolean mForced = false;
    private IdlenessListener mIdleListener;

    @Override
    public boolean isIdle() {
        return this.mIdle;
    }

    @Override
    public void startTracking(Context context, IdlenessListener listener) {
        this.mIdleListener = listener;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction(ACTION_GARAGE_MODE_ON);
        filter.addAction(ACTION_GARAGE_MODE_OFF);
        filter.addAction(ACTION_FORCE_IDLE);
        filter.addAction(ACTION_UNFORCE_IDLE);
        filter.addAction("com.android.server.ACTION_TRIGGER_IDLE");
        context.registerReceiver(this, filter);
    }

    @Override
    public void dump(PrintWriter pw) {
        pw.print("  mIdle: ");
        pw.println(this.mIdle);
        pw.print("  mGarageModeOn: ");
        pw.println(this.mGarageModeOn);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        CarIdlenessTracker.logIfDebug("Received action: " + action);
        if (action.equals(ACTION_FORCE_IDLE)) {
            CarIdlenessTracker.logIfDebug("Forcing idle...");
            this.setForceIdleState(true);
        } else if (action.equals(ACTION_UNFORCE_IDLE)) {
            CarIdlenessTracker.logIfDebug("Unforcing idle...");
            this.setForceIdleState(false);
        } else if (action.equals("android.intent.action.SCREEN_ON")) {
            CarIdlenessTracker.logIfDebug("Screen is on...");
            this.handleScreenOn();
        } else if (action.equals(ACTION_GARAGE_MODE_ON)) {
            CarIdlenessTracker.logIfDebug("GarageMode is on...");
            this.mGarageModeOn = true;
            this.updateIdlenessState();
        } else if (action.equals(ACTION_GARAGE_MODE_OFF)) {
            CarIdlenessTracker.logIfDebug("GarageMode is off...");
            this.mGarageModeOn = false;
            this.updateIdlenessState();
        } else if (action.equals("com.android.server.ACTION_TRIGGER_IDLE")) {
            if (!this.mGarageModeOn) {
                CarIdlenessTracker.logIfDebug("Idle trigger fired...");
                this.triggerIdlenessOnce();
            } else {
                CarIdlenessTracker.logIfDebug("TRIGGER_IDLE received but not changing state; idle=" + this.mIdle + " screen=" + this.mGarageModeOn);
            }
        }
    }

    private void setForceIdleState(boolean forced) {
        this.mForced = forced;
        this.updateIdlenessState();
    }

    private void updateIdlenessState() {
        boolean newState;
        boolean bl = newState = this.mForced || this.mGarageModeOn;
        if (this.mIdle != newState) {
            CarIdlenessTracker.logIfDebug("Device idleness changed. New idle=" + newState);
            this.mIdle = newState;
            this.mIdleListener.reportNewIdleState(this.mIdle);
        } else {
            CarIdlenessTracker.logIfDebug("Device idleness is the same. Current idle=" + newState);
        }
    }

    private void triggerIdlenessOnce() {
        if (this.mIdle) {
            CarIdlenessTracker.logIfDebug("Device is already idle");
        } else {
            CarIdlenessTracker.logIfDebug("Device is going idle once");
            this.mIdle = true;
            this.mIdleListener.reportNewIdleState(this.mIdle);
        }
    }

    private void handleScreenOn() {
        if (this.mForced || this.mGarageModeOn) {
            CarIdlenessTracker.logIfDebug("Screen is on, but device cannot exit idle");
        } else if (this.mIdle) {
            CarIdlenessTracker.logIfDebug("Device is exiting idle");
            this.mIdle = false;
        } else {
            CarIdlenessTracker.logIfDebug("Device is already non-idle");
        }
    }

    private static void logIfDebug(String msg) {
        if (DEBUG) {
            Slog.v(TAG, msg);
        }
    }
}

