/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers.idle;

import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import android.util.Slog;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.idle.IdlenessListener;
import com.android.server.job.controllers.idle.IdlenessTracker;
import java.io.PrintWriter;

public final class DeviceIdlenessTracker
extends BroadcastReceiver
implements IdlenessTracker {
    private static final String TAG = "JobScheduler.DeviceIdlenessTracker";
    private static final boolean DEBUG = JobSchedulerService.DEBUG || Log.isLoggable("JobScheduler.DeviceIdlenessTracker", 3);
    private AlarmManager mAlarm;
    private long mInactivityIdleThreshold;
    private long mIdleWindowSlop;
    private boolean mIdle = false;
    private boolean mScreenOn = true;
    private boolean mDockIdle = false;
    private IdlenessListener mIdleListener;
    private AlarmManager.OnAlarmListener mIdleAlarmListener = () -> this.handleIdleTrigger();

    @Override
    public boolean isIdle() {
        return this.mIdle;
    }

    @Override
    public void startTracking(Context context, IdlenessListener listener) {
        this.mIdleListener = listener;
        this.mInactivityIdleThreshold = context.getResources().getInteger(17694815);
        this.mIdleWindowSlop = context.getResources().getInteger(17694814);
        this.mAlarm = (AlarmManager)context.getSystemService("alarm");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.DREAMING_STARTED");
        filter.addAction("android.intent.action.DREAMING_STOPPED");
        filter.addAction("com.android.server.ACTION_TRIGGER_IDLE");
        filter.addAction("android.intent.action.DOCK_IDLE");
        filter.addAction("android.intent.action.DOCK_ACTIVE");
        context.registerReceiver(this, filter);
    }

    @Override
    public void dump(PrintWriter pw) {
        pw.print("  mIdle: ");
        pw.println(this.mIdle);
        pw.print("  mScreenOn: ");
        pw.println(this.mScreenOn);
        pw.print("  mDockIdle: ");
        pw.println(this.mDockIdle);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.intent.action.SCREEN_ON") || action.equals("android.intent.action.DREAMING_STOPPED") || action.equals("android.intent.action.DOCK_ACTIVE")) {
            if (action.equals("android.intent.action.DOCK_ACTIVE")) {
                if (!this.mScreenOn) {
                    return;
                }
                this.mDockIdle = false;
            } else {
                this.mScreenOn = true;
                this.mDockIdle = false;
            }
            if (DEBUG) {
                Slog.v(TAG, "exiting idle : " + action);
            }
            this.mAlarm.cancel(this.mIdleAlarmListener);
            if (this.mIdle) {
                this.mIdle = false;
                this.mIdleListener.reportNewIdleState(this.mIdle);
            }
        } else if (action.equals("android.intent.action.SCREEN_OFF") || action.equals("android.intent.action.DREAMING_STARTED") || action.equals("android.intent.action.DOCK_IDLE")) {
            if (action.equals("android.intent.action.DOCK_IDLE")) {
                if (!this.mScreenOn) {
                    return;
                }
                this.mDockIdle = true;
            } else {
                this.mScreenOn = false;
                this.mDockIdle = false;
            }
            long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
            long when = nowElapsed + this.mInactivityIdleThreshold;
            if (DEBUG) {
                Slog.v(TAG, "Scheduling idle : " + action + " now:" + nowElapsed + " when=" + when);
            }
            this.mAlarm.setWindow(2, when, this.mIdleWindowSlop, "JS idleness", this.mIdleAlarmListener, null);
        } else if (action.equals("com.android.server.ACTION_TRIGGER_IDLE")) {
            this.handleIdleTrigger();
        }
    }

    private void handleIdleTrigger() {
        if (!(this.mIdle || this.mScreenOn && !this.mDockIdle)) {
            if (DEBUG) {
                Slog.v(TAG, "Idle trigger fired @ " + JobSchedulerService.sElapsedRealtimeClock.millis());
            }
            this.mIdle = true;
            this.mIdleListener.reportNewIdleState(this.mIdle);
        } else if (DEBUG) {
            Slog.v(TAG, "TRIGGER_IDLE received but not changing state; idle=" + this.mIdle + " screen=" + this.mScreenOn);
        }
    }
}

