/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.WorkSource;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

public abstract class AbstractLocationProvider {
    protected final Context mContext;
    private final LocationProviderManager mLocationProviderManager;

    protected AbstractLocationProvider(Context context, LocationProviderManager locationProviderManager) {
        this.mContext = context;
        this.mLocationProviderManager = locationProviderManager;
    }

    protected void reportLocation(Location location) {
        this.mLocationProviderManager.onReportLocation(location);
    }

    protected void reportLocation(List<Location> locations) {
        this.mLocationProviderManager.onReportLocation(locations);
    }

    protected void setEnabled(boolean enabled) {
        this.mLocationProviderManager.onSetEnabled(enabled);
    }

    protected void setProperties(ProviderProperties properties) {
        this.mLocationProviderManager.onSetProperties(properties);
    }

    public List<String> getProviderPackages() {
        return Collections.singletonList(this.mContext.getPackageName());
    }

    public abstract void setRequest(ProviderRequest var1, WorkSource var2);

    public abstract void dump(FileDescriptor var1, PrintWriter var2, String[] var3);

    @Deprecated
    public int getStatus(Bundle extras) {
        return 2;
    }

    @Deprecated
    public long getStatusUpdateTime() {
        return 0L;
    }

    public abstract void sendExtraCommand(String var1, Bundle var2);

    public static interface LocationProviderManager {
        public void onSetEnabled(boolean var1);

        public void onSetProperties(ProviderProperties var1);

        public void onReportLocation(Location var1);

        public void onReportLocation(List<Location> var1);
    }
}

