/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.contexthub.V1_0.ContextHubMsg;
import android.hardware.contexthub.V1_0.IContexthub;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.IContextHubClient;
import android.hardware.location.IContextHubClientCallback;
import android.hardware.location.NanoAppMessage;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.location.ContextHubClientManager;
import com.android.server.location.ContextHubServiceUtil;
import java.util.function.Supplier;

public class ContextHubClientBroker
extends IContextHubClient.Stub
implements IBinder.DeathRecipient {
    private static final String TAG = "ContextHubClientBroker";
    private final Context mContext;
    private final IContexthub mContextHubProxy;
    private final ContextHubClientManager mClientManager;
    private final ContextHubInfo mAttachedContextHubInfo;
    private final short mHostEndPointId;
    private IContextHubClientCallback mCallbackInterface = null;
    private boolean mRegistered = true;
    private final PendingIntentRequest mPendingIntentRequest;

    ContextHubClientBroker(Context context, IContexthub contextHubProxy, ContextHubClientManager clientManager, ContextHubInfo contextHubInfo, short hostEndPointId, IContextHubClientCallback callback) {
        this.mContext = context;
        this.mContextHubProxy = contextHubProxy;
        this.mClientManager = clientManager;
        this.mAttachedContextHubInfo = contextHubInfo;
        this.mHostEndPointId = hostEndPointId;
        this.mCallbackInterface = callback;
        this.mPendingIntentRequest = new PendingIntentRequest();
    }

    ContextHubClientBroker(Context context, IContexthub contextHubProxy, ContextHubClientManager clientManager, ContextHubInfo contextHubInfo, short hostEndPointId, PendingIntent pendingIntent, long nanoAppId) {
        this.mContext = context;
        this.mContextHubProxy = contextHubProxy;
        this.mClientManager = clientManager;
        this.mAttachedContextHubInfo = contextHubInfo;
        this.mHostEndPointId = hostEndPointId;
        this.mPendingIntentRequest = new PendingIntentRequest(pendingIntent, nanoAppId);
    }

    @Override
    public int sendMessageToNanoApp(NanoAppMessage message) {
        int result;
        ContextHubServiceUtil.checkPermissions(this.mContext);
        if (this.isRegistered()) {
            ContextHubMsg messageToNanoApp = ContextHubServiceUtil.createHidlContextHubMessage(this.mHostEndPointId, message);
            int contextHubId = this.mAttachedContextHubInfo.getId();
            try {
                result = this.mContextHubProxy.sendMessageToHub(contextHubId, messageToNanoApp);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in sendMessageToNanoApp (target hub ID = " + contextHubId + ")", e);
                result = 1;
            }
        } else {
            Log.e(TAG, "Failed to send message to nanoapp: client connection is closed");
            result = 1;
        }
        return ContextHubServiceUtil.toTransactionResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ContextHubClientBroker contextHubClientBroker = this;
        synchronized (contextHubClientBroker) {
            this.mPendingIntentRequest.clear();
        }
        this.onClientExit();
    }

    @Override
    public void binderDied() {
        this.onClientExit();
    }

    int getAttachedContextHubId() {
        return this.mAttachedContextHubInfo.getId();
    }

    short getHostEndPointId() {
        return this.mHostEndPointId;
    }

    void sendMessageToClient(NanoAppMessage message) {
        this.invokeCallback(callback -> callback.onMessageFromNanoApp(message));
        Supplier<Intent> supplier = () -> this.createIntent(5, message.getNanoAppId()).putExtra("android.hardware.location.extra.MESSAGE", message);
        this.sendPendingIntent(supplier, message.getNanoAppId());
    }

    void onNanoAppLoaded(long nanoAppId) {
        this.invokeCallback(callback -> callback.onNanoAppLoaded(nanoAppId));
        this.sendPendingIntent(() -> this.createIntent(0, nanoAppId), nanoAppId);
    }

    void onNanoAppUnloaded(long nanoAppId) {
        this.invokeCallback(callback -> callback.onNanoAppUnloaded(nanoAppId));
        this.sendPendingIntent(() -> this.createIntent(1, nanoAppId), nanoAppId);
    }

    void onHubReset() {
        this.invokeCallback(callback -> callback.onHubReset());
        this.sendPendingIntent(() -> this.createIntent(6));
    }

    void onNanoAppAborted(long nanoAppId, int abortCode) {
        this.invokeCallback(callback -> callback.onNanoAppAborted(nanoAppId, abortCode));
        Supplier<Intent> supplier = () -> this.createIntent(4, nanoAppId).putExtra("android.hardware.location.extra.NANOAPP_ABORT_CODE", abortCode);
        this.sendPendingIntent(supplier, nanoAppId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPendingIntent(PendingIntent intent, long nanoAppId) {
        long intentNanoAppId;
        PendingIntent pendingIntent = null;
        ContextHubClientBroker contextHubClientBroker = this;
        synchronized (contextHubClientBroker) {
            pendingIntent = this.mPendingIntentRequest.getPendingIntent();
            intentNanoAppId = this.mPendingIntentRequest.getNanoAppId();
        }
        return pendingIntent != null && pendingIntent.equals(intent) && intentNanoAppId == nanoAppId;
    }

    void attachDeathRecipient() throws RemoteException {
        if (this.mCallbackInterface != null) {
            this.mCallbackInterface.asBinder().linkToDeath(this, 0);
        }
    }

    private synchronized void invokeCallback(CallbackConsumer consumer) {
        if (this.mCallbackInterface != null) {
            try {
                consumer.accept(this.mCallbackInterface);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException while invoking client callback (host endpoint ID = " + this.mHostEndPointId + ")", e);
            }
        }
    }

    private Intent createIntent(int eventType) {
        Intent intent = new Intent();
        intent.putExtra("android.hardware.location.extra.EVENT_TYPE", eventType);
        intent.putExtra("android.hardware.location.extra.CONTEXT_HUB_INFO", this.mAttachedContextHubInfo);
        return intent;
    }

    private Intent createIntent(int eventType, long nanoAppId) {
        Intent intent = this.createIntent(eventType);
        intent.putExtra("android.hardware.location.extra.NANOAPP_ID", nanoAppId);
        return intent;
    }

    private synchronized void sendPendingIntent(Supplier<Intent> supplier) {
        if (this.mPendingIntentRequest.hasPendingIntent()) {
            this.doSendPendingIntent(this.mPendingIntentRequest.getPendingIntent(), supplier.get());
        }
    }

    private synchronized void sendPendingIntent(Supplier<Intent> supplier, long nanoAppId) {
        if (this.mPendingIntentRequest.hasPendingIntent() && this.mPendingIntentRequest.getNanoAppId() == nanoAppId) {
            this.doSendPendingIntent(this.mPendingIntentRequest.getPendingIntent(), supplier.get());
        }
    }

    private void doSendPendingIntent(PendingIntent pendingIntent, Intent intent) {
        try {
            pendingIntent.send(this.mContext, 0, intent, null, null, "android.permission.LOCATION_HARDWARE", null);
        }
        catch (PendingIntent.CanceledException e) {
            Log.w(TAG, "PendingIntent has been canceled, unregistering from client (host endpoint ID " + this.mHostEndPointId + ")");
            this.close();
        }
    }

    private synchronized boolean isRegistered() {
        return this.mRegistered;
    }

    private synchronized void onClientExit() {
        if (this.mCallbackInterface != null) {
            this.mCallbackInterface.asBinder().unlinkToDeath(this, 0);
            this.mCallbackInterface = null;
        }
        if (!this.mPendingIntentRequest.hasPendingIntent() && this.mRegistered) {
            this.mClientManager.unregisterClient(this.mHostEndPointId);
            this.mRegistered = false;
        }
    }

    private class PendingIntentRequest {
        private PendingIntent mPendingIntent;
        private long mNanoAppId;

        PendingIntentRequest() {
        }

        PendingIntentRequest(PendingIntent pendingIntent, long nanoAppId) {
            this.mPendingIntent = pendingIntent;
            this.mNanoAppId = nanoAppId;
        }

        public long getNanoAppId() {
            return this.mNanoAppId;
        }

        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        public boolean hasPendingIntent() {
            return this.mPendingIntent != null;
        }

        public void clear() {
            this.mPendingIntent = null;
        }
    }

    private static interface CallbackConsumer {
        public void accept(IContextHubClientCallback var1) throws RemoteException;
    }
}

