/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.location.Address;
import android.location.GeocoderParams;
import android.location.IGeocodeProvider;
import com.android.server.FgThread;
import com.android.server.ServiceWatcher;
import java.util.List;

public class GeocoderProxy {
    private static final String TAG = "GeocoderProxy";
    private static final String SERVICE_ACTION = "com.android.location.service.GeocodeProvider";
    private final ServiceWatcher mServiceWatcher;

    public static GeocoderProxy createAndBind(Context context, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId) {
        GeocoderProxy proxy = new GeocoderProxy(context, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId);
        if (proxy.bind()) {
            return proxy;
        }
        return null;
    }

    private GeocoderProxy(Context context, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId) {
        this.mServiceWatcher = new ServiceWatcher(context, TAG, SERVICE_ACTION, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, FgThread.getHandler());
    }

    private boolean bind() {
        return this.mServiceWatcher.start();
    }

    public String getConnectedPackageName() {
        return this.mServiceWatcher.getCurrentPackageName();
    }

    public String getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        return this.mServiceWatcher.runOnBinderBlocking(binder -> {
            IGeocodeProvider provider = IGeocodeProvider.Stub.asInterface(binder);
            return provider.getFromLocation(latitude, longitude, maxResults, params, addrs);
        }, "Service not Available");
    }

    public String getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        return this.mServiceWatcher.runOnBinderBlocking(binder -> {
            IGeocodeProvider provider = IGeocodeProvider.Stub.asInterface(binder);
            return provider.getFromLocationName(locationName, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, maxResults, params, addrs);
        }, "Service not Available");
    }
}

