/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.hardware.location.GeofenceHardwareService;
import android.hardware.location.IGeofenceHardware;
import android.location.IFusedGeofenceHardware;
import android.location.IGeofenceProvider;
import android.location.IGpsGeofenceHardware;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import com.android.server.FgThread;
import com.android.server.ServiceWatcher;

public final class GeofenceProxy {
    private static final String TAG = "GeofenceProxy";
    private static final String SERVICE_ACTION = "com.android.location.service.GeofenceProvider";
    private final Context mContext;
    private final ServiceWatcher mServiceWatcher;
    private final IGpsGeofenceHardware mGpsGeofenceHardware;
    private final IFusedGeofenceHardware mFusedGeofenceHardware;
    private volatile IGeofenceHardware mGeofenceHardware;
    private final ServiceWatcher.BinderRunner mUpdateGeofenceHardware = binder -> {
        IGeofenceProvider provider = IGeofenceProvider.Stub.asInterface(binder);
        try {
            provider.setGeofenceHardware(this.mGeofenceHardware);
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
    };

    public static GeofenceProxy createAndBind(Context context, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, IGpsGeofenceHardware gpsGeofence, IFusedGeofenceHardware fusedGeofenceHardware) {
        GeofenceProxy proxy = new GeofenceProxy(context, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, gpsGeofence, fusedGeofenceHardware);
        if (proxy.bind()) {
            return proxy;
        }
        return null;
    }

    private GeofenceProxy(Context context, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, IGpsGeofenceHardware gpsGeofence, IFusedGeofenceHardware fusedGeofenceHardware) {
        this.mContext = context;
        this.mServiceWatcher = new ServiceWatcher(context, TAG, SERVICE_ACTION, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, FgThread.getHandler()){

            @Override
            protected void onBind() {
                this.runOnBinder(GeofenceProxy.this.mUpdateGeofenceHardware);
            }
        };
        this.mGpsGeofenceHardware = gpsGeofence;
        this.mFusedGeofenceHardware = fusedGeofenceHardware;
        this.mGeofenceHardware = null;
    }

    private boolean bind() {
        if (this.mServiceWatcher.start()) {
            this.mContext.bindServiceAsUser(new Intent(this.mContext, GeofenceHardwareService.class), new GeofenceProxyServiceConnection(), 1, UserHandle.SYSTEM);
            return true;
        }
        return false;
    }

    private class GeofenceProxyServiceConnection
    implements ServiceConnection {
        private GeofenceProxyServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IGeofenceHardware geofenceHardware = IGeofenceHardware.Stub.asInterface(service);
            try {
                if (GeofenceProxy.this.mGpsGeofenceHardware != null) {
                    geofenceHardware.setGpsGeofenceHardware(GeofenceProxy.this.mGpsGeofenceHardware);
                }
                if (GeofenceProxy.this.mFusedGeofenceHardware != null) {
                    geofenceHardware.setFusedGeofenceHardware(GeofenceProxy.this.mFusedGeofenceHardware);
                }
                GeofenceProxy.this.mGeofenceHardware = geofenceHardware;
                GeofenceProxy.this.mServiceWatcher.runOnBinder(GeofenceProxy.this.mUpdateGeofenceHardware);
            }
            catch (Exception e) {
                Log.w(GeofenceProxy.TAG, e);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            GeofenceProxy.this.mGeofenceHardware = null;
            GeofenceProxy.this.mServiceWatcher.runOnBinder(GeofenceProxy.this.mUpdateGeofenceHardware);
        }
    }
}

