/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.GnssCapabilities;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;

public class GnssCapabilitiesProvider {
    private static final String TAG = "GnssCapabilitiesProvider";
    private static final boolean DEBUG = Log.isLoggable("GnssCapabilitiesProvider", 3);
    private static final long GNSS_CAPABILITIES_TOP_HAL = 31L;
    private static final long GNSS_CAPABILITIES_SUB_HAL_MEASUREMENT_CORRECTIONS = 480L;
    @GuardedBy(value={"this"})
    private long mGnssCapabilities;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGnssCapabilities() {
        GnssCapabilitiesProvider gnssCapabilitiesProvider = this;
        synchronized (gnssCapabilitiesProvider) {
            return this.mGnssCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTopHalCapabilities(int topHalCapabilities) {
        long gnssCapabilities = 0L;
        if (GnssCapabilitiesProvider.hasCapability(topHalCapabilities, 256)) {
            gnssCapabilities |= 1L;
        }
        if (GnssCapabilitiesProvider.hasCapability(topHalCapabilities, 512)) {
            gnssCapabilities |= 2L;
        }
        if (GnssCapabilitiesProvider.hasCapability(topHalCapabilities, 32)) {
            gnssCapabilities |= 4L;
        }
        if (GnssCapabilitiesProvider.hasCapability(topHalCapabilities, 64)) {
            gnssCapabilities |= 8L;
        }
        if (GnssCapabilitiesProvider.hasCapability(topHalCapabilities, 128)) {
            gnssCapabilities |= 0x10L;
        }
        GnssCapabilitiesProvider gnssCapabilitiesProvider = this;
        synchronized (gnssCapabilitiesProvider) {
            this.mGnssCapabilities &= 0xFFFFFFFFFFFFFFE0L;
            this.mGnssCapabilities |= gnssCapabilities;
            if (DEBUG) {
                Log.d(TAG, "setTopHalCapabilities, mGnssCapabilities=0x" + Long.toHexString(this.mGnssCapabilities) + ", " + GnssCapabilities.of(this.mGnssCapabilities));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSubHalMeasurementCorrectionsCapabilities(int measurementCorrectionsCapabilities) {
        long gnssCapabilities = 32L;
        if (GnssCapabilitiesProvider.hasCapability(measurementCorrectionsCapabilities, 1)) {
            gnssCapabilities |= 0x40L;
        }
        if (GnssCapabilitiesProvider.hasCapability(measurementCorrectionsCapabilities, 2)) {
            gnssCapabilities |= 0x80L;
        }
        if (GnssCapabilitiesProvider.hasCapability(measurementCorrectionsCapabilities, 4)) {
            gnssCapabilities |= 0x100L;
        }
        GnssCapabilitiesProvider gnssCapabilitiesProvider = this;
        synchronized (gnssCapabilitiesProvider) {
            this.mGnssCapabilities &= 0xFFFFFFFFFFFFFE1FL;
            this.mGnssCapabilities |= gnssCapabilities;
            if (DEBUG) {
                Log.d(TAG, "setSubHalMeasurementCorrectionsCapabilities, mGnssCapabilities=0x" + Long.toHexString(this.mGnssCapabilities) + ", " + GnssCapabilities.of(this.mGnssCapabilities));
            }
        }
    }

    private static boolean hasCapability(int halCapabilities, int capability) {
        return (halCapabilities & capability) != 0;
    }
}

