/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.os.PersistableBundle;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.StatsLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import libcore.io.IoUtils;

class GnssConfiguration {
    private static final String TAG = "GnssConfiguration";
    private static final boolean DEBUG = Log.isLoggable("GnssConfiguration", 3);
    private static final String DEBUG_PROPERTIES_FILE = "/etc/gps_debug.conf";
    private static final String CONFIG_SUPL_HOST = "SUPL_HOST";
    private static final String CONFIG_SUPL_PORT = "SUPL_PORT";
    private static final String CONFIG_C2K_HOST = "C2K_HOST";
    private static final String CONFIG_C2K_PORT = "C2K_PORT";
    private static final String CONFIG_SUPL_VER = "SUPL_VER";
    private static final String CONFIG_SUPL_MODE = "SUPL_MODE";
    private static final String CONFIG_SUPL_ES = "SUPL_ES";
    private static final String CONFIG_LPP_PROFILE = "LPP_PROFILE";
    private static final String CONFIG_A_GLONASS_POS_PROTOCOL_SELECT = "A_GLONASS_POS_PROTOCOL_SELECT";
    private static final String CONFIG_USE_EMERGENCY_PDN_FOR_EMERGENCY_SUPL = "USE_EMERGENCY_PDN_FOR_EMERGENCY_SUPL";
    private static final String CONFIG_GPS_LOCK = "GPS_LOCK";
    private static final String CONFIG_ES_EXTENSION_SEC = "ES_EXTENSION_SEC";
    public static final String CONFIG_NFW_PROXY_APPS = "NFW_PROXY_APPS";
    private static final int MAX_EMERGENCY_MODE_EXTENSION_SECONDS = 300;
    static final String LPP_PROFILE = "persist.sys.gps.lpp";
    private Properties mProperties;
    private int mEsExtensionSec = 0;
    private final Context mContext;

    GnssConfiguration(Context context) {
        this.mContext = context;
        this.mProperties = new Properties();
    }

    Properties getProperties() {
        return this.mProperties;
    }

    int getEsExtensionSec() {
        return this.mEsExtensionSec;
    }

    String getSuplHost() {
        return this.mProperties.getProperty(CONFIG_SUPL_HOST);
    }

    int getSuplPort(int defaultPort) {
        return this.getIntConfig(CONFIG_SUPL_PORT, defaultPort);
    }

    String getC2KHost() {
        return this.mProperties.getProperty(CONFIG_C2K_HOST);
    }

    int getC2KPort(int defaultPort) {
        return this.getIntConfig(CONFIG_C2K_PORT, defaultPort);
    }

    int getSuplMode(int defaultMode) {
        return this.getIntConfig(CONFIG_SUPL_MODE, defaultMode);
    }

    int getSuplEs(int defaulSuplEs) {
        return this.getIntConfig(CONFIG_SUPL_ES, defaulSuplEs);
    }

    String getLppProfile() {
        return this.mProperties.getProperty(CONFIG_LPP_PROFILE);
    }

    List<String> getProxyApps() {
        String proxyAppsStr = this.mProperties.getProperty(CONFIG_NFW_PROXY_APPS);
        if (TextUtils.isEmpty(proxyAppsStr)) {
            return Collections.EMPTY_LIST;
        }
        String[] proxyAppsArray = proxyAppsStr.trim().split("\\s+");
        if (proxyAppsArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> proxyApps = new ArrayList<String>(proxyAppsArray.length);
        for (String proxyApp : proxyAppsArray) {
            proxyApps.add(proxyApp);
        }
        return proxyApps;
    }

    void setSatelliteBlacklist(int[] constellations, int[] svids) {
        GnssConfiguration.native_set_satellite_blacklist(constellations, svids);
    }

    void reloadGpsProperties() {
        if (DEBUG) {
            Log.d(TAG, "Reset GPS properties, previous size = " + this.mProperties.size());
        }
        this.loadPropertiesFromCarrierConfig();
        String lpp_prof = SystemProperties.get(LPP_PROFILE);
        if (!TextUtils.isEmpty(lpp_prof)) {
            this.mProperties.setProperty(CONFIG_LPP_PROFILE, lpp_prof);
        }
        this.loadPropertiesFromGpsDebugConfig(this.mProperties);
        this.mEsExtensionSec = this.getRangeCheckedConfigEsExtensionSec();
        this.logConfigurations();
        final HalInterfaceVersion gnssConfigurationIfaceVersion = GnssConfiguration.native_get_gnss_configuration_version();
        if (gnssConfigurationIfaceVersion != null) {
            if (GnssConfiguration.isConfigEsExtensionSecSupported(gnssConfigurationIfaceVersion) && !GnssConfiguration.native_set_es_extension_sec(this.mEsExtensionSec)) {
                Log.e(TAG, "Unable to set ES_EXTENSION_SEC: " + this.mEsExtensionSec);
            }
            HashMap<String, SetCarrierProperty> map = new HashMap<String, SetCarrierProperty>(){
                {
                    this.put(GnssConfiguration.CONFIG_SUPL_VER, x$0 -> GnssConfiguration.native_set_supl_version(x$0));
                    this.put(GnssConfiguration.CONFIG_SUPL_MODE, x$0 -> GnssConfiguration.native_set_supl_mode(x$0));
                    if (GnssConfiguration.isConfigSuplEsSupported(gnssConfigurationIfaceVersion)) {
                        this.put(GnssConfiguration.CONFIG_SUPL_ES, x$0 -> GnssConfiguration.native_set_supl_es(x$0));
                    }
                    this.put(GnssConfiguration.CONFIG_LPP_PROFILE, x$0 -> GnssConfiguration.native_set_lpp_profile(x$0));
                    this.put(GnssConfiguration.CONFIG_A_GLONASS_POS_PROTOCOL_SELECT, x$0 -> GnssConfiguration.native_set_gnss_pos_protocol_select(x$0));
                    this.put(GnssConfiguration.CONFIG_USE_EMERGENCY_PDN_FOR_EMERGENCY_SUPL, x$0 -> GnssConfiguration.native_set_emergency_supl_pdn(x$0));
                    if (GnssConfiguration.isConfigGpsLockSupported(gnssConfigurationIfaceVersion)) {
                        this.put(GnssConfiguration.CONFIG_GPS_LOCK, x$0 -> GnssConfiguration.native_set_gps_lock(x$0));
                    }
                }
            };
            for (Map.Entry entry : map.entrySet()) {
                String propertyName = (String)entry.getKey();
                String propertyValueString = this.mProperties.getProperty(propertyName);
                if (propertyValueString == null) continue;
                try {
                    int propertyValueInt = Integer.decode(propertyValueString);
                    boolean result = ((SetCarrierProperty)entry.getValue()).set(propertyValueInt);
                    if (result) continue;
                    Log.e(TAG, "Unable to set " + propertyName);
                }
                catch (NumberFormatException e) {
                    Log.e(TAG, "Unable to parse propertyName: " + propertyValueString);
                }
            }
        } else if (DEBUG) {
            Log.d(TAG, "Skipped configuration update because GNSS configuration in GPS HAL is not supported");
        }
    }

    private void logConfigurations() {
        StatsLog.write(132, this.getSuplHost(), this.getSuplPort(0), this.getC2KHost(), this.getC2KPort(0), this.getIntConfig(CONFIG_SUPL_VER, 0), this.getSuplMode(0), this.getSuplEs(0) == 1, this.getIntConfig(CONFIG_LPP_PROFILE, 0), this.getIntConfig(CONFIG_A_GLONASS_POS_PROTOCOL_SELECT, 0), this.getIntConfig(CONFIG_USE_EMERGENCY_PDN_FOR_EMERGENCY_SUPL, 0) == 1, this.getIntConfig(CONFIG_GPS_LOCK, 0), this.getEsExtensionSec(), this.mProperties.getProperty(CONFIG_NFW_PROXY_APPS));
    }

    void loadPropertiesFromCarrierConfig() {
        PersistableBundle configs;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configManager == null) {
            return;
        }
        int ddSubId = SubscriptionManager.getDefaultDataSubscriptionId();
        PersistableBundle persistableBundle = configs = SubscriptionManager.isValidSubscriptionId(ddSubId) ? configManager.getConfigForSubId(ddSubId) : null;
        if (configs == null) {
            if (DEBUG) {
                Log.d(TAG, "SIM not ready, use default carrier config.");
            }
            configs = CarrierConfigManager.getDefaultConfig();
        }
        for (String configKey : configs.keySet()) {
            if (!configKey.startsWith("gps.")) continue;
            String key = configKey.substring("gps.".length()).toUpperCase();
            Object value = configs.get(configKey);
            if (DEBUG) {
                Log.d(TAG, "Gps config: " + key + " = " + value);
            }
            if (value instanceof String) {
                this.mProperties.setProperty(key, (String)value);
                continue;
            }
            if (value == null) continue;
            this.mProperties.setProperty(key, value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFromGpsDebugConfig(Properties properties) {
        block4: {
            try {
                File file = new File(DEBUG_PROPERTIES_FILE);
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(file);
                    properties.load(stream);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(stream);
                    throw throwable;
                }
                IoUtils.closeQuietly(stream);
            }
            catch (IOException e) {
                if (!DEBUG) break block4;
                Log.d(TAG, "Could not open GPS configuration file /etc/gps_debug.conf");
            }
        }
    }

    private int getRangeCheckedConfigEsExtensionSec() {
        int emergencyExtensionSeconds = this.getIntConfig(CONFIG_ES_EXTENSION_SEC, 0);
        if (emergencyExtensionSeconds > 300) {
            Log.w(TAG, "ES_EXTENSION_SEC: " + emergencyExtensionSeconds + " too high, reset to " + 300);
            emergencyExtensionSeconds = 300;
        } else if (emergencyExtensionSeconds < 0) {
            Log.w(TAG, "ES_EXTENSION_SEC: " + emergencyExtensionSeconds + " is negative, reset to zero.");
            emergencyExtensionSeconds = 0;
        }
        return emergencyExtensionSeconds;
    }

    private int getIntConfig(String configParameter, int defaultValue) {
        String valueString = this.mProperties.getProperty(configParameter);
        if (TextUtils.isEmpty(valueString)) {
            return defaultValue;
        }
        try {
            return Integer.decode(valueString);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Unable to parse config parameter " + configParameter + " value: " + valueString + ". Using default value: " + defaultValue);
            return defaultValue;
        }
    }

    private static boolean isConfigEsExtensionSecSupported(HalInterfaceVersion gnssConfiguartionIfaceVersion) {
        return gnssConfiguartionIfaceVersion.mMajor >= 2;
    }

    private static boolean isConfigSuplEsSupported(HalInterfaceVersion gnssConfiguartionIfaceVersion) {
        return gnssConfiguartionIfaceVersion.mMajor < 2;
    }

    private static boolean isConfigGpsLockSupported(HalInterfaceVersion gnssConfiguartionIfaceVersion) {
        return gnssConfiguartionIfaceVersion.mMajor < 2;
    }

    private static native HalInterfaceVersion native_get_gnss_configuration_version();

    private static native boolean native_set_supl_version(int var0);

    private static native boolean native_set_supl_mode(int var0);

    private static native boolean native_set_supl_es(int var0);

    private static native boolean native_set_lpp_profile(int var0);

    private static native boolean native_set_gnss_pos_protocol_select(int var0);

    private static native boolean native_set_gps_lock(int var0);

    private static native boolean native_set_emergency_supl_pdn(int var0);

    private static native boolean native_set_satellite_blacklist(int[] var0, int[] var1);

    private static native boolean native_set_es_extension_sec(int var0);

    static interface SetCarrierProperty {
        public boolean set(int var1);
    }

    private static class HalInterfaceVersion {
        final int mMajor;
        final int mMinor;

        HalInterfaceVersion(int major, int minor) {
            this.mMajor = major;
            this.mMinor = minor;
        }
    }
}

