/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.IGpsGeofenceHardware;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;

class GnssGeofenceProvider
extends IGpsGeofenceHardware.Stub {
    private static final String TAG = "GnssGeofenceProvider";
    private static final boolean DEBUG = Log.isLoggable("GnssGeofenceProvider", 3);
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final GnssGeofenceProviderNative mNative;
    @GuardedBy(value={"mLock"})
    private final SparseArray<GeofenceEntry> mGeofenceEntries = new SparseArray();

    GnssGeofenceProvider() {
        this(new GnssGeofenceProviderNative());
    }

    @VisibleForTesting
    GnssGeofenceProvider(GnssGeofenceProviderNative gnssGeofenceProviderNative) {
        this.mNative = gnssGeofenceProviderNative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeIfStarted() {
        if (DEBUG) {
            Log.d(TAG, "resumeIfStarted");
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mGeofenceEntries.size(); ++i) {
                GeofenceEntry entry = this.mGeofenceEntries.valueAt(i);
                boolean added = this.mNative.addGeofence(entry.geofenceId, entry.latitude, entry.longitude, entry.radius, entry.lastTransition, entry.monitorTransitions, entry.notificationResponsiveness, entry.unknownTimer);
                if (!added || !entry.paused) continue;
                this.mNative.pauseGeofence(entry.geofenceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHardwareGeofenceSupported() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNative.isGeofenceSupported();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCircularHardwareGeofence(int geofenceId, double latitude, double longitude, double radius, int lastTransition, int monitorTransitions, int notificationResponsiveness, int unknownTimer) {
        Object object = this.mLock;
        synchronized (object) {
            boolean added = this.mNative.addGeofence(geofenceId, latitude, longitude, radius, lastTransition, monitorTransitions, notificationResponsiveness, unknownTimer);
            if (added) {
                GeofenceEntry entry = new GeofenceEntry();
                entry.geofenceId = geofenceId;
                entry.latitude = latitude;
                entry.longitude = longitude;
                entry.radius = radius;
                entry.lastTransition = lastTransition;
                entry.monitorTransitions = monitorTransitions;
                entry.notificationResponsiveness = notificationResponsiveness;
                entry.unknownTimer = unknownTimer;
                this.mGeofenceEntries.put(geofenceId, entry);
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeHardwareGeofence(int geofenceId) {
        Object object = this.mLock;
        synchronized (object) {
            boolean removed = this.mNative.removeGeofence(geofenceId);
            if (removed) {
                this.mGeofenceEntries.remove(geofenceId);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pauseHardwareGeofence(int geofenceId) {
        Object object = this.mLock;
        synchronized (object) {
            GeofenceEntry entry;
            boolean paused = this.mNative.pauseGeofence(geofenceId);
            if (paused && (entry = this.mGeofenceEntries.get(geofenceId)) != null) {
                entry.paused = true;
            }
            return paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resumeHardwareGeofence(int geofenceId, int monitorTransitions) {
        Object object = this.mLock;
        synchronized (object) {
            GeofenceEntry entry;
            boolean resumed = this.mNative.resumeGeofence(geofenceId, monitorTransitions);
            if (resumed && (entry = this.mGeofenceEntries.get(geofenceId)) != null) {
                entry.paused = false;
                entry.monitorTransitions = monitorTransitions;
            }
            return resumed;
        }
    }

    private static native boolean native_is_geofence_supported();

    private static native boolean native_add_geofence(int var0, double var1, double var3, double var5, int var7, int var8, int var9, int var10);

    private static native boolean native_remove_geofence(int var0);

    private static native boolean native_resume_geofence(int var0, int var1);

    private static native boolean native_pause_geofence(int var0);

    @VisibleForTesting
    static class GnssGeofenceProviderNative {
        GnssGeofenceProviderNative() {
        }

        public boolean isGeofenceSupported() {
            return GnssGeofenceProvider.native_is_geofence_supported();
        }

        public boolean addGeofence(int geofenceId, double latitude, double longitude, double radius, int lastTransition, int monitorTransitions, int notificationResponsiveness, int unknownTimer) {
            return GnssGeofenceProvider.native_add_geofence(geofenceId, latitude, longitude, radius, lastTransition, monitorTransitions, notificationResponsiveness, unknownTimer);
        }

        public boolean removeGeofence(int geofenceId) {
            return GnssGeofenceProvider.native_remove_geofence(geofenceId);
        }

        public boolean resumeGeofence(int geofenceId, int transitions) {
            return GnssGeofenceProvider.native_resume_geofence(geofenceId, transitions);
        }

        public boolean pauseGeofence(int geofenceId) {
            return GnssGeofenceProvider.native_pause_geofence(geofenceId);
        }
    }

    private static class GeofenceEntry {
        public int geofenceId;
        public double latitude;
        public double longitude;
        public double radius;
        public int lastTransition;
        public int monitorTransitions;
        public int notificationResponsiveness;
        public int unknownTimer;
        public boolean paused;

        private GeofenceEntry() {
        }
    }
}

